/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.workflow.engine.impl.bpmn.listener;

import java.util.Map;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.workflow.engine.WfUtils;
import kd.bos.workflow.engine.delegate.TaskListener;
import kd.bos.workflow.engine.delegate.event.ActivitiEventType;
import kd.bos.workflow.engine.delegate.event.impl.ActivitiEventBuilder;
import kd.bos.workflow.engine.impl.interceptor.Command;
import kd.bos.workflow.engine.impl.interceptor.CommandConfig;
import kd.bos.workflow.engine.impl.interceptor.CommandContext;
import kd.bos.workflow.engine.impl.interceptor.DefaultCommandContextCloseListener;
import kd.bos.workflow.engine.impl.persistence.entity.runtime.ExecutionEntity;
import kd.bos.workflow.engine.impl.persistence.entity.task.TaskEntity;
import kd.bos.workflow.service.WfTraceType;

public class ExecuteTaskListenerTransactionListener
extends DefaultCommandContextCloseListener {
    protected TaskListener listener;
    protected TaskEntity taskEntity;
    protected String eventName;
    protected Map<String, Object> params;

    public ExecuteTaskListenerTransactionListener(String aim, TaskListener listener, TaskEntity taskEntity, String eventName, Map<String, Object> params) {
        super(aim);
        this.listener = listener;
        this.taskEntity = taskEntity;
        this.eventName = eventName;
        this.params = params;
    }

    @Override
    public void closed(CommandContext commandContext) {
        if (this.listener != null) {
            try {
                CommandConfig commandConfig = commandContext.getProcessEngineConfiguration().getCommandExecutor().getDefaultConfig().transactionRequiresNew();
                commandContext.getProcessEngineConfiguration().getCommandExecutor().execute(commandConfig, new Command<Void>(){

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     */
                    @Override
                    public Void execute(CommandContext commandContext) {
                        String lName = "";
                        ExecutionEntity execution = ExecuteTaskListenerTransactionListener.this.taskEntity.getExecution();
                        String event = execution.getEventName();
                        try {
                            lName = ExecuteTaskListenerTransactionListener.this.listener.getClass().getName();
                            ExecuteTaskListenerTransactionListener.this.log.debug(String.format("execution after task listener[%s] when tx[%s] is closed.", lName, ExecuteTaskListenerTransactionListener.this.eventName));
                            ExecuteTaskListenerTransactionListener.this.taskEntity.setEventName(ExecuteTaskListenerTransactionListener.this.eventName);
                            execution.setEventName(ExecuteTaskListenerTransactionListener.this.eventName);
                            ExecuteTaskListenerTransactionListener.this.listener.afterHandleTask(ExecuteTaskListenerTransactionListener.this.taskEntity, ExecuteTaskListenerTransactionListener.this.eventName, ExecuteTaskListenerTransactionListener.this.params);
                            ExecuteTaskListenerTransactionListener.this.log.debug(String.format(ResManager.loadKDString((String)"\u6210\u529f\u6267\u884c\u76d1\u542c[%s]", (String)"ExecuteExecutionListenerTransactionListener_1", (String)"bos-wf-engine", (Object[])new Object[0]), lName));
                        }
                        catch (Exception e) {
                            String eInfo = WfUtils.getExceptionStacktrace(e);
                            ExecuteTaskListenerTransactionListener.this.log.debug(String.format(ResManager.loadKDString((String)"\u76d1\u542c[%1$s]\u6267\u884c\u5931\u8d25[%2$s]", (String)"ExecuteExecutionListenerTransactionListener_2", (String)"bos-wf-engine", (Object[])new Object[0]), lName, eInfo));
                            if (commandContext.getEventDispatcher().isEnabled()) {
                                try {
                                    String activityId = "";
                                    if (ExecuteTaskListenerTransactionListener.this.taskEntity != null && ExecuteTaskListenerTransactionListener.this.taskEntity.getTaskDefinitionKey() != null) {
                                        activityId = ExecuteTaskListenerTransactionListener.this.taskEntity.getTaskDefinitionKey();
                                    }
                                    Long executionId = ExecuteTaskListenerTransactionListener.this.taskEntity == null ? Long.valueOf(0L) : ExecuteTaskListenerTransactionListener.this.taskEntity.getExecutionId();
                                    Long processInstanceId = ExecuteTaskListenerTransactionListener.this.taskEntity == null ? Long.valueOf(0L) : ExecuteTaskListenerTransactionListener.this.taskEntity.getProcessInstanceId();
                                    Long processDefId = ExecuteTaskListenerTransactionListener.this.taskEntity == null ? Long.valueOf(0L) : ExecuteTaskListenerTransactionListener.this.taskEntity.getProcessDefinitionId();
                                    String businessKey = ExecuteTaskListenerTransactionListener.this.taskEntity == null ? "" : ExecuteTaskListenerTransactionListener.this.taskEntity.getBusinessKey();
                                    Long jobId = WfTraceType.get().getJobInfo() == null ? Long.valueOf(0L) : WfTraceType.get().getJobInfo().getCurrentJobId();
                                    String entityNumber = ExecuteTaskListenerTransactionListener.this.taskEntity == null ? "" : ExecuteTaskListenerTransactionListener.this.taskEntity.getEntityNumber();
                                    commandContext.getEventDispatcher().dispatchEvent(ActivitiEventBuilder.createAsyncMessageEvent(ActivitiEventType.JOB_EXECUTION_FAILURE, "listenerErrorWhenCommit", null, activityId, executionId, processInstanceId, processDefId, businessKey, jobId, entityNumber, e));
                                }
                                catch (Exception ignore) {
                                    ExecuteTaskListenerTransactionListener.this.log.warn(String.format("Exception occurred while dispatching job failure event, ignoring[%s].", WfUtils.getExceptionStacktrace(ignore)));
                                }
                            }
                        }
                        finally {
                            if (ExecuteTaskListenerTransactionListener.this.taskEntity != null) {
                                ExecuteTaskListenerTransactionListener.this.taskEntity.setEventName(null);
                            }
                            execution.setEventName(event);
                        }
                        return null;
                    }
                });
            }
            catch (Exception e) {
                this.log.error(WfUtils.getExceptionStacktrace(e));
            }
        }
    }
}

