/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.workflow.engine.impl.bpmn.listener;

import com.alibaba.fastjson.JSONObject;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.exception.KDBizException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.workflow.api.AgentExecution;
import kd.bos.workflow.api.ExecutionListener;
import kd.bos.workflow.api.constants.ProcessType;
import kd.bos.workflow.bpmn.converter.BpmnJsonConverterUtil;
import kd.bos.workflow.bpmn.converter.util.ModelConfigUtil;
import kd.bos.workflow.bpmn.diff.util.BpmnDiffUtil;
import kd.bos.workflow.bpmn.model.ActivitiListener;
import kd.bos.workflow.bpmn.model.Activity;
import kd.bos.workflow.bpmn.model.FlowElement;
import kd.bos.workflow.bpmn.model.FlowNode;
import kd.bos.workflow.bpmn.model.HasExecutionListeners;
import kd.bos.workflow.bpmn.model.IEntitySupport;
import kd.bos.workflow.bpmn.model.Process;
import kd.bos.workflow.bpmn.model.Task;
import kd.bos.workflow.bpmn.model.UserTask;
import kd.bos.workflow.engine.WfUtils;
import kd.bos.workflow.engine.delegate.BaseTaskListener;
import kd.bos.workflow.engine.delegate.DelegateExecution;
import kd.bos.workflow.engine.delegate.TaskListener;
import kd.bos.workflow.engine.enumeration.TaskListenerInvocationType;
import kd.bos.workflow.engine.extitf.ExternalInterfaceUtil;
import kd.bos.workflow.engine.idempotent.IdempotentHelper;
import kd.bos.workflow.engine.impl.bpmn.helper.nodetemplate.NodeTemplateUtil;
import kd.bos.workflow.engine.impl.bpmn.listener.ExecuteExecutionListenerTransactionListener;
import kd.bos.workflow.engine.impl.bpmn.listener.ExecuteTaskListenerTransactionListener;
import kd.bos.workflow.engine.impl.bpmn.parser.factory.ListenerFactory;
import kd.bos.workflow.engine.impl.context.Context;
import kd.bos.workflow.engine.impl.delegate.invocation.TaskListenerInvocation;
import kd.bos.workflow.engine.impl.interceptor.CommandContext;
import kd.bos.workflow.engine.impl.persistence.entity.runtime.ExecutionEntity;
import kd.bos.workflow.engine.impl.persistence.entity.task.TaskEntity;
import kd.bos.workflow.engine.impl.util.BpmnModelUtil;
import kd.bos.workflow.engine.impl.util.CollectionUtil;
import kd.bos.workflow.engine.impl.util.DynamicFlowUtil;
import kd.bos.workflow.engine.impl.util.ProcessDefinitionUtil;
import kd.bos.workflow.engine.impl.util.TaskHelper;
import kd.bos.workflow.exception.ExceptionUtil;
import kd.bos.workflow.exception.WFBizException;
import kd.bos.workflow.exception.WFEngineException;
import kd.bos.workflow.service.WfTraceType;

public class ListenerNotificationHelper {
    private Log log = LogFactory.getLog(this.getClass());

    public void executeExecutionListeners(HasExecutionListeners elementWithExecutionListeners, DelegateExecution execution, String eventType) {
        ArrayList<ActivitiListener> listeners = new ArrayList<ActivitiListener>();
        ModelConfigUtil.addUniqueListeners(listeners, elementWithExecutionListeners.getExecutionListeners());
        this.addExpendPluginListener(execution, eventType, listeners);
        if (elementWithExecutionListeners instanceof Activity) {
            Activity task = (Activity)elementWithExecutionListeners;
            List<ActivitiListener> eListeners = BpmnJsonConverterUtil.getExecutionListenerFromProcess(task);
            ModelConfigUtil.addUniqueListeners(listeners, eListeners);
            Map<String, Map<String, UserTask>> configCache = Context.getCommandContext().getProcessEngineConfiguration().getDynModelConfigCache();
            List<ActivitiListener> tmp = ModelConfigUtil.getListenersConfig(execution.getEntityNumber(), task.getType(), false, configCache);
            if (tmp != null && !tmp.isEmpty()) {
                ModelConfigUtil.addUniqueListeners(listeners, tmp);
            }
        } else if (elementWithExecutionListeners instanceof Process) {
            Map<String, Map<String, UserTask>> configCache = Context.getCommandContext().getProcessEngineConfiguration().getDynModelConfigCache();
            List<ActivitiListener> tmp = ModelConfigUtil.getListenersConfig(execution.getEntityNumber(), "Diagram", false, configCache);
            if (tmp != null && !tmp.isEmpty()) {
                listeners.addAll(tmp);
            }
        }
        if (listeners != null && !listeners.isEmpty()) {
            ListenerFactory listenerFactory = Context.getProcessEngineConfiguration().getListenerFactory();
            for (ActivitiListener activitiListener : listeners) {
                boolean isUserDefined;
                this.log.debug(String.format("executeExecutionListeners:[evtType:%s-listener:%s]", eventType, activitiListener.getImplementation()));
                if (!eventType.equals(activitiListener.getEvent())) continue;
                String operation = activitiListener.getOperation();
                String node = elementWithExecutionListeners instanceof FlowNode ? ((FlowNode)elementWithExecutionListeners).getId() : "";
                boolean isJump = DynamicFlowUtil.isJumpInCurrentNode(execution, execution.getCurrentActivityId());
                boolean isReject = DynamicFlowUtil.isRejectInCurrentNode(execution, execution.getCurrentActivityId());
                boolean isBillWithdrawJump = DynamicFlowUtil.isBillWithdrawJumpInCurrentNode(execution, execution.getCurrentActivityId());
                boolean bl = isUserDefined = ExternalInterfaceUtil.isValidValue(activitiListener.getImplementation()) || activitiListener.getUserDefinied() != null && Boolean.TRUE.equals(activitiListener.getUserDefinied());
                if (isUserDefined) {
                    if (DynamicFlowUtil.isSkipCurNodeForListener(execution)) {
                        this.log.debug(String.format("--cannot execute listener when skip, node is [%s],dynType is [%s]", execution.getCurrentActivityId(), DynamicFlowUtil.getDynamicType((ExecutionEntity)execution)));
                        continue;
                    }
                    if ("jump".equals(operation) && !isJump || "reject".equals(operation) && !isReject || "normal".equals(operation) && (isReject || isJump || isBillWithdrawJump)) {
                        this.log.debug(String.format("--cannot execute listener when jump or reject, node is [%s],operation is [%s], jump is [%s],reject is [%s],listener is [%s]", execution.getCurrentActivityId(), operation, isJump, isReject, activitiListener.getImplementation()));
                        continue;
                    }
                }
                this.log.debug(String.format("executeExecutionListeners:[node:%s-evtType:%s-jump:%s-reject:%s-listener:%s-option:%s]", node, eventType, isJump, isReject, activitiListener.getImplementation(), operation));
                ExecutionListener executionListener = null;
                ExecutionListener executionListenerWhenCommit = null;
                if (ExternalInterfaceUtil.isValidValue(activitiListener.getImplementation())) {
                    if (WfUtils.isNotEmpty(activitiListener.getOnTransaction())) {
                        executionListenerWhenCommit = listenerFactory.createExtItfExecutionListener(activitiListener.getImplementationType(), activitiListener);
                    } else {
                        executionListener = listenerFactory.createExtItfExecutionListener(activitiListener.getImplementationType(), activitiListener);
                    }
                } else if ("class".equalsIgnoreCase(activitiListener.getImplementationType())) {
                    String implementation = activitiListener.getImplementation();
                    if (implementation != null && WfUtils.isEmpty(activitiListener.getOnTransaction())) {
                        executionListener = listenerFactory.createClassDelegateExecutionListener(activitiListener);
                    } else {
                        executionListenerWhenCommit = listenerFactory.createClassDelegateExecutionListener(activitiListener);
                    }
                }
                if (executionListener != null) {
                    execution.setEventName(WfUtils.isEmpty(operation) ? eventType : eventType + "@" + operation);
                    execution.setCurrentActivitiListener(activitiListener);
                    execution.setCurrentWFPlugin(activitiListener.getImplementation());
                    if (this.canExecute(activitiListener, execution)) {
                        executionListener.notify((AgentExecution)execution);
                        this.log.debug(String.format("execution listener[%s] when tx is not closed.", executionListener.getClass().getName()));
                    } else {
                        this.log.debug(String.format("listener: %s %s %s cann't be executed!", activitiListener.getEvent(), activitiListener.getImplementationType(), activitiListener.getImplementation()));
                    }
                    execution.setEventName(null);
                    execution.setCurrentActivitiListener(null);
                    execution.setCurrentWFPlugin(null);
                    continue;
                }
                if (executionListenerWhenCommit == null) continue;
                this.planTransactionDependentExecutionListener(listenerFactory, execution, executionListenerWhenCommit, activitiListener);
            }
        }
    }

    private void addExpendPluginListener(DelegateExecution execution, String eventType, List<ActivitiListener> listeners) {
        FlowElement currentFlowElement = execution.getCurrentFlowElement();
        if (!NodeTemplateUtil.isScalableNodes(currentFlowElement)) {
            return;
        }
        List<JSONObject> extPluginList = NodeTemplateUtil.getExtPluginsByType(currentFlowElement, currentFlowElement.getType(), "executionListeners");
        for (JSONObject executionListener : extPluginList) {
            String event = executionListener.getString("event");
            String string = event = "jump".equals(event) || "reject".equals(event) || "normal".equals(event) ? "start" : event;
            if (!eventType.equals(event)) continue;
            ActivitiListener activitiListener = new ActivitiListener();
            activitiListener.setEvent(event);
            activitiListener.setImplementation(executionListener.getString("pluginTypeAndValue"));
            activitiListener.setImplementationType(executionListener.getString("implementationtype"));
            activitiListener.setId(BpmnDiffUtil.getListElementId("executionListeners"));
            activitiListener.setOperation(executionListener.getString("event"));
            listeners.add(activitiListener);
        }
    }

    private boolean canExecute(ActivitiListener listener, DelegateExecution execution) {
        String processType = ((ExecutionEntity)execution).getProcessType();
        if (ProcessType.BizFlow.name().equals(processType)) {
            String entityNumber = listener.getBillNumber();
            if (WfUtils.isEmpty(entityNumber) && execution.getCurrentFlowElement() instanceof Task && execution.getCurrentFlowElement() instanceof IEntitySupport) {
                Set<String> set = BpmnModelUtil.getTargetEntityNumber(execution.getCurrentFlowElement());
                String string = entityNumber = set == null || set.isEmpty() ? null : set.iterator().next();
            }
            if (entityNumber != null && WfUtils.isNotEmpty(entityNumber) && !entityNumber.equals(execution.getEntityNumber())) {
                this.log.debug(String.format("%s %s entity is different,can not execute!", execution.getEntityNumber(), entityNumber));
                return false;
            }
        }
        if (("terminate".equals(listener.getEvent()) || "withdraw_audited_proc".equals(listener.getEvent())) && "operation".equals(listener.getImplementationType())) {
            if (!WfUtils.exist(execution.getEntityNumber(), (Object)execution.getBusinessKey())) {
                this.log.debug(String.format("%s %s cann't found!", execution.getEntityNumber(), execution.getBusinessKey()));
                return false;
            }
            try {
                String type = ExternalInterfaceUtil.getExtItfValue(listener.getImplementation());
                HashMap<String, Object> im = ExternalInterfaceUtil.castJSONToMap(type);
                String op = (String)im.get("forward");
                String excepitonEvent = (String)execution.getVariable("exceptionEvent");
                if (op != null && excepitonEvent != null && excepitonEvent.equalsIgnoreCase(op)) {
                    this.log.debug(String.format("%s has been executed before due to bill operation [%s]!", op, excepitonEvent));
                    return false;
                }
            }
            catch (Exception e) {
                this.log.debug(String.format("[%s] errord when cast map,error is [%s]", listener.getImplementation(), e.getMessage()));
            }
            return true;
        }
        return true;
    }

    protected void planTransactionDependentExecutionListener(ListenerFactory listenerFactory, DelegateExecution execution, ExecutionListener executionListener, ActivitiListener activitiListener) {
        Context.getCommandContext().addCloseListener(new ExecuteExecutionListenerTransactionListener("commitListener", executionListener, execution));
    }

    public void executeTaskListeners(TaskEntity taskEntity, String eventType) {
        if (taskEntity != null) {
            String taskSource = taskEntity.getSource();
            this.log.info(String.format("executeTaskListeners taskId:%s taskSource:%s eventType:%s", taskEntity.getId(), taskSource, eventType));
            if (!taskEntity.isBizTask() && taskEntity.getProcessDefinitionId() != null) {
                Process process = ProcessDefinitionUtil.getProcess(taskEntity.getProcessDefinitionId(), taskEntity.getProcessInstanceId());
                FlowElement flowElement = process.getFlowElement(taskEntity.getTaskDefinitionKey(), true);
                if (flowElement instanceof UserTask) {
                    UserTask userTask = (UserTask)flowElement;
                    this.executeTaskListeners(userTask, taskEntity, eventType, TaskListenerInvocationType.NOTWITHDRAW);
                }
            } else if (taskEntity.isBizTask()) {
                this.log.debug(String.format("task[%s] is null when invoke event [%s]", taskEntity.getId(), eventType));
                this.executeCustomTaskListeners(null, taskEntity, eventType, TaskListenerInvocationType.NOTWITHDRAW);
            }
        }
    }

    public void executeWithdrawTaskListeners(TaskEntity taskEntity, String eventType) {
        Process process;
        FlowElement flowElement;
        if (taskEntity.getProcessDefinitionId() != null && (flowElement = (process = ProcessDefinitionUtil.getProcess(taskEntity.getProcessDefinitionId(), taskEntity.getProcessInstanceId())).getFlowElement(taskEntity.getTaskDefinitionKey(), true)) instanceof UserTask) {
            UserTask userTask = (UserTask)flowElement;
            this.executeTaskListeners(userTask, taskEntity, eventType, TaskListenerInvocationType.WITHDRAW);
            CommandContext commandContext = Context.getCommandContext();
            Long actInstId = commandContext.getHistoricActivityInstanceEntityManager().findActivityIdByTask(taskEntity.getId());
            IdempotentHelper.deleteListenerExecuteLog(commandContext, taskEntity.getBusinessKey(), actInstId, eventType);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void executeCustomTaskListeners(UserTask userTasks, TaskEntity taskEntity, String eventType, TaskListenerInvocationType withdraw) {
        ArrayList<ActivitiListener> listeners = new ArrayList<ActivitiListener>();
        ActivitiListener al = new ActivitiListener();
        al.setEvent("delete");
        al.setImplementation("kd.bos.workflow.engine.task.center.TaskCompleteListener");
        al.setImplementationType("class");
        al.setUserDefinied(Boolean.FALSE);
        listeners.add(al);
        String number = "";
        if (null != taskEntity) {
            number = (String)taskEntity.getVariableLocal("auditNumber");
        }
        for (ActivitiListener activitiListener : listeners) {
            this.log.debug("--executeTaskListeners: " + eventType + "  " + number + "  " + activitiListener.getOperation() + "  " + activitiListener.getImplementation() + " " + taskEntity.getId());
            String event = activitiListener.getEvent();
            this.log.debug("--executeTaskListeners: " + event + "  " + number + "  " + activitiListener.getOperation() + "  " + activitiListener.getImplementation() + " " + taskEntity.getId());
            if (!event.equals(eventType) && !event.equals("all")) continue;
            BaseTaskListener taskListener = this.createTaskListener(activitiListener);
            taskEntity.setEventName(eventType + "@" + number);
            taskEntity.setCurrentActivitiListener(activitiListener);
            try {
                Context.getProcessEngineConfiguration().getDelegateInterceptor().handleInvocation(new TaskListenerInvocation((TaskListener)taskListener, taskEntity, withdraw));
            }
            catch (Exception e) {
                KDBizException kdBizExeception;
                if (WfTraceType.getOrCreate() == null || WfTraceType.getOrCreate().getJobInfo() == null) {
                    throw new WFEngineException("Exception while invoking TaskListener: " + e.getMessage(), e);
                }
                if (e instanceof WFBizException && ((WFBizException)((Object)e)).getCause() != null && ((WFBizException)((Object)e)).getCause() instanceof KDBizException) {
                    kdBizExeception = (KDBizException)((WFBizException)((Object)e)).getCause();
                    if (ExceptionUtil.matchBoundryException(kdBizExeception, taskEntity.getExecution())) continue;
                    throw e;
                }
                if (e instanceof KDBizException) {
                    kdBizExeception = (KDBizException)((Object)e);
                    if (!ExceptionUtil.matchBoundryException(kdBizExeception, taskEntity.getExecution())) {
                        throw e;
                    }
                    taskEntity.setExecutionType("enterBoundary");
                    continue;
                }
                if (e instanceof WFBizException) {
                    throw e;
                }
                throw new WFEngineException("Exception while invoking TaskListener: " + WfUtils.getExceptionStacktrace(e), e);
            }
            finally {
                taskEntity.setEventName(null);
                taskEntity.setCurrentActivitiListener(null);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void executeTaskListeners(UserTask userTask, TaskEntity taskEntity, String eventType, TaskListenerInvocationType withdraw) {
        ArrayList<ActivitiListener> listeners = new ArrayList<ActivitiListener>();
        Map<String, Map<String, UserTask>> configCache = Context.getCommandContext().getProcessEngineConfiguration().getDynModelConfigCache();
        List<ActivitiListener> tListeners = BpmnJsonConverterUtil.getTaskListenerFromProcess(userTask);
        ModelConfigUtil.addUniqueListeners(listeners, tListeners);
        ModelConfigUtil.addUniqueListeners(listeners, userTask.getTaskListeners());
        String entityNumber = "";
        String number = "";
        if (null != taskEntity) {
            Object auditNumber;
            Map<String, Object> tmp;
            entityNumber = taskEntity.getEntityNumber();
            number = (String)taskEntity.getVariableLocal("auditNumber");
            if (TaskListenerInvocationType.WITHDRAW == withdraw && WfUtils.isEmpty(number) && null != (tmp = Context.getCommandContext().getHistoricVariableInstanceEntityManager().findVariablesByTaskId(taskEntity.getId())) && WfUtils.isNotEmptyString(auditNumber = tmp.get("auditNumber"))) {
                number = (String)auditNumber;
            }
        }
        listeners.addAll(ModelConfigUtil.getListenersConfig(entityNumber, userTask.getType(), true, configCache));
        this.log.debug(String.format("listeners:%s", WfUtils.listToString(listeners, ",")));
        for (ActivitiListener activitiListener : listeners) {
            boolean isUserDefined;
            this.log.debug("--executeTaskListeners: " + eventType + "  " + number + "  " + activitiListener.getOperation() + "  " + activitiListener.getImplementation() + " " + taskEntity.getId());
            if (WfUtils.isNotEmpty(activitiListener.getOperation()) && !"approverModify".equals(activitiListener.getOperation()) && !activitiListener.getOperation().equals(number)) continue;
            boolean bl = isUserDefined = ExternalInterfaceUtil.isValidValue(activitiListener.getImplementation()) || activitiListener.getUserDefinied() != null && Boolean.TRUE.equals(activitiListener.getUserDefinied());
            if (isUserDefined && DynamicFlowUtil.isSkipCurNode(taskEntity.getExecution())) {
                this.log.debug("--cannot execute listener when skip, node is " + taskEntity.getTaskDefinitionKey());
                continue;
            }
            String event = activitiListener.getEvent();
            this.log.debug("--executeTaskListeners: " + event + "  " + number + "  " + activitiListener.getOperation() + "  " + activitiListener.getImplementation() + " " + taskEntity.getId());
            if (!event.equals(eventType) && !event.equals("all")) continue;
            BaseTaskListener taskListener = this.createTaskListener(activitiListener);
            taskEntity.setEventName(eventType + "@" + number);
            taskEntity.setCurrentActivitiListener(activitiListener);
            try {
                Context.getProcessEngineConfiguration().getDelegateInterceptor().handleInvocation(new TaskListenerInvocation((TaskListener)taskListener, taskEntity, withdraw));
            }
            catch (Exception e) {
                KDBizException kdBizExeception;
                if (WfTraceType.getOrCreate() == null || WfTraceType.getOrCreate().getJobInfo() == null) {
                    throw new WFEngineException("Exception while invoking TaskListener: " + e.getMessage(), e);
                }
                if (e instanceof WFBizException && ((WFBizException)((Object)e)).getCause() != null && ((WFBizException)((Object)e)).getCause() instanceof KDBizException) {
                    kdBizExeception = (KDBizException)((WFBizException)((Object)e)).getCause();
                    if (!ExceptionUtil.matchBoundryException(kdBizExeception, taskEntity.getExecution())) {
                        throw e;
                    }
                    taskEntity.setExecutionType("enterBoundary");
                    continue;
                }
                if (e instanceof KDBizException) {
                    kdBizExeception = (KDBizException)((Object)e);
                    if (!ExceptionUtil.matchBoundryException(kdBizExeception, taskEntity.getExecution())) {
                        throw e;
                    }
                    taskEntity.setExecutionType("enterBoundary");
                    continue;
                }
                if (e instanceof WFBizException) {
                    throw e;
                }
                throw new WFEngineException("Exception while invoking TaskListener: " + e.getMessage(), e);
            }
            finally {
                taskEntity.setEventName(null);
                taskEntity.setCurrentActivitiListener(null);
            }
        }
    }

    protected BaseTaskListener createTaskListener(ActivitiListener activitiListener) {
        TaskListener taskListener = null;
        ListenerFactory listenerFactory = Context.getProcessEngineConfiguration().getListenerFactory();
        if (ExternalInterfaceUtil.isValidValue(activitiListener.getImplementation())) {
            taskListener = listenerFactory.createExtItfTaskListener(activitiListener.getImplementationType(), activitiListener);
        } else if ("class".equalsIgnoreCase(activitiListener.getImplementationType())) {
            taskListener = listenerFactory.createClassDelegateTaskListener(activitiListener);
        }
        return taskListener;
    }

    public void executeWithdrawExecutionListeners(HasExecutionListeners elementWithExecutionListeners, DelegateExecution execution, String eventType, String operationName, Long actInstId) {
        ArrayList<ActivitiListener> listeners = new ArrayList<ActivitiListener>();
        String activityId = "";
        if (elementWithExecutionListeners instanceof UserTask) {
            UserTask task = (UserTask)elementWithExecutionListeners;
            activityId = task.getId();
            Map<String, Map<String, UserTask>> configCache = Context.getCommandContext().getProcessEngineConfiguration().getDynModelConfigCache();
            listeners.addAll(ModelConfigUtil.getListenersConfig(execution.getEntityNumber(), task.getType(), false, configCache));
        }
        ModelConfigUtil.addUniqueListeners(listeners, elementWithExecutionListeners.getExecutionListeners());
        if (CollectionUtil.isNotEmpty(listeners)) {
            ListenerFactory listenerFactory = Context.getProcessEngineConfiguration().getListenerFactory();
            TaskHelper taskHelper = Context.getProcessEngineConfiguration().getTaskHelper();
            for (ActivitiListener activitiListener : listeners) {
                if (!eventType.equals(activitiListener.getEvent())) continue;
                ExecutionListener executionListener = null;
                if (ExternalInterfaceUtil.isValidValue(activitiListener.getImplementation())) {
                    Map mp;
                    Map m;
                    if (WfUtils.isNotEmpty(operationName) && (m = (Map)SerializationUtils.fromJsonString((String)activitiListener.getImplementation(), Map.class)).get("value") instanceof Map && (mp = (Map)m.get("value")).containsKey("withdraw") && mp.get("withdraw").equals(operationName)) {
                        this.log.debug(String.format("--cannot execute listener[%s] because operationName[%s] equals withdraw listener", activitiListener.getImplementation(), operationName));
                        continue;
                    }
                    String operation = activitiListener.getOperation();
                    if ("start".equals(eventType)) {
                        if ("jump".equals(operation)) {
                            this.log.debug(String.format("--cannot execute listener[%s] because  operation is jump", activitiListener.getImplementation()));
                            continue;
                        }
                        boolean isRejectTask = taskHelper.isRejectTask(execution.getProcessInstanceId(), actInstId, activityId);
                        if ("reject".equals(operation) && !isRejectTask) {
                            this.log.debug(String.format("--cannot execute listener[%s] because operation is not reject", activitiListener.getImplementation()));
                            continue;
                        }
                        if ("normal".equals(operation) && isRejectTask) {
                            this.log.debug(String.format("--cannot execute listener[%s] because operation is normal but the task was rejected", activitiListener.getImplementation()));
                            continue;
                        }
                    }
                    executionListener = listenerFactory.createExtItfExecutionListener(activitiListener.getImplementationType(), activitiListener);
                } else if ("class".equalsIgnoreCase(activitiListener.getImplementationType())) {
                    executionListener = listenerFactory.createClassDelegateExecutionListener(activitiListener);
                }
                if (executionListener == null) continue;
                execution.setEventName(eventType);
                execution.setCurrentActivitiListener(activitiListener);
                executionListener.notifyByWithdraw((AgentExecution)execution);
                execution.setEventName(null);
                execution.setCurrentActivitiListener(null);
            }
            IdempotentHelper.deleteListenerExecuteLog(Context.getCommandContext(), execution.getBusinessKey(), actInstId, eventType);
        }
    }

    public boolean executeCanWithdrawListeners(UserTask userTask, TaskEntity taskEntity) {
        boolean result = true;
        String eventType = "canWithdraw";
        ArrayList<ActivitiListener> listeners = new ArrayList<ActivitiListener>();
        CommandContext commandContext = Context.getCommandContext();
        Map<String, Map<String, UserTask>> configCache = commandContext.getProcessEngineConfiguration().getDynModelConfigCache();
        listeners.addAll(ModelConfigUtil.getListenersConfig(taskEntity.getEntityNumber(), userTask.getType(), true, configCache));
        for (ActivitiListener activitiListener : listeners) {
            if (!eventType.equals(activitiListener.getEvent())) continue;
            this.log.debug("--activitiListener: " + activitiListener + "  " + activitiListener.getOperation() + "  " + activitiListener.getImplementation() + " " + taskEntity.getId());
            TaskListener taskListener = null;
            if (ExternalInterfaceUtil.isValidValue(activitiListener.getImplementation())) {
                ListenerFactory listenerFactory = Context.getProcessEngineConfiguration().getListenerFactory();
                Map m = (Map)SerializationUtils.fromJsonString((String)activitiListener.getImplementation(), Map.class);
                taskListener = listenerFactory.createExtItfTaskListener(activitiListener.getImplementationType(), activitiListener);
            }
            if (taskListener != null) {
                taskEntity.setEventName(eventType);
                taskEntity.setCurrentActivitiListener(activitiListener);
                try {
                    result = taskListener.canWithdraw(taskEntity);
                }
                catch (Exception e) {
                    this.log.debug(e.getMessage());
                    throw e;
                }
                taskEntity.setEventName(null);
                taskEntity.setCurrentActivitiListener(null);
                continue;
            }
            this.log.debug("taskListener \u4e3a\u7a7a");
        }
        return result;
    }

    public void executeAfterTaskListeners(TaskEntity task, String eventName) {
        this.executeAfterTaskListeners(task, eventName, Collections.emptyMap());
    }

    public void executeAfterTaskListeners(TaskEntity taskEntity, String eventName, Map<String, Object> params) {
        if (taskEntity.getProcessDefinitionId() != null) {
            Process process;
            FlowElement flowElement;
            if (params == null) {
                params = Collections.emptyMap();
            }
            if ((flowElement = (process = ProcessDefinitionUtil.getProcess(taskEntity.getProcessDefinitionId(), taskEntity.getProcessInstanceId())).getFlowElement(taskEntity.getTaskDefinitionKey(), true)) instanceof UserTask) {
                UserTask userTask = (UserTask)flowElement;
                this.executeAfterTaskListeners(userTask, taskEntity, eventName, params);
            }
        }
    }

    private void executeAfterTaskListeners(UserTask userTask, TaskEntity taskEntity, String eventName, Map<String, Object> params) {
        if (params == null) {
            params = Collections.emptyMap();
        }
        if (taskEntity == null) {
            this.log.debug("executeAfterTaskListeners error,taskentity is null");
            return;
        }
        ArrayList<ActivitiListener> listeners = new ArrayList<ActivitiListener>();
        CommandContext commandContext = Context.getCommandContext();
        Map<String, Map<String, UserTask>> configCache = commandContext.getProcessEngineConfiguration().getDynModelConfigCache();
        List<ActivitiListener> tListeners = BpmnJsonConverterUtil.getTaskListenerFromProcess(userTask);
        ModelConfigUtil.addUniqueListeners(listeners, tListeners);
        ModelConfigUtil.addUniqueListeners(listeners, userTask.getTaskListeners());
        String entityNumber = taskEntity.getEntityNumber();
        this.log.debug(String.format("[%1$s][%2$s][%3$s]\u76d1\u542c", "tasklistener", userTask.getName(), eventName));
        listeners.addAll(ModelConfigUtil.getListenersConfig(entityNumber, userTask.getType(), true, configCache));
        for (ActivitiListener activitiListener : listeners) {
            String event = activitiListener.getEvent();
            this.log.debug("--executeAfterTaskListeners: " + event + ", " + eventName + " " + activitiListener.getOperation() + "  " + activitiListener.getImplementation() + " " + taskEntity.getId());
            if (!event.equals(eventName) && !event.equals("all")) continue;
            this.log.debug("--executeAfterTaskListeners--: " + eventName);
            TaskListener taskListener = (TaskListener)this.createTaskListener(activitiListener);
            this.planTransactionDependentTaskListener(taskListener, taskEntity, eventName, params);
        }
    }

    private void planTransactionDependentTaskListener(TaskListener listener, TaskEntity taskEntity, String eventName, Map<String, Object> params) {
        Context.getCommandContext().addCloseListener(new ExecuteTaskListenerTransactionListener("afterTaskListeners", listener, taskEntity, eventName, params));
    }
}

