/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.workflow.engine.impl.bpmn.listener;

import java.util.ArrayList;
import java.util.List;
import kd.bos.workflow.engine.WfUtils;
import kd.bos.workflow.engine.impl.cfg.TransactionPropagation;
import kd.bos.workflow.engine.impl.clean.calculator.CleanDataCalculator;
import kd.bos.workflow.engine.impl.cmd.history.MoveFinishedProcessJobsToHistoryCmd;
import kd.bos.workflow.engine.impl.interceptor.CommandConfig;
import kd.bos.workflow.engine.impl.interceptor.CommandContext;
import kd.bos.workflow.engine.impl.interceptor.CommandContextCloseListener;
import kd.bos.workflow.engine.impl.interceptor.CommandExecutor;
import kd.bos.workflow.engine.impl.persistence.entity.runtime.ExecutionEntity;

public class ProcessInstanceFinishListener
implements CommandContextCloseListener {
    private Long procInstId;
    private ExecutionEntity processInstanceEntity;
    private List<String> entityNumbers;
    private List<String> businessKeys;
    private boolean useCleanFrame;

    public ProcessInstanceFinishListener(ExecutionEntity processInstanceEntity, List<String> businessKeys, boolean useCleanFrame) {
        this.procInstId = processInstanceEntity.getProcessInstanceId();
        this.processInstanceEntity = processInstanceEntity;
        this.businessKeys = businessKeys;
        this.useCleanFrame = useCleanFrame;
    }

    public ProcessInstanceFinishListener(ExecutionEntity processInstanceEntity, List<String> entityNumbers, List<String> businessKeys, boolean useCleanFrame) {
        this.procInstId = processInstanceEntity.getProcessInstanceId();
        this.processInstanceEntity = processInstanceEntity;
        this.entityNumbers = entityNumbers;
        this.businessKeys = businessKeys;
        this.useCleanFrame = useCleanFrame;
    }

    public ProcessInstanceFinishListener(Long procInstId, String businessKey) {
        this.procInstId = procInstId;
    }

    @Override
    public void afterSessionsFlush(CommandContext commandContext) {
    }

    @Override
    public void closed(CommandContext commandContext) {
        if (WfUtils.isEmpty(this.procInstId)) {
            return;
        }
        commandContext.getDeploymentManager().getProcessDefinitionCache().remove(this.procInstId);
        CommandExecutor commandExecutor = commandContext.getProcessEngineConfiguration().getCommandExecutor();
        CommandConfig commandConfig = new CommandConfig(false, TransactionPropagation.REQUIRES_NEW);
        ArrayList<Long> procInstIds = new ArrayList<Long>(1);
        procInstIds.add(this.procInstId);
        commandExecutor.execute(commandConfig, ctx -> {
            if (this.useCleanFrame) {
                CleanDataCalculator.create().executeProcessCleaners(ctx, "immediate", this.businessKeys, procInstIds);
            }
            if (this.procInstId.equals(this.processInstanceEntity.getRootProcessInstanceId())) {
                new MoveFinishedProcessJobsToHistoryCmd(this.entityNumbers, this.businessKeys, this.procInstId).execute(ctx);
            }
            return null;
        });
    }

    @Override
    public void closeFailure(CommandContext commandContext) {
    }

    @Override
    public void closing(CommandContext commandContext) {
    }
}

