/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.workflow.engine.impl.bpmn.listener;

import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.workflow.api.AgentExecution;
import kd.bos.workflow.api.ExecutionListener;
import kd.bos.workflow.engine.WfUtils;
import kd.bos.workflow.engine.impl.cmd.startup.TryTriggerProcessCmd;
import kd.bos.workflow.engine.impl.context.Context;
import kd.bos.workflow.engine.impl.interceptor.CommandContext;
import kd.bos.workflow.engine.impl.interceptor.DefaultCommandContextCloseListener;
import kd.bos.workflow.engine.impl.jobexecutor.JobUtil;
import kd.bos.workflow.engine.impl.persistence.entity.job.JobEntity;

public class RestartProcessListener
implements ExecutionListener {
    private static final long serialVersionUID = 2480709956801930763L;
    private Log logger = LogFactory.getLog(RestartProcessListener.class);

    public void notify(AgentExecution execution) {
        Map<String, Object> variables = new HashMap(16);
        String jsonVar = (String)execution.getVariable("restartVariables");
        if (WfUtils.isEmpty(jsonVar)) {
            this.logger.debug("\u9a73\u56de\u91cd\u65b0\u5bfb\u5740\u6ca1\u6709\u83b7\u53d6\u5230\u53d8\u91cf\u8868\u4fe1\u606f");
            return;
        }
        variables = (Map)SerializationUtils.fromJsonString((String)jsonVar, Map.class);
        Long procdefId = Long.valueOf(String.valueOf(execution.getVariable("wfProcessDefineId")));
        Long schemeId = Long.valueOf(String.valueOf(execution.getVariable("wfSchemeId")));
        String operation = (String)execution.getVariable("wfOperation");
        variables.put("procdefid", procdefId.toString());
        variables.put("wfSchemeId", schemeId);
        DynamicObject obj = WfUtils.findBusinessObject(execution.getBusinessKey(), execution.getEntityNumber());
        DynamicObject[] objs = new DynamicObject[]{obj};
        this.logger.debug(String.format("\u9a73\u56de\u91cd\u65b0\u5bfb\u5740\u7684\u6d41\u7a0bid\u3001\u65b9\u6848id\u3001\u4e1a\u52a1\u4e3b\u952e\u3001\u5b9e\u4f53\u7f16\u7801\u4e3a\uff1a%1$s\uff0c%2$s\uff0c%3$s\uff0c%4$s", procdefId, schemeId, execution.getBusinessKey(), execution.getEntityNumber()));
        CommandContext commandContext = Context.getCommandContext();
        Object jobs = new TryTriggerProcessCmd(objs, operation, variables).execute(commandContext);
        if (jobs != null && !jobs.isEmpty()) {
            this.logger.debug("\u9a73\u56de\u91cd\u65b0\u5bfb\u5740\u521b\u5efajob\u6210\u529f");
            Iterator iterator = jobs.iterator();
            while (iterator.hasNext()) {
                JobEntity job = (JobEntity)iterator.next();
                commandContext.getJobEntityManager().insert(job);
            }
            commandContext.addCloseListener(new DefaultCommandContextCloseListener("RestartProcessListener", (List)jobs){
                final /* synthetic */ List val$jobs;
                {
                    this.val$jobs = list;
                    super(aim);
                }

                @Override
                public void closed(CommandContext commandContext) {
                    RestartProcessListener.this.logger.debug("\u9a73\u56de\u91cd\u65b0\u5bfb\u5740\u91cd\u65b0\u542f\u52a8\u6d41\u7a0b\u53d1\u9001\u6d88\u606f");
                    JobUtil.sendJobToMQ(this.val$jobs);
                }
            });
        }
    }
}

