/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.workflow.engine.impl.bpmn.listener;

import com.alibaba.fastjson.JSONObject;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.exception.ORMDesignException;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.MainEntityType;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.workflow.api.AgentExecution;
import kd.bos.workflow.api.ExecutionListener;
import kd.bos.workflow.bpmn.model.FlowElement;
import kd.bos.workflow.bpmn.model.Process;
import kd.bos.workflow.bpmn.model.UserTask;
import kd.bos.workflow.engine.WfConfigurationUtil;
import kd.bos.workflow.engine.WfUtils;
import kd.bos.workflow.engine.delegate.DelegateExecution;
import kd.bos.workflow.engine.impl.context.Context;
import kd.bos.workflow.engine.impl.interceptor.CommandContext;
import kd.bos.workflow.engine.impl.persistence.entity.design.ModelType;
import kd.bos.workflow.engine.impl.persistence.entity.history.HistoricActivityInstanceEntity;
import kd.bos.workflow.engine.impl.persistence.entity.runtime.ExecutionEntity;
import kd.bos.workflow.engine.impl.util.CollectionUtil;
import kd.bos.workflow.engine.impl.util.ProcessDefinitionUtil;
import kd.bos.workflow.engine.impl.util.SensitiveFieldUtil;

public class SensitiveFieldRecordListener
implements ExecutionListener {
    private static final long serialVersionUID = -4177296821788027764L;
    private static final String FIELDNAME = "fieldname";
    private static final String FIELDKEY = "fieldkey";
    private static Log log = LogFactory.getLog(SensitiveFieldRecordListener.class);

    public void notify(AgentExecution execution) {
        HistoricActivityInstanceEntity ac;
        DelegateExecution exe = (DelegateExecution)execution;
        CommandContext commandContext = Context.getCommandContext();
        if (WfUtils.isNotEmpty(exe.getCurrentActInstId()) && (ac = (HistoricActivityInstanceEntity)commandContext.getHistoricActivityInstanceEntityManager().findById(exe.getCurrentActInstId())) != null && ("jump".equalsIgnoreCase(ac.getExecutionType()) || "skip".equalsIgnoreCase(ac.getExecutionType()))) {
            return;
        }
        ExecutionEntity executionEntity = (ExecutionEntity)execution;
        Process mainProcess = ProcessDefinitionUtil.getBpmnModelByProcDefId(executionEntity.getProcessDefinitionId()).getMainProcess();
        if (!ModelType.AuditFlow.name().equals(mainProcess.getProcessType())) {
            return;
        }
        FlowElement flowElement = mainProcess.getFlowElement(executionEntity.getCurrentActivityId());
        if (flowElement instanceof UserTask && ((UserTask)flowElement).getSensitiveField() != null) {
            if (!"UserTask".equalsIgnoreCase(flowElement.getType()) && !"save".equalsIgnoreCase(((UserTask)flowElement).getBillSetting().getOperationWhenSave())) {
                return;
            }
            String sensitiveFieldData = ((UserTask)flowElement).getSensitiveField().getSensitiveFieldData();
            this.addSensitiveRecord(executionEntity, sensitiveFieldData);
        }
    }

    private void addSensitiveRecord(ExecutionEntity execution, String sensitiveFieldData) {
        List sensitiveFieldList = JSONObject.parseArray((String)sensitiveFieldData, Map.class);
        if (CollectionUtil.isNotEmpty(sensitiveFieldList)) {
            Integer sensitiveFieldsEntrythreshold = WfConfigurationUtil.getSensitiveFieldsEntrythreshold();
            if (sensitiveFieldsEntrythreshold == null) {
                sensitiveFieldsEntrythreshold = 30;
            }
            MainEntityType entity = EntityMetadataCache.getDataEntityType((String)execution.getEntityNumber());
            log.debug(String.format("SensitiveFieldRecordListener-addSensitiveRecord, entityNumber[%s], billType[%s]", execution.getEntityNumber(), execution.getBillType()));
            DynamicObject dynamicObject = BusinessDataServiceHelper.loadSingle((Object)Long.valueOf(execution.getBusinessKey()), (DynamicObjectType)entity, (int)0, (int)sensitiveFieldsEntrythreshold);
            if (dynamicObject != null) {
                HashMap<String, Object> sensitiveFieldsDataMap = new HashMap<String, Object>();
                for (Map sensitiveField : sensitiveFieldList) {
                    this.extractSensitiveFieldChange(dynamicObject, sensitiveFieldsDataMap, sensitiveField);
                }
                if (!sensitiveFieldsDataMap.isEmpty()) {
                    String sensitiveFieldsDataMapStr = SerializationUtils.toJsonString(sensitiveFieldsDataMap);
                    String activityId = execution.getActivityId();
                    CommandContext commandContext = Context.getCommandContext();
                    ExecutionEntity rootProcessInstanceId = commandContext.getExecutionEntityManager().findByRootProcessInstanceId(execution.getProcessInstanceId());
                    if (rootProcessInstanceId != null) {
                        rootProcessInstanceId.setVariable(execution.getBusinessKey() + activityId.toLowerCase() + "sensitivefieldinfo", sensitiveFieldsDataMapStr);
                    }
                }
            }
        }
    }

    private void extractSensitiveFieldChange(DynamicObject dynamicObject, Map<String, Object> sensitiveFieldsDataMap, Map<String, Object> sensitiveField) {
        Object sensitiveFieldValue = null;
        String entrylocation = (String)sensitiveField.get("entrylocation");
        if (WfUtils.isNotEmpty(entrylocation)) {
            this.extractEntrySensitiveFieldChange(dynamicObject, sensitiveFieldsDataMap, sensitiveField);
        } else {
            String key = (String)sensitiveField.get(FIELDKEY);
            sensitiveFieldValue = dynamicObject.get(key);
            if (sensitiveFieldValue != null) {
                this.putRecord(sensitiveFieldsDataMap, sensitiveField, sensitiveFieldValue, key);
            } else {
                this.putRecordMap(sensitiveFieldsDataMap, sensitiveField, sensitiveFieldValue, key);
            }
        }
    }

    private void putRecord(Map<String, Object> sensitiveFieldsDataMap, Map<String, Object> sensitiveField, Object sensitiveFieldValue, String key) {
        sensitiveFieldValue = SensitiveFieldUtil.formatValue(sensitiveFieldValue);
        this.putRecordMap(sensitiveFieldsDataMap, sensitiveField, sensitiveFieldValue, key);
    }

    private void putRecordMap(Map<String, Object> sensitiveFieldsDataMap, Map<String, Object> sensitiveField, Object sensitiveFieldValue, String key) {
        Object fieldname = sensitiveField.get(FIELDNAME);
        HashMap<String, Object> recordMap = new HashMap<String, Object>();
        recordMap.put("oldValue", sensitiveFieldValue);
        recordMap.put("name", fieldname);
        sensitiveFieldsDataMap.put(key, recordMap);
    }

    private void extractEntrySensitiveFieldChange(DynamicObject dynamicObject, Map<String, Object> sensitiveFieldsDataMap, Map<String, Object> sensitiveField) {
        try {
            String key = (String)sensitiveField.get(FIELDKEY);
            String entrylocation = (String)sensitiveField.get("entrylocation");
            DynamicObjectCollection dynamics = dynamicObject.getDynamicObjectCollection(entrylocation);
            if (CollectionUtil.isEmpty((Collection)dynamics)) {
                Object fieldname = sensitiveField.get(FIELDNAME);
                String fieldkey = String.join((CharSequence)"/", entrylocation, "seq_-1", key);
                HashMap<String, Object> recordMap = new HashMap<String, Object>();
                recordMap.put("name", fieldname);
                sensitiveFieldsDataMap.put(fieldkey, recordMap);
                log.debug("sensitive entry[%s] is null", (Object)entrylocation);
            } else {
                int size = dynamics.size();
                for (int i = 0; i < size; ++i) {
                    DynamicObject dynamic = (DynamicObject)dynamics.get(i);
                    Object sensitiveFieldValue = dynamic.get(key);
                    Long id = dynamic.getLong("id");
                    String fieldkey = String.join((CharSequence)"/", entrylocation, id.toString(), key);
                    if (sensitiveFieldValue != null) {
                        this.putRecord(sensitiveFieldsDataMap, sensitiveField, sensitiveFieldValue, fieldkey);
                        continue;
                    }
                    this.putRecordMap(sensitiveFieldsDataMap, sensitiveField, sensitiveFieldValue, fieldkey);
                }
            }
        }
        catch (ORMDesignException e1) {
            log.error("sensitive getValue error:" + e1.getMessage());
        }
    }
}

