/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.workflow.engine.impl.bpmn.parser;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.node.ObjectNode;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.workflow.bpmn.converter.BpmnJsonConverter;
import kd.bos.workflow.bpmn.model.BoundaryEvent;
import kd.bos.workflow.bpmn.model.BpmnModel;
import kd.bos.workflow.bpmn.model.Event;
import kd.bos.workflow.bpmn.model.FlowElement;
import kd.bos.workflow.bpmn.model.FlowNode;
import kd.bos.workflow.bpmn.model.GraphicInfo;
import kd.bos.workflow.bpmn.model.Process;
import kd.bos.workflow.bpmn.model.SequenceFlow;
import kd.bos.workflow.bpmn.model.SubProcess;
import kd.bos.workflow.engine.delegate.event.impl.ActivitiEventSupport;
import kd.bos.workflow.engine.impl.bpmn.parser.BpmnParseHandlers;
import kd.bos.workflow.engine.impl.bpmn.parser.BpmnParser;
import kd.bos.workflow.engine.impl.bpmn.parser.factory.ActivityBehaviorFactory;
import kd.bos.workflow.engine.impl.bpmn.parser.factory.ListenerFactory;
import kd.bos.workflow.engine.impl.cfg.ProcessEngineConfigurationImpl;
import kd.bos.workflow.engine.impl.context.Context;
import kd.bos.workflow.engine.impl.persistence.IDynamicResourceItem;
import kd.bos.workflow.engine.impl.persistence.entity.Entity;
import kd.bos.workflow.engine.impl.persistence.entity.design.ResourceEntity;
import kd.bos.workflow.engine.impl.persistence.entity.history.HistoricProcessInstanceEntity;
import kd.bos.workflow.engine.impl.persistence.entity.management.DeploymentEntity;
import kd.bos.workflow.engine.impl.persistence.entity.management.ProcessDefinitionEntity;
import kd.bos.workflow.engine.impl.persistence.entity.runtime.ExecutionEntity;
import kd.bos.workflow.engine.impl.util.ProcessDefinitionUtil;
import kd.bos.workflow.exception.WFEngineException;
import kd.bos.workflow.exception.WFIllegalArgumentException;

public class BpmnParse {
    protected static Log logger = LogFactory.getLog(BpmnParse.class);
    public static final String PROPERTYNAME_INITIAL = "initial";
    public static final String PROPERTYNAME_INITIATOR_VARIABLE_NAME = "initiatorVariableName";
    public static final String PROPERTYNAME_CONDITION = "condition";
    public static final String PROPERTYNAME_CONDITION_TEXT = "conditionText";
    public static final String PROPERTYNAME_TIMER_DECLARATION = "timerDeclarations";
    public static final String PROPERTYNAME_ISEXPANDED = "isExpanded";
    public static final String PROPERTYNAME_START_TIMER = "timerStart";
    public static final String PROPERTYNAME_COMPENSATION_HANDLER_ID = "compensationHandler";
    public static final String PROPERTYNAME_IS_FOR_COMPENSATION = "isForCompensation";
    public static final String PROPERTYNAME_ERROR_EVENT_DEFINITIONS = "errorEventDefinitions";
    public static final String PROPERTYNAME_EVENT_SUBSCRIPTION_DECLARATION = "eventDefinitions";
    protected String nameSpace;
    protected boolean validateSchema = true;
    protected boolean validateProcess = true;
    protected InputStream streamSource;
    protected String sourceSystemId;
    protected BpmnModel bpmnModel;
    protected String targetNamespace;
    protected DeploymentEntity deploymentEntity;
    protected List<ProcessDefinitionEntity> processDefinitions = new ArrayList<ProcessDefinitionEntity>();
    protected Map<String, SequenceFlow> sequenceFlows;
    protected BpmnParseHandlers bpmnParserHandlers;
    protected ProcessDefinitionEntity currentProcessDefinition;
    protected Process currentProcess;
    protected ResourceEntity resourceEntity;
    protected FlowElement currentFlowElement;
    protected LinkedList<SubProcess> currentSubprocessStack = new LinkedList();
    protected Map<String, String> prefixs = new HashMap<String, String>();
    protected ActivityBehaviorFactory activityBehaviorFactory;
    protected ListenerFactory listenerFactory;

    public BpmnParse(BpmnParser parser) {
        this.activityBehaviorFactory = parser.getActivityBehaviorFactory();
        this.listenerFactory = parser.getListenerFactory();
        this.bpmnParserHandlers = parser.getBpmnParserHandlers();
    }

    public BpmnParse deployment(DeploymentEntity deploymentEntity) {
        this.deploymentEntity = deploymentEntity;
        return this;
    }

    public BpmnParse resource(ResourceEntity resourceEntity) {
        this.resourceEntity = resourceEntity;
        return this;
    }

    public BpmnParse executeJSONConverter(List<IDynamicResourceItem> dynamicResourceItems) {
        try {
            ProcessEngineConfigurationImpl processEngineConfiguration = Context.getProcessEngineConfiguration();
            BpmnJsonConverter converter = new BpmnJsonConverter();
            ObjectNode modelNode = (ObjectNode)new ObjectMapper().readTree(this.streamSource);
            this.bpmnModel = converter.convertToBpmnModel((JsonNode)modelNode, dynamicResourceItems);
            this.bpmnModel.setSourceSystemId(this.sourceSystemId);
            this.bpmnModel.setEventSupport(new ActivitiEventSupport());
            this.applyParseHandlers();
            this.processDI();
        }
        catch (WFEngineException e) {
            throw e;
        }
        catch (Exception e) {
            throw new WFEngineException("Error parsing Model", e);
        }
        return this;
    }

    public BpmnParse name(String nameSpace) {
        this.nameSpace = nameSpace;
        return this;
    }

    public BpmnParse sourceInputStream(InputStream inputStream) {
        if (this.nameSpace == null) {
            this.name("inputStream");
        }
        this.setStreamSource(inputStream);
        return this;
    }

    public BpmnParse sourceResource(String resource) {
        return this.sourceResource(resource, null);
    }

    public BpmnParse sourceUrl(URL url) {
        if (this.nameSpace == null) {
            this.name(url.toString());
        }
        return this;
    }

    public BpmnParse sourceUrl(String url) {
        try {
            return this.sourceUrl(new URL(url));
        }
        catch (MalformedURLException e) {
            throw new WFIllegalArgumentException("malformed url: " + url, e);
        }
    }

    public BpmnParse sourceResource(String resource, ClassLoader classLoader) {
        if (this.nameSpace == null) {
            this.name(resource);
        }
        return this;
    }

    public BpmnParse sourceString(String string) {
        if (this.nameSpace == null) {
            this.name("string");
        }
        return this;
    }

    protected void setStreamSource(InputStream streamSource) {
        if (this.streamSource != null) {
            throw new WFIllegalArgumentException("invalid: multiple sources " + this.streamSource + " and " + streamSource);
        }
        this.streamSource = streamSource;
    }

    public BpmnParse setSourceSystemId(String sourceSystemId) {
        this.sourceSystemId = sourceSystemId;
        return this;
    }

    protected void applyParseHandlers() {
        this.sequenceFlows = new HashMap<String, SequenceFlow>();
        Iterator<Process> iterator = this.bpmnModel.getProcesses().iterator();
        while (iterator.hasNext()) {
            Process process;
            this.currentProcess = process = iterator.next();
            if (!process.isExecutable()) continue;
            this.bpmnParserHandlers.parseElement(this, process);
        }
    }

    public void processFlowElements(Collection<FlowElement> flowElements) {
        ArrayList<SequenceFlow> sequenceFlowToParse = new ArrayList<SequenceFlow>();
        ArrayList<BoundaryEvent> boundaryEventsToParse = new ArrayList<BoundaryEvent>();
        ArrayList<FlowElement> defferedFlowElementsToParse = new ArrayList<FlowElement>();
        for (FlowElement flowElement : flowElements) {
            if (flowElement instanceof SequenceFlow) {
                sequenceFlowToParse.add((SequenceFlow)flowElement);
                continue;
            }
            if (flowElement instanceof BoundaryEvent) {
                boundaryEventsToParse.add((BoundaryEvent)flowElement);
                continue;
            }
            if (flowElement instanceof Event) {
                defferedFlowElementsToParse.add(flowElement);
                continue;
            }
            this.bpmnParserHandlers.parseElement(this, flowElement);
        }
        for (FlowElement flowElement : defferedFlowElementsToParse) {
            this.bpmnParserHandlers.parseElement(this, flowElement);
        }
        for (BoundaryEvent boundaryEvent : boundaryEventsToParse) {
            this.bpmnParserHandlers.parseElement(this, boundaryEvent);
        }
        for (SequenceFlow sequenceFlow : sequenceFlowToParse) {
            this.bpmnParserHandlers.parseElement(this, sequenceFlow);
        }
    }

    public void processDI() {
        if (this.processDefinitions.isEmpty()) {
            return;
        }
        if (!this.bpmnModel.getLocationMap().isEmpty()) {
            for (String bpmnReference : this.bpmnModel.getLocationMap().keySet()) {
                if (this.bpmnModel.getFlowElement(bpmnReference) == null) {
                    if (this.bpmnModel.getArtifact(bpmnReference) != null || this.bpmnModel.getPool(bpmnReference) != null || this.bpmnModel.getLane(bpmnReference) != null) continue;
                    logger.warn("Invalid reference in diagram interchange definition: could not find " + bpmnReference);
                    continue;
                }
                if (this.bpmnModel.getFlowElement(bpmnReference) instanceof FlowNode) continue;
                logger.warn("Invalid reference in diagram interchange definition: " + bpmnReference + " does not reference a flow node");
            }
            for (String bpmnReference : this.bpmnModel.getFlowLocationMap().keySet()) {
                if (this.bpmnModel.getFlowElement(bpmnReference) == null) {
                    if (this.bpmnModel.getArtifact(bpmnReference) != null) continue;
                    logger.warn("Invalid reference in diagram interchange definition: could not find " + bpmnReference);
                    continue;
                }
                if (this.bpmnModel.getFlowElement(bpmnReference) instanceof SequenceFlow) continue;
                logger.warn("Invalid reference in diagram interchange definition: " + bpmnReference + " does not reference a sequence flow");
            }
            for (Process process : this.bpmnModel.getProcesses()) {
                ProcessDefinitionEntity processDefinition;
                if (!process.isExecutable() || (processDefinition = this.getProcessDefinition(process.getId())) == null) continue;
                processDefinition.setGraphicalDefined(true);
                for (String edgeId : this.bpmnModel.getFlowLocationMap().keySet()) {
                    if (this.bpmnModel.getFlowElement(edgeId) == null) continue;
                    this.createBPMNEdge(edgeId, this.bpmnModel.getFlowLocationGraphicInfo(edgeId));
                }
            }
        }
    }

    public void createBPMNEdge(String key, List<GraphicInfo> graphicList) {
        FlowElement flowElement = this.bpmnModel.getFlowElement(key);
        if (flowElement instanceof SequenceFlow) {
            SequenceFlow sequenceFlow = (SequenceFlow)flowElement;
            ArrayList<Integer> waypoints = new ArrayList<Integer>(graphicList.size() * 2);
            for (GraphicInfo waypointInfo : graphicList) {
                waypoints.add((int)waypointInfo.getX());
                waypoints.add((int)waypointInfo.getY());
            }
            sequenceFlow.setWaypoints(waypoints);
        } else {
            logger.warn("Invalid reference in 'bpmnElement' attribute, sequenceFlow " + key + " not found");
        }
    }

    public ProcessDefinitionEntity getProcessDefinition(String processDefinitionKey) {
        for (ProcessDefinitionEntity processDefinition : this.processDefinitions) {
            if (!processDefinition.getKey().equals(processDefinitionKey)) continue;
            return processDefinition;
        }
        return null;
    }

    public boolean isValidateSchema() {
        return this.validateSchema;
    }

    public void setValidateSchema(boolean validateSchema) {
        this.validateSchema = validateSchema;
    }

    public boolean isValidateProcess() {
        return this.validateProcess;
    }

    public void setValidateProcess(boolean validateProcess) {
        this.validateProcess = validateProcess;
    }

    public List<ProcessDefinitionEntity> getProcessDefinitions() {
        return this.processDefinitions;
    }

    public String getTargetNamespace() {
        return this.targetNamespace;
    }

    public BpmnParseHandlers getBpmnParserHandlers() {
        return this.bpmnParserHandlers;
    }

    public void setBpmnParserHandlers(BpmnParseHandlers bpmnParserHandlers) {
        this.bpmnParserHandlers = bpmnParserHandlers;
    }

    public DeploymentEntity getDeployment() {
        return this.deploymentEntity;
    }

    public void setDeployment(DeploymentEntity deploymentEntity) {
        this.deploymentEntity = deploymentEntity;
    }

    public BpmnModel getBpmnModel() {
        return this.bpmnModel;
    }

    public void setBpmnModel(BpmnModel bpmnModel) {
        this.bpmnModel = bpmnModel;
    }

    public ResourceEntity getResource() {
        return this.resourceEntity;
    }

    public void setResource(ResourceEntity resourceEntity) {
        this.resourceEntity = resourceEntity;
    }

    public ActivityBehaviorFactory getActivityBehaviorFactory() {
        return this.activityBehaviorFactory;
    }

    public void setActivityBehaviorFactory(ActivityBehaviorFactory activityBehaviorFactory) {
        this.activityBehaviorFactory = activityBehaviorFactory;
    }

    public ListenerFactory getListenerFactory() {
        return this.listenerFactory;
    }

    public void setListenerFactory(ListenerFactory listenerFactory) {
        this.listenerFactory = listenerFactory;
    }

    public Map<String, SequenceFlow> getSequenceFlows() {
        return this.sequenceFlows;
    }

    public ProcessDefinitionEntity getCurrentProcessDefinition() {
        return this.currentProcessDefinition;
    }

    public void setCurrentProcessDefinition(ProcessDefinitionEntity currentProcessDefinition) {
        this.currentProcessDefinition = currentProcessDefinition;
    }

    public FlowElement getCurrentFlowElement() {
        return this.currentFlowElement;
    }

    public void setCurrentFlowElement(FlowElement currentFlowElement) {
        this.currentFlowElement = currentFlowElement;
    }

    public Process getCurrentProcess() {
        return this.currentProcess;
    }

    public void setCurrentProcess(Process currentProcess) {
        this.currentProcess = currentProcess;
    }

    public void setCurrentSubProcess(SubProcess subProcess) {
        this.currentSubprocessStack.push(subProcess);
    }

    public SubProcess getCurrentSubProcess() {
        return this.currentSubprocessStack.peek();
    }

    public void removeCurrentSubProcess() {
        this.currentSubprocessStack.pop();
    }

    public List<IDynamicResourceItem> mergeDynamicResource(Entity processInstanceEntity) {
        if (!(processInstanceEntity instanceof ExecutionEntity) && !(processInstanceEntity instanceof HistoricProcessInstanceEntity)) {
            return null;
        }
        Long procInstId = null;
        boolean processIsTerminated = false;
        if (processInstanceEntity instanceof ExecutionEntity) {
            ExecutionEntity execution = (ExecutionEntity)processInstanceEntity;
            procInstId = execution.getProcessInstanceId();
            processIsTerminated = false;
        } else {
            HistoricProcessInstanceEntity procInstEntity = (HistoricProcessInstanceEntity)processInstanceEntity;
            procInstId = procInstEntity.getProcessInstanceId();
            processIsTerminated = procInstEntity.getEndTime() != null;
        }
        return ProcessDefinitionUtil.findDynamicResourceContentByProcessInstance(this.getBpmnModel(), procInstId, processIsTerminated);
    }
}

