/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.workflow.engine.impl.bpmn.parser;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.workflow.bpmn.model.BaseElement;
import kd.bos.workflow.bpmn.model.DataObject;
import kd.bos.workflow.bpmn.model.FlowElement;
import kd.bos.workflow.engine.impl.bpmn.parser.BpmnParse;
import kd.bos.workflow.engine.parse.BpmnParseHandler;

public class BpmnParseHandlers {
    protected static Log logger = LogFactory.getLog(BpmnParseHandlers.class);
    protected Map<Class<? extends BaseElement>, List<BpmnParseHandler>> parseHandlers = new HashMap<Class<? extends BaseElement>, List<BpmnParseHandler>>();

    public List<BpmnParseHandler> getHandlersFor(Class<? extends BaseElement> clazz) {
        return this.parseHandlers.get(clazz);
    }

    public void addHandlers(List<BpmnParseHandler> bpmnParseHandlers) {
        for (BpmnParseHandler bpmnParseHandler : bpmnParseHandlers) {
            this.addHandler(bpmnParseHandler);
        }
    }

    public void addHandler(BpmnParseHandler bpmnParseHandler) {
        for (Class<? extends BaseElement> type : bpmnParseHandler.getHandledTypes()) {
            this.parseHandlers.computeIfAbsent(type, k -> new ArrayList());
            List<BpmnParseHandler> handlers = this.parseHandlers.get(type);
            handlers.add(bpmnParseHandler);
        }
    }

    public void parseElement(BpmnParse bpmnParse, BaseElement element) {
        List<BpmnParseHandler> handlers;
        if (element instanceof DataObject) {
            return;
        }
        if (element instanceof FlowElement) {
            bpmnParse.setCurrentFlowElement((FlowElement)element);
        }
        if ((handlers = this.parseHandlers.get(element.getClass())) == null) {
            logger.warn("Could not find matching parse handler for + " + element.getId() + " this is likely a bug.");
        } else {
            for (BpmnParseHandler handler : handlers) {
                handler.parse(bpmnParse, element);
            }
        }
    }
}

