/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.workflow.engine.impl.bpmn.parser.factory;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import kd.bos.workflow.api.ExecutionListener;
import kd.bos.workflow.bpmn.model.ActivitiListener;
import kd.bos.workflow.bpmn.model.EventListener;
import kd.bos.workflow.bpmn.model.FieldExtension;
import kd.bos.workflow.engine.delegate.CustomPropertiesResolver;
import kd.bos.workflow.engine.delegate.TaskListener;
import kd.bos.workflow.engine.delegate.TransactionDependentTaskListener;
import kd.bos.workflow.engine.delegate.event.ActivitiEventListener;
import kd.bos.workflow.engine.impl.bpmn.helper.BaseDelegateEventListener;
import kd.bos.workflow.engine.impl.bpmn.helper.ClassDelegate;
import kd.bos.workflow.engine.impl.bpmn.helper.ClassDelegateFactory;
import kd.bos.workflow.engine.impl.bpmn.helper.DefaultClassDelegateFactory;
import kd.bos.workflow.engine.impl.bpmn.helper.DelegateActivitiEventListener;
import kd.bos.workflow.engine.impl.bpmn.helper.DelegateExpressionActivitiEventListener;
import kd.bos.workflow.engine.impl.bpmn.helper.ErrorThrowingEventListener;
import kd.bos.workflow.engine.impl.bpmn.helper.MessageThrowingEventListener;
import kd.bos.workflow.engine.impl.bpmn.helper.SignalThrowingEventListener;
import kd.bos.workflow.engine.impl.bpmn.listener.DelegateExpressionCustomPropertiesResolver;
import kd.bos.workflow.engine.impl.bpmn.listener.DelegateExpressionExecutionListener;
import kd.bos.workflow.engine.impl.bpmn.listener.DelegateExpressionTaskListener;
import kd.bos.workflow.engine.impl.bpmn.listener.DelegateExpressionTransactionDependentExecutionListener;
import kd.bos.workflow.engine.impl.bpmn.listener.DelegateExpressionTransactionDependentTaskListener;
import kd.bos.workflow.engine.impl.bpmn.listener.ExpressionCustomPropertiesResolver;
import kd.bos.workflow.engine.impl.bpmn.listener.ExpressionExecutionListener;
import kd.bos.workflow.engine.impl.bpmn.listener.ExpressionTaskListener;
import kd.bos.workflow.engine.impl.bpmn.listener.KScriptExecutionListener;
import kd.bos.workflow.engine.impl.bpmn.listener.OperationExecutionListener;
import kd.bos.workflow.engine.impl.bpmn.listener.PluginExecutionListener;
import kd.bos.workflow.engine.impl.bpmn.parser.factory.AbstractBehaviorFactory;
import kd.bos.workflow.engine.impl.bpmn.parser.factory.ListenerFactory;
import kd.bos.workflow.engine.repository.ProcessDefinition;
import kd.bos.workflow.engine.runtime.Execution;
import kd.bos.workflow.engine.runtime.Job;
import kd.bos.workflow.engine.runtime.ProcessInstance;
import kd.bos.workflow.engine.task.Attachment;
import kd.bos.workflow.engine.task.Comment;
import kd.bos.workflow.engine.task.IdentityLink;
import kd.bos.workflow.engine.task.Task;
import kd.bos.workflow.exception.WFIllegalArgumentException;

public class DefaultListenerFactory
extends AbstractBehaviorFactory
implements ListenerFactory {
    private final ClassDelegateFactory classDelegateFactory;
    protected static final Map<String, Class<?>> ENTITY_MAPPING = new HashMap();

    public DefaultListenerFactory(ClassDelegateFactory classDelegateFactory) {
        this.classDelegateFactory = classDelegateFactory;
    }

    public DefaultListenerFactory() {
        this(new DefaultClassDelegateFactory());
    }

    @Override
    public TaskListener createClassDelegateTaskListener(ActivitiListener activitiListener) {
        return this.classDelegateFactory.create(activitiListener.getImplementation(), this.createFieldDeclarations(activitiListener.getFieldExtensions()));
    }

    @Override
    public TaskListener createExpressionTaskListener(ActivitiListener activitiListener) {
        return new ExpressionTaskListener(this.expressionManager.createExpression(activitiListener.getImplementation()));
    }

    @Override
    public TaskListener createDelegateExpressionTaskListener(ActivitiListener activitiListener) {
        return new DelegateExpressionTaskListener(this.expressionManager.createExpression(activitiListener.getImplementation()), this.createFieldDeclarations(activitiListener.getFieldExtensions()));
    }

    @Override
    public TransactionDependentTaskListener createTransactionDependentDelegateExpressionTaskListener(ActivitiListener activitiListener) {
        return new DelegateExpressionTransactionDependentTaskListener(this.expressionManager.createExpression(activitiListener.getImplementation()));
    }

    @Override
    public ExecutionListener createClassDelegateExecutionListener(ActivitiListener activitiListener) {
        return this.classDelegateFactory.create(activitiListener.getImplementation(), this.createFieldDeclarations(activitiListener.getFieldExtensions()));
    }

    @Override
    public ExecutionListener createExpressionExecutionListener(ActivitiListener activitiListener) {
        return new ExpressionExecutionListener(this.expressionManager.createExpression(activitiListener.getImplementation()));
    }

    @Override
    public ExecutionListener createDelegateExpressionExecutionListener(ActivitiListener activitiListener) {
        return new DelegateExpressionExecutionListener(this.expressionManager.createExpression(activitiListener.getImplementation()), this.createFieldDeclarations(activitiListener.getFieldExtensions()));
    }

    @Override
    public DelegateExpressionTransactionDependentExecutionListener createTransactionDependentDelegateExpressionExecutionListener(ActivitiListener activitiListener) {
        return new DelegateExpressionTransactionDependentExecutionListener(this.expressionManager.createExpression(activitiListener.getImplementation()));
    }

    @Override
    public ActivitiEventListener createClassDelegateEventListener(EventListener eventListener) {
        return new DelegateActivitiEventListener(eventListener.getImplementation(), this.getEntityType(eventListener.getEntityType()));
    }

    @Override
    public ActivitiEventListener createDelegateExpressionEventListener(EventListener eventListener) {
        return new DelegateExpressionActivitiEventListener(this.expressionManager.createExpression(eventListener.getImplementation()), this.getEntityType(eventListener.getEntityType()));
    }

    @Override
    public ActivitiEventListener createEventThrowingEventListener(EventListener eventListener) {
        BaseDelegateEventListener result = null;
        if ("throwSignalEvent".equals(eventListener.getImplementationType())) {
            result = new SignalThrowingEventListener();
            ((SignalThrowingEventListener)result).setSignalName(eventListener.getImplementation());
            ((SignalThrowingEventListener)result).setProcessInstanceScope(true);
        } else if ("throwGlobalSignalEvent".equals(eventListener.getImplementationType())) {
            result = new SignalThrowingEventListener();
            ((SignalThrowingEventListener)result).setSignalName(eventListener.getImplementation());
            ((SignalThrowingEventListener)result).setProcessInstanceScope(false);
        } else if ("throwMessageEvent".equals(eventListener.getImplementationType())) {
            result = new MessageThrowingEventListener();
            ((MessageThrowingEventListener)result).setMessageName(eventListener.getImplementation());
        } else if ("throwErrorEvent".equals(eventListener.getImplementationType())) {
            result = new ErrorThrowingEventListener();
            ((ErrorThrowingEventListener)result).setErrorCode(eventListener.getImplementation());
        }
        if (result == null) {
            throw new WFIllegalArgumentException("Cannot create an event-throwing event-listener, unknown implementation type: " + eventListener.getImplementationType());
        }
        result.setEntityClass(this.getEntityType(eventListener.getEntityType()));
        return result;
    }

    @Override
    public CustomPropertiesResolver createClassDelegateCustomPropertiesResolver(ActivitiListener activitiListener) {
        return this.classDelegateFactory.create(activitiListener.getCustomPropertiesResolverImplementation(), null);
    }

    @Override
    public CustomPropertiesResolver createExpressionCustomPropertiesResolver(ActivitiListener activitiListener) {
        return new ExpressionCustomPropertiesResolver(this.expressionManager.createExpression(activitiListener.getCustomPropertiesResolverImplementation()));
    }

    @Override
    public CustomPropertiesResolver createDelegateExpressionCustomPropertiesResolver(ActivitiListener activitiListener) {
        return new DelegateExpressionCustomPropertiesResolver(this.expressionManager.createExpression(activitiListener.getCustomPropertiesResolverImplementation()));
    }

    protected ClassDelegate createExtItfClassDelegate(String type, ActivitiListener activitiListener) {
        int size = activitiListener.getFieldExtensions().size();
        ArrayList<FieldExtension> fieldExtensions = new ArrayList<FieldExtension>(size + 1);
        fieldExtensions.addAll(activitiListener.getFieldExtensions());
        FieldExtension impl = new FieldExtension();
        impl.setFieldName("implementation");
        impl.setStringValue(activitiListener.getImplementation());
        fieldExtensions.add(impl);
        String clazz = null;
        if (type.equals("class")) {
            clazz = PluginExecutionListener.class.getCanonicalName();
        } else if (type.equals("script")) {
            clazz = KScriptExecutionListener.class.getCanonicalName();
        } else if (type.equals("operation")) {
            clazz = OperationExecutionListener.class.getCanonicalName();
        }
        return this.classDelegateFactory.create(clazz, this.createFieldDeclarations(fieldExtensions));
    }

    @Override
    public ExecutionListener createExtItfExecutionListener(String type, ActivitiListener activitiListener) {
        return this.createExtItfClassDelegate(type, activitiListener);
    }

    @Override
    public TaskListener createExtItfTaskListener(String type, ActivitiListener activitiListener) {
        return this.createExtItfClassDelegate(type, activitiListener);
    }

    protected Class<?> getEntityType(String entityType) {
        if (entityType != null) {
            Class<?> entityClass = ENTITY_MAPPING.get(entityType.trim());
            if (entityClass == null) {
                throw new WFIllegalArgumentException("Unsupported entity-type for an ActivitiEventListener: " + entityType);
            }
            return entityClass;
        }
        return null;
    }

    static {
        ENTITY_MAPPING.put("attachment", Attachment.class);
        ENTITY_MAPPING.put("comment", Comment.class);
        ENTITY_MAPPING.put("execution", Execution.class);
        ENTITY_MAPPING.put("identity-link", IdentityLink.class);
        ENTITY_MAPPING.put("job", Job.class);
        ENTITY_MAPPING.put("process-definition", ProcessDefinition.class);
        ENTITY_MAPPING.put("process-instance", ProcessInstance.class);
        ENTITY_MAPPING.put("task", Task.class);
    }
}

