/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.workflow.engine.impl.bpmn.parser.handler;

import kd.bos.workflow.bpmn.model.Activity;
import kd.bos.workflow.bpmn.model.BaseElement;
import kd.bos.workflow.bpmn.model.FlowNode;
import kd.bos.workflow.bpmn.model.MultiInstanceLoopCharacteristics;
import kd.bos.workflow.bpmn.model.YunzhijiaTask;
import kd.bos.workflow.engine.impl.bpmn.behavior.AbstractBpmnActivityBehavior;
import kd.bos.workflow.engine.impl.bpmn.behavior.MultiInstanceActivityBehavior;
import kd.bos.workflow.engine.impl.bpmn.parser.BpmnParse;
import kd.bos.workflow.engine.impl.bpmn.parser.handler.AbstractFlowNodeBpmnParseHandler;
import kd.bos.workflow.engine.impl.context.Context;
import kd.bos.workflow.engine.impl.el.ExpressionManager;
import org.apache.commons.lang.StringUtils;

public abstract class AbstractActivityBpmnParseHandler<T extends FlowNode>
extends AbstractFlowNodeBpmnParseHandler<T> {
    @Override
    public void parse(BpmnParse bpmnParse, BaseElement element) {
        super.parse(bpmnParse, element);
        if (element instanceof Activity && ((Activity)element).getLoopCharacteristics() != null) {
            this.createMultiInstanceLoopCharacteristics(bpmnParse, (Activity)element);
        }
    }

    protected void createMultiInstanceLoopCharacteristics(BpmnParse bpmnParse, Activity modelActivity) {
        MultiInstanceLoopCharacteristics loopCharacteristics = modelActivity.getLoopCharacteristics();
        Boolean isSequentialMultiInstance = Boolean.FALSE;
        if (modelActivity instanceof YunzhijiaTask) {
            YunzhijiaTask yunZhiJiaTask = (YunzhijiaTask)modelActivity;
            isSequentialMultiInstance = "serialAudit".equals(yunZhiJiaTask.getSignType()) ? Boolean.TRUE : Boolean.FALSE;
        }
        MultiInstanceActivityBehavior miActivityBehavior = null;
        miActivityBehavior = isSequentialMultiInstance != false ? bpmnParse.getActivityBehaviorFactory().createSequentialMultiInstanceBehavior(modelActivity, (AbstractBpmnActivityBehavior)modelActivity.getBehavior()) : bpmnParse.getActivityBehaviorFactory().createParallelMultiInstanceBehavior(modelActivity, (AbstractBpmnActivityBehavior)modelActivity.getBehavior());
        modelActivity.setBehavior(miActivityBehavior);
        ExpressionManager expressionManager = Context.getProcessEngineConfiguration().getExpressionManager();
        if (StringUtils.isNotEmpty((String)loopCharacteristics.getLoopCardinality())) {
            miActivityBehavior.setLoopCardinalityExpression(expressionManager.createExpression(loopCharacteristics.getLoopCardinality()));
        }
        if (StringUtils.isNotEmpty((String)loopCharacteristics.getCompletionCondition())) {
            miActivityBehavior.setCompletionConditionExpression(expressionManager.createExpression(loopCharacteristics.getCompletionCondition()));
        }
        if (StringUtils.isNotEmpty((String)loopCharacteristics.getInputDataItem())) {
            if (loopCharacteristics.getInputDataItem().contains("{")) {
                miActivityBehavior.setCollectionExpression(expressionManager.createExpression(loopCharacteristics.getInputDataItem()));
            } else {
                miActivityBehavior.setCollectionVariable(loopCharacteristics.getInputDataItem());
            }
        }
        if (StringUtils.isNotEmpty((String)loopCharacteristics.getElementVariable())) {
            miActivityBehavior.setCollectionElementVariable(loopCharacteristics.getElementVariable());
        }
        if (StringUtils.isNotEmpty((String)loopCharacteristics.getElementIndexVariable())) {
            miActivityBehavior.setCollectionElementIndexVariable(loopCharacteristics.getElementIndexVariable());
        }
    }
}

