/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.workflow.engine.impl.bpmn.parser.handler;

import java.util.HashSet;
import java.util.Set;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.workflow.api.ExecutionListener;
import kd.bos.workflow.bpmn.model.ActivitiListener;
import kd.bos.workflow.bpmn.model.BaseElement;
import kd.bos.workflow.bpmn.model.EventGateway;
import kd.bos.workflow.bpmn.model.FlowElement;
import kd.bos.workflow.bpmn.model.IntermediateCatchEvent;
import kd.bos.workflow.bpmn.model.SequenceFlow;
import kd.bos.workflow.engine.impl.bpmn.parser.BpmnParse;
import kd.bos.workflow.engine.parse.BpmnParseHandler;

public abstract class AbstractBpmnParseHandler<T extends BaseElement>
implements BpmnParseHandler {
    protected static Log logger = LogFactory.getLog(AbstractBpmnParseHandler.class);
    public static final String PROPERTYNAME_EVENT_SUBSCRIPTION_DECLARATION = "eventDefinitions";
    public static final String PROPERTYNAME_ERROR_EVENT_DEFINITIONS = "errorEventDefinitions";
    public static final String PROPERTYNAME_TIMER_DECLARATION = "timerDeclarations";

    public Set<Class<? extends BaseElement>> getHandledTypes() {
        HashSet<Class<? extends BaseElement>> types = new HashSet<Class<? extends BaseElement>>();
        types.add(this.getHandledType());
        return types;
    }

    protected abstract Class<? extends BaseElement> getHandledType();

    @Override
    public void parse(BpmnParse bpmnParse, BaseElement element) {
        BaseElement baseElement = element;
        this.executeParse(bpmnParse, baseElement);
    }

    protected abstract void executeParse(BpmnParse var1, T var2);

    protected ExecutionListener createExecutionListener(BpmnParse bpmnParse, ActivitiListener activitiListener) {
        ExecutionListener executionListener = null;
        if ("class".equalsIgnoreCase(activitiListener.getImplementationType())) {
            executionListener = bpmnParse.getListenerFactory().createClassDelegateExecutionListener(activitiListener);
        } else if ("expression".equalsIgnoreCase(activitiListener.getImplementationType())) {
            executionListener = bpmnParse.getListenerFactory().createExpressionExecutionListener(activitiListener);
        } else if ("delegateExpression".equalsIgnoreCase(activitiListener.getImplementationType())) {
            executionListener = bpmnParse.getListenerFactory().createDelegateExpressionExecutionListener(activitiListener);
        }
        return executionListener;
    }

    protected String getPrecedingEventBasedGateway(BpmnParse bpmnParse, IntermediateCatchEvent event) {
        String eventBasedGatewayId = null;
        for (SequenceFlow sequenceFlow : event.getIncomingFlows()) {
            FlowElement sourceElement = bpmnParse.getBpmnModel().getFlowElement(sequenceFlow.getSourceRef());
            if (!(sourceElement instanceof EventGateway)) continue;
            eventBasedGatewayId = sourceElement.getId();
            break;
        }
        return eventBasedGatewayId;
    }
}

