/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.workflow.engine.impl.bpmn.parser.handler;

import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.workflow.bpmn.model.BaseElement;
import kd.bos.workflow.bpmn.model.BoundaryEvent;
import kd.bos.workflow.bpmn.model.CancelEventDefinition;
import kd.bos.workflow.bpmn.model.CompensateEventDefinition;
import kd.bos.workflow.bpmn.model.ErrorEventDefinition;
import kd.bos.workflow.bpmn.model.EventDefinition;
import kd.bos.workflow.bpmn.model.MessageEventDefinition;
import kd.bos.workflow.bpmn.model.SignalEventDefinition;
import kd.bos.workflow.bpmn.model.TimerEventDefinition;
import kd.bos.workflow.engine.impl.bpmn.parser.BpmnParse;
import kd.bos.workflow.engine.impl.bpmn.parser.handler.AbstractFlowNodeBpmnParseHandler;
import kd.bos.workflow.engine.impl.util.CollectionUtil;

public class BoundaryEventParseHandler
extends AbstractFlowNodeBpmnParseHandler<BoundaryEvent> {
    protected static Log logger = LogFactory.getLog(BoundaryEventParseHandler.class);

    @Override
    public Class<? extends BaseElement> getHandledType() {
        return BoundaryEvent.class;
    }

    @Override
    protected void executeParse(BpmnParse bpmnParse, BoundaryEvent boundaryEvent) {
        if (boundaryEvent.getAttachedToRef() == null) {
            logger.warn("Invalid reference in boundary event. Make sure that the referenced activity is defined in the same scope as the boundary event " + boundaryEvent.getId());
            return;
        }
        EventDefinition eventDefinition = null;
        if (CollectionUtil.isNotEmpty(boundaryEvent.getEventDefinitions())) {
            eventDefinition = boundaryEvent.getEventDefinitions().get(0);
        }
        if (this.isInstanceOf(eventDefinition)) {
            bpmnParse.getBpmnParserHandlers().parseElement(bpmnParse, eventDefinition);
        } else {
            logger.warn("Unsupported boundary event type for boundary event " + boundaryEvent.getId());
        }
    }

    private boolean isInstanceOf(EventDefinition eventDefinition) {
        return eventDefinition instanceof TimerEventDefinition || eventDefinition instanceof ErrorEventDefinition || eventDefinition instanceof SignalEventDefinition || eventDefinition instanceof CancelEventDefinition || eventDefinition instanceof MessageEventDefinition || eventDefinition instanceof CompensateEventDefinition;
    }
}

