/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.workflow.engine.impl.bpmn.parser.handler;

import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.workflow.bpmn.model.BaseElement;
import kd.bos.workflow.bpmn.model.EndEvent;
import kd.bos.workflow.bpmn.model.ErrorEventDefinition;
import kd.bos.workflow.bpmn.model.EventDefinition;
import kd.bos.workflow.bpmn.model.TerminateEventDefinition;
import kd.bos.workflow.engine.impl.bpmn.parser.BpmnParse;
import kd.bos.workflow.engine.impl.bpmn.parser.handler.AbstractActivityBpmnParseHandler;
import kd.bos.workflow.engine.impl.util.CollectionUtil;
import org.apache.commons.lang.StringUtils;

public class EndEventParseHandler
extends AbstractActivityBpmnParseHandler<EndEvent> {
    protected static Log logger = LogFactory.getLog(EndEventParseHandler.class);

    @Override
    public Class<? extends BaseElement> getHandledType() {
        return EndEvent.class;
    }

    @Override
    protected void executeParse(BpmnParse bpmnParse, EndEvent endEvent) {
        EventDefinition eventDefinition = null;
        if (CollectionUtil.isNotEmpty(endEvent.getEventDefinitions())) {
            eventDefinition = endEvent.getEventDefinitions().get(0);
            if (eventDefinition instanceof ErrorEventDefinition) {
                String errorCode;
                ErrorEventDefinition errorDefinition = (ErrorEventDefinition)eventDefinition;
                if (bpmnParse.getBpmnModel().containsErrorRef(errorDefinition.getErrorCode()) && StringUtils.isEmpty((String)(errorCode = bpmnParse.getBpmnModel().getErrors().get(errorDefinition.getErrorCode())))) {
                    logger.warn("errorCode is required for an error event " + endEvent.getId());
                }
                endEvent.setBehavior(bpmnParse.getActivityBehaviorFactory().createErrorEndEventActivityBehavior(endEvent, errorDefinition));
            } else if (eventDefinition instanceof TerminateEventDefinition) {
                endEvent.setBehavior(bpmnParse.getActivityBehaviorFactory().createTerminateEndEventActivityBehavior(endEvent));
            } else {
                endEvent.setBehavior(bpmnParse.getActivityBehaviorFactory().createNoneEndEventActivityBehavior(endEvent));
            }
        } else {
            endEvent.setBehavior(bpmnParse.getActivityBehaviorFactory().createNoneEndEventActivityBehavior(endEvent));
        }
    }
}

