/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.workflow.engine.impl.bpmn.parser.handler;

import com.alibaba.fastjson.JSONObject;
import java.util.List;
import kd.bos.dataentity.entity.ILocaleString;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.workflow.bpmn.model.BaseElement;
import kd.bos.workflow.bpmn.model.BpmnModel;
import kd.bos.workflow.bpmn.model.EventListener;
import kd.bos.workflow.bpmn.model.Process;
import kd.bos.workflow.engine.delegate.event.ActivitiEventType;
import kd.bos.workflow.engine.delegate.event.impl.ActivitiEventSupport;
import kd.bos.workflow.engine.impl.bpmn.parser.BpmnParse;
import kd.bos.workflow.engine.impl.bpmn.parser.handler.AbstractBpmnParseHandler;
import kd.bos.workflow.engine.impl.context.Context;
import kd.bos.workflow.engine.impl.persistence.entity.management.ProcessDefinitionEntity;
import kd.bos.workflow.engine.impl.util.BpmnModelUtil;

public class ProcessParseHandler
extends AbstractBpmnParseHandler<Process> {
    protected static Log logger = LogFactory.getLog(ProcessParseHandler.class);
    public static final String PROPERTYNAME_DOCUMENTATION = "documentation";

    @Override
    public Class<? extends BaseElement> getHandledType() {
        return Process.class;
    }

    @Override
    protected void executeParse(BpmnParse bpmnParse, Process process) {
        if (!process.isExecutable()) {
            logger.debug("Ignoring non-executable process with id='" + process.getId() + "'. Set the attribute isExecutable=\"true\" to deploy this process.");
        } else {
            bpmnParse.getProcessDefinitions().add(this.transformProcess(bpmnParse, process));
        }
    }

    protected ProcessDefinitionEntity transformProcess(BpmnParse bpmnParse, Process process) {
        ProcessDefinitionEntity currentProcessDefinition = (ProcessDefinitionEntity)Context.getCommandContext().getProcessDefinitionEntityManager().create();
        bpmnParse.setCurrentProcessDefinition(currentProcessDefinition);
        currentProcessDefinition.setKey(process.getId());
        JSONObject multiLangDatas = BpmnModelUtil.getMultiLangDatasFromResource(bpmnParse.getResource());
        ILocaleString name = BpmnModelUtil.getMultiLangFieldValue(multiLangDatas, BpmnModelUtil.getProcessPropertyMultiKey("name"), process.getName());
        currentProcessDefinition.setName(name != null ? name : process.getProcessName());
        currentProcessDefinition.setCategory(bpmnParse.getBpmnModel().getTargetNamespace());
        ILocaleString description = BpmnModelUtil.getMultiLangFieldValue(multiLangDatas, BpmnModelUtil.getProcessPropertyMultiKey(PROPERTYNAME_DOCUMENTATION), process.getDocumentation());
        if (description != null) {
            currentProcessDefinition.setDescription(description);
        }
        currentProcessDefinition.setDeploymentId(bpmnParse.getDeployment().getId());
        currentProcessDefinition.setBusinessId(process.getBusinessId());
        if (bpmnParse.getDeployment().getEngineVersion() != null) {
            currentProcessDefinition.setEngineVersion(bpmnParse.getDeployment().getEngineVersion());
        }
        this.createEventListeners(bpmnParse, process.getEventListeners());
        logger.debug(String.format("Parsing process %s", currentProcessDefinition.getKey()));
        bpmnParse.processFlowElements(process.getFlowElements());
        return currentProcessDefinition;
    }

    protected void createEventListeners(BpmnParse bpmnParse, List<EventListener> eventListeners) {
        if (eventListeners != null && !eventListeners.isEmpty()) {
            for (EventListener eventListener : eventListeners) {
                ActivitiEventType[] types = ActivitiEventType.getTypesFromString(eventListener.getEvents());
                if ("class".equals(eventListener.getImplementationType())) {
                    this.getEventSupport(bpmnParse.getBpmnModel()).addEventListener(bpmnParse.getListenerFactory().createClassDelegateEventListener(eventListener), types);
                    continue;
                }
                if ("delegateExpression".equals(eventListener.getImplementationType())) {
                    this.getEventSupport(bpmnParse.getBpmnModel()).addEventListener(bpmnParse.getListenerFactory().createDelegateExpressionEventListener(eventListener), types);
                    continue;
                }
                if ("throwSignalEvent".equals(eventListener.getImplementationType()) || "throwGlobalSignalEvent".equals(eventListener.getImplementationType()) || "throwMessageEvent".equals(eventListener.getImplementationType()) || "throwErrorEvent".equals(eventListener.getImplementationType())) {
                    this.getEventSupport(bpmnParse.getBpmnModel()).addEventListener(bpmnParse.getListenerFactory().createEventThrowingEventListener(eventListener), types);
                    continue;
                }
                logger.warn("Unsupported implementation type for EventListener: " + eventListener.getImplementationType() + " for element " + bpmnParse.getCurrentFlowElement().getId());
            }
        }
    }

    protected ActivitiEventSupport getEventSupport(BpmnModel bpmnModel) {
        return (ActivitiEventSupport)bpmnModel.getEventSupport();
    }
}

