/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.workflow.engine.impl.bpmn.parser.handler;

import kd.bos.workflow.bpmn.model.BaseElement;
import kd.bos.workflow.bpmn.model.BpmnModel;
import kd.bos.workflow.bpmn.model.ErrorEventDefinition;
import kd.bos.workflow.bpmn.model.EventDefinition;
import kd.bos.workflow.bpmn.model.EventSubProcess;
import kd.bos.workflow.bpmn.model.Message;
import kd.bos.workflow.bpmn.model.MessageEventDefinition;
import kd.bos.workflow.bpmn.model.StartEvent;
import kd.bos.workflow.engine.impl.bpmn.parser.BpmnParse;
import kd.bos.workflow.engine.impl.bpmn.parser.handler.AbstractActivityBpmnParseHandler;
import kd.bos.workflow.engine.impl.util.CollectionUtil;

public class StartEventParseHandler
extends AbstractActivityBpmnParseHandler<StartEvent> {
    @Override
    public Class<? extends BaseElement> getHandledType() {
        return StartEvent.class;
    }

    @Override
    protected void executeParse(BpmnParse bpmnParse, StartEvent element) {
        if (element.getSubProcess() != null && element.getSubProcess() instanceof EventSubProcess) {
            if (CollectionUtil.isNotEmpty(element.getEventDefinitions())) {
                EventDefinition eventDefinition = element.getEventDefinitions().get(0);
                if (eventDefinition instanceof MessageEventDefinition) {
                    String messageRef;
                    MessageEventDefinition messageDefinition = (MessageEventDefinition)eventDefinition;
                    BpmnModel bpmnModel = bpmnParse.getBpmnModel();
                    if (bpmnModel.containsMessageId(messageRef = messageDefinition.getMessageRef())) {
                        Message message = bpmnModel.getMessage(messageRef);
                        messageDefinition.setMessageRef(message.getName());
                        messageDefinition.setExtensionElements(message.getExtensionElements());
                    }
                    element.setBehavior(bpmnParse.getActivityBehaviorFactory().createEventSubProcessMessageStartEventActivityBehavior(element, messageDefinition));
                } else if (eventDefinition instanceof ErrorEventDefinition) {
                    element.setBehavior(bpmnParse.getActivityBehaviorFactory().createEventSubProcessErrorStartEventActivityBehavior(element));
                }
            }
        } else {
            element.setBehavior(bpmnParse.getActivityBehaviorFactory().createNoneStartEventActivityBehavior(element));
        }
        if (element.getSubProcess() == null && (CollectionUtil.isEmpty(element.getEventDefinitions()) || bpmnParse.getCurrentProcess().getInitialFlowElement() == null)) {
            bpmnParse.getCurrentProcess().setInitialFlowElement(element);
        }
    }
}

