/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.workflow.engine.impl.cache;

import com.alibaba.fastjson.JSONObject;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.regex.Pattern;
import kd.bos.cache.CacheFactory;
import kd.bos.cache.DistributeCacheHAPolicy;
import kd.bos.cache.DistributeSessionlessCache;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.ILocaleString;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.cache.CacheKeyUtil;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.devportal.BizAppServiceHelp;
import kd.bos.servicehelper.message.MessageServiceHelper;
import kd.bos.workflow.api.NodeTemplate;
import kd.bos.workflow.bpmn.converter.util.ModelConfigUtil;
import kd.bos.workflow.engine.WfUtils;
import kd.bos.workflow.engine.impl.bpmn.deployer.ProcessOperation;
import kd.bos.workflow.engine.impl.interceptor.CommandContext;

public class WfCacheHelper {
    public static final String WORKFLOWDISTRICT = "workflow";
    public static final String PROCESSDEF = "PRODEF";
    public static final String PROCESSINSTANCE = "PROINST";
    public static final String EMPTYVALUE = "-1";
    public static final String NOTEMPTYVALUE = "NOTEMPTY";
    public static final String EXISTPROCESS = "existProcess";
    private static final String SERIALJOB = "SERIALJOB";
    private static DistributeSessionlessCache disCache = null;
    private static final String ISVMODELCONFIG = "ISVModelConfig";
    private static final String DELETEDBUSINESSKEYS = "deletedBusinessKeys";
    private static final String DELETEDTASKIDS = "deletedTaskIds";
    private static final String HADADDTARGETACTINSTID = "hadAddTargetActInstId";
    private static final String TESTINGPLAN = "testingplan";
    private static final String SCHEMEMULTILANGDATAS = "SchemeMultiLangDatas";
    private static final String DYNAMICPROCESS = "dynamicProcessVal";
    private static final String MULTIINSTVARIABLE = "multiInstVariable";
    private static final String MICROOPERATEVARIABLE = "microOperateVariable";
    private static final String HADADDYUNZHIJIATASKPARENTID = "hadAddYunzhijiaTaskParentId";
    private static Map<String, JSONObject> bigKeySplitBucketCutDigitConfig = new HashMap<String, JSONObject>(16);
    public static final String MSGCHANNEL = "msgChannel";
    public static final String V_OPERATION = "operation";
    public static final String SCANDBOFJOB = "scanDBOfJob";
    public static final String CURRENTEXECUTEJOB = "CURRENTEXECUTEJOB";
    public static final String CURRENTEXECUTEROOTJOB = "CURRENTEXECUTEROOTJOB";
    public static final String APPIDOFJOB = "appIdOfJob";
    public static final String EXECUTINGREPAIRTASK = "EXECUTINGREPAIRTASK";
    private static final int EightHours = 28800;
    private static final int TenMinutes = 600;
    private static final int FourHours = 14400;
    private static final int OneHour = 3600;
    private static final int ThreeDays = 259200;
    private static final int TwoMINITUE = 120;
    private static final String WFADMINISTRATORUSERIDS = "wfAdministratorUserIds";
    private static Log logger = LogFactory.getLog(WfCacheHelper.class);
    private static final String USERNAME = "USERNAME";
    private static final String WFJOBRECORDTABLE = "WFJOBRECORDTABLE";
    private static final String BILLEXCEPTIONCREATETASK = "BECT";
    private static final String BLOCKSTATE = "BSTATE";
    private static final String BLOCKQUEUE = "BQUEUE";
    private static final String ADDRESSPK = "addressPks";
    private static final String TESTJOBANDMQ = "testJobAndMQ";
    private static final String NODETEMPLATE = "nodeTemplate";
    private static final String NODETEMPLATEEXPEND = "nodeTemplateExpend";
    private static final String AUTORECOVERSYSERRORPROCSSIGNPREFIX = "wf.autorecover";
    public static final String CURRENTSTARTPROCESSPK = "CURRENTSTARTPROCESSPK";
    public static final String WITHDRAWTIMERORDEADJOBROOTID = "withdrawTimerOrDeadJobRootId";
    private static final String CANREJECTLOCK = "canRejectLock";
    private static final String TRDBUSINESSOBJECTDATASOURCE = "trdBusinessObjectDataSource";
    public static final String CURRENTJOBGYENTITY = "CURRENTJOBGYENTITY";
    public static final String EXTEXPRESSIONPROPS = "extExpressionProps";
    private static final String HANDLEDREQUEST = "handledRequest";

    private static DistributeSessionlessCache getDisCache() {
        if (disCache == null) {
            disCache = CacheFactory.getCommonCacheFactory().getDistributeSessionlessCache(WORKFLOWDISTRICT, new DistributeCacheHAPolicy());
        }
        return disCache;
    }

    public static String getAccountId() {
        return CacheKeyUtil.getAcctId();
    }

    public static String getWholeKey(String ... args) {
        StringBuilder sb = new StringBuilder();
        sb.append(WfCacheHelper.getAccountId()).append(".wf.");
        return WfUtils.strAppend(sb.toString(), ".", args);
    }

    private static String getWholeKeyWithBucketNum(String cacheKey, String entityNumber, String pk) {
        int cutDigit = WfCacheHelper.getCutDigitValueFromConfig(cacheKey, entityNumber);
        entityNumber = WfCacheHelper.getEntityNumberWithBucketNumSuf(cacheKey, entityNumber, pk, cutDigit);
        return WfCacheHelper.getWholeKey(cacheKey, entityNumber);
    }

    private static String getEntityNumberWithBucketNumSuf(String cacheKey, String entityNumber, String pk, int cutDigit) {
        if (cutDigit <= 0) {
            return entityNumber;
        }
        try {
            String bucketNum;
            String baseStr = pk.trim();
            if (!WfCacheHelper.isNumberStr(baseStr)) {
                baseStr = String.valueOf(pk.hashCode());
            }
            if (StringUtils.isNotBlank((CharSequence)(bucketNum = baseStr.substring(baseStr.length() - cutDigit)))) {
                entityNumber = String.format("%s_%s", entityNumber, bucketNum);
            }
        }
        catch (Exception e) {
            logger.warn(String.format("calculate bucketNum error. cacheKey[%s], entityNumber[%s], pk[%s], errMsg[%s]", cacheKey, entityNumber, pk, WfUtils.getExceptionStacktrace(e)));
        }
        return entityNumber;
    }

    private static int getCutDigitValueFromConfig(String cacheKey, String entityNumber) {
        try {
            JSONObject entityNumberDigitVal;
            JSONObject config;
            String accountId = WfCacheHelper.getAccountId();
            if (!bigKeySplitBucketCutDigitConfig.containsKey(accountId)) {
                String configJson = System.getProperty("workflow.runtime.bigKey.bucketDigit");
                JSONObject jsonObject = StringUtils.isBlank((CharSequence)configJson) ? new JSONObject() : JSONObject.parseObject((String)configJson);
                bigKeySplitBucketCutDigitConfig.put(accountId, jsonObject);
            }
            if ((config = bigKeySplitBucketCutDigitConfig.get(accountId)) != null && config.get((Object)cacheKey) != null && (entityNumberDigitVal = (JSONObject)config.get((Object)cacheKey)) != null && entityNumberDigitVal.get((Object)entityNumber) != null) {
                int digitVal = Integer.parseInt(String.valueOf(entityNumberDigitVal.get((Object)entityNumber)));
                return digitVal < 0 ? 1 : digitVal;
            }
        }
        catch (Exception e) {
            logger.warn(String.format("get cutDigitValue from config error.[%s]", WfUtils.getExceptionStacktrace(e)));
        }
        return 1;
    }

    private static void getEntityAllPksFromEachBucket(String cacheKey, String entityNumber, Set<String> values) {
        WfCacheHelper.getEntityAllPksFromEachBucket(cacheKey, entityNumber, values, new ArrayList<String>());
    }

    private static void getEntityAllPksFromEachBucket(String cacheKey, String entityNumber, Set<String> values, List<String> businessKeys) {
        int cutDigit = WfCacheHelper.getCutDigitValueFromConfig(cacheKey, entityNumber);
        if (cutDigit == 0) {
            String entityKey = WfCacheHelper.getWholeKey(cacheKey, entityNumber);
            Collections.addAll(values, WfCacheHelper.getDisCache().getSetValues(entityKey));
        } else if (cutDigit > 0) {
            int bucketNums = (int)Math.pow(10.0, cutDigit);
            HashSet bucketNumsSet = new HashSet(bucketNums);
            if (WfUtils.isNotEmptyForCollection(businessKeys)) {
                businessKeys.forEach(pk -> {
                    String baseStr = pk.trim();
                    if (!WfCacheHelper.isNumberStr(baseStr)) {
                        baseStr = String.valueOf(pk.hashCode());
                    }
                    String bucketNum = baseStr.substring(baseStr.length() - cutDigit);
                    bucketNumsSet.add(Integer.parseInt(bucketNum));
                });
            }
            for (int i = 0; i < bucketNums; ++i) {
                if (!bucketNumsSet.isEmpty() && !bucketNumsSet.contains(i)) continue;
                String bucketNum = String.format("%0" + cutDigit + "d", i);
                String entityNumberWithBucketNum = String.format("%s_%s", entityNumber, bucketNum);
                String entityKey = WfCacheHelper.getWholeKey(cacheKey, entityNumberWithBucketNum);
                String[] value = WfCacheHelper.getDisCache().getSetValues(entityKey);
                Collections.addAll(values, value);
            }
        }
    }

    private static void batchPutEntityPksInCache(String cacheKey, String entityNumber, List<String> pks, int timeoutSeconds) {
        Map<String, List<String>> groupResult = WfCacheHelper.getGroupResult(cacheKey, entityNumber, pks);
        groupResult.forEach((key, value) -> {
            String wholeKeyWithBucketNum = WfCacheHelper.getWholeKey(cacheKey, key);
            WfCacheHelper.getDisCache().addToSet(wholeKeyWithBucketNum, value.toArray(new String[0]), timeoutSeconds);
        });
    }

    private static void batchRemoveEntityPksInCache(String cacheKey, String entityNumber, List<String> pks) {
        Map<String, List<String>> groupResult = WfCacheHelper.getGroupResult(cacheKey, entityNumber, pks);
        groupResult.forEach((key, value) -> {
            String wholeKeyWithBucketNum = WfCacheHelper.getWholeKey(cacheKey, key);
            WfCacheHelper.getDisCache().removeSetValues(wholeKeyWithBucketNum, value.toArray(new String[0]));
        });
    }

    private static Map<String, List<String>> getGroupResult(String cacheKey, String entityNumber, List<String> pks) {
        HashMap<String, List<String>> groupResult = new HashMap<String, List<String>>(16);
        if (StringUtils.isBlank((CharSequence)entityNumber) || WfUtils.isEmptyForCollection(pks)) {
            return groupResult;
        }
        int cutDigit = WfCacheHelper.getCutDigitValueFromConfig(cacheKey, entityNumber);
        if (cutDigit == 0) {
            groupResult.put(entityNumber, pks);
        } else {
            pks.forEach(pk -> {
                String entityNumberWithBucketNumSuf = WfCacheHelper.getEntityNumberWithBucketNumSuf(cacheKey, entityNumber, pk, cutDigit);
                List<String> sameBucketNumPks = groupResult.get(entityNumberWithBucketNumSuf) == null ? new ArrayList(16) : (List)groupResult.get(entityNumberWithBucketNumSuf);
                sameBucketNumPks.add((String)pk);
                groupResult.putIfAbsent(entityNumberWithBucketNumSuf, sameBucketNumPks);
            });
        }
        return groupResult;
    }

    public static Boolean cacheableOfProcessDefByEntityAndOperation(String entityNumber, String operation) {
        String key = WfCacheHelper.getWholeKey(entityNumber, operation);
        String[] ret = WfCacheHelper.getDisCache().getSetValues(key);
        if (ret.length == 0) {
            return null;
        }
        return !WfUtils.inArray(ret, EMPTYVALUE);
    }

    public static Boolean existEnableProcDefByEntityNumber(String entityNumber) {
        String existKey = WfCacheHelper.getWholeKey(EXISTPROCESS, entityNumber);
        String val = (String)WfCacheHelper.getDisCache().get(existKey);
        return StringUtils.isBlank((CharSequence)val) ? null : Boolean.valueOf(NOTEMPTYVALUE.equals(val));
    }

    public static void putProcessToCacheDefByEntityAndOperation(String entityNumber, String operation, List<String> ids) {
        String key = WfCacheHelper.getWholeKey(entityNumber, operation);
        if (ids == null) {
            ids = new ArrayList<String>();
        }
        if (ids.isEmpty()) {
            ids.add(EMPTYVALUE);
        } else {
            WfCacheHelper.putEnableProcDefByEntityNumber(entityNumber, ids.size());
        }
        WfCacheHelper.getDisCache().remove(key);
        WfCacheHelper.getDisCache().addToSet(key, ids.toArray(new String[0]), 259200);
    }

    public static void putEnableProcDefByEntityNumber(String entityNumber, int enableNum) {
        String existKey = WfCacheHelper.getWholeKey(EXISTPROCESS, entityNumber);
        WfCacheHelper.getDisCache().remove(existKey);
        WfCacheHelper.getDisCache().put(existKey, (Object)(enableNum > 0 ? NOTEMPTYVALUE : EMPTYVALUE), 259200);
    }

    public static void updateProcessDefWhenStateChange(CommandContext commandContext, String entityNumber, List<ProcessOperation> operations) {
        String existKey = WfCacheHelper.getWholeKey(EXISTPROCESS, entityNumber);
        WfCacheHelper.getDisCache().remove(existKey);
        HashMap entityOperMap = new HashMap(16);
        entityOperMap.put(entityNumber, new HashSet());
        if (operations != null && !operations.isEmpty()) {
            HashSet<String> opers = null;
            for (ProcessOperation processOperation : operations) {
                String number = WfUtils.isNotEmpty(processOperation.getEntityNumber()) ? processOperation.getEntityNumber() : entityNumber;
                opers = (HashSet<String>)entityOperMap.get(number);
                if (opers == null) {
                    opers = new HashSet<String>();
                    entityOperMap.put(number, opers);
                }
                opers.add(processOperation.getOp());
            }
        }
        Map<String, Set<String>> dbEntityOperMap = commandContext.getProcessDefinitionInfoEntityManager().findAllOperations(entityOperMap.keySet());
        for (Map.Entry entry : entityOperMap.entrySet()) {
            Set<String> opers = dbEntityOperMap.get(entry.getKey());
            if (opers == null || opers.isEmpty()) continue;
            ((Set)entry.getValue()).addAll(opers);
        }
        for (Map.Entry entry : entityOperMap.entrySet()) {
            String entity = (String)entry.getKey();
            Set opers = (Set)entry.getValue();
            if (opers == null || opers.isEmpty()) continue;
            int index = 0;
            int size = opers.size();
            String[] keys = new String[size];
            for (String oper : opers) {
                keys[index++] = WfCacheHelper.getWholeKey(entity, oper);
            }
            WfCacheHelper.getDisCache().remove(keys);
        }
    }

    public static void removeCacheByKeys(String[] keys) {
        WfCacheHelper.getDisCache().remove(keys);
    }

    public static void updateProcessDefAllowNextParticipantWhenStart(Boolean state, Long processDefId, String entityNumber, String operation) {
        String key = WfCacheHelper.getWholeKey("isallownextparticipant", entityNumber, operation);
        if (!WfCacheHelper.getDisCache().contains(key)) {
            WfCacheHelper.initProcessDefAllowNextParticipantWhenStart(entityNumber, operation, key);
        }
        if (state.booleanValue()) {
            WfCacheHelper.getDisCache().removeSetValues(key, new String[]{EMPTYVALUE});
            WfCacheHelper.getDisCache().addToSet(key, new String[]{String.valueOf(processDefId)});
        } else {
            WfCacheHelper.getDisCache().removeSetValues(key, new String[]{String.valueOf(processDefId)});
        }
    }

    private static String[] initProcessDefAllowNextParticipantWhenStart(String entityNumber, String operation, String key) {
        QFilter q2 = new QFilter("isallownextperson", "=", (Object)Character.valueOf('1'));
        QFilter q3 = new QFilter("entitynumber", "=", (Object)entityNumber);
        QFilter q4 = new QFilter(V_OPERATION, "=", (Object)operation).or(V_OPERATION, "like", (Object)("%," + operation)).or(V_OPERATION, "like", (Object)("%," + operation + ",%")).or(V_OPERATION, "like", (Object)(operation + ",%"));
        QFilter[] filters = new QFilter[]{q2, q3, q4};
        DynamicObject[] procs = BusinessDataServiceHelper.load((String)"wf_processconfig", (String)"procdefid", (QFilter[])filters);
        ArrayList<String> procDefIds = new ArrayList<String>();
        WfCacheHelper.getDisCache().remove(key);
        if (procs != null && procs.length > 0) {
            for (DynamicObject proc : procs) {
                Long procdefId = proc.getLong("procdefid");
                procDefIds.add(procdefId.toString());
            }
        } else {
            procDefIds.add(EMPTYVALUE);
        }
        String[] ret = procDefIds.toArray(new String[procDefIds.size()]);
        WfCacheHelper.getDisCache().addToSet(key, ret);
        return ret;
    }

    public static boolean isAllowNextParticipantWhenStart(String entityNumber, String operation) {
        String key = WfCacheHelper.getWholeKey("isallownextparticipant", entityNumber, operation);
        boolean ret = false;
        String[] processDefIds = null;
        processDefIds = !WfCacheHelper.getDisCache().contains(key) ? WfCacheHelper.initProcessDefAllowNextParticipantWhenStart(entityNumber, operation, key) : WfCacheHelper.getDisCache().getSetValues(key);
        if (processDefIds != null && (processDefIds.length > 1 || processDefIds.length == 1 && !EMPTYVALUE.equals(processDefIds[0]))) {
            ret = true;
        }
        return ret;
    }

    public static void putJobSourceOfDBRouteKey(String dbRouteKey) {
        String key = WfCacheHelper.getWholeKey(SCANDBOFJOB);
        WfCacheHelper.getDisCache().addToSet(key, new String[]{String.valueOf(dbRouteKey)});
    }

    public static String[] getJobSourceOfDBRouteKey() {
        String key = WfCacheHelper.getWholeKey(SCANDBOFJOB);
        return WfCacheHelper.getDisCache().getSetValues(key);
    }

    public static void removeJobSourceOfDBRouteKey(String dbRouteKey) {
        String key = WfCacheHelper.getWholeKey(SCANDBOFJOB);
        WfCacheHelper.getDisCache().removeSetValues(key, new String[]{dbRouteKey});
    }

    public static void putEventJobSourceOfDbRouteKey(String dbRouteKey) {
        String key = WfCacheHelper.getWholeKey("scanDBOfEventJob");
        WfCacheHelper.getDisCache().addToSet(key, new String[]{String.valueOf(dbRouteKey)}, 259200);
    }

    public static boolean existEvtJobRecordTable(String dbRouteKey) {
        String[] catchDbKey = WfCacheHelper.getEventJobSourceOfDBRouteKey();
        if (catchDbKey == null) {
            return false;
        }
        return Arrays.asList(catchDbKey).contains(dbRouteKey);
    }

    public static String[] getEventJobSourceOfDBRouteKey() {
        String key = WfCacheHelper.getWholeKey("scanDBOfEventJob");
        return WfCacheHelper.getDisCache().getSetValues(key);
    }

    public static void removeSingleEventJobSourceOfDBRouteKey(String dbRouteKey) {
        String key = WfCacheHelper.getWholeKey("scanDBOfEventJob");
        WfCacheHelper.getDisCache().removeSetValues(key, new String[]{dbRouteKey});
    }

    public static void removeEventJobSourceOfDBRouteKey(String dbkey) {
        WfCacheHelper.getDisCache().remove(new String[]{WfCacheHelper.getWholeKey("scanDBOfEventJob"), WfCacheHelper.getWholeKey("scanDBOfEventBusinessKey")});
    }

    @Deprecated
    public static void setWithdrawDeleteBizJobIds(String[] businesskeys) {
        String key = WfCacheHelper.getWholeKey("withdrawDeleteBizJobIds");
        WfCacheHelper.getDisCache().addToSet(key, businesskeys);
    }

    @Deprecated
    public static String[] getWithdrawDeleteBizJobIds() {
        String key = WfCacheHelper.getWholeKey("withdrawDeleteBizJobIds");
        return WfCacheHelper.getDisCache().getSetValues(key);
    }

    @Deprecated
    public static void removerWithdrawDeleteBizJobIds(String jobId) {
        String key = WfCacheHelper.getWholeKey("withdrawDeleteBizJobIds");
        WfCacheHelper.getDisCache().removeSetValues(key, new String[]{jobId});
    }

    @Deprecated
    public static void removerWithdrawDeleteBizJobIds(String[] jobIds) {
        String key = WfCacheHelper.getWholeKey("withdrawDeleteBizJobIds");
        WfCacheHelper.getDisCache().removeSetValues(key, jobIds);
    }

    @Deprecated
    public static void addProcDefIdsOfTheEndedProcess(String procDefId) {
    }

    @Deprecated
    public static String[] getProcDefIdsOfTheEndedProcess() {
        return new String[0];
    }

    @Deprecated
    public static void removeProcDefIdsOfTheEndedProcess(String[] procDefIds) {
    }

    public static void putCurrentExecuteJobState(Long id, String businessKey, String entityNumber) {
        String key = WfCacheHelper.getWholeKey(CURRENTEXECUTEJOB, businessKey);
        WfCacheHelper.getDisCache().addToSet(key, new String[]{String.valueOf(id)}, 3600);
    }

    public static void removeCurrentExecuteJobState(Long id, String businessKey) {
        String key = WfCacheHelper.getWholeKey(CURRENTEXECUTEJOB, businessKey);
        WfCacheHelper.getDisCache().removeSetValues(key, new String[]{String.valueOf(id)});
    }

    public static boolean isCurrentExecuting(Long id, String businessKey) {
        String key = WfCacheHelper.getWholeKey(CURRENTEXECUTEJOB, businessKey);
        String[] ids = WfCacheHelper.getDisCache().getSetValues(key);
        return WfUtils.inArray(ids, String.valueOf(id));
    }

    public static void putCurrentExecuteRootJob(Long rootid) {
        String rootIdStr = String.valueOf(rootid);
        String key = WfCacheHelper.getWholeKey(CURRENTEXECUTEROOTJOB, rootIdStr);
        WfCacheHelper.getDisCache().addToSet(key, new String[]{rootIdStr}, 600);
    }

    public static int putCurrentExecuteRootJobInc(Long rootid) {
        String rootIdStr = String.valueOf(rootid);
        String key = WfCacheHelper.getWholeKey(CURRENTEXECUTEROOTJOB, rootIdStr);
        return WfCacheHelper.getDisCache().addToSet(key, new String[]{rootIdStr}, 3600);
    }

    public static void removeCurrentExecuteRootJob(Long rootid) {
        String rootIdStr = String.valueOf(rootid);
        String key = WfCacheHelper.getWholeKey(CURRENTEXECUTEROOTJOB, rootIdStr);
        WfCacheHelper.getDisCache().removeSetValues(key, new String[]{rootIdStr});
    }

    public static int putCurrentExecuteBySceneAndKey(String markId) {
        String key = WfCacheHelper.getWholeKey(markId);
        return WfCacheHelper.getDisCache().addToSet(key, new String[]{markId}, 600);
    }

    public static void removeCurrentExecuteBySceneAndKey(String markId) {
        String key = WfCacheHelper.getWholeKey(markId);
        WfCacheHelper.getDisCache().remove(key);
    }

    public static boolean isCurrentExecutingJob(Long rootid) {
        String rootIdStr = String.valueOf(rootid);
        String key = WfCacheHelper.getWholeKey(CURRENTEXECUTEROOTJOB, rootIdStr);
        String[] ids = WfCacheHelper.getDisCache().getSetValues(key);
        return WfUtils.inArray(ids, rootIdStr);
    }

    public static void putExecutingBusinesskeysByEntityNumber(String businessKey, String entityNumber) {
        if (WfUtils.isEmpty(businessKey)) {
            logger.debug("CURRENTJOBGYENTITY - businesskey is null !");
            return;
        }
        String entityKey = WfCacheHelper.getWholeKeyWithBucketNum(CURRENTJOBGYENTITY, entityNumber, businessKey);
        WfCacheHelper.getDisCache().addToSet(entityKey, new String[]{businessKey}, 259200);
        logger.debug(String.format("CURRENTJOBGYENTITY[%s]add\uff0ckey[%s]", businessKey, entityKey));
    }

    public static boolean isNumberStr(String str) {
        Pattern pattern = Pattern.compile("[0-9]*");
        return pattern.matcher(str).matches();
    }

    public static String[] getExecutingBusinesskeysByEntityNumber(String entityNumber) {
        return WfCacheHelper.getExecutingBusinesskeysByEntityNumber(entityNumber, new ArrayList<String>());
    }

    public static String[] getExecutingBusinesskeysByEntityNumber(String entityNumber, List<String> businessKeys) {
        HashSet<String> values = new HashSet<String>();
        WfCacheHelper.getEntityAllPksFromEachBucket(CURRENTJOBGYENTITY, entityNumber, values, businessKeys);
        String entityKey = WfCacheHelper.getWholeKey(CURRENTJOBGYENTITY, entityNumber);
        Collections.addAll(values, WfCacheHelper.getDisCache().getSetValues(entityKey));
        return values.toArray(new String[0]);
    }

    public static void removeExecutingJobGYEntityOfCurrentBusiness(String businessKey, String entityNumber) {
        String entityKey;
        if (WfUtils.isNotEmpty(businessKey)) {
            logger.debug("CURRENTJOBGYENTITY - businesskey is null !");
            entityKey = WfCacheHelper.getWholeKeyWithBucketNum(CURRENTJOBGYENTITY, entityNumber, businessKey);
            WfCacheHelper.getDisCache().removeSetValues(entityKey, new String[]{businessKey});
            logger.debug(String.format("CURRENTJOBGYENTITY[%s]delete with suffix\uff0ckey[%s]", businessKey, entityKey));
        }
        entityKey = WfCacheHelper.getWholeKey(CURRENTJOBGYENTITY, entityNumber);
        WfCacheHelper.getDisCache().removeSetValues(entityKey, new String[]{businessKey});
        logger.debug(String.format("CURRENTJOBGYENTITY[%s]delete\uff0ckey[%s]", businessKey, entityKey));
    }

    public static void removeExecutingJobOfCurrentBusiness(String businessKey, String entityNumber) {
        String key = WfCacheHelper.getWholeKey(CURRENTEXECUTEJOB, businessKey);
        WfCacheHelper.getDisCache().remove(key);
    }

    public static boolean isCurrentExecuting(String businessKey) {
        String key = WfCacheHelper.getWholeKey(CURRENTEXECUTEJOB, businessKey);
        String[] ids = WfCacheHelper.getDisCache().getSetValues(key);
        return ids != null && ids.length > 0;
    }

    public static void putAllExtExpressionProps(Map<String, String> props) {
        String key = WfCacheHelper.getWholeKey(EXTEXPRESSIONPROPS);
        WfCacheHelper.getDisCache().put(key, props);
    }

    public static void removeAllExtExpressionProps() {
        String key = WfCacheHelper.getWholeKey(EXTEXPRESSIONPROPS);
        WfCacheHelper.getDisCache().remove(key);
    }

    public static String getExtExpressionPropByNumber(String number) {
        String key = WfCacheHelper.getWholeKey(EXTEXPRESSIONPROPS);
        Map props = WfCacheHelper.getDisCache().getAll(key);
        return (String)props.get(number);
    }

    public static Map<String, String> getExtExpressionProps() {
        String key = WfCacheHelper.getWholeKey(EXTEXPRESSIONPROPS);
        Map props = WfCacheHelper.getDisCache().getAll(key);
        return props;
    }

    public static String getSchemeMultiLangDatas(Long schemeId) {
        String wholeKey = WfCacheHelper.getWholeKey(SCHEMEMULTILANGDATAS, String.valueOf(schemeId));
        return (String)WfCacheHelper.getDisCache().get(wholeKey);
    }

    public static void putSchemeMultiLangDatas(Long schemeId, String multiLangDatas) {
        String wholeKey = WfCacheHelper.getWholeKey(SCHEMEMULTILANGDATAS, String.valueOf(schemeId));
        WfCacheHelper.getDisCache().put(wholeKey, (Object)multiLangDatas, 28800);
    }

    public static void removeSchemeMultiLangDatas(Long schemeId) {
        String wholeKey = WfCacheHelper.getWholeKey(SCHEMEMULTILANGDATAS, String.valueOf(schemeId));
        WfCacheHelper.getDisCache().remove(wholeKey);
    }

    public static String getDynModelConfig(String appConfigKey, String stencilType) {
        Map config = WfCacheHelper.getDisCache().getAll(appConfigKey);
        return (String)config.get(stencilType);
    }

    public static void putDynModelConfig(String appConfigKey, String stencilType, String updateTime) {
        Map config = WfCacheHelper.getDisCache().getAll(appConfigKey);
        config.put(stencilType, updateTime);
        WfCacheHelper.getDisCache().put(appConfigKey, config, 28800);
    }

    public static String getISVModelConfig(String isv) {
        String isvConfigKey = WfCacheHelper.getWholeKey(ISVMODELCONFIG);
        Map config = WfCacheHelper.getDisCache().getAll(isvConfigKey);
        return (String)config.get(isv);
    }

    public static void putISVModelConfig(String isv, String modelConfig) {
        String isvConfigKey = WfCacheHelper.getWholeKey(ISVMODELCONFIG);
        Map config = WfCacheHelper.getDisCache().getAll(isvConfigKey);
        config.put(isv, modelConfig);
        WfCacheHelper.getDisCache().put(isvConfigKey, config);
    }

    public static void removeISVModelConfig(String isv) {
        String isvConfigKey = WfCacheHelper.getWholeKey(ISVMODELCONFIG);
        WfCacheHelper.getDisCache().remove(isvConfigKey, isv);
    }

    public static String getAppIdByEntityNumber(String entityNumber) {
        String key = ModelConfigUtil.getEntityNumberKey(entityNumber);
        String appId = (String)WfCacheHelper.getDisCache().get(key);
        if (appId == null && WfUtils.isNotEmpty(appId = BizAppServiceHelp.getAppIdByFormNum((String)entityNumber))) {
            WfCacheHelper.getDisCache().put(key, (Object)appId);
        }
        return appId;
    }

    @Deprecated
    public static void addDeletedBusinessKeys(String businessKey) {
        String key = WfCacheHelper.getWholeKey(DELETEDBUSINESSKEYS);
        WfCacheHelper.getDisCache().addToSet(key, new String[]{businessKey}, 600);
    }

    @Deprecated
    public static void removeDeletedBusinessKeys(String[] businessKeys) {
        String key = WfCacheHelper.getWholeKey(DELETEDBUSINESSKEYS);
        WfCacheHelper.getDisCache().removeSetValues(key, businessKeys);
    }

    @Deprecated
    public static String[] getDeletedBusinessKeys() {
        String key = WfCacheHelper.getWholeKey(DELETEDBUSINESSKEYS);
        return WfCacheHelper.getDisCache().getSetValues(key);
    }

    public static void addDeletedTaskIds(String proInstId, String[] taskIds) {
        String key = WfCacheHelper.getWholeKey(DELETEDTASKIDS, proInstId);
        WfCacheHelper.getDisCache().addToSet(key, taskIds, 600);
    }

    public static void removeDeletedTaskIds(String proInstId, String[] taskIds) {
        String key = WfCacheHelper.getWholeKey(DELETEDTASKIDS, proInstId);
        WfCacheHelper.getDisCache().removeSetValues(key, taskIds);
    }

    public static String[] getDeletedTaskIds(String proInstId) {
        String key = WfCacheHelper.getWholeKey(DELETEDTASKIDS, proInstId);
        return WfCacheHelper.getDisCache().getSetValues(key);
    }

    @Deprecated
    public static void putMultiInstVariable(Long procInstId, String activityId, String key, String value) {
        String wholeKey = WfCacheHelper.getWholeKey(MULTIINSTVARIABLE, String.valueOf(procInstId), activityId, key);
        WfCacheHelper.getDisCache().put(wholeKey, (Object)value);
    }

    @Deprecated
    public static String getMultiInstVariable(Long procInstId, String activityId, String key) {
        String wholeKey = WfCacheHelper.getWholeKey(MULTIINSTVARIABLE, String.valueOf(procInstId), activityId, key);
        return (String)WfCacheHelper.getDisCache().get(wholeKey);
    }

    @Deprecated
    public static void removeMultiInstVariable(Long procInstId, String activityId, String key) {
        String wholeKey = WfCacheHelper.getWholeKey(MULTIINSTVARIABLE, String.valueOf(procInstId), activityId, key);
        WfCacheHelper.getDisCache().remove(wholeKey);
    }

    public static void putMicroOperateVariable(Long microOperateVariable, String value) {
        String wholeKey = WfCacheHelper.getWholeKey(MICROOPERATEVARIABLE, String.valueOf(microOperateVariable));
        WfCacheHelper.getDisCache().put(wholeKey, (Object)value, 3600);
    }

    public static Map<String, Object> getMicroOperateVariable(Long microOperateVariable) {
        String wholeKey = WfCacheHelper.getWholeKey(MICROOPERATEVARIABLE, String.valueOf(microOperateVariable));
        String result = (String)WfCacheHelper.getDisCache().get(wholeKey);
        if (WfUtils.isNotEmpty(result)) {
            return (Map)SerializationUtils.fromJsonString((String)result, Map.class);
        }
        return null;
    }

    public static void removeMicroOperateVariable(Long microOperateVariable) {
        String wholeKey = WfCacheHelper.getWholeKey(MICROOPERATEVARIABLE, String.valueOf(microOperateVariable));
        WfCacheHelper.getDisCache().remove(wholeKey);
    }

    public static void markProcessInstanceIsDynamic(Long procInstId, Map<String, String> val) {
        String wholeKey = WfCacheHelper.getWholeKey(DYNAMICPROCESS, String.valueOf(procInstId));
        WfCacheHelper.getDisCache().put(wholeKey, val, 600);
    }

    public static Map<String, String> getCachedDynamicProcessInstance(Long procInstId) {
        String wholeKey = WfCacheHelper.getWholeKey(DYNAMICPROCESS, String.valueOf(procInstId));
        return WfCacheHelper.getDisCache().getAll(wholeKey);
    }

    public static void removeCachedDynamicProcessInstance(Long procInstId) {
        String wholeKey = WfCacheHelper.getWholeKey(DYNAMICPROCESS, String.valueOf(procInstId));
        WfCacheHelper.getDisCache().remove(wholeKey);
    }

    public static Long getCachedSchemeId(Long processInstanceId) {
        Long schemeId = null;
        Map<String, String> cacheVal = WfCacheHelper.getCachedDynamicProcessInstance(processInstanceId);
        if (cacheVal != null) {
            String t;
            if (cacheVal.get("scheme") != null) {
                schemeId = Long.valueOf(cacheVal.get("scheme"));
            } else if (cacheVal.get("procinstance") != null && (t = cacheVal.get("procinstance")) != null && t.contains("#") && t.length() > 1) {
                schemeId = Long.valueOf(t.substring(t.indexOf(35) + 1));
            }
        }
        return schemeId;
    }

    public static void putTestingPlanData(String key, String[] values) {
        String wholeKey = WfCacheHelper.getWholeKey(TESTINGPLAN, key);
        WfCacheHelper.getDisCache().addToSet(wholeKey, values, 3600);
    }

    public static String[] getTestingPlanData(String key) {
        String wholeKey = WfCacheHelper.getWholeKey(TESTINGPLAN, key);
        return WfCacheHelper.getDisCache().getSetValues(wholeKey);
    }

    public static void removeTestingPlanData(String key) {
        String wholeKey = WfCacheHelper.getWholeKey(TESTINGPLAN, key);
        WfCacheHelper.getDisCache().remove(wholeKey);
    }

    public static boolean isOlderMsgConfig(String accountId, String tag) {
        String v = MessageServiceHelper.getHashTag((String)accountId);
        return tag == null || !tag.equals(v);
    }

    public static String getMsgConfig() {
        return MessageServiceHelper.getHashTag((String)WfCacheHelper.getAccountId());
    }

    @Deprecated
    public static void putMsgConfig(String accountId, String tag) {
        String key = WfCacheHelper.getWholeKey(accountId, "msgConfig");
        if (WfUtils.isNotEmpty(tag)) {
            WfCacheHelper.getDisCache().put(key, (Object)tag, 14400);
        }
    }

    @Deprecated
    public static String getDefaultNotifyType(String type) {
        String key = WfCacheHelper.getWholeKey(MSGCHANNEL, type);
        return (String)WfCacheHelper.getDisCache().get(key);
    }

    @Deprecated
    public static void putDefaultNotifyType(String type, String val) {
        String key = WfCacheHelper.getWholeKey(MSGCHANNEL, type);
        WfCacheHelper.getDisCache().put(key, (Object)val, 14400);
    }

    public static void removeDefaultNotifyType(String type) {
        String key = WfCacheHelper.getWholeKey(MSGCHANNEL, type);
        WfCacheHelper.getDisCache().remove(key);
    }

    public static void removeAllSet(String targetKey) {
        String wholeKey = WfCacheHelper.getWholeKey(targetKey);
        WfCacheHelper.getDisCache().remove(wholeKey);
    }

    public static void removeSetOfSome(String targetKey, String[] some) {
        String wholeKey = WfCacheHelper.getWholeKey(targetKey);
        WfCacheHelper.getDisCache().removeSetValues(wholeKey, some);
    }

    public static Object getCacheValue(String targetKey, int i) {
        String wholeKey = WfCacheHelper.getWholeKey(targetKey);
        Object tmp = null;
        tmp = i == 0 ? WfCacheHelper.getDisCache().get(wholeKey) : (i == 1 ? WfCacheHelper.getDisCache().getSetValues(wholeKey) : WfCacheHelper.getDisCache().getAll(wholeKey));
        if (WfUtils.isNotEmptyString(tmp)) {
            tmp = SerializationUtils.toJsonString((Object)tmp);
        }
        return tmp;
    }

    public static void putJobLock(String type, String executionId) {
        String key = WfCacheHelper.getWholeKey(type, executionId);
        WfCacheHelper.getDisCache().put(key, (Object)executionId, 120);
    }

    public static boolean hasJobLock(String type, String executionId) {
        String key = WfCacheHelper.getWholeKey(type, executionId);
        return WfCacheHelper.getDisCache().get(key) != null;
    }

    public static void removeJobLock(String type, String executionId) {
        String key = WfCacheHelper.getWholeKey(type, executionId);
        WfCacheHelper.getDisCache().remove(key);
    }

    public static boolean isSettedTargetActInstId(Long processInstanceId, Long srcActInstId) {
        String key = WfCacheHelper.getWholeKey(HADADDTARGETACTINSTID, String.valueOf(processInstanceId), String.valueOf(srcActInstId));
        return WfCacheHelper.getDisCache().get(key) != null;
    }

    public static void setTargetActInstId(Long processInstanceId, Long srcActInstId, Long targetActInstId) {
        String key = WfCacheHelper.getWholeKey(HADADDTARGETACTINSTID, String.valueOf(processInstanceId), String.valueOf(srcActInstId));
        WfCacheHelper.getDisCache().put(key, (Object)String.valueOf(targetActInstId), 120);
    }

    public static void removeTargetActInstId(Long processInstanceId, Long srcActInstId) {
        String key = WfCacheHelper.getWholeKey(HADADDTARGETACTINSTID, String.valueOf(processInstanceId), String.valueOf(srcActInstId));
        WfCacheHelper.getDisCache().remove(key);
    }

    public static boolean isSettedYunzhijiaTaskParentId(Long parentTaskId) {
        String key = WfCacheHelper.getWholeKey(HADADDYUNZHIJIATASKPARENTID, String.valueOf(parentTaskId));
        return WfCacheHelper.getDisCache().get(key) != null;
    }

    public static void setYunzhijiaTaskParentId(Long parentTaskId) {
        String key = WfCacheHelper.getWholeKey(HADADDYUNZHIJIATASKPARENTID, String.valueOf(parentTaskId));
        WfCacheHelper.getDisCache().put(key, (Object)String.valueOf(parentTaskId), 600);
    }

    public static boolean isHandledRequest(String scene, String value) {
        String key = WfCacheHelper.getWholeKey(HANDLEDREQUEST, scene, value);
        return WfCacheHelper.getDisCache().get(key) != null;
    }

    public static void setHandledRequest(String scene, String value) {
        String key = WfCacheHelper.getWholeKey(HANDLEDREQUEST, scene, value);
        WfCacheHelper.getDisCache().put(key, (Object)"true", 120);
    }

    public static void removeHandledRequest(String scene, String value) {
        String key = WfCacheHelper.getWholeKey(HANDLEDREQUEST, scene, value);
        WfCacheHelper.getDisCache().remove(key);
    }

    public static ILocaleString getUserName(String userId) {
        String key = WfCacheHelper.getWholeKey(USERNAME, userId);
        String value = (String)WfCacheHelper.getDisCache().get(key);
        if (WfUtils.isNotEmpty(value)) {
            return (ILocaleString)SerializationUtils.fromJsonString((String)value, LocaleString.class);
        }
        return null;
    }

    public static void putUserName(String userId, ILocaleString localString) {
        if (localString != null) {
            String key = WfCacheHelper.getWholeKey(USERNAME, userId);
            WfCacheHelper.getDisCache().put(key, (Object)SerializationUtils.toJsonString((Object)localString), 259200);
        }
    }

    public static void clearUserName(String userId) {
        String key = WfCacheHelper.getWholeKey(USERNAME, userId);
        WfCacheHelper.getDisCache().remove(key);
    }

    public static String getCacheValue(String cacheKey) {
        String key = WfCacheHelper.getWholeKey(cacheKey);
        Object value = WfCacheHelper.getDisCache().get(key);
        try {
            if (null != value && WfUtils.isNotEmptyString(value)) {
                return SerializationUtils.toJsonString((Object)value);
            }
        }
        catch (Exception e) {
            logger.error(WfUtils.getExceptionStacktrace(e));
        }
        return "";
    }

    public static boolean existWfJobRecordTable(String dbRouteKey) {
        String key = WfCacheHelper.getWholeKey(WFJOBRECORDTABLE);
        String[] routeKeys = WfCacheHelper.getDisCache().getSetValues(key);
        return WfUtils.inArray(routeKeys, dbRouteKey);
    }

    public static void putWfJobRecordTable(String dbRouteKey, Boolean exist) {
        String key = WfCacheHelper.getWholeKey(WFJOBRECORDTABLE);
        WfCacheHelper.getDisCache().addToSet(key, new String[]{dbRouteKey});
    }

    public static void removeWfJobRecordTable() {
        String key = WfCacheHelper.getWholeKey(WFJOBRECORDTABLE);
        WfCacheHelper.getDisCache().remove(key);
    }

    public static void putWfAdminUserIdsCache(String value) {
        String key = WfCacheHelper.getWholeKey(WFADMINISTRATORUSERIDS);
        WfCacheHelper.getDisCache().put(key, (Object)value, 28800);
    }

    public static String getWfAdminUserIdsCache() {
        String key = WfCacheHelper.getWholeKey(WFADMINISTRATORUSERIDS);
        return (String)WfCacheHelper.getDisCache().get(key);
    }

    public static void removeWfAdminUserIdsCache() {
        String key = WfCacheHelper.getWholeKey(WFADMINISTRATORUSERIDS);
        WfCacheHelper.getDisCache().remove(key);
    }

    public static void putWfAdminCache(String cacheKey, String userId, String value) {
        String key = WfCacheHelper.getWholeKey(cacheKey, userId);
        WfCacheHelper.getDisCache().put(key, (Object)value, 28800);
    }

    public static String getWfAdminCache(String cacheKey, String userId) {
        String key = WfCacheHelper.getWholeKey(cacheKey, userId);
        return (String)WfCacheHelper.getDisCache().get(key);
    }

    public static void removeWfAdminCache(String cacheKey, String userId) {
        String key = WfCacheHelper.getWholeKey(cacheKey, userId);
        WfCacheHelper.getDisCache().remove(key);
    }

    public static void putBillExceptionCreateTaskCache(String businesskey, String taskId) {
        String key = WfCacheHelper.getWholeKey(BILLEXCEPTIONCREATETASK, businesskey);
        WfCacheHelper.getDisCache().put(key, (Object)taskId, 28800);
    }

    public static void removeBillExceptionCreateTaskCache(String businesskey) {
        String key = WfCacheHelper.getWholeKey(BILLEXCEPTIONCREATETASK, businesskey);
        WfCacheHelper.getDisCache().remove(key);
    }

    public static String getBillExceptionCreateTaskCache(String businesskey) {
        String key = WfCacheHelper.getWholeKey(BILLEXCEPTIONCREATETASK, businesskey);
        return (String)WfCacheHelper.getDisCache().get(key);
    }

    public static String getRepairTaskCache() {
        String wholeKey = WfCacheHelper.getWholeKey(EXECUTINGREPAIRTASK);
        return (String)WfCacheHelper.getDisCache().get(wholeKey);
    }

    public static void putRepairTaskCache() {
        String wholeKey = WfCacheHelper.getWholeKey(EXECUTINGREPAIRTASK);
        WfCacheHelper.getDisCache().put(wholeKey, (Object)wholeKey);
    }

    public static void removeRepairTaskCache() {
        String wholeKey = WfCacheHelper.getWholeKey(EXECUTINGREPAIRTASK);
        WfCacheHelper.getDisCache().remove(wholeKey);
    }

    public static boolean exsitBlockState(String stateKey) {
        String key = WfCacheHelper.getWholeKey(BLOCKSTATE, stateKey);
        return WfCacheHelper.getDisCache().contains(key);
    }

    public static void setBlockState(String stateKey, String state) {
        String key = WfCacheHelper.getWholeKey(BLOCKSTATE, stateKey);
        WfCacheHelper.getDisCache().put(key, (Object)state);
    }

    public static void removeBlockState(String stateKey) {
        String key = WfCacheHelper.getWholeKey(BLOCKSTATE, stateKey);
        WfCacheHelper.getDisCache().remove(key);
    }

    public static String getBlockedItem(String blockQueueKey) {
        String key = WfCacheHelper.getWholeKey(BLOCKQUEUE, blockQueueKey);
        int len = WfCacheHelper.getDisCache().getListLength(key);
        if (len > 0) {
            String item = WfCacheHelper.getDisCache().getListObject(key, 0);
            WfCacheHelper.getDisCache().removeListObject(key, 0);
            return item;
        }
        return null;
    }

    public static void setBlockedItem(String blockQueueKey, String data) {
        String key = WfCacheHelper.getWholeKey(BLOCKQUEUE, blockQueueKey);
        WfCacheHelper.getDisCache().addList(key, new String[]{data});
    }

    public static void removeBlockQueue(String blockQueueKey) {
        String key = WfCacheHelper.getWholeKey(BLOCKQUEUE, blockQueueKey);
        WfCacheHelper.getDisCache().remove(key);
    }

    public static int getBlockQueueLength(String blockQueueKey) {
        String key = WfCacheHelper.getWholeKey(BLOCKQUEUE, blockQueueKey);
        return WfCacheHelper.getDisCache().getListLength(key);
    }

    public static List<String> getBlockQueueValus(String blockQueueKey) {
        String key = WfCacheHelper.getWholeKey(BLOCKQUEUE, blockQueueKey);
        String[] queue = WfCacheHelper.getDisCache().getList(key);
        if (queue == null || queue.length < 1) {
            return Collections.emptyList();
        }
        return Arrays.asList(queue);
    }

    public static String getModelConfigFormatter(String configType, String formatterKey) {
        String key = WfCacheHelper.getWholeKey(configType, formatterKey);
        return (String)WfCacheHelper.getDisCache().get(key);
    }

    public static void putModelConfigFormatter(String configType, String formatterKey, String formmaterValue) {
        String key = WfCacheHelper.getWholeKey(configType, formatterKey);
        WfCacheHelper.getDisCache().put(key, (Object)formmaterValue);
    }

    public static void putAddressPks(String entityNumber, List<String> pks) {
        WfCacheHelper.batchPutEntityPksInCache(ADDRESSPK, entityNumber, pks, 28800);
    }

    @Deprecated
    public static String[] getAddressPks(String entityNumber) {
        return new String[0];
    }

    public static boolean existAddressPk(String entityNumber, String pk) {
        String key = WfCacheHelper.getWholeKeyWithBucketNum(ADDRESSPK, entityNumber, pk);
        String[] ret = WfCacheHelper.getDisCache().getSetValues(key);
        return Arrays.asList(ret).contains(pk);
    }

    public static void removeAddressPks(String entityNumber, String pk) {
        String key = WfCacheHelper.getWholeKeyWithBucketNum(ADDRESSPK, entityNumber, pk);
        WfCacheHelper.getDisCache().removeSetValues(key, new String[]{pk});
    }

    public static void removeAddressPksBatch(String entityNumber, String[] pks) {
        WfCacheHelper.batchRemoveEntityPksInCache(ADDRESSPK, entityNumber, Arrays.asList(pks));
    }

    public static void putCurrentMQDealResult() {
        String key = WfCacheHelper.getWholeKey(TESTJOBANDMQ);
        WfCacheHelper.getDisCache().put(key, (Object)"ture");
    }

    public static String getCurrentMQDealResult() {
        String key = WfCacheHelper.getWholeKey(TESTJOBANDMQ);
        return (String)WfCacheHelper.getDisCache().get(key);
    }

    public static void removeMQDealResult() {
        String key = WfCacheHelper.getWholeKey(TESTJOBANDMQ);
        WfCacheHelper.getDisCache().remove(key);
    }

    public static void putJobSourceOfAppId(String appId) {
        String key = WfCacheHelper.getWholeKey(APPIDOFJOB);
        WfCacheHelper.getDisCache().addToSet(key, new String[]{appId}, 28800);
    }

    public static void putJobSourceOfAppId(String[] appIds) {
        String key = WfCacheHelper.getWholeKey(APPIDOFJOB);
        WfCacheHelper.getDisCache().addToSet(key, appIds, 28800);
    }

    public static String[] getJobSourceOfAppId() {
        String key = WfCacheHelper.getWholeKey(APPIDOFJOB);
        return WfCacheHelper.getDisCache().getSetValues(key);
    }

    public static void removeJobSourceOfAppId(String appId) {
        String key = WfCacheHelper.getWholeKey(APPIDOFJOB);
        WfCacheHelper.getDisCache().removeSetValues(key, new String[]{appId});
    }

    public static void putAutoRecoverSysErrorProcsSign() {
        String key = WfUtils.strAppend(AUTORECOVERSYSERRORPROCSSIGNPREFIX, ".", new String[]{RequestContext.get().getAccountId()});
        WfCacheHelper.getDisCache().put(key, (Object)"repair");
    }

    public static void removeAutoRecoverSysErrorProcsSign() {
        String key = WfUtils.strAppend(AUTORECOVERSYSERRORPROCSSIGNPREFIX, ".", new String[]{RequestContext.get().getAccountId()});
        WfCacheHelper.getDisCache().remove(key);
    }

    public static String getAutoRecoverSysErrorProcsSign() {
        String key = WfUtils.strAppend(AUTORECOVERSYSERRORPROCSSIGNPREFIX, ".", new String[]{RequestContext.get().getAccountId()});
        return (String)WfCacheHelper.getDisCache().get(key);
    }

    public static void putStencilConfigTime(String nodeTemplateNumber, String time) {
        String key = WfCacheHelper.getWholeKey(NODETEMPLATE, nodeTemplateNumber);
        WfCacheHelper.getDisCache().put(key, (Object)time);
    }

    public static void removeStencilConfigTime(String nodeTemplateNumber) {
        String key = WfCacheHelper.getWholeKey(NODETEMPLATE, nodeTemplateNumber);
        WfCacheHelper.getDisCache().remove(key);
    }

    public static String getStencilConfigTime(String nodeTemplateNumber) {
        String key = WfCacheHelper.getWholeKey(NODETEMPLATE, nodeTemplateNumber);
        return (String)WfCacheHelper.getDisCache().get(key);
    }

    public static void putNodeTemplateExpendData(String stencilType, List<NodeTemplate> nodeTemplates) {
        String key = WfCacheHelper.getWholeKey(NODETEMPLATEEXPEND, stencilType);
        WfCacheHelper.getDisCache().put(key, (Object)SerializationUtils.toJsonString(nodeTemplates), 259200);
    }

    public static void removeNodeTemplateExpendData(String stencilType) {
        String key = WfCacheHelper.getWholeKey(NODETEMPLATEEXPEND, stencilType);
        WfCacheHelper.getDisCache().remove(key);
    }

    public static String getNodeTemplateExpendData(String stencilType) {
        String key = WfCacheHelper.getWholeKey(NODETEMPLATEEXPEND, stencilType);
        return (String)WfCacheHelper.getDisCache().get(key);
    }

    public static Long getNextSerialJob(String serialJobKey) {
        String key = WfCacheHelper.getWholeKey(SERIALJOB, serialJobKey);
        String[] ids = WfCacheHelper.getDisCache().getSetValues(key);
        if (ids == null || ids.length == 0) {
            return null;
        }
        WfCacheHelper.getDisCache().removeSetValues(key, new String[]{ids[0]});
        return Long.valueOf(ids[0]);
    }

    public static void putSerialJobIds(String serialJobKey, Long jobId) {
        String key = WfCacheHelper.getWholeKey(SERIALJOB, serialJobKey);
        WfCacheHelper.getDisCache().addToSet(key, new String[]{String.valueOf(jobId)}, 259200);
    }

    public static void removeSerialJobIds(String serialJobKey) {
        String key = WfCacheHelper.getWholeKey(SERIALJOB, serialJobKey);
        WfCacheHelper.getDisCache().remove(key);
    }

    public static void putWithdrawDeleteBizJobs(String entityNumber, String[] jobIds) {
        String key = WfCacheHelper.getWholeKey("withdrawDeleteBizJobIds", entityNumber);
        WfCacheHelper.getDisCache().addToSet(key, jobIds, 120);
    }

    public static boolean existWithdrawDeleteBizJobs(String entityNumber, Long jobId) {
        String key = WfCacheHelper.getWholeKey("withdrawDeleteBizJobIds", entityNumber);
        String[] jobIds = WfCacheHelper.getDisCache().getSetValues(key);
        if (jobIds != null && jobIds.length > 0) {
            return Arrays.asList(jobIds).contains(jobId);
        }
        return false;
    }

    public static void putWithdrawTimerOrDeadJobRootId(String entityNumber, String[] rootJobIds) {
        String key = WfCacheHelper.getWholeKey(WITHDRAWTIMERORDEADJOBROOTID, entityNumber);
        WfCacheHelper.getDisCache().addToSet(key, rootJobIds, 120);
    }

    public static void removeWithdrawTimerOrDeadJobRootId(String entityNumber, String[] rootJobIds) {
        String key = WfCacheHelper.getWholeKey(WITHDRAWTIMERORDEADJOBROOTID, entityNumber);
        WfCacheHelper.getDisCache().removeSetValues(key, rootJobIds);
    }

    public static boolean existWithdrawTimerOrDeadJobRootId(String entityNumber, Long rootJobId) {
        String key = WfCacheHelper.getWholeKey(WITHDRAWTIMERORDEADJOBROOTID, entityNumber);
        String[] rootJobIds = WfCacheHelper.getDisCache().getSetValues(key);
        if (rootJobIds != null && rootJobIds.length > 0) {
            return Arrays.asList(rootJobIds).contains(rootJobId);
        }
        return false;
    }

    public static void putCurrentStartProcessBusinessKey(String entityNumber, String businesskey) {
        String key = WfCacheHelper.getWholeKeyWithBucketNum(CURRENTSTARTPROCESSPK, entityNumber, businesskey);
        WfCacheHelper.getDisCache().addToSet(key, new String[]{businesskey}, 120);
    }

    public static void removeCurrentStartProcessBusinessKey(String entityNumber, String businesskey) {
        String key = WfCacheHelper.getWholeKeyWithBucketNum(CURRENTSTARTPROCESSPK, entityNumber, businesskey);
        WfCacheHelper.getDisCache().removeSetValues(key, new String[]{businesskey});
    }

    @Deprecated
    public static String[] getCurrentStartProcessBusinessKey(String entityNumber) {
        return new String[0];
    }

    public static boolean existCurrentStartProcessBusinessKey(String entityNumber, String businesskey) {
        String key = WfCacheHelper.getWholeKeyWithBucketNum(CURRENTSTARTPROCESSPK, entityNumber, businesskey);
        String[] ret = WfCacheHelper.getDisCache().getSetValues(key);
        return Arrays.asList(ret).contains(businesskey);
    }

    public static void putCanRejectLock(String key, String value) {
        String cacheKey = WfCacheHelper.getWholeKey(CANREJECTLOCK, key);
        WfCacheHelper.getDisCache().put(cacheKey, (Object)value);
    }

    public static boolean existCanRejectLock(String key) {
        String cacheKey = WfCacheHelper.getWholeKey(CANREJECTLOCK, key);
        return WfCacheHelper.getDisCache().contains(cacheKey);
    }

    public static void removeCanRejectLock(String key) {
        String cacheKey = WfCacheHelper.getWholeKey(CANREJECTLOCK, key);
        WfCacheHelper.getDisCache().remove(cacheKey);
    }

    public static void putCopyMessageModel(String copyObject) {
        String key = WfCacheHelper.getWholeKey(RequestContext.get().getUserId(), "copyMessageModel");
        WfCacheHelper.getDisCache().put(key, (Object)copyObject, 1800);
    }

    public static String getCopyMessageModel() {
        String key = WfCacheHelper.getWholeKey(RequestContext.get().getUserId(), "copyMessageModel");
        return (String)WfCacheHelper.getDisCache().get(key);
    }

    public static void putSendExpireMessage(String key) {
        String cacheKey = WfCacheHelper.getWholeKey("ExpireSendMessage", key);
        WfCacheHelper.getDisCache().put(cacheKey, (Object)key, 3600);
    }

    public static boolean getSendExpireMessage(String key) {
        String cacheKey = WfCacheHelper.getWholeKey("ExpireSendMessage", key);
        return WfCacheHelper.getDisCache().get(cacheKey) != null;
    }

    public static void putWorkflowRoleOldExport(String pageId) {
        String cacheKey = WfCacheHelper.getWholeKey("exportoldversion", pageId);
        WfCacheHelper.getDisCache().put(cacheKey, (Object)"old", 3600);
    }

    public static String getWorkflowRoleOldExport(String pageId) {
        String cacheKey = WfCacheHelper.getWholeKey("exportoldversion", pageId);
        return (String)WfCacheHelper.getDisCache().get(cacheKey);
    }

    public static void removeWorkflowRoleOldExport(String pageId) {
        String cacheKey = WfCacheHelper.getWholeKey("exportoldversion", pageId);
        WfCacheHelper.getDisCache().remove(cacheKey);
    }

    public static void putTrdBusinessObjectDataSource(String entityNumber, String businessKey, String details) {
        String wholeKey = WfCacheHelper.getWholeKey(TRDBUSINESSOBJECTDATASOURCE, entityNumber, businessKey);
        WfCacheHelper.getDisCache().put(wholeKey, (Object)details, 259200);
    }

    public static String getTrdBusinessObjectDataSource(String entityNumber, String businessKey) {
        String wholeKey = WfCacheHelper.getWholeKey(TRDBUSINESSOBJECTDATASOURCE, entityNumber, businessKey);
        return (String)WfCacheHelper.getDisCache().get(wholeKey);
    }

    public static void removeTrdBusinessObjectDataSource(String entityNumber, String businessKey) {
        String wholeKey = WfCacheHelper.getWholeKey(TRDBUSINESSOBJECTDATASOURCE, entityNumber, businessKey);
        WfCacheHelper.getDisCache().remove(wholeKey);
    }

    public static void putBusinessField(String entitynumber, String value) {
        String wholeKey = WfCacheHelper.getWholeKey(entitynumber);
        WfCacheHelper.getDisCache().put(wholeKey, (Object)value);
    }

    public static String getBusinessField(String entitynumber) {
        String wholeKey = WfCacheHelper.getWholeKey(entitynumber);
        return WfCacheHelper.getDisCache().get(wholeKey) == null ? "" : (String)WfCacheHelper.getDisCache().get(wholeKey);
    }
}

