/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.workflow.engine.impl.calculator;

import com.alibaba.fastjson.JSONObject;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import kd.bos.dataentity.entity.ILocaleString;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.lang.Lang;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.workflow.bpmn.model.BillSubjectModel;
import kd.bos.workflow.engine.WfUtils;
import kd.bos.workflow.engine.delegate.VariableScope;
import kd.bos.workflow.engine.history.HistoricProcessInstance;
import kd.bos.workflow.engine.impl.calculator.BillSubjectCalculator;
import kd.bos.workflow.engine.impl.calculator.BillSubjectCalculatorUtil;
import kd.bos.workflow.engine.impl.cfg.ProcessEngineConfigurationImpl;
import kd.bos.workflow.engine.impl.persistence.entity.management.BillSubjectModelEntity;
import kd.bos.workflow.engine.impl.persistence.entity.management.BillSubjectModelEntityManager;
import kd.bos.workflow.engine.impl.persistence.entity.runtime.ExecutionEntity;
import kd.bos.workflow.engine.impl.persistence.entity.task.TaskEntity;
import kd.bos.workflow.engine.impl.util.BpmnModelUtil;
import kd.bos.workflow.engine.impl.util.TaskHelper;
import kd.bos.workflow.engine.impl.util.condition.ConditionType;
import kd.bos.workflow.engine.impl.util.condition.ConditionUtil;

public class BillSubjectCalculatorImpl
implements BillSubjectCalculator {
    private Log logger = LogFactory.getLog(this.getClass());
    protected ProcessEngineConfigurationImpl processEngineConfiguration;

    public BillSubjectCalculatorImpl(ProcessEngineConfigurationImpl processEngineConfiguration) {
        this.processEngineConfiguration = processEngineConfiguration;
    }

    @Override
    public ILocaleString getSubjectByBillSubjectModel(List<BillSubjectModel> billSubjectModels, String businessKey, String entityNumber, VariableScope scope) {
        this.logger.debug(String.format("\u8ba1\u7b97\u5355\u636e %s[%s] \u7684\u5355\u636e\u4e3b\u9898", entityNumber, businessKey));
        BillSubjectModelEntityManager dataManager = this.processEngineConfiguration.getBillSubjectModelEntityManager();
        String taskScene = StringUtils.isNotBlank((Object)scope.getTransientVariable("taskscene")) ? (String)scope.getTransientVariable("taskscene") : null;
        ILocaleString subject = null;
        if (billSubjectModels != null && !billSubjectModels.isEmpty()) {
            this.logger.debug(String.format("BpmnModel\u6a21\u578b\u4e0a\u5355\u636e\u4e3b\u9898\u4e0d\u4e3a\u7a7a\uff01--%s", businessKey));
            subject = this.getSubjectFromBillSubjectModel(billSubjectModels, dataManager, businessKey, entityNumber, scope, taskScene);
        }
        if (WfUtils.isEmpty(subject)) {
            this.logger.debug(String.format("BpmnModel\u6a21\u578b\u4e0a\u5355\u636e\u4e3b\u9898\u4e3a\u7a7a\uff0c\u4ece\u5355\u636e\u6d41\u7a0b\u5c5e\u6027\u89e3\u6790\uff01--%s", businessKey));
            subject = this.getSubjectFromBillSubjectEntity(businessKey, entityNumber, dataManager, scope);
        }
        return subject;
    }

    private ILocaleString getSubjectFromBillSubjectEntity(String businessKey, String entityNumber, BillSubjectModelEntityManager dataManager, VariableScope scope) {
        ILocaleString subjectDef = BillSubjectCalculatorUtil.getSubjectDef(dataManager, entityNumber, scope, true);
        if (WfUtils.isNotEmpty(subjectDef)) {
            Lang[] langs;
            LocaleString subject = new LocaleString();
            for (Lang lang : langs = WfUtils.getSupportLangs()) {
                String lName = lang.name();
                String value = WfUtils.getEmptyStringValue(subjectDef, lName);
                String subjectValue = BillSubjectCalculatorUtil.getSubjectValue(businessKey, entityNumber, value, scope, lName);
                subject.put((Object)lName, (Object)subjectValue);
            }
            return subject;
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ILocaleString getSubjectFromBillSubjectModel(List<BillSubjectModel> billSubjectModels, BillSubjectModelEntityManager dataManager, String businessKey, String entityNumber, VariableScope scope, String taskScene) {
        if (StringUtils.isNotBlank((CharSequence)taskScene)) {
            BillSubjectModel matchSubjectModel = this.matchSubjectModel(billSubjectModels, scope, taskScene);
            if (matchSubjectModel != null) {
                return this.getSubject(dataManager, matchSubjectModel, businessKey, entityNumber, scope);
            }
            try {
                scope.setTransientVariable("isonlymatchsamescene", Boolean.TRUE);
                ILocaleString subjectFromBillSubjectEntity = this.getSubjectFromBillSubjectEntity(businessKey, entityNumber, dataManager, scope);
                if (WfUtils.isNotEmpty(subjectFromBillSubjectEntity)) {
                    ILocaleString iLocaleString = subjectFromBillSubjectEntity;
                    return iLocaleString;
                }
            }
            finally {
                scope.removeTransientVariable("isonlymatchsamescene");
            }
        }
        return this.getSubjectFromBillSubjectModel(billSubjectModels, dataManager, businessKey, entityNumber, scope);
    }

    private ILocaleString getSubjectFromBillSubjectModel(List<BillSubjectModel> billSubjectModels, BillSubjectModelEntityManager dataManager, String businessKey, String entityNumber, VariableScope scope) {
        boolean isRejectTask = this.isRejectTask(scope);
        String timing = isRejectTask ? "reject" : "normal";
        BillSubjectModel matchSubjectModel = this.matchSubjectModel(billSubjectModels, scope, timing);
        this.logger.debug(String.format("\u4ece\u6a21\u578b\u4e0a\u89e3\u6790\u5355\u636e\u4e3b\u9898\uff1aisReject: %s\uff0ctiming: %s", isRejectTask, timing));
        return this.getSubject(dataManager, matchSubjectModel, businessKey, entityNumber, scope);
    }

    private BillSubjectModel matchSubjectModel(List<BillSubjectModel> billSubjectModels, VariableScope scope, String taskScene) {
        String nodeNumber = this.getNodeNumber(scope);
        String key = ConditionUtil.getConInstKey(nodeNumber, "taskSubject");
        BillSubjectModel subjectWithMatchRule = null;
        BillSubjectModel subjectWithOutRule = null;
        for (BillSubjectModel billSubjectModel : billSubjectModels) {
            this.logger.debug(String.format("BillSubjectModel: %s %s", billSubjectModel.getCustomSubject(), billSubjectModel.getTiming()));
            if (WfUtils.isEmpty(billSubjectModel.getCustomSubject()) || !taskScene.equals(billSubjectModel.getTiming())) continue;
            if (billSubjectModel.getRule() != null) {
                ConditionType.logOpDesc(billSubjectModel.getRule());
                if (ConditionUtil.hasTrueCondition(billSubjectModel.getRule(), scope, key)) {
                    subjectWithMatchRule = billSubjectModel;
                    break;
                }
                this.logger.debug("\u6ca1\u6709\u627e\u5230\u6709\u6761\u4ef6\u5e76\u4e14\u6761\u4ef6\u4e3a\u771f\u7684\u4efb\u52a1\u4e3b\u9898\u5185\u5bb9\uff01");
                continue;
            }
            if (subjectWithOutRule != null) continue;
            subjectWithOutRule = billSubjectModel;
        }
        return subjectWithMatchRule != null ? subjectWithMatchRule : subjectWithOutRule;
    }

    private boolean isRejectTask(VariableScope scope) {
        TaskHelper taskHelper = this.processEngineConfiguration.getTaskHelper();
        boolean isRejectTask = false;
        if (scope instanceof ExecutionEntity) {
            ExecutionEntity execution = (ExecutionEntity)scope;
            isRejectTask = taskHelper.isRejectTask(execution.getProcessInstanceId(), execution.getCurrentActInstId(), execution.getCurrentActivityId());
        } else if (scope instanceof TaskEntity) {
            TaskEntity taskEntity = (TaskEntity)scope;
            isRejectTask = taskHelper.isRejectTask(taskEntity.getProcessInstanceId(), taskEntity.getExecution().getCurrentActInstId(), taskEntity.getTaskDefinitionKey());
        }
        return isRejectTask;
    }

    private String getNodeNumber(VariableScope scope) {
        String activityId = null;
        if (scope instanceof ExecutionEntity) {
            activityId = ((ExecutionEntity)scope).getActivityId();
        } else if (scope instanceof TaskEntity) {
            activityId = ((TaskEntity)scope).getTaskDefinitionKey();
        }
        return activityId;
    }

    private ILocaleString getSubject(BillSubjectModelEntityManager dataManager, BillSubjectModel model, String businessKey, String entityNumber, VariableScope scope) {
        if (model == null || WfUtils.isEmpty(model.getCustomSubject())) {
            this.logger.debug(String.format("\u6a21\u578b\u4e2d\u672a\u627e\u5230\u6ee1\u8db3\u6761\u4ef6\u7684\u5355\u636e\u4e3b\u9898\uff0c\u4ece\u5355\u636e\u6d41\u7a0b\u5c5e\u6027\u4e2d\u89e3\u6790\uff01--%s", businessKey));
            return this.getSubjectFromBillSubjectEntity(businessKey, entityNumber, dataManager, scope);
        }
        this.logger.debug(String.format("\u5df2\u627e\u5230\u6ee1\u8db3\u6761\u4ef6\u7684\u5355\u636e\u4e3b\u9898\uff0c\u5f00\u59cb\u89e3\u6790\uff01--%s %s", businessKey, model.getCustomSubject()));
        return this.getMultiLangSubject(dataManager, model, businessKey, entityNumber, scope, model.getCustomSubject());
    }

    private ILocaleString getMultiLangSubject(BillSubjectModelEntityManager dataManager, BillSubjectModel model, String businessKey, String entityNumber, VariableScope scope, String customSubject) {
        Lang[] langs;
        String activityId = this.getNodeNumber(scope);
        this.logger.debug(String.format("\u89e3\u6790\u5355\u636e\u4e3b\u9898\uff0cActivityId: %s", activityId));
        if (WfUtils.isEmpty(activityId)) {
            this.logger.debug("\u89e3\u6790\u5355\u636e\u4e3b\u9898\uff0cActivityId\u4e3a\u7a7a\uff01");
            return this.getSubjectResult(customSubject, businessKey, entityNumber, dataManager, scope);
        }
        LocaleString subject = new LocaleString();
        String multiKey = "";
        if (model != null) {
            subject = new LocaleString();
            multiKey = String.format("%s.subject.[%s].customSubject", activityId, model.getId());
        }
        String oldMultiKey = String.format("%s.subject.customSubject", activityId);
        Long procInstanceId = null;
        ExecutionEntity e = this.processEngineConfiguration.getExecutionEntityManager().findActiveExecutionByBusinessKeyAndActivityId(businessKey, activityId);
        if (e != null) {
            procInstanceId = e.getProcessInstanceId();
        } else {
            HistoricProcessInstance entity = this.processEngineConfiguration.getHistoricProcessInstanceEntityManager().findLatestHistoricProcessInstanceByBusinessKey(businessKey);
            procInstanceId = entity.getId();
        }
        JSONObject multiLangDatas = BpmnModelUtil.getMultiLangDatas(procInstanceId);
        this.logger.debug(String.format("BusinessKey: %s MultiLangDatas: %s", businessKey, multiLangDatas));
        for (Lang lang : langs = WfUtils.getSupportLangs()) {
            String key = lang.name();
            JSONObject datas = multiLangDatas.getJSONObject(key);
            if (WfUtils.isEmptyForMap((Map)datas)) continue;
            String subjectDef = (String)datas.get((Object)multiKey);
            if (WfUtils.isEmpty(subjectDef)) {
                subjectDef = (String)datas.get((Object)oldMultiKey);
            }
            if (WfUtils.isEmpty(subjectDef) && model != null) {
                subjectDef = model.getCustomSubject();
            }
            if (WfUtils.isEmpty(subjectDef)) continue;
            subjectDef = this.getCustomSubject(dataManager, subjectDef, entityNumber, key);
            subject.put((Object)key, (Object)BillSubjectCalculatorUtil.getSubjectValue(businessKey, entityNumber, subjectDef, scope, key));
            this.logger.debug(String.format("\u89e3\u6790\u540e\u7684\u5355\u636e\u4e3b\u9898: %s -- %s", key, subject));
        }
        return subject;
    }

    private String getCustomSubject(BillSubjectModelEntityManager dataManager, String subjectDef, String entityNumber, String lang) {
        Pattern pattern = Pattern.compile("\\{\\{(.+?)\\}\\}");
        Matcher matcher = pattern.matcher(subjectDef);
        if (matcher.find()) {
            String subjectId = matcher.group(1);
            BillSubjectModelEntity subjectModel = dataManager.findBillSubjectByEntityNumber(entityNumber);
            if (subjectModel != null) {
                String value;
                ILocaleString generalSub = subjectModel.getBillSubject();
                if (generalSub != null && WfUtils.isNotEmpty(value = (String)generalSub.get((Object)lang))) {
                    subjectDef = subjectDef.replace("{{" + subjectId + "}}", value);
                }
            } else {
                this.logger.debug(String.format("%s \u7684\u5355\u636e\u4e3b\u9898\u4e3a\u7a7a\uff01", entityNumber));
            }
        }
        return subjectDef;
    }

    private ILocaleString getSubjectResult(String subjectDef, String businessKey, String entityNumber, BillSubjectModelEntityManager dataManager, VariableScope scope) {
        Pattern pattern;
        Matcher matcher;
        LocaleString ret = new LocaleString(subjectDef);
        if (WfUtils.isNotEmpty(subjectDef) && (matcher = (pattern = Pattern.compile("\\{\\{(.+?)\\}\\}")).matcher(subjectDef)).find()) {
            String subjectId = matcher.group(1);
            BillSubjectModelEntity subjectModel = dataManager.findBillSubjectByEntityNumber(entityNumber);
            if (subjectModel != null) {
                ILocaleString generalSub = subjectModel.getBillSubject();
                if (generalSub != null) {
                    Lang[] langs;
                    for (Lang lang : langs = WfUtils.getSupportLangs()) {
                        String key = lang.name();
                        String value = WfUtils.getEmptyStringValue(generalSub, key);
                        if (!WfUtils.isNotEmpty(value)) continue;
                        ret.put((Object)key, (Object)BillSubjectCalculatorUtil.getSubjectValue(businessKey, entityNumber, subjectDef.replace("{{" + subjectId + "}}", value), scope, key));
                    }
                }
            } else {
                this.logger.debug(String.format("%s \u7684\u5355\u636e\u4e3b\u9898\u4e3a\u7a7a\uff01", entityNumber));
            }
        }
        return ret;
    }
}

