/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.workflow.engine.impl.calculator;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.alibaba.fastjson.TypeReference;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.ILocaleString;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.BasedataEntityType;
import kd.bos.entity.BillEntityType;
import kd.bos.entity.MainEntityType;
import kd.bos.exception.KDException;
import kd.bos.form.FormConfig;
import kd.bos.form.FormMetadataCache;
import kd.bos.lang.Lang;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.workflow.engine.WfConfigurationUtil;
import kd.bos.workflow.engine.WfMultiLangUtils;
import kd.bos.workflow.engine.WfUtils;
import kd.bos.workflow.engine.delegate.VariableScope;
import kd.bos.workflow.engine.extitf.ExtItfCallerType;
import kd.bos.workflow.engine.extitf.ExternalInterfaceUtil;
import kd.bos.workflow.engine.impl.calculator.ExpressionCalculatorUtil;
import kd.bos.workflow.engine.impl.persistence.entity.management.BillSubjectModelEntity;
import kd.bos.workflow.engine.impl.persistence.entity.management.BillSubjectModelEntityManager;
import kd.bos.workflow.engine.impl.persistence.entity.runtime.ExecutionEntity;
import kd.bos.workflow.engine.impl.persistence.entity.task.TaskEntity;
import kd.bos.workflow.engine.impl.util.condition.ConditionType;
import kd.bos.workflow.engine.impl.util.condition.ConditionUtil;
import kd.bos.workflow.relservice.BusinessObjectQueryHelper;

public class BillSubjectCalculatorUtil {
    private static Log logger = LogFactory.getLog(BillSubjectCalculatorUtil.class);
    public static final String COMMONTASKSCENE = "task";

    public static ILocaleString getSubjectDef(BillSubjectModelEntityManager dataManager, String entityNumber, VariableScope scope, Boolean subjectForPC) {
        LocaleString subjectDef = new LocaleString();
        logger.debug(String.format("\u4ece\u5355\u636e\u6d41\u7a0b\u5c5e\u6027\u67e5\u8be2\u5355\u636e %s \u7684\u4e3b\u9898\uff01", entityNumber));
        BillSubjectModelEntity subjectEntity = dataManager.findBillSubjectByEntityNumber(entityNumber);
        String taskScene = StringUtils.isNotBlank((Object)scope.getTransientVariable("taskscene")) ? (String)scope.getTransientVariable("taskscene") : COMMONTASKSCENE;
        ILocaleString billSubject = null;
        if (subjectEntity != null && (billSubject = subjectForPC != false ? subjectEntity.getBillSubject() : subjectEntity.getBillSubjectMob()) != null) {
            Lang[] langs;
            LocaleString def = new LocaleString();
            for (Lang lang : langs = WfUtils.getSupportLangs()) {
                String key = lang.name();
                String subjectStr = WfUtils.getEmptyStringValue(billSubject, key);
                JSONObject jsonObject = new JSONObject();
                jsonObject.put("subjectStr", (Object)subjectStr);
                jsonObject.put("subjectForPC", (Object)subjectForPC);
                subjectStr = jsonObject.toJSONString();
                String matchSubjectDef = BillSubjectCalculatorUtil.getMatchSubjectDef(subjectStr, entityNumber, scope, taskScene);
                if (WfUtils.isEmpty(matchSubjectDef) && COMMONTASKSCENE.equals(taskScene)) {
                    if (WfUtils.isEmpty((ILocaleString)def)) {
                        def = BillSubjectCalculatorUtil.getSubjectFrommainEntity(entityNumber, (ILocaleString)new LocaleString());
                    }
                    logger.debug(String.format("%s \u5355\u636e\u5b9a\u4e49\u5355\u636e\u6d41\u7a0b\u5c5e\u6027\u5728\u3010%s\u3011\u8bed\u97f3\u73af\u5883\u4e2d\u672a\u627e\u5230\u7b26\u5408\u6761\u4ef6\u7684\u5355\u636e\u4e3b\u9898\uff0c\u751f\u6210\u9ed8\u8ba4\u7684\u5355\u636e\u4e3b\u9898\uff01", entityNumber, key));
                    matchSubjectDef = (String)def.get((Object)key);
                }
                subjectDef.put((Object)key, (Object)matchSubjectDef);
            }
        }
        if (WfUtils.isEmpty((ILocaleString)subjectDef) && COMMONTASKSCENE.equals(taskScene)) {
            logger.debug(String.format("%s \u5355\u636e\u672a\u5b9a\u4e49\u5355\u636e\u6d41\u7a0b\u5c5e\u6027\uff0c\u751f\u6210\u9ed8\u8ba4\u7684\u5355\u636e\u4e3b\u9898\uff01", entityNumber));
            subjectDef = BillSubjectCalculatorUtil.getSubjectFrommainEntity(entityNumber, (ILocaleString)subjectDef);
        }
        return subjectDef;
    }

    private static ILocaleString getSubjectFrommainEntity(String entityNumber, ILocaleString subjectDef) {
        boolean isNoCodeBill = false;
        try {
            FormConfig formConfig = FormMetadataCache.getFormConfig((String)entityNumber);
            isNoCodeBill = "nocodebill".equalsIgnoreCase(formConfig.getModelType());
        }
        catch (Exception e) {
            logger.error(String.format("getFormConfig error. EntityNumber: %s, Error: %s", entityNumber, WfUtils.getExceptionStacktrace(e)));
        }
        if (isNoCodeBill) {
            return subjectDef;
        }
        MainEntityType mainEntityType = null;
        try {
            mainEntityType = BusinessObjectQueryHelper.getDataEntityType((String)entityNumber);
        }
        catch (KDException e) {
            logger.warn("mainEntityType number[" + entityNumber + "] error:" + e.getMessage());
            subjectDef = WfUtils.getPromptWordLocaleString("\u83b7\u53d6\u5143\u6570\u636e\u5f02\u5e38\uff0c\u5143\u6570\u636e\u53ef\u80fd\u5df2\u7ecf\u5220\u9664\uff0c\u65e0\u6cd5\u89e3\u6790\u4efb\u52a1\u4e3b\u9898\u3002", "BillSubjectCalculatorUtil_1", "bos-wf-engine");
        }
        if (!WfUtils.isNullObject(mainEntityType)) {
            String billNoOrName = null;
            if (mainEntityType instanceof BasedataEntityType) {
                billNoOrName = ((BasedataEntityType)mainEntityType).getNameProperty();
                subjectDef = WfUtils.getPromptWordLocaleString("\u540d\u79f0:{%s}", "BillSubjectCalculatorUtil_6", "bos-wf-engine");
            } else if (mainEntityType instanceof BillEntityType) {
                billNoOrName = ((BillEntityType)mainEntityType).getBillNo();
                subjectDef = WfUtils.getPromptWordLocaleString("\u5355\u636e\u7f16\u53f7\uff1a{%s}", "BillSubjectCalculatorUtil_7", "bos-wf-engine");
            }
            if (!WfUtils.isEmpty(billNoOrName)) {
                subjectDef = WfMultiLangUtils.getMultiLangValue(new ILocaleString[]{subjectDef, new LocaleString(billNoOrName)});
            }
        }
        return subjectDef;
    }

    private static String getMatchSubjectDef(String subjectStr, String entityNumber, VariableScope scope) {
        try {
            logger.debug(String.format("\u4ece\u5355\u636e\u6d41\u7a0b\u5c5e\u6027\u4e2d\u627e\u6ee1\u8db3\u6761\u4ef6\u7684\u5355\u636e\u4e3b\u9898\uff1a%s %s", entityNumber, subjectStr));
            return BillSubjectCalculatorUtil.matchSubjectDef(subjectStr, scope, COMMONTASKSCENE);
        }
        catch (Exception e) {
            logger.warn(String.format("\u7f16\u7801\u4e3a[%s]\u7684\u5355\u636e\u4e0a\u7684\u5355\u636e\u4e3b\u9898\u662f\u65e7\u7248\u7684\uff01", entityNumber));
            return subjectStr;
        }
    }

    private static String getMatchSubjectDef(String subjectStr, String entityNumber, VariableScope scope, String taskScene) {
        try {
            logger.debug(String.format("\u4ece\u5355\u636e\u6d41\u7a0b\u5c5e\u6027\u4e2d\u627e\u6ee1\u8db3\u6761\u4ef6\u7684\u5355\u636e\u4e3b\u9898\uff1a%s %s", entityNumber, subjectStr));
            if (WfUtils.isEmpty(subjectStr)) {
                return null;
            }
            Boolean isOnlyMatchSameScene = StringUtils.isNotBlank((Object)scope.getTransientVariable("isonlymatchsamescene")) ? (Boolean)scope.getTransientVariable("isonlymatchsamescene") : Boolean.FALSE;
            String subjectDef = BillSubjectCalculatorUtil.matchSubjectDef(subjectStr, scope, taskScene);
            if (!isOnlyMatchSameScene.booleanValue() && subjectDef == null) {
                return BillSubjectCalculatorUtil.getMatchSubjectDef(subjectStr, entityNumber, scope);
            }
            return subjectDef;
        }
        catch (Exception e) {
            logger.warn(String.format("\u7f16\u7801\u4e3a[%s]\u7684\u5355\u636e\u4e0a\u7684\u5355\u636e\u4e3b\u9898\u662f\u65e7\u7248\u7684\uff01", entityNumber));
            return null;
        }
    }

    private static String matchSubjectDef(String subjectStr, VariableScope scope, String taskScene) {
        String subjectRuleStr = null;
        JSONObject subjectWithMatchRule = null;
        JSONObject subjectWithOutRule = null;
        String activityId = BillSubjectCalculatorUtil.getNodeNumber(scope);
        JSONObject jsonObject = JSONObject.parseObject((String)subjectStr);
        JSONArray subjectJson = BillSubjectCalculatorUtil.getSubjectJson(jsonObject);
        Boolean subjectForPC = jsonObject.getBoolean("subjectForPC");
        String keyType = subjectForPC != null && subjectForPC != false ? "billSubjectPc" : "billSubjectMobil";
        String key = ConditionUtil.getConInstKey(activityId, keyType);
        for (Object subjectObject : subjectJson) {
            JSONObject subject = (JSONObject)subjectObject;
            String scene = StringUtils.isNotBlank((CharSequence)subject.getString("scene")) ? subject.getString("scene") : COMMONTASKSCENE;
            if (!taskScene.equals(scene)) continue;
            subjectRuleStr = subject.getString("rule");
            if (WfUtils.isNotEmpty(subjectRuleStr)) {
                JSONObject ruleObject = JSON.parseObject((String)subjectRuleStr);
                String rule = ruleObject.getString("expression");
                if (WfUtils.isEmpty(rule)) {
                    rule = ruleObject.getString("plugin");
                }
                JSONObject showText = ruleObject.getJSONObject("showtext");
                Map map = (Map)showText.toJavaObject((TypeReference)new TypeReference<Map<String, String>>(){});
                LocaleString localeString = LocaleString.fromMap((Map)map);
                ConditionType.logOpDesc(localeString.toString());
                boolean hasTrueCondition = ConditionUtil.hasTrueCondition(rule, scope, key);
                if (hasTrueCondition) {
                    subjectWithMatchRule = subject;
                    break;
                }
                logger.debug("\u6ca1\u6709\u627e\u5230\u6709\u6761\u4ef6\u5e76\u4e14\u6761\u4ef6\u4e3a\u771f\u7684\u5355\u636e\u4e3b\u9898\u5185\u5bb9\uff01");
                continue;
            }
            if (subjectWithOutRule != null) continue;
            subjectWithOutRule = subject;
        }
        String subjectDef = null;
        if (subjectWithMatchRule != null) {
            subjectDef = subjectWithMatchRule.getString("customSubject");
        } else if (subjectWithOutRule != null) {
            subjectDef = subjectWithOutRule.getString("customSubject");
        }
        return subjectDef;
    }

    private static JSONArray getSubjectJson(JSONObject jsonObject) {
        try {
            return jsonObject.getJSONArray("subjectStr");
        }
        catch (Throwable e) {
            Object subjectStr = jsonObject.get((Object)"subjectStr");
            if (!(subjectStr instanceof String)) {
                return new JSONArray();
            }
            if (StringUtils.isBlank((Object)subjectStr)) {
                return new JSONArray();
            }
            String subject = (String)subjectStr;
            JSONObject subjectObj = new JSONObject();
            subjectObj.put("customSubject", (Object)subject);
            JSONArray result = new JSONArray();
            result.add((Object)subjectObj);
            return result;
        }
    }

    private static String getNodeNumber(VariableScope scope) {
        String activityId = null;
        if (scope instanceof ExecutionEntity) {
            activityId = ((ExecutionEntity)scope).getActivityId();
        } else if (scope instanceof TaskEntity) {
            activityId = ((TaskEntity)scope).getTaskDefinitionKey();
        }
        return activityId;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String getSubjectValue(String businessKey, String entityNumber, String subjectDef, VariableScope scope, String lang) {
        logger.debug(String.format("\u5f00\u59cb\u8ba1\u7b97 %s \u5355\u636e %s \u5728 %s \u4e0b\u7684\u5355\u636e\u4e3b\u9898\uff01 %s", entityNumber, businessKey, lang, subjectDef));
        String subject = "";
        try {
            DynamicObject dynObj = WfUtils.findBusinessObject(businessKey, entityNumber);
            if (dynObj == null) {
                String string = subject;
                return string;
            }
            scope.setTransientVariable("lang", lang);
            subject = ExternalInterfaceUtil.isValidValue(subjectDef) ? (scope instanceof TaskEntity ? (String)ExternalInterfaceUtil.executeExtItf(ExtItfCallerType.BILLSUBJECT, subjectDef, ((TaskEntity)scope).getExecution(), lang) : (String)ExternalInterfaceUtil.executeExtItf(ExtItfCallerType.BILLSUBJECT, subjectDef, scope, lang)) : (!WfConfigurationUtil.isCurrencyFormat() ? ExpressionCalculatorUtil.contentParser(subjectDef, dynObj, scope, false) : ExpressionCalculatorUtil.contentParser(subjectDef, dynObj, scope, true));
            if (subject.length() > 2000) {
                subject = subject.substring(0, 2000);
            }
        }
        catch (Exception e) {
            logger.warn(WfUtils.getExceptionStacktrace(e));
        }
        finally {
            scope.removeTransientVariable("lang");
        }
        return subject;
    }

    public static ILocaleString getSubjectValue(String businessKey, String entityNumber, VariableScope scope, BillSubjectModelEntityManager dataManager, Boolean subjectForPC) {
        LocaleString ret = new LocaleString();
        ILocaleString subject = BillSubjectCalculatorUtil.getSubjectDef(dataManager, entityNumber, scope, subjectForPC);
        if (subject != null) {
            Lang[] langs;
            for (Lang lang : langs = WfUtils.getSupportLangs()) {
                String lName = lang.name();
                String value = WfUtils.getEmptyStringValue(subject, lName);
                ret.put((Object)lName, (Object)BillSubjectCalculatorUtil.getSubjectValue(businessKey, entityNumber, value, scope, lName));
            }
        } else {
            logger.debug(String.format("%s %s \u7684\u5355\u636e\u4e3b\u9898\u4e3a\u7a7a\uff01", entityNumber, subjectForPC));
        }
        return ret;
    }
}

