/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.workflow.engine.impl.calculator;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import kd.bos.bec.model.KDBizEvent;
import kd.bos.exception.KDException;
import kd.bos.workflow.bpmn.model.Process;
import kd.bos.workflow.bpmn.model.WaitTask;
import kd.bos.workflow.engine.WfUtils;
import kd.bos.workflow.engine.impl.calculator.DefaultMacroParserImpl;
import kd.bos.workflow.engine.impl.calculator.MacroParser;
import kd.bos.workflow.engine.impl.persistence.entity.runtime.ExecutionEntity;
import kd.bos.workflow.engine.impl.util.ProcessDefinitionUtil;
import kd.bos.workflow.exception.WFErrorCode;

public class EventMacroParserImpl
extends DefaultMacroParserImpl
implements MacroParser {
    protected static final String DEFALUTJSON = "{}";

    public EventMacroParserImpl(String macro) {
        super(macro);
    }

    @Override
    public Object parseMacro(ExecutionEntity execution) {
        String activityId = this.macro.substring(0, this.macro.length() - "event".length());
        String eventSrcJson = "";
        if (WfUtils.isNotEmpty(activityId)) {
            Process process = ProcessDefinitionUtil.getProcessByProcInstId(execution.getProcessInstanceId());
            WaitTask waitTask = (WaitTask)process.getFlowElement(activityId);
            String eventNum = waitTask.getTimingModel().getEvent();
            String variableKey = String.format("%s.%s", activityId, eventNum);
            eventSrcJson = (String)execution.getProcessInstance().getVariable(variableKey);
            eventSrcJson = WfUtils.isNotEmpty(eventSrcJson) ? eventSrcJson : DEFALUTJSON;
        }
        ObjectMapper objectMapper = new ObjectMapper();
        try {
            JsonNode jsonNode = objectMapper.readTree(eventSrcJson);
            KDBizEvent k = new KDBizEvent((Object)"");
            return null;
        }
        catch (Exception e) {
            throw new KDException(WFErrorCode.conditionParseError(), new Object[]{WfUtils.getExceptionStacktrace(e)});
        }
    }
}

