/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.workflow.engine.impl.calculator;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.bec.api.IEventService;
import kd.bos.bec.engine.EventDispatchContext;
import kd.bos.bec.engine.EvtUtils;
import kd.bos.bec.engine.el.EventModelVariableScope;
import kd.bos.bec.model.EntityEvent;
import kd.bos.bec.model.KDBizEvent;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.EntryType;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.SubEntryType;
import kd.bos.exception.KDException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.login.service.DispatchServiceHelper;
import kd.bos.workflow.engine.WfUtils;
import kd.bos.workflow.engine.delegate.VariableScope;
import kd.bos.workflow.engine.impl.calculator.ExpressionCalculatorUtil;
import kd.bos.workflow.engine.impl.cmd.startup.BusinessModelVariableScope;
import kd.bos.workflow.engine.impl.persistence.entity.runtime.VariableScopeImpl;
import kd.bos.workflow.exception.BECEngineException;
import kd.bos.workflow.exception.WFErrorCode;

public class EventParticipantCalculatorUtil {
    public static final String VALUE = "value";
    private static final String ERRORDESCRIPTION = "Error while evaluating expression: ";
    private static Log log = LogFactory.getLog(EventParticipantCalculatorUtil.class);

    public static Map<String, List<Long>> participantCalculator(String returnDataList, KDBizEvent event, List<String> businesskeys, String entityNumber, EventDispatchContext edContext) {
        HashMap<String, List<Long>> combineResult = new HashMap<String, List<Long>>(16);
        HashMap participantMap = new HashMap(16);
        HashMap<String, Object> pluginMap = new HashMap<String, Object>();
        for (String businesskey : businesskeys) {
            HashSet<Long> userSet = new HashSet<Long>();
            if (!WfUtils.isEmpty(returnDataList)) {
                List participants = (List)SerializationUtils.fromJsonString((String)returnDataList, List.class);
                for (Map participant : participants) {
                    Object id;
                    String type = (String)participant.get("type");
                    Object object = participant.get(VALUE);
                    if ("person".equals(type)) {
                        String[] ids = String.valueOf(object).split(",");
                        ArrayList<Long> list = new ArrayList<Long>();
                        for (int j = 0; j < ids.length; ++j) {
                            id = ids[j].trim();
                            if (((String)id).isEmpty() || list.contains(Long.valueOf((String)id))) continue;
                            list.add(Long.valueOf((String)id));
                        }
                        userSet.addAll(list);
                        continue;
                    }
                    if ("entity".equals(type)) {
                        DynamicObject obj = EvtUtils.findBusinessObject(businesskey, entityNumber);
                        BusinessModelVariableScope scope = new BusinessModelVariableScope(businesskey, entityNumber);
                        if (obj == null) continue;
                        try {
                            DynamicObjectCollection entryEntityCollection;
                            DynamicObject dynamicObject;
                            int i;
                            String express = (String)participant.get(VALUE);
                            String[] channelArray = new String[]{};
                            if (StringUtils.isNotBlank((CharSequence)express)) {
                                channelArray = express.split("\\.");
                            }
                            boolean flag = false;
                            if (channelArray.length == 3 && obj.get(channelArray[1]) instanceof DynamicObjectCollection) {
                                DynamicObjectCollection entryEntityCollection2 = (DynamicObjectCollection)obj.get(channelArray[1]);
                                if (entryEntityCollection2 != null && entryEntityCollection2.getDynamicObjectType() instanceof EntryType) {
                                    for (i = 0; i < entryEntityCollection2.size(); ++i) {
                                        dynamicObject = (DynamicObject)entryEntityCollection2.get(i);
                                        DynamicObject dyObject = (DynamicObject)dynamicObject.get(channelArray[2]);
                                        if (dyObject == null) continue;
                                        userSet.add(Long.valueOf(String.valueOf(dyObject.getPkValue())));
                                    }
                                    flag = true;
                                }
                            } else if (channelArray.length == 4 && obj.get(channelArray[1]) instanceof DynamicObjectCollection && (entryEntityCollection = (DynamicObjectCollection)obj.get(channelArray[1])) != null && entryEntityCollection.getDynamicObjectType() instanceof EntryType) {
                                for (i = 0; i < entryEntityCollection.size(); ++i) {
                                    DynamicObjectCollection subEntryEntityCollection;
                                    dynamicObject = (DynamicObject)entryEntityCollection.get(i);
                                    if (dynamicObject == null || !(dynamicObject.get(channelArray[2]) instanceof DynamicObjectCollection) || (subEntryEntityCollection = (DynamicObjectCollection)dynamicObject.get(channelArray[2])) == null || !(subEntryEntityCollection.getDynamicObjectType() instanceof SubEntryType)) continue;
                                    for (int j = 0; j < subEntryEntityCollection.size(); ++j) {
                                        DynamicObject dyObject = (DynamicObject)((DynamicObject)subEntryEntityCollection.get(j)).get(channelArray[3]);
                                        if (dyObject == null) continue;
                                        userSet.add(Long.valueOf(String.valueOf(dyObject.getPkValue())));
                                    }
                                    flag = true;
                                }
                            }
                            if (flag) continue;
                            EventParticipantCalculatorUtil.entityParticipantCalculator(obj, scope, userSet, object);
                        }
                        catch (Exception e) {
                            EventParticipantCalculatorUtil.entityParticipantCalculator(obj, scope, userSet, object);
                        }
                        continue;
                    }
                    if ("event".equals(type)) {
                        String eventValue = "${" + object + ".id}";
                        DynamicObject obj = null;
                        VariableScopeImpl scope = null;
                        if (event instanceof EntityEvent) {
                            obj = EvtUtils.findBusinessObject(businesskey, entityNumber);
                            if (obj == null) {
                                log.debug(String.format("\u5355\u636eevent\u53ef\u80fd\u5df2\u88ab\u5220\u9664-%s", businesskey));
                                continue;
                            }
                            scope = new BusinessModelVariableScope(businesskey, entityNumber);
                        } else {
                            String json = edContext.getJson();
                            scope = new EventModelVariableScope(json);
                        }
                        id = ExpressionCalculatorUtil.parseValue(obj, scope, eventValue, new HashMap<String, Object>());
                        if (id instanceof String) {
                            userSet.add(Long.valueOf(String.valueOf(id)));
                            continue;
                        }
                        if (id instanceof Long) {
                            userSet.add(Long.valueOf(String.valueOf(id)));
                            continue;
                        }
                        if (id instanceof List) {
                            List idList = (List)id;
                            for (int i = 0; i < idList.size(); ++i) {
                                userSet.add((Long)idList.get(i));
                            }
                            continue;
                        }
                        if (id == null) continue;
                        userSet.add(Long.valueOf(String.valueOf(id)));
                        continue;
                    }
                    if (!"Plugin".equals(type)) continue;
                    pluginMap.putAll(participant);
                }
            }
            participantMap.put(businesskey, new LinkedList(userSet));
        }
        if (pluginMap != null && !pluginMap.isEmpty()) {
            Map<String, List<Long>> pluginCalculator = EventParticipantCalculatorUtil.pluginCalculator(pluginMap, edContext, businesskeys);
            Set set = participantMap.keySet();
            for (String s1 : set) {
                HashSet combineSet = new HashSet();
                combineSet.addAll((Collection)participantMap.get(s1));
                if (pluginCalculator != null && pluginCalculator.get(s1) != null) {
                    combineSet.addAll(pluginCalculator.get(s1));
                } else {
                    log.debug(String.format("\u63d2\u4ef6\u89e3\u6790\u53c2\u4e0e\u4eba\u4e3a\u7a7a-%s", s1));
                }
                ArrayList combineList = new ArrayList(combineSet);
                combineResult.put(s1, combineList);
            }
        } else {
            combineResult = participantMap;
        }
        return combineResult;
    }

    private static void entityParticipantCalculator(DynamicObject obj, VariableScope scope, HashSet<Long> userSet, Object object) {
        String entityValue = "${" + object + ".id}";
        Object id = null;
        try {
            id = ExpressionCalculatorUtil.parseValue(obj, scope, entityValue, new HashMap<String, Object>());
        }
        catch (Exception e) {
            throw new BECEngineException(ERRORDESCRIPTION + entityValue, e);
        }
        if (id != null) {
            if (id instanceof List) {
                List idList = (List)id;
                for (int i = 0; i < idList.size(); ++i) {
                    userSet.add((Long)idList.get(i));
                }
            } else {
                userSet.add(Long.valueOf(String.valueOf(id)));
            }
        }
    }

    private static Map<String, List<Long>> pluginCalculator(Map<String, Object> pluginMap, EventDispatchContext edContext, List<String> businesskeys) {
        HashMap<String, List<Long>> participantMap = new HashMap<String, List<Long>>();
        HashSet userSet = new HashSet();
        KDBizEvent event = edContext.getEvent();
        String pluginJson = (String)pluginMap.get("class");
        Map participantsMap = (Map)SerializationUtils.fromJsonString((String)pluginJson, Map.class);
        String appId = (String)participantsMap.get("appid");
        if (WfUtils.isEmpty(appId) && event instanceof EntityEvent) {
            String entityNumber = ((EntityEvent)event).getEntityNumber();
            MainEntityType dt = EntityMetadataCache.getDataEntityType((String)entityNumber);
            appId = dt.getAppId();
        } else if (WfUtils.isEmpty(appId)) {
            appId = "wf";
        }
        String plugin = (String)participantsMap.get("class");
        try {
            Object ids = DispatchServiceHelper.invokeBOSServiceByAppId((String)appId, (String)IEventService.class.getSimpleName(), (String)"invokeEventPlugin", (Object[])new Object[]{plugin, "calculateUserIds", new Object[]{event}});
            participantMap.putAll((Map)ids);
            return participantMap;
        }
        catch (RuntimeException e) {
            log.debug("\u901a\u8fc7\u63d2\u4ef6\u8ba1\u7b97\u4eba\u5458\u65f6,\u63d2\u4ef6\u4e2d\u6ca1\u5b9e\u73b0IEventService\u63a5\u53e3\u7684calculateUserIds\u65b9\u6cd5\u3002");
            try {
                Object ids = DispatchServiceHelper.invokeBOSServiceByAppId((String)appId, (String)IEventService.class.getSimpleName(), (String)"invokeEventPlugin", (Object[])new Object[]{plugin, "calcUserIds", new Object[]{event}});
                List idList = (List)ids;
                for (int i = 0; i < idList.size(); ++i) {
                    userSet.add(idList.get(i));
                }
                for (String businesskey : businesskeys) {
                    participantMap.put(businesskey, new ArrayList(userSet));
                }
                return participantMap;
            }
            catch (Exception e2) {
                throw new KDException((Throwable)e, WFErrorCode.bizEventError(), new Object[]{String.format(ResManager.loadKDString((String)"\u901a\u8fc7\u63d2\u4ef6\u89e3\u6790\u4eba\u5458\u5931\u8d25\uff1a%s", (String)"EventMicroServiceJobHandler_24", (String)"bos-wf-engine", (Object[])new Object[0]), e.getMessage())});
            }
        }
        catch (Exception e) {
            throw new KDException((Throwable)e, WFErrorCode.bizEventError(), new Object[]{String.format(ResManager.loadKDString((String)"\u901a\u8fc7\u63d2\u4ef6\u89e3\u6790\u4eba\u5458\u5931\u8d25\uff1a%s", (String)"EventMicroServiceJobHandler_24", (String)"bos-wf-engine", (Object[])new Object[0]), e.getMessage())});
        }
    }

    @Deprecated
    public static List<Long> participantCalculator(String returnDataList, DynamicObject obj, VariableScope scope, EventDispatchContext edContext) {
        HashSet<Long> userSet = new HashSet<Long>();
        if (!WfUtils.isEmpty(returnDataList)) {
            List participants = (List)SerializationUtils.fromJsonString((String)returnDataList, List.class);
            HashMap<String, Object> pluginMap = new HashMap<String, Object>();
            for (Map participant : participants) {
                String type = (String)participant.get("type");
                Object object = participant.get(VALUE);
                if ("person".equals(type)) {
                    String[] ids = String.valueOf(object).split(",");
                    ArrayList<Long> list = new ArrayList<Long>();
                    for (int j = 0; j < ids.length; ++j) {
                        String id = ids[j].trim();
                        if (id.isEmpty() || list.contains(Long.valueOf(id))) continue;
                        list.add(Long.valueOf(id));
                    }
                    userSet.addAll(list);
                    continue;
                }
                if ("entity".equals(type) && obj != null) {
                    try {
                        DynamicObject dynamicObject;
                        int i;
                        DynamicObjectCollection entryEntityCollection;
                        String express = (String)participant.get(VALUE);
                        String[] channelArray = new String[]{};
                        if (StringUtils.isNotBlank((CharSequence)express)) {
                            channelArray = express.split("\\.");
                        }
                        boolean flag = false;
                        if (channelArray.length == 3 && obj.get(channelArray[1]) instanceof DynamicObjectCollection) {
                            entryEntityCollection = (DynamicObjectCollection)obj.get(channelArray[1]);
                            if (entryEntityCollection != null && entryEntityCollection.getDynamicObjectType() instanceof EntryType) {
                                for (i = 0; i < entryEntityCollection.size(); ++i) {
                                    dynamicObject = (DynamicObject)entryEntityCollection.get(i);
                                    DynamicObject dyObject = (DynamicObject)dynamicObject.get(channelArray[2]);
                                    if (dyObject == null) continue;
                                    userSet.add(Long.valueOf(String.valueOf(dyObject.getPkValue())));
                                }
                                flag = true;
                            }
                        } else if (channelArray.length == 4 && obj.get(channelArray[1]) instanceof DynamicObjectCollection && (entryEntityCollection = (DynamicObjectCollection)obj.get(channelArray[1])) != null && entryEntityCollection.getDynamicObjectType() instanceof EntryType) {
                            for (i = 0; i < entryEntityCollection.size(); ++i) {
                                DynamicObjectCollection subEntryEntityCollection;
                                dynamicObject = (DynamicObject)entryEntityCollection.get(i);
                                if (dynamicObject == null || !(dynamicObject.get(channelArray[2]) instanceof DynamicObjectCollection) || (subEntryEntityCollection = (DynamicObjectCollection)dynamicObject.get(channelArray[2])) == null || !(subEntryEntityCollection.getDynamicObjectType() instanceof SubEntryType)) continue;
                                for (int j = 0; j < subEntryEntityCollection.size(); ++j) {
                                    DynamicObject dyObject = (DynamicObject)((DynamicObject)subEntryEntityCollection.get(j)).get(channelArray[3]);
                                    if (dyObject == null) continue;
                                    userSet.add(Long.valueOf(String.valueOf(dyObject.getPkValue())));
                                }
                                flag = true;
                            }
                        }
                        if (flag) continue;
                        EventParticipantCalculatorUtil.entityParticipantCalculator(obj, scope, userSet, object);
                    }
                    catch (Exception e) {
                        EventParticipantCalculatorUtil.entityParticipantCalculator(obj, scope, userSet, object);
                    }
                    continue;
                }
                if ("event".equals(type)) {
                    String eventValue = "${" + object + ".id}";
                    Object id = ExpressionCalculatorUtil.parseValue(obj, scope, eventValue, new HashMap<String, Object>());
                    if (id instanceof String) {
                        userSet.add(Long.valueOf(String.valueOf(id)));
                        continue;
                    }
                    if (id instanceof Long) {
                        userSet.add(Long.valueOf(String.valueOf(id)));
                        continue;
                    }
                    if (id instanceof List) {
                        id = ((List)id).get(0);
                        userSet.add(Long.valueOf(String.valueOf(id)));
                        continue;
                    }
                    if (id == null) continue;
                    userSet.add(Long.valueOf(String.valueOf(id)));
                    continue;
                }
                if (!"Plugin".equals(type)) continue;
                pluginMap.putAll(participant);
            }
            if (pluginMap != null && !pluginMap.isEmpty()) {
                EventParticipantCalculatorUtil.pluginCalculator(pluginMap, edContext, userSet, obj);
            }
        }
        return new ArrayList<Long>(userSet);
    }

    @Deprecated
    private static void pluginCalculator(Map<String, Object> pluginMap, EventDispatchContext edContext, HashSet<Long> userSet, DynamicObject obj) {
        KDBizEvent event = edContext.getEvent();
        if (event instanceof EntityEvent && obj != null) {
            List businesskeys = ((EntityEvent)event).getBusinesskeys();
            businesskeys.clear();
            businesskeys.add(String.valueOf(obj.getPkValue()));
            ((EntityEvent)event).setBusinesskeys(businesskeys);
        }
        String plugin = (String)pluginMap.get("class");
        Map participantsMap = (Map)SerializationUtils.fromJsonString((String)plugin, Map.class);
        String appId = (String)participantsMap.get("appid");
        plugin = (String)participantsMap.get("class");
        if (WfUtils.isEmpty(appId) && event instanceof EntityEvent) {
            String entityNumber = ((EntityEvent)event).getEntityNumber();
            MainEntityType mainEntityType = EntityMetadataCache.getDataEntityType((String)entityNumber);
        } else if (WfUtils.isEmpty(appId)) {
            appId = "wf";
        }
        Object ids = DispatchServiceHelper.invokeBOSServiceByAppId((String)appId, (String)IEventService.class.getSimpleName(), (String)"invokeEventPlugin", (Object[])new Object[]{plugin, "calcUserIds", new Object[]{event}});
        if (ids instanceof List) {
            List idList = (List)ids;
            for (int i = 0; i < idList.size(); ++i) {
                userSet.add((Long)idList.get(i));
            }
        }
    }
}

