/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.workflow.engine.impl.calculator;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.node.JsonNodeFactory;
import java.util.Map;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.workflow.bpmn.model.AutoMicroServiceTask;
import kd.bos.workflow.bpmn.model.Process;
import kd.bos.workflow.engine.WfUtils;
import kd.bos.workflow.engine.impl.bpmn.behavior.AutoMicroServiceTaskActivityBehavior;
import kd.bos.workflow.engine.impl.calculator.DefaultMacroParserImpl;
import kd.bos.workflow.engine.impl.calculator.MacroParser;
import kd.bos.workflow.engine.impl.persistence.entity.runtime.ExecutionEntity;
import kd.bos.workflow.engine.impl.util.ProcessDefinitionUtil;

public class ExecuteResultMacroParserImpl
extends DefaultMacroParserImpl
implements MacroParser {
    private Log log = LogFactory.getLog(this.getClass());

    public ExecuteResultMacroParserImpl(String macro) {
        super(macro);
    }

    @Override
    public Object parseMacro(ExecutionEntity execution) {
        Object result = execution.getVariable(this.macro);
        if (result instanceof Map) {
            try {
                Map map = (Map)result;
                Object value = map.get("value");
                String fetchType = (String)map.get("fetchType");
                if ("dynamic".equals(fetchType)) {
                    String activityId = this.macro.substring(0, this.macro.length() - "ExecuteResult".length());
                    Process process = ProcessDefinitionUtil.getProcessByProcInstId(execution.getProcessInstanceId());
                    AutoMicroServiceTask autoMicroServiceTask = (AutoMicroServiceTask)process.getFlowElement(activityId);
                    new AutoMicroServiceTaskActivityBehavior(autoMicroServiceTask).invokeService(execution);
                    map = (Map)execution.getVariable(this.macro);
                    value = map.get("value");
                }
                ObjectMapper objectMapper = new ObjectMapper();
                objectMapper.setNodeFactory(new JsonNodeFactory(true));
                objectMapper.setSerializationInclusion(JsonInclude.Include.NON_NULL);
                return objectMapper.valueToTree(value);
            }
            catch (Exception e) {
                this.log.error(WfUtils.getExceptionStacktrace(e));
            }
        }
        return result;
    }
}

