/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.workflow.engine.impl.calculator;

import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.ValueMapItem;
import kd.bos.workflow.engine.WfUtils;
import kd.bos.workflow.engine.impl.calculator.DefaultMacroParserImpl;
import kd.bos.workflow.engine.impl.calculator.MacroParser;
import kd.bos.workflow.engine.impl.cmd.precomputation.PercomputatorUtils;
import kd.bos.workflow.engine.impl.context.Context;
import kd.bos.workflow.engine.impl.persistence.entity.history.HistoricActivityInstanceEntity;
import kd.bos.workflow.engine.impl.persistence.entity.history.HistoricActivityInstanceEntityManager;
import kd.bos.workflow.engine.impl.persistence.entity.runtime.ExecutionEntity;

public class ExecutionTypeMacroParserImpl
extends DefaultMacroParserImpl
implements MacroParser {
    private Map<String, String> types = new LinkedHashMap<String, String>();

    public ExecutionTypeMacroParserImpl(String macro) {
        super(macro);
        this.types.put("byHand", ResManager.loadKDString((String)"\u4eba\u5de5", (String)"ExpressionPropUtils_15", (String)"bos-wf-engine", (Object[])new Object[0]));
        this.types.put("byAuto", ResManager.loadKDString((String)"\u81ea\u52a8", (String)"ExpressionPropUtils_16", (String)"bos-wf-engine", (Object[])new Object[0]));
        this.types.put("skip", ResManager.loadKDString((String)"\u8df3\u8fc7", (String)"ExpressionPropUtils_17", (String)"bos-wf-engine", (Object[])new Object[0]));
        this.types.put("jump", ResManager.loadKDString((String)"\u8df3\u8f6c", (String)"ExpressionPropUtils_18", (String)"bos-wf-engine", (Object[])new Object[0]));
    }

    @Override
    public Object parseMacro(ExecutionEntity execution) {
        Object result;
        String BYHAND = "";
        String activityId = this.macro.substring(0, this.macro.length() - "ExecutionType".length());
        if (execution.getTransientVariable("percomputation_ctx") != null && (result = PercomputatorUtils.getExecutionType(activityId, execution)) != null) {
            this.buildEnumText(execution, String.valueOf(result));
            return result;
        }
        HistoricActivityInstanceEntityManager hisActInstManager = Context.getProcessEngineConfiguration().getHistoricActivityInstanceEntityManager();
        List<HistoricActivityInstanceEntity> entities = hisActInstManager.findByActivityId(execution.getProcessInstanceId(), activityId);
        if (entities == null || entities.isEmpty()) {
            return null;
        }
        HistoricActivityInstanceEntity hisActInst = entities.get(0);
        String executionType = hisActInst.getExecutionType();
        String ret = executionType != null && "".equals(executionType.trim()) ? "byHand" : executionType;
        this.buildEnumText(execution, String.valueOf(ret));
        return ret;
    }

    protected void buildEnumText(ExecutionEntity execution, String key) {
        if (execution.getTransientVariable("buildEnumMarcoMark") != null) {
            execution.removeTransientVariable("buildEnumMarcoMark");
            ArrayList<ValueMapItem> items = new ArrayList<ValueMapItem>(1);
            ValueMapItem item = new ValueMapItem();
            item.setValue(key);
            String n = this.types.get(key);
            if (n == null) {
                n = "";
            }
            item.setName((LocaleString)WfUtils.getMultiLangValue(n));
            items.add(item);
            execution.setTransientVariable("enumMarcoCombos", items);
        }
    }
}

