/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.workflow.engine.impl.calculator;

import de.odysseus.el.function.collection.CollectionFunctionType;
import java.math.BigDecimal;
import java.text.Format;
import java.text.SimpleDateFormat;
import java.time.Duration;
import java.time.LocalTime;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import kd.bos.bec.engine.el.EventModelVariableScope;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.ILocaleString;
import kd.bos.dataentity.entity.OrmLocaleValue;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.metadata.IDataEntityType;
import kd.bos.dataentity.metadata.clr.DataEntityPropertyCollection;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.metadata.dynamicobject.DynamicProperty;
import kd.bos.dataentity.metadata.dynamicobject.DynamicSimpleProperty;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.BillEntityType;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.EntryType;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.format.FormatFactory;
import kd.bos.entity.format.FormatObject;
import kd.bos.entity.format.FormatTypes;
import kd.bos.entity.property.AmountProp;
import kd.bos.entity.property.DecimalProp;
import kd.bos.entity.property.EntryProp;
import kd.bos.entity.property.IRefBillField;
import kd.bos.entity.property.LongProp;
import kd.bos.entity.property.MulBasedataProp;
import kd.bos.entity.property.PriceProp;
import kd.bos.entity.property.QtyProp;
import kd.bos.entity.property.TimeProp;
import kd.bos.form.FormConfig;
import kd.bos.form.FormMetadataCache;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.user.UserServiceHelper;
import kd.bos.workflow.engine.WfUtils;
import kd.bos.workflow.engine.delegate.Expression;
import kd.bos.workflow.engine.delegate.VariableScope;
import kd.bos.workflow.engine.impl.calculator.ExpressionEntryLoopCalculatorUtil;
import kd.bos.workflow.engine.impl.calculator.ExpressionParseResult;
import kd.bos.workflow.engine.impl.calculator.MacroParser;
import kd.bos.workflow.engine.impl.cmd.startup.BusinessModelVariableScope;
import kd.bos.workflow.engine.impl.context.Context;
import kd.bos.workflow.engine.impl.interceptor.CommandContext;
import kd.bos.workflow.engine.impl.persistence.entity.runtime.ExecutionEntity;
import kd.bos.workflow.engine.impl.persistence.entity.task.TaskEntity;
import kd.bos.workflow.exception.WFErrorCode;
import kd.bos.workflow.exception.WFObjectNotFoundException;
import kd.bos.workflow.nocode.NoCodeFlowUtil;

public class ExpressionCalculatorUtil {
    private static Log logger = LogFactory.getLog(ExpressionCalculatorUtil.class);
    public static final String PROCESS_PREFIX = "PROC_";
    public static final String ENTITY_PREFIX = "ENTI_";
    public static final String ENTRY_PREFIX = "ENTRY_";
    public static final String DEFULTFORMAT = "{name}|{position}";
    public static final String POSTIONINFO = "postionInfo";
    public static final String POSITION = "position";
    public static final String MCTLINK = "model.mc_tlink";
    public static final String MCTCIRCULATIONLINK = "model.mc_tCirculationLink";
    public static final String APPTYPE = "apptype";

    public static Object getFieldValue(String entityNumber, String businessKey, String field) {
        String fieldWithoutPrefix = ExpressionCalculatorUtil.removeFieldPrefix(field);
        CommandContext commandContext = Context.getCommandContext();
        DynamicObject model = null;
        Object value = null;
        String[] fields = ExpressionCalculatorUtil.getFieldInfo(fieldWithoutPrefix, false);
        if (null != fields && fields.length > 0) {
            String fieldForBill = fields[0];
            boolean isMulBasedataProp = ExpressionCalculatorUtil.isMulBasedataProp(entityNumber, fieldForBill);
            boolean hasFomrContext = ExpressionCalculatorUtil.fromContext(entityNumber, businessKey, commandContext);
            if (hasFomrContext) {
                model = commandContext.getParsedBusinessObject();
            } else if (isMulBasedataProp) {
                model = WfUtils.findBusinessObject(businessKey, entityNumber);
            } else {
                DynamicObjectCollection models;
                MainEntityType entity = EntityMetadataCache.getDataEntityType((String)entityNumber);
                Object billId = businessKey;
                if (entity.getPrimaryKey() instanceof LongProp) {
                    billId = Long.valueOf(businessKey);
                }
                if ((models = QueryServiceHelper.query((String)"Workflow.ParticipantCalculator", (String)entityNumber, (String)fieldForBill, (QFilter[])new QFilter[]{new QFilter("id", "=", billId)}, null)) != null && models.size() > 0) {
                    model = (DynamicObject)models.get(0);
                }
            }
            if (model != null) {
                Object fieldValue;
                if (isMulBasedataProp) {
                    fieldValue = model.get(fieldForBill);
                    if (null != fieldValue && fieldValue instanceof DynamicObjectCollection) {
                        value = ExpressionCalculatorUtil.getObjIdsForMulbaseDataProp((DynamicObjectCollection)fieldValue);
                    }
                } else {
                    fieldValue = model.get(fieldForBill);
                    boolean isNoCodeBill = false;
                    boolean isRefBillField = false;
                    try {
                        FormConfig formConfig = FormMetadataCache.getFormConfig((String)entityNumber);
                        isNoCodeBill = "nocodebill".equalsIgnoreCase(formConfig.getModelType());
                        if (isNoCodeBill) {
                            MainEntityType entity = EntityMetadataCache.getDataEntityType((String)entityNumber);
                            DynamicProperty property = entity.getProperty(fieldForBill);
                            isRefBillField = property instanceof IRefBillField;
                        }
                    }
                    catch (Exception e) {
                        logger.error(WfUtils.getExceptionStacktrace(e));
                    }
                    if (null != fieldValue) {
                        if (isNoCodeBill && isRefBillField) {
                            logger.debug(String.format("isNoCodeBill: true, isRefBillField: true, entityNumber: %s, businessKey: %s, fieldValue: %s, fieldForBill: %s", entityNumber, businessKey, fieldValue, fieldForBill));
                            if (fieldValue instanceof DynamicObject) {
                                DynamicObject dynObj = (DynamicObject)fieldValue;
                                return dynObj.getLong("id");
                            }
                            if (fieldValue instanceof String) {
                                String[] ids = ((String)fieldValue).split(",");
                                ArrayList<Long> ret = new ArrayList<Long>(ids.length);
                                for (String id : ids) {
                                    ret.add(Long.valueOf(id));
                                }
                                return ret;
                            }
                        }
                        if (fieldValue instanceof DynamicObject) {
                            value = model.get(fieldForBill + "_id");
                        } else if (fieldValue instanceof Long || fieldValue instanceof String) {
                            value = fieldValue;
                        }
                        if (fields.length == 2) {
                            value = UserServiceHelper.getUserMainOrgId((long)((Long)value));
                        }
                    }
                }
            } else {
                throw new WFObjectNotFoundException(null, WFErrorCode.objectNotFoundError(), new Object[]{entityNumber, businessKey});
            }
        }
        return value;
    }

    private static boolean isMulBasedataProp(String entityNumber, String field) {
        MainEntityType mainEntiyType = EntityMetadataCache.getDataEntityType((String)entityNumber);
        if (null != mainEntiyType) {
            return mainEntiyType.getProperty(field) instanceof MulBasedataProp;
        }
        return false;
    }

    public static List<Long> getObjIdsForMulbaseDataProp(DynamicObjectCollection objCollection) {
        ArrayList<Long> objIds = new ArrayList<Long>();
        if (WfUtils.isNotEmptyForCollection((Collection)objCollection)) {
            Object objDetail = null;
            DynamicObject objDynamic = null;
            Object objId = null;
            for (DynamicObject obj : objCollection) {
                objDetail = obj.get("fbasedataid");
                if (null == objDetail || !(objDetail instanceof DynamicObject) || !WfUtils.isNotEmptyString(objId = (objDynamic = (DynamicObject)objDetail).get("id")) || !(objId instanceof Long)) continue;
                objIds.add((Long)objId);
            }
        }
        return objIds;
    }

    public static DynamicObjectCollection getEntryFieldValue(String entityNumber, String fieldWithEntryKey, String businessKey) {
        String fieldWithoutPrefix = ExpressionCalculatorUtil.removeFieldPrefix(fieldWithEntryKey);
        CommandContext ctx = Context.getCommandContext();
        DynamicObjectCollection collection = null;
        String[] fields = ExpressionCalculatorUtil.getFieldInfo(fieldWithoutPrefix, true);
        if (null != fields && fields.length > 0) {
            String fieldForBill = fields[0];
            String[] props = ExpressionCalculatorUtil.getPropsFromField(fieldForBill);
            boolean isMulBasedataPropForEntry = ExpressionCalculatorUtil.isMulBasedataPropForEntry(entityNumber, props);
            CommandContext commandContext = Context.getCommandContext();
            boolean hasFomrContext = ExpressionCalculatorUtil.fromContext(entityNumber, businessKey, commandContext);
            if (hasFomrContext) {
                DynamicObject model = ctx.getParsedBusinessObject();
                if (model != null && null != props) {
                    DynamicObjectType dt = new DynamicObjectType("PlainObject");
                    if (props.length == 2) {
                        DynamicObjectCollection entryDatas = model.getDynamicObjectCollection(props[0]);
                        if (entryDatas != null && entryDatas.size() > 0) {
                            if (collection == null) {
                                collection = ExpressionCalculatorUtil.getDynamicObjectCollectionByEntryDatas(entryDatas, dt);
                            }
                            String propField = props[1];
                            if (isMulBasedataPropForEntry) {
                                for (DynamicObject data : entryDatas) {
                                    Object fieldValue = data.get(propField);
                                    if (null == fieldValue || !(fieldValue instanceof DynamicObjectCollection)) continue;
                                    collection.addAll((Collection)((DynamicObjectCollection)fieldValue));
                                }
                            } else {
                                DynamicObject obj = null;
                                DynamicObject entryField = null;
                                for (DynamicObject data : entryDatas) {
                                    obj = new DynamicObject(dt, true);
                                    entryField = data.getDynamicObject(propField);
                                    if (null == entryField || dt.getProperties() == null || dt.getProperties().size() <= 0) continue;
                                    ((IDataEntityProperty)dt.getProperties().get(0)).setValueFast((Object)obj, entryField.getPkValue());
                                    collection.add((Object)obj);
                                }
                            }
                        }
                    } else if (props.length == 3) {
                        DynamicObjectCollection entryDatas = model.getDynamicObjectCollection(props[0]);
                        for (DynamicObject data : entryDatas) {
                            DynamicObjectCollection subEntryDatas = data.getDynamicObjectCollection(props[1]);
                            if (subEntryDatas == null || subEntryDatas.size() <= 0) continue;
                            if (collection == null) {
                                Class<?> propertyType = ((DynamicObject)subEntryDatas.get(0)).getPkValue().getClass();
                                DynamicSimpleProperty property = new DynamicSimpleProperty("id", (Class)propertyType, null);
                                dt.registerSimpleProperty(property);
                                collection = new DynamicObjectCollection(dt, null);
                            }
                            for (DynamicObject subData : subEntryDatas) {
                                DynamicObject subEntryField = subData.getDynamicObject(props[2]);
                                DynamicObject obj = new DynamicObject(dt, true);
                                if (null == subEntryField || dt.getProperties() == null || dt.getProperties().size() <= 0) continue;
                                ((IDataEntityProperty)dt.getProperties().get(0)).setValueFast((Object)obj, subEntryField.getPkValue());
                                collection.add((Object)obj);
                            }
                        }
                        if (entryDatas != null && entryDatas.size() > 0) {
                            if (collection == null) {
                                Class<?> propertyType = ((DynamicObject)entryDatas.get(0)).getPkValue().getClass();
                                DynamicSimpleProperty property = new DynamicSimpleProperty("id", (Class)propertyType, null);
                                dt.registerSimpleProperty(property);
                                collection = new DynamicObjectCollection(dt, null);
                            }
                            for (DynamicObject data : entryDatas) {
                                DynamicObject entryField = data.getDynamicObject(props[1]);
                                DynamicObject obj = new DynamicObject(dt, true);
                                if (null == entryField || dt.getProperties() == null || dt.getProperties().size() <= 0) continue;
                                ((IDataEntityProperty)dt.getProperties().get(0)).setValueFast((Object)obj, entryField.getPkValue());
                                collection.add((Object)obj);
                            }
                        }
                    }
                }
            } else if (isMulBasedataPropForEntry) {
                DynamicObject model;
                DynamicObjectCollection entryDatas;
                if (null != props && 1 < props.length && (entryDatas = (model = WfUtils.findBusinessObject(businessKey, entityNumber)).getDynamicObjectCollection(props[0])) != null && entryDatas.size() > 0) {
                    if (collection == null) {
                        DynamicObjectType dt = new DynamicObjectType("PlainObject");
                        collection = ExpressionCalculatorUtil.getDynamicObjectCollectionByEntryDatas(entryDatas, dt);
                    }
                    for (DynamicObject data : entryDatas) {
                        Object fieldValue = data.get(props[1]);
                        if (null == fieldValue || !(fieldValue instanceof DynamicObjectCollection)) continue;
                        collection.addAll((Collection)((DynamicObjectCollection)fieldValue));
                    }
                }
            } else {
                MainEntityType entity = EntityMetadataCache.getDataEntityType((String)entityNumber);
                Object billId = businessKey;
                if (entity.getPrimaryKey() instanceof LongProp) {
                    billId = Long.valueOf(businessKey);
                }
                collection = QueryServiceHelper.query((String)"Workflow.ParticipantCalculator", (String)entityNumber, (String)fieldForBill, (QFilter[])new QFilter[]{new QFilter("id", "=", billId)}, null);
            }
            if (fields.length == 2) {
                return ExpressionCalculatorUtil.getOrgIdsFromCollection(collection, entityNumber);
            }
            if (collection == null || collection.isEmpty()) {
                return null;
            }
        }
        return collection;
    }

    public static boolean isMulBasedataPropForEntry(String entityNumber, String[] props) {
        EntryType entryType;
        IDataEntityType dynamicObjectType;
        EntryProp entryProp;
        DynamicProperty dynamicProperty;
        MainEntityType mainEntiyType;
        if (null != props && props.length > 1 && null != (mainEntiyType = EntityMetadataCache.getDataEntityType((String)entityNumber)) && null != (dynamicProperty = mainEntiyType.getProperty(props[0])) && dynamicProperty instanceof EntryProp && null != (entryProp = (EntryProp)dynamicProperty) && null != (dynamicObjectType = entryProp.getItemType()) && dynamicObjectType instanceof EntryType && null != (entryType = (EntryType)dynamicObjectType)) {
            return entryType.getProperty(props[1]) instanceof MulBasedataProp;
        }
        return false;
    }

    private static DynamicObjectCollection getOrgIdsFromCollection(DynamicObjectCollection collection, String entityNumber) {
        DynamicObjectCollection orgIds = null;
        if (null != collection && collection.size() > 0) {
            orgIds = new DynamicObjectCollection();
            Object fieldValueForBilll = null;
            DynamicObject orgId = null;
            Long userId = null;
            for (DynamicObject objCol : collection) {
                fieldValueForBilll = objCol.get("id");
                if (!WfUtils.isNotEmptyString(fieldValueForBilll) || !(fieldValueForBilll instanceof Long) || !WfUtils.isNotEmpty(userId = (Long)fieldValueForBilll)) continue;
                orgId = BusinessDataServiceHelper.newDynamicObject((String)entityNumber);
                orgId.set("id", (Object)UserServiceHelper.getUserMainOrgId((long)userId));
                orgIds.add((Object)orgId);
            }
        }
        return orgIds;
    }

    private static String[] getFieldInfo(String field, boolean isBelongToEntry) {
        if (WfUtils.isNotEmpty(field)) {
            String splitChar = "entryentity.dpt";
            if (field.contains(splitChar)) {
                int fieldForUserIndex = field.indexOf(splitChar);
                String fieldForBill = field.substring(0, fieldForUserIndex - 1);
                String fieldForExtend = splitChar;
                if (isBelongToEntry) {
                    return new String[]{fieldForBill + " id ", fieldForExtend};
                }
                return new String[]{fieldForBill, fieldForExtend};
            }
            return new String[]{field};
        }
        return null;
    }

    private static DynamicObjectCollection getDynamicObjectCollectionByEntryDatas(DynamicObjectCollection entryDatas, DynamicObjectType dt) {
        Class<?> propertyType = ((DynamicObject)entryDatas.get(0)).getPkValue().getClass();
        DynamicSimpleProperty property = new DynamicSimpleProperty("id", propertyType, null);
        dt.registerSimpleProperty(property);
        return new DynamicObjectCollection(dt, null);
    }

    public static String[] getPropsFromField(String fieldWithoutPrefix) {
        if (fieldWithoutPrefix.endsWith(" id ") && (fieldWithoutPrefix = fieldWithoutPrefix.substring(0, fieldWithoutPrefix.lastIndexOf(" id "))).contains(".")) {
            return fieldWithoutPrefix.split("\\.");
        }
        return null;
    }

    public static Object getVariableValue(VariableScope variableScope, String macroName) {
        if (variableScope instanceof BusinessModelVariableScope) {
            return null;
        }
        String fieldWithoutPrefix = ExpressionCalculatorUtil.removeFieldPrefix(macroName);
        MacroParser macroParser = Context.getProcessEngineConfiguration().getMacroParser(fieldWithoutPrefix);
        return macroParser.parseMacro((ExecutionEntity)variableScope);
    }

    public static String removeFieldPrefix(String fieldWithPrefix) {
        if (fieldWithPrefix.startsWith(PROCESS_PREFIX)) {
            return fieldWithPrefix.substring(PROCESS_PREFIX.length());
        }
        if (fieldWithPrefix.startsWith(ENTITY_PREFIX)) {
            return fieldWithPrefix.substring(ENTITY_PREFIX.length());
        }
        if (fieldWithPrefix.startsWith(ENTRY_PREFIX)) {
            return fieldWithPrefix.substring(ENTRY_PREFIX.length());
        }
        return fieldWithPrefix;
    }

    public static List<String> getKeywords(String subjectDef) {
        String reg = "(?<=(?<!\\\\)\\{)(.*?)(?=(?<!\\\\)\\})";
        Matcher matcher = Pattern.compile(reg).matcher(subjectDef);
        ArrayList<String> list = new ArrayList<String>();
        while (matcher.find()) {
            list.add(matcher.group());
        }
        return list;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String contentParser(String subjectDef, String businessKey, String entityNumber, VariableScope scope, String lang, boolean userFormat) {
        String content = null;
        try {
            DynamicObject dynObj = WfUtils.findBusinessObject(businessKey, entityNumber);
            scope.setTransientVariable("lang", lang);
            content = ExpressionCalculatorUtil.contentParser(subjectDef, dynObj, scope, userFormat);
        }
        catch (Exception e) {
            logger.warn(WfUtils.getExceptionStacktrace(e));
        }
        finally {
            scope.removeTransientVariable("lang");
        }
        return content;
    }

    public static String contentParser(String subjectDef, DynamicObject dynObj, VariableScope scope, boolean userFormat) {
        return ExpressionCalculatorUtil.contentParser(subjectDef, dynObj, scope, null, userFormat);
    }

    public static String contentParser(String subjectDef, DynamicObject dynObj, VariableScope scope, Map<String, Object> param, boolean userFormat) {
        String result = null;
        result = subjectDef != null && subjectDef.startsWith("#NOCODE#") ? NoCodeFlowUtil.parseNoCodeContentExpression(subjectDef, scope, userFormat, dynObj) : ExpressionCalculatorUtil.parseContent(subjectDef, dynObj, scope, param, userFormat);
        return result;
    }

    public static ExpressionParseResult msgContentParser(String subjectDef, DynamicObject dynObj, VariableScope scope, Map<String, Object> param, boolean userFormat) {
        boolean isNoCode;
        boolean bl = isNoCode = WfUtils.isNotNullObject(subjectDef) && subjectDef.startsWith("#NOCODE#");
        if (isNoCode) {
            ExpressionParseResult expressionParseResult = new ExpressionParseResult(subjectDef, "", null);
            subjectDef = NoCodeFlowUtil.parseNoCodeContentExpression(subjectDef, scope, userFormat, dynObj);
            expressionParseResult.setParsedContent(subjectDef);
            return expressionParseResult;
        }
        subjectDef = ExpressionEntryLoopCalculatorUtil.parseLoopTableExpression(subjectDef, dynObj, ExpressionEntryLoopCalculatorUtil.getLangFromCtx(scope, param), userFormat);
        return ExpressionCalculatorUtil.calculateContent(subjectDef, dynObj, scope, param, userFormat);
    }

    private static ExpressionParseResult calculateContent(String subjectDef, DynamicObject dynObj, VariableScope scope, Map<String, Object> param, boolean userFormat) {
        String apptype;
        if (WfUtils.isEmpty(subjectDef)) {
            return new ExpressionParseResult(subjectDef, "", null);
        }
        if (dynObj == null && !(scope instanceof EventModelVariableScope)) {
            logger.debug(String.format("contentParser calc error: model object is null.[%s]", subjectDef));
            return new ExpressionParseResult(subjectDef, subjectDef, null);
        }
        String lang = (String)scope.getTransientVariable("lang");
        if (lang == null && null != param) {
            lang = (String)param.get("lang");
        }
        if (lang == null) {
            lang = RequestContext.get().getLang().toString();
        }
        if (WfUtils.isEmpty(apptype = (String)scope.getTransientVariable(APPTYPE)) && param != null && StringUtils.isNotBlank((Object)param.get(APPTYPE))) {
            apptype = (String)param.get(APPTYPE);
        }
        Long msgId = 0L;
        if (param != null && StringUtils.isNotBlank((Object)param.get("msgId"))) {
            msgId = (Long)param.get("msgId");
        }
        if (StringUtils.isBlank((Object)scope.getTransientVariable("isfrommsg")) || !((Boolean)scope.getTransientVariable("isfrommsg")).booleanValue()) {
            subjectDef = ExpressionCalculatorUtil.parserEntryExpression(subjectDef, dynObj, scope, param, userFormat);
        }
        List<String> keys = ExpressionCalculatorUtil.getKeywords(subjectDef);
        ArrayList<Map<String, String>> variables = new ArrayList<Map<String, String>>(keys.size());
        ExpressionParseResult expressionParseResult = new ExpressionParseResult(subjectDef, "", variables);
        for (String key : keys) {
            String value = "";
            try {
                boolean isModelProp = false;
                try {
                    if (dynObj != null && dynObj.get(key) != null) {
                        isModelProp = true;
                    }
                }
                catch (Exception e) {
                    logger.debug(e.getMessage());
                }
                if (("subject".equals(key) || "model.subject".equals(key)) && scope instanceof TaskEntity && param != null && StringUtils.isNotBlank((Object)param.get("parsesubject"))) {
                    value = (String)param.get("parsesubject");
                } else if (key != null && !isModelProp) {
                    String valueItem;
                    String express = "${" + key.trim() + "}";
                    ArrayList<String> val = ExpressionCalculatorUtil.parseValue(dynObj, scope, express, param, userFormat);
                    logger.debug(String.format("\u83b7\u53d6[%s]\u7684\u89e3\u6790\u7ed3\u679c\u4e3a[%s]", express, val));
                    if (val instanceof Collection) {
                        ArrayList<String> distinctVal = new ArrayList<String>();
                        for (Object v : (Collection)val) {
                            if (v == null) continue;
                            String tempValue = v.toString();
                            if (v instanceof OrmLocaleValue) {
                                tempValue = "commonlang".equalsIgnoreCase(lang) ? ((OrmLocaleValue)v).getDefaultItem() : ((OrmLocaleValue)v).getItem(lang);
                            } else if (v instanceof DynamicObject && ((DynamicObject)v).getDataEntityType() != null && "t_bd_flexauxpropdata".equals(((DynamicObject)v).getDataEntityType().getAlias())) {
                                Object flexFieldValue = ExpressionCalculatorUtil.getFlexFieldValue(v);
                                String string = tempValue = flexFieldValue == null ? "" : flexFieldValue.toString();
                            }
                            if (distinctVal.contains(tempValue) || !WfUtils.isNotEmpty(tempValue)) continue;
                            distinctVal.add(tempValue);
                        }
                        val = distinctVal;
                        if (((Collection)val).isEmpty()) {
                            val = "";
                        }
                    } else if (val instanceof OrmLocaleValue) {
                        val = "commonlang".equalsIgnoreCase(lang) ? ((OrmLocaleValue)val).getDefaultItem() : (WfUtils.isEmpty(valueItem = ((OrmLocaleValue)val).getItem(lang)) ? ((OrmLocaleValue)val).getDefaultItem() : valueItem);
                    } else if (val instanceof ILocaleString) {
                        val = "commonlang".equalsIgnoreCase(lang) ? ((ILocaleString)val).getDefaultItem() : (WfUtils.isEmpty(valueItem = (String)((ILocaleString)val).getItem(lang)) ? ((ILocaleString)val).toString() : valueItem);
                    } else if (val instanceof DynamicObject && ((DynamicObject)val).getDataEntityType() != null && "t_bd_flexauxpropdata".equals(((DynamicObject)val).getDataEntityType().getAlias())) {
                        val = ExpressionCalculatorUtil.getFlexFieldValue(val);
                    }
                    String string = value = val == null ? "" : ((Object)val).toString();
                    if (value.length() > 1 && value.startsWith("[") && value.endsWith("]")) {
                        value = value.substring(1, value.length() - 1);
                    }
                } else {
                    Object tmp = null;
                    if (dynObj != null) {
                        tmp = dynObj.get(key);
                    }
                    if (tmp instanceof BigDecimal || tmp instanceof Integer || tmp instanceof Long) {
                        tmp = ExpressionCalculatorUtil.numberOrCurrencyFormatIncludeEntryType(dynObj, key, tmp, userFormat);
                    } else if (tmp instanceof Date) {
                        tmp = ExpressionCalculatorUtil.formatSubDate(tmp);
                    } else if (tmp instanceof ILocaleString) {
                        tmp = "commonlang".equalsIgnoreCase(lang) ? ((ILocaleString)tmp).getDefaultItem() : ((ILocaleString)tmp).getItem(lang);
                    } else if (tmp instanceof DynamicObject && ((DynamicObject)tmp).getDataEntityType() != null && "t_bd_flexauxpropdata".equals(((DynamicObject)tmp).getDataEntityType().getAlias())) {
                        tmp = ExpressionCalculatorUtil.getFlexFieldValue(tmp);
                    }
                    value = String.valueOf(tmp == null ? "" : tmp);
                }
                if ((MCTLINK.equalsIgnoreCase(key) || MCTCIRCULATIONLINK.equalsIgnoreCase(key)) && WfUtils.isNotEmpty(apptype) && WfUtils.isNotEmpty(value)) {
                    String str = String.format("&apptype=%s", apptype);
                    if (WfUtils.isNotEmpty(msgId)) {
                        str = String.format("&msgId=%s%s", msgId, str);
                    }
                    value = String.format("%s%s ", value, str);
                }
            }
            catch (Exception e) {
                logger.warn("subjectParser key[" + key + "] error:" + WfUtils.getExceptionStacktrace(e));
            }
            subjectDef = subjectDef.replace("{" + key + "}", value);
            HashMap<String, String> kv = new HashMap<String, String>(2);
            kv.put("key", key);
            kv.put("value", value);
            variables.add(kv);
        }
        expressionParseResult.setParsedContent(subjectDef);
        return expressionParseResult;
    }

    public static String parseContent(String subjectDef, DynamicObject dynObj, VariableScope scope, Map<String, Object> param, boolean userFormat) {
        ExpressionParseResult expressionParseResult = ExpressionCalculatorUtil.calculateContent(subjectDef, dynObj, scope, param, userFormat);
        return expressionParseResult.getParsedContent();
    }

    public static Object getFlexFieldValue(Object fieldValue) {
        String flexFieldvalue = ((DynamicObject)fieldValue).getString("value");
        if (flexFieldvalue == null) {
            return null;
        }
        StringBuilder sb = new StringBuilder();
        logger.debug("flexField:" + fieldValue);
        Map map = (Map)SerializationUtils.fromJsonString((String)flexFieldvalue, Map.class);
        QFilter qFilter = new QFilter("flexfield", "in", map.keySet());
        Map auxObjects = BusinessDataServiceHelper.loadFromCache((String)"bd_auxproperty", (QFilter[])new QFilter[]{qFilter});
        for (Map.Entry entry : auxObjects.entrySet()) {
            DynamicObject valuesource;
            DynamicObject valueSourceObject;
            Object key = entry.getKey();
            DynamicObject auxObject = (DynamicObject)entry.getValue();
            String flexfield = auxObject.getString("flexfield");
            String valueType = auxObject.getString("valuetype");
            String flexName = auxObject.getString("name");
            Object flexValue = null;
            if ("1".equals(valueType)) {
                valueSourceObject = auxObject.getDynamicObject("valuesource");
                valuesource = BusinessDataServiceHelper.loadSingleFromCache(map.get(flexfield), (String)valueSourceObject.getString("number"));
                flexValue = valuesource.get("name");
            } else if ("2".equals(valueType)) {
                valueSourceObject = auxObject.getDynamicObject("valuesource");
                valuesource = BusinessDataServiceHelper.loadSingleFromCache(map.get(flexfield), (String)"bos_assistantdata_detail");
                flexValue = valuesource.get("name");
            } else if ("3".equals(valueType)) {
                flexValue = map.get(flexfield);
            }
            sb.append(flexName).append(":").append(flexValue == null ? "" : flexValue.toString()).append(";");
        }
        return sb.toString().endsWith(";") ? sb.toString().substring(0, sb.toString().length() - 1) : sb.toString();
    }

    public static Object numberOrCurrencyFormat(DynamicObject dynObj, String key, Object value) {
        IDataEntityProperty property;
        DataEntityPropertyCollection properties = dynObj.getDynamicObjectType().getProperties();
        if (properties != null && !properties.isEmpty() && (property = (IDataEntityProperty)properties.get((Object)key)) != null) {
            value = property instanceof AmountProp ? ExpressionCalculatorUtil.currencyFormat(dynObj, key, value, property) : WfUtils.numberOrCurrencyFormat(value, FormatTypes.Number, null);
        }
        return value;
    }

    private static Object currencyFormat(DynamicObject dynObj, String key, Object value, IDataEntityProperty property) {
        try {
            DynamicObject currency;
            String propertyName = ((AmountProp)property).getControlPropName();
            value = !WfUtils.isEmpty(propertyName) ? ((currency = (DynamicObject)dynObj.get(propertyName)) != null ? WfUtils.numberOrCurrencyFormat(value, FormatTypes.Currency, currency) : WfUtils.numberOrCurrencyFormat(value, FormatTypes.Currency, null)) : WfUtils.numberOrCurrencyFormat(value, FormatTypes.Currency, null);
        }
        catch (Exception e) {
            logger.warn("currency format key[" + key + "] error:" + e.getMessage());
            return String.format("%.2f", value);
        }
        return value;
    }

    public static Object numberOrCurrencyFormatIncludeEntryType(DynamicObject dynObj, String key, Object value, boolean userFormat) {
        IDataEntityProperty property;
        if (!userFormat && (value instanceof Integer || value instanceof Long)) {
            return value;
        }
        DataEntityPropertyCollection properties = dynObj.getDynamicObjectType().getProperties();
        if (properties != null && !properties.isEmpty() && (property = (IDataEntityProperty)properties.get((Object)key)) != null) {
            if (property instanceof AmountProp) {
                try {
                    DynamicObject currency;
                    block16: {
                        String proName = ((AmountProp)property).getControlPropName();
                        currency = null;
                        try {
                            currency = (DynamicObject)dynObj.get(proName);
                        }
                        catch (Exception e) {
                            if (!"currency".equals(proName) || !(dynObj.getDataEntityType() instanceof EntryType)) break block16;
                            dynObj = ExpressionCalculatorUtil.getBillEntityByEntry(dynObj);
                            currency = (DynamicObject)dynObj.get(proName);
                        }
                    }
                    if (currency != null) {
                        Integer scale = (Integer)currency.get("amtprecision");
                        if (property instanceof PriceProp) {
                            scale = (Integer)currency.get("priceprecision");
                        }
                        if (userFormat) {
                            value = ExpressionCalculatorUtil.numberOrCurrencyFormat(value, FormatTypes.Currency, currency, scale);
                        }
                        value = ExpressionCalculatorUtil.formatNumByScale((BigDecimal)value, scale);
                    }
                    if (userFormat) {
                        value = ExpressionCalculatorUtil.numberOrCurrencyFormat(value, FormatTypes.Currency, null, ((AmountProp)property).getScale());
                    }
                    value = ExpressionCalculatorUtil.formatNumByScale((BigDecimal)value, ((AmountProp)property).getScale());
                }
                catch (Exception e) {
                    logger.warn("currency format key[" + key + "] error:" + WfUtils.getExceptionStacktrace(e));
                    return value;
                }
            } else if (property instanceof QtyProp) {
                String proName = ((QtyProp)property).getControlPropName();
                DynamicObject measureunit = (DynamicObject)dynObj.get(proName);
                int scale = (Integer)measureunit.get("precision");
                value = userFormat ? ExpressionCalculatorUtil.numberOrCurrencyFormat(value, FormatTypes.Number, null, scale) : ExpressionCalculatorUtil.formatNumByScale((BigDecimal)value, scale);
            } else if (property instanceof TimeProp) {
                String proName = property.getName();
                value = ExpressionCalculatorUtil.formatSubTime(dynObj.get(proName));
            } else {
                int scale = ((DecimalProp)property).getScale();
                value = userFormat ? ExpressionCalculatorUtil.numberOrCurrencyFormat(value, FormatTypes.Number, null, scale) : ExpressionCalculatorUtil.formatNumByScale((BigDecimal)value, scale);
            }
        }
        return value;
    }

    public static Object numberOrCurrencyFormat(Object object, FormatTypes type, DynamicObject currency, int scale) {
        if (object == null) {
            return null;
        }
        if (scale == 10) {
            scale = 2;
        }
        FormatObject formatObject = FormatFactory.getFormat((Long)WfUtils.getCurrentUser());
        if (FormatTypes.Number == type) {
            formatObject.getNumberFormat().setMinimumFractionDigits(scale);
        } else if (FormatTypes.Currency == type && currency != null) {
            String currencySymbols;
            String currencyNumber = (String)currency.get("number");
            if (WfUtils.isNotEmpty(currencyNumber)) {
                formatObject.getCurrencyFormat().setCurrencyNumber(currencyNumber);
            }
            if (WfUtils.isNotEmpty(currencySymbols = (String)currency.get("sign"))) {
                formatObject.getCurrencyFormat().setCurrencySymbols(currencySymbols);
            }
            formatObject.getCurrencyFormat().setMinimumFractionDigits(scale);
        }
        Format format = FormatFactory.get((FormatTypes)type).getFormat(formatObject);
        return format == null ? null : format.format(object);
    }

    private static DynamicObject getBillEntityByEntry(DynamicObject obj) {
        if (obj.getDataEntityType() instanceof BillEntityType) {
            return obj;
        }
        if (obj.getDataEntityType() instanceof EntryType) {
            return ExpressionCalculatorUtil.getBillEntityByEntry((DynamicObject)obj.getParent());
        }
        return obj;
    }

    private static String parserEntryExpression(String subjectDef, DynamicObject dynObj, VariableScope scope, Map<String, Object> param, boolean userFormat) {
        Pattern pattern = Pattern.compile("@(.+?)@");
        Matcher matcher = pattern.matcher(subjectDef);
        Pattern pattern1 = Pattern.compile("\\{(.+?)\\}");
        while (matcher.find()) {
            String entrySubject = matcher.group(1);
            try {
                ArrayList<String> entryExpressions = new ArrayList<String>();
                Matcher matcher1 = pattern1.matcher(entrySubject);
                while (matcher1.find()) {
                    entryExpressions.add(matcher1.group(1));
                }
                String[] paths = ((String)entryExpressions.get(0)).split("\\.");
                boolean findNotPath = true;
                int i = 1;
                String entryPath = "model";
                while (i < paths.length && findNotPath) {
                    String path = entryPath + "." + paths[i] + ".";
                    for (int j = 1; j < entryExpressions.size(); ++j) {
                        if (((String)entryExpressions.get(j)).contains(path)) continue;
                        findNotPath = false;
                        break;
                    }
                    if (!findNotPath) continue;
                    entryPath = path.substring(0, path.length() - 1);
                    ++i;
                }
                String entryExpression = "${" + entryPath + "}";
                Object entryVal = ExpressionCalculatorUtil.parseValue(dynObj, scope, entryExpression, param);
                String entrySubjectVal = entrySubject;
                if (entryVal instanceof DynamicObjectCollection && !((DynamicObjectCollection)entryVal).isEmpty()) {
                    DynamicObjectCollection entryObjs = (DynamicObjectCollection)entryVal;
                    StringBuilder entrySubjectValSB = new StringBuilder();
                    for (int k = 0; k < entryObjs.size(); ++k) {
                        String template = entrySubject;
                        for (String expression : entryExpressions) {
                            String newExpression = "${" + expression.replace(entryPath, "model") + "}";
                            Object val = ExpressionCalculatorUtil.parseValue((DynamicObject)entryObjs.get(k), scope, newExpression, param, userFormat);
                            if (val instanceof BigDecimal) {
                                val = String.format("%.2f", (BigDecimal)val);
                            }
                            template = template.replace("{" + expression + "}", val == null ? "" : val.toString());
                        }
                        if (k == entryObjs.size() - 1) {
                            entrySubjectValSB.append(template);
                            continue;
                        }
                        entrySubjectValSB.append(template).append("\uff0c");
                    }
                    entrySubjectVal = entrySubjectValSB.toString();
                }
                subjectDef = subjectDef.replace("@" + entrySubject + "@", entrySubjectVal);
            }
            catch (Exception e) {
                subjectDef = subjectDef.replace("@" + entrySubject + "@", "");
                logger.warn("parserEntryExpression:" + WfUtils.getExceptionStacktrace(e));
            }
        }
        return subjectDef;
    }

    public static Object parseValue(DynamicObject dynObj, VariableScope scope, String express, Map<String, Object> param, boolean userFormat) {
        if (express.startsWith("${event.")) {
            return ExpressionCalculatorUtil.parseValue(dynObj, scope, express, param);
        }
        if (express.startsWith("${") && express.endsWith("}")) {
            express = ExpressionCalculatorUtil.isNotContainCountFunction(express = express.substring(2, express.length() - 1)) ? (userFormat ? "${amountdateformat(" + express + ")}" : "${standardformat(" + express + ")}") : "${" + express + "}";
        }
        return ExpressionCalculatorUtil.parseValue(dynObj, scope, express, param);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Object parseValue(DynamicObject dynObj, VariableScope scope, String express, Map<String, Object> param) {
        Expression expression = Context.getProcessEngineConfiguration().getExpressionManager().createExpression(express);
        try {
            Object val;
            if (dynObj != null) {
                scope.setTransientVariable("model", dynObj);
            }
            if (param != null) {
                scope.setTransientVariables(param);
            }
            Object object = val = expression.getValue(scope);
            return object;
        }
        finally {
            scope.removeTransientVariable("model");
            if (param != null) {
                Iterator<String> iter = param.keySet().iterator();
                while (iter.hasNext()) {
                    scope.removeTransientVariable(iter.next());
                }
            }
        }
    }

    public static Object parseValue(String businessKey, String entityNumber, String express) {
        BusinessModelVariableScope scop = new BusinessModelVariableScope(businessKey, entityNumber);
        return ExpressionCalculatorUtil.parseValue(null, scop, express, null, false);
    }

    public static Object formatSubDate(Object tmp) {
        if (!(tmp instanceof CharSequence)) {
            SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd");
            tmp = sdf.format(tmp);
        }
        return tmp;
    }

    private static Object formatSubTime(Object tmp) {
        if (!(tmp instanceof CharSequence)) {
            if (WfUtils.isNullObject(tmp)) {
                tmp = 0;
            }
            Duration duration = Duration.ofSeconds(((Integer)tmp).intValue());
            LocalTime time = LocalTime.MIDNIGHT.plus(duration);
            DateTimeFormatter formatter = DateTimeFormatter.ofPattern("HH:mm:ss");
            return time.format(formatter);
        }
        return tmp;
    }

    private static Object formatNumByScale(BigDecimal value, int scale) {
        if (scale == 10) {
            scale = 2;
        }
        StringBuilder sb = new StringBuilder();
        sb.append("%.").append(scale).append("f");
        return String.format(sb.toString(), value);
    }

    public static boolean fromContext(String entityNumber, String pk, CommandContext commandContext) {
        if (commandContext == null || commandContext.getParsedBusinessObject() == null || commandContext.getParsedBusinessObject().getDataEntityType() == null) {
            return false;
        }
        if (!commandContext.getParsedBusinessObject().getDataEntityType().getName().equalsIgnoreCase(entityNumber)) {
            return false;
        }
        Object tPk = commandContext.getParsedBusinessObject().getPkValue();
        if (tPk instanceof Long) {
            return WfUtils.isEmpty((Long)tPk) || tPk.toString().equals(pk);
        }
        if (tPk instanceof String) {
            return WfUtils.isEmpty((String)tPk) || "0".equals(tPk) || tPk.toString().equals(pk);
        }
        return true;
    }

    @Deprecated
    public static Object getParticipantDisplayValue(DynamicObject user, VariableScope execution, String lang, String displayInfo, String entityNumber, String businessKey) {
        return null;
    }

    @Deprecated
    public static Object getParticipantDisplayValue(DynamicObject user, VariableScope execution, String lang, String displayInfo, String entityNumber, String businessKey, boolean isDisplaySetting) {
        return null;
    }

    @Deprecated
    public static Object parseParticipantDisplayValue(DynamicObject user, String express, VariableScope execution, String lang, Boolean isHandle, String entityNumber, String businessKey) {
        return express;
    }

    @Deprecated
    protected static String getMainDpt(String lang, Long userId) {
        return "";
    }

    @Deprecated
    protected static String removeUselessLine(String express, Boolean isHandle) {
        return express;
    }

    @Deprecated
    protected static Map<String, String> getUserPresentJob(Long userId, String entityNumber, CommandContext commandContext, String businessKey, String lang) {
        return new HashMap<String, String>();
    }

    @Deprecated
    protected static Map<String, String> getPositionByBillSubject(String entityNumber, String businessKey, Long userId, String lang) {
        return new HashMap<String, String>();
    }

    @Deprecated
    public static List<Long> getOrgIdList(List<Long> userDptIds) {
        return new ArrayList<Long>();
    }

    @Deprecated
    public static List<Long> getReferOrgAllSubordinateOrgs(String entityNumber, String businessKey) {
        return new ArrayList<Long>();
    }

    @Deprecated
    public static Map<String, String> getUserPositionInfo(Long userId, List<Long> userDptIds, Map<Long, Map<String, Object>> dptIdAndValueMap, String lang) {
        return new HashMap<String, String>();
    }

    private static boolean isNotContainCountFunction(String express) {
        if (StringUtils.isNotBlank((CharSequence)express) && express.contains("(") && express.endsWith(")")) {
            String[] functions = express.split("\\(");
            for (int i = 0; i < functions.length - 1; ++i) {
                if (!CollectionFunctionType.COUNT.getNumber().equals(functions[i])) continue;
                return false;
            }
        }
        return true;
    }
}

