/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.workflow.engine.impl.calculator;

import com.google.common.collect.ImmutableSet;
import java.math.BigDecimal;
import java.sql.Timestamp;
import java.text.SimpleDateFormat;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.ILocaleString;
import kd.bos.dataentity.entity.OrmLocaleValue;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.metadata.IDataEntityType;
import kd.bos.dataentity.metadata.clr.DataEntityPropertyCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.property.DateTimeProp;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.servicehelper.TimeServiceHelper;
import kd.bos.util.Pair;
import kd.bos.workflow.engine.WfUtils;
import kd.bos.workflow.engine.delegate.VariableScope;
import kd.bos.workflow.engine.impl.calculator.ExpressionCalculatorUtil;
import kd.bos.workflow.engine.impl.calculator.TableAttrText;
import org.jsoup.Jsoup;
import org.jsoup.nodes.Document;
import org.jsoup.nodes.Element;
import org.jsoup.nodes.Node;
import org.jsoup.select.Elements;

public class ExpressionEntryLoopCalculatorUtil {
    private static Log logger = LogFactory.getLog(ExpressionEntryLoopCalculatorUtil.class);
    public static final String T_BD_FLEX_AUX_PROP_DATA = "t_bd_flexauxpropdata";
    public static final String STYLE = "style";
    public static final String TBODY = "tbody";
    public static final String TR = "tr";
    public static final String TD = "td";
    public static final String ENTRY_NAME_ERR = "%1$s entryentity  is not in metadata %2$s";
    public static final String FIELD_NAME_ERR = "%1$s field is not in metadata %2$s";
    public static final String LOOP_REG = "(?<=(loop:(?<!\\\\))\\{\\()(.*?)(?=(?<!\\\\)\\)\\})";
    public static final String LOOP_PREF = "loop:{(";
    public static final String LOOP_SUFF = ")}";
    public static final String SEQ_COL_STYLE = "width: 3%";
    public static final String COMMON_LANG = "commonlang";
    public static final Set<Class<? extends Number>> FMT_TYPE_CLZ = ImmutableSet.of(Integer.class, Long.class, BigDecimal.class);

    protected static String parseLoopTableExpression(String subjectDef, DynamicObject dynObj, String lang, boolean userFormat) {
        Document document;
        if (WfUtils.isEmpty(subjectDef)) {
            return "";
        }
        try {
            document = Jsoup.parse((String)subjectDef);
        }
        catch (Exception e) {
            logger.error("Jsoup.parse error, subjectDef:" + subjectDef + ", stack:" + WfUtils.getExceptionStacktrace(e));
            return subjectDef;
        }
        Elements table = document.select(TBODY);
        if (WfUtils.isEmptyForCollection((Collection)table)) {
            return subjectDef;
        }
        boolean isSeq = Boolean.TRUE;
        int entryMax = 100;
        for (Element tb : table) {
            TableAttrText attrText = ExpressionEntryLoopCalculatorUtil.calculateTable(tb.select(TR), isSeq);
            DynamicObjectCollection dynObjConcrete = ExpressionEntryLoopCalculatorUtil.checkEntryIsLegal(dynObj, attrText.getEntry());
            if (Objects.isNull(dynObjConcrete) || dynObjConcrete.isEmpty()) continue;
            ExpressionEntryLoopCalculatorUtil.calculateTrRes(attrText, entryMax, dynObjConcrete, isSeq, lang, userFormat, dynObj.getDataEntityType().getName());
        }
        return document.toString();
    }

    public static String getEntryKeyword(String subjectDef) {
        Matcher matcher = Pattern.compile(LOOP_REG).matcher(subjectDef);
        if (matcher.find()) {
            return matcher.group();
        }
        return "";
    }

    protected static String getLangFromCtx(VariableScope scope, Map<String, Object> param) {
        StringBuilder sb = new StringBuilder();
        String lang = (String)scope.getTransientVariable("lang");
        sb.append("scope lang value\uff1a").append(lang);
        if (Objects.isNull(lang) && Objects.nonNull(param)) {
            lang = (String)param.get("lang");
            sb.append(";param lang value\uff1a").append(lang);
        }
        if (Objects.isNull(lang)) {
            lang = RequestContext.get().getLang().toString();
            sb.append(";ctx default lang value\uff1a").append(lang);
        }
        logger.debug(sb.toString());
        return lang;
    }

    private static TableAttrText calculateTable(Elements trs, boolean isNotSeq) {
        TableAttrText attrText = new TableAttrText(trs.size(), isNotSeq);
        Elements blankSeq = attrText.getBlankSeq();
        for (Element tr : trs) {
            boolean isFirst = WfUtils.isEmpty(attrText.getEntry());
            if (WfUtils.isNotEmpty(ExpressionEntryLoopCalculatorUtil.getEntryKeyword(tr.text())) && isFirst) {
                ExpressionEntryLoopCalculatorUtil.calculateTd(attrText, tr);
                attrText.setTrToDel(tr);
                continue;
            }
            if (attrText.isNotSeq() && isFirst) {
                attrText.setTrToPrepEnd(tr);
                attrText.setNotSeq(Boolean.FALSE);
                continue;
            }
            if (!isNotSeq) continue;
            blankSeq.add((Object)tr);
        }
        return attrText;
    }

    private static void calculateTd(TableAttrText attrText, Element tr) {
        List<Pair<String, Element>> keys = attrText.getKeys();
        for (Element td : tr.select(TD)) {
            String[] split;
            if (WfUtils.isEmpty(attrText.getEntry()) && (split = StringUtils.split((String)ExpressionEntryLoopCalculatorUtil.getEntryKeyword(tr.text()), (String)".", (int)3)).length > 1) {
                attrText.setEntry(split[1]);
            }
            keys.add((Pair<String, Element>)new Pair((Object)td.text(), (Object)td));
        }
    }

    private static DynamicObjectCollection checkEntryIsLegal(DynamicObject dynObj, String entry) {
        Object dynObjC;
        if (WfUtils.isEmpty(entry)) {
            return null;
        }
        try {
            dynObjC = dynObj.get(entry);
        }
        catch (Exception e) {
            logger.error(String.format(ENTRY_NAME_ERR, entry, dynObj.getDataEntityType().getName()));
            return null;
        }
        if (!(dynObjC instanceof DynamicObjectCollection)) {
            return null;
        }
        return (DynamicObjectCollection)dynObjC;
    }

    private static void calculateTrRes(TableAttrText attrText, int entryMax, DynamicObjectCollection dynObjConcrete, boolean isSeq, String lang, boolean userFormat, String entityName) {
        Elements blankSeq;
        Element trToDel = attrText.getTrToDel();
        Element trToPrepEnd = attrText.getTrToPrepEnd();
        if (WfUtils.isNotNullObject(trToPrepEnd)) {
            ILocaleString localeString = ExpressionEntryLoopCalculatorUtil.getSeqText();
            logger.debug("\u5e8f\u53f7\uff1a" + WfUtils.mapToString(localeString));
            String seqTitle = (String)localeString.getOrDefault((Object)lang, (Object)localeString.getLocaleValue());
            trToPrepEnd.prepend(ExpressionEntryLoopCalculatorUtil.buildSeqTD(seqTitle).toString());
        }
        trToPrepEnd = trToDel;
        for (int i = 0; i < Math.min(entryMax, dynObjConcrete.size()); ++i) {
            Element tempTr = new Element(TR);
            if (isSeq) {
                tempTr.appendChild((Node)ExpressionEntryLoopCalculatorUtil.buildSeqTD(String.valueOf(i + 1)));
            }
            ExpressionEntryLoopCalculatorUtil.calculateTdRes(dynObjConcrete, attrText.getKeys(), lang, userFormat, entityName, i, tempTr);
            trToPrepEnd.after((Node)tempTr);
            trToPrepEnd = tempTr;
        }
        if (WfUtils.isNotNullObject(trToDel)) {
            trToDel.remove();
        }
        if (WfUtils.isNotEmptyForCollection((Collection)(blankSeq = attrText.getBlankSeq()))) {
            blankSeq.forEach(tr -> tr.prepend(ExpressionEntryLoopCalculatorUtil.buildSeqTD("").toString()));
        }
    }

    private static Element buildSeqTD(String text) {
        Element tempNumTd = new Element(TD);
        tempNumTd.attr(STYLE, SEQ_COL_STYLE);
        if (WfUtils.isNotEmpty(text)) {
            tempNumTd.text(text);
        }
        return tempNumTd;
    }

    private static void calculateTdRes(DynamicObjectCollection dynObjConcrete, List<Pair<String, Element>> keys, String lang, boolean userFormat, String entityName, int i, Element tempTr) {
        for (Pair<String, Element> en : keys) {
            String entryKeyword = ExpressionEntryLoopCalculatorUtil.getEntryKeyword((String)en.getKey());
            if (WfUtils.isNotEmpty(entryKeyword)) {
                String[] split = StringUtils.split((String)entryKeyword, (String)".", (int)3);
                Object v = "";
                if (split.length > 1) {
                    String substring = entryKeyword.substring(split[0].length() + split[1].length() + 2);
                    try {
                        DynamicObject dynamicObject = (DynamicObject)dynObjConcrete.get(i);
                        v = ExpressionEntryLoopCalculatorUtil.getMulTypeVal(dynamicObject, substring, lang, userFormat);
                        if (WfUtils.isNotNullObject(v)) {
                            v = v.toString();
                        }
                    }
                    catch (Exception ormDE) {
                        logger.error(String.format(FIELD_NAME_ERR, substring, entityName));
                    }
                }
                tempTr.append(((Element)en.getValue()).toString().replace(LOOP_PREF + entryKeyword + LOOP_SUFF, v.toString()));
                continue;
            }
            tempTr.append(((Element)en.getValue()).toString());
        }
    }

    private static Object getMulTypeVal(DynamicObject dynObj, String key, String lang, boolean userFormat) {
        IDataEntityType dataEntityType;
        Object v = dynObj.get(key);
        if (WfUtils.isNullObject(v)) {
            return "";
        }
        if (Objects.equals(ILocaleString.class, v.getClass())) {
            v = ExpressionEntryLoopCalculatorUtil.getMulLangVal(v, lang, ILocaleString.class);
        } else if (Objects.equals(OrmLocaleValue.class, v.getClass())) {
            v = ExpressionEntryLoopCalculatorUtil.getMulLangVal(v, lang, OrmLocaleValue.class);
        } else if (FMT_TYPE_CLZ.contains(v.getClass())) {
            v = ExpressionCalculatorUtil.numberOrCurrencyFormatIncludeEntryType(dynObj, key, v, userFormat);
        } else if (Objects.equals(Date.class, v.getClass())) {
            v = ExpressionCalculatorUtil.formatSubDate(v);
        } else if (Objects.equals(Timestamp.class, v.getClass())) {
            DataEntityPropertyCollection properties = dynObj.getDynamicObjectType().getProperties();
            if (properties != null && !properties.isEmpty()) {
                IDataEntityProperty property = (IDataEntityProperty)properties.get((Object)key);
                v = Objects.equals(property.getClass(), DateTimeProp.class) ? ExpressionEntryLoopCalculatorUtil.formatSubTimeStamp(v) : ExpressionCalculatorUtil.formatSubDate(v);
            }
        } else if (Objects.equals(DynamicObject.class, v.getClass()) && WfUtils.isNotNullObject(dataEntityType = ((DynamicObject)v).getDataEntityType()) && Objects.equals(T_BD_FLEX_AUX_PROP_DATA, dataEntityType.getAlias())) {
            v = ExpressionCalculatorUtil.getFlexFieldValue(v);
        }
        if (Objects.isNull(v)) {
            return "";
        }
        String str = v.toString();
        if (str.length() > 1 && str.startsWith("[") && str.endsWith("]")) {
            str = str.substring(1, str.length() - 1);
        }
        if (str.startsWith(",")) {
            str = str.substring(1);
        }
        if (str.endsWith(",")) {
            str = str.substring(0, str.length() - 1);
        }
        return str;
    }

    private static Object getMulLangVal(Object v, String lang, Class<? extends ILocaleString> type) {
        String valueItem;
        ILocaleString cast = type.cast(v);
        v = COMMON_LANG.equalsIgnoreCase(lang) ? cast.getDefaultItem() : (WfUtils.isNullObject(valueItem = (String)cast.getItem(lang)) ? cast.toString() : valueItem);
        return v;
    }

    private static ILocaleString getSeqText() {
        return ResManager.getLocaleString((String)"\u5e8f\u53f7", (String)"ExpressionEntryLoopCalculatorUtil_1", (String)"bos-wf-engine");
    }

    private static Object formatSubTimeStamp(Object tmp) {
        if (!(tmp instanceof CharSequence)) {
            SimpleDateFormat sdf = new SimpleDateFormat(TimeServiceHelper.getDateTimeFormatString());
            if (WfUtils.isNullObject(tmp)) {
                tmp = 0;
            }
            tmp = sdf.format(tmp);
        }
        return tmp;
    }
}

