/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.workflow.engine.impl.calculator;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.workflow.engine.WfMultiLangUtils;
import kd.bos.workflow.engine.WfUtils;
import kd.bos.workflow.engine.impl.calculator.DefaultMacroParserImpl;
import kd.bos.workflow.engine.impl.calculator.MacroParser;
import kd.bos.workflow.engine.impl.cfg.ProcessEngineConfigurationImpl;
import kd.bos.workflow.engine.impl.context.Context;
import kd.bos.workflow.engine.impl.persistence.entity.history.HistoricActivityInstanceEntity;
import kd.bos.workflow.engine.impl.persistence.entity.history.HistoricActivityInstanceEntityManager;
import kd.bos.workflow.engine.impl.persistence.entity.history.HistoricTaskInstanceEntity;
import kd.bos.workflow.engine.impl.persistence.entity.runtime.ExecutionEntity;
import kd.bos.workflow.engine.impl.persistence.entity.task.CommentEntity;
import kd.bos.workflow.engine.impl.util.BpmnModelUtil;

public class LastAssigneeAndCommentMacroParserImpl
extends DefaultMacroParserImpl
implements MacroParser {
    protected static Log logger = LogFactory.getLog(LastAssigneeAndCommentMacroParserImpl.class);

    public LastAssigneeAndCommentMacroParserImpl(String macro) {
        super(macro);
    }

    @Override
    public Object parseMacro(ExecutionEntity execution) {
        HistoricTaskInstanceEntity hiTask;
        ArrayList<HistoricActivityInstanceEntity> hiActInsEntities = new ArrayList<HistoricActivityInstanceEntity>();
        HistoricActivityInstanceEntityManager hisActivityManager = Context.getProcessEngineConfiguration().getHistoricActivityInstanceEntityManager();
        boolean nodeTakeoutgoing = false;
        if (WfUtils.isNotEmpty(execution.getCurrentTaskId()) && (hiTask = (HistoricTaskInstanceEntity)Context.getProcessEngineConfiguration().getHistoricTaskInstanceEntityManager().findById(execution.getCurrentTaskId())) != null && hiTask.getEndTime() != null) {
            nodeTakeoutgoing = true;
            if ("YunzhijiaTask".equals(hiTask.getCategory())) {
                QFilter[] filters = new QFilter[]{new QFilter("processInstanceId", "=", (Object)execution.getProcessInstanceId()), new QFilter("parenttaskid", "=", (Object)hiTask.getId())};
                hiActInsEntities.addAll(hisActivityManager.findByQueryFilters(filters));
            } else {
                hiActInsEntities.add((HistoricActivityInstanceEntity)hisActivityManager.findById(execution.getCurrentActInstId()));
            }
        }
        if (!nodeTakeoutgoing) {
            this.getAllLastHiActIns(hiActInsEntities, execution.getProcessInstanceId(), execution.getCurrentActInstId(), 0);
        }
        String result = this.getAllNodesLastCommentFormat(execution, hiActInsEntities);
        return result;
    }

    private String getAllNodesLastCommentFormat(ExecutionEntity execution, List<HistoricActivityInstanceEntity> hiActInsEntities) {
        StringBuilder sb = new StringBuilder();
        String lang = (String)execution.getTransientVariable("lang");
        if (WfUtils.isNotEmptyForCollection(hiActInsEntities)) {
            QFilter commentfilter = null;
            if (this.isOnlyOneYunzhijiaAudit(hiActInsEntities)) {
                Long parentTaskId = hiActInsEntities.get(0).getParentTaskId();
                commentfilter = new QFilter("taskId", "=", (Object)parentTaskId);
                commentfilter.and(new QFilter("type", "=", (Object)"comment"));
                CommentEntity commentEntity = (CommentEntity)Context.getCommandContext().getCommentEntityManager().findByQueryFilters(new QFilter[]{commentfilter}).get(0);
                String result = WfMultiLangUtils.getCurrentLang(commentEntity.getCommentMessage(), lang);
                sb.append(result);
            }
            commentfilter = new QFilter("taskId", "in", this.getAllTaskIds(hiActInsEntities));
            commentfilter.and(new QFilter("type", "=", (Object)"comment"));
            List comments = Context.getCommandContext().getCommentEntityManager().findByQueryFilters(new QFilter[]{commentfilter});
            HashMap assigneeAndCommentMap = new HashMap(hiActInsEntities.size());
            for (CommentEntity c : comments) {
                String commentString = WfMultiLangUtils.getCurrentLang(c.getCommentMessage(), lang);
                String key = String.format("%s,%s", this.getAssigneeName(c, hiActInsEntities, lang), c.getUserId());
                Set<String> commentSet = assigneeAndCommentMap.containsKey(key) ? (Set)assigneeAndCommentMap.get(key) : new HashSet(hiActInsEntities.size());
                commentSet.add(commentString);
                assigneeAndCommentMap.put(key, commentSet);
            }
            if (WfUtils.isNotEmptyForMap(assigneeAndCommentMap)) {
                for (Map.Entry entry : assigneeAndCommentMap.entrySet()) {
                    sb.append(((String)entry.getKey()).split(",")[0]).append("\uff1a").append(this.splicingComments((Set)entry.getValue())).append("\uff1b");
                }
            }
        }
        return sb.toString();
    }

    private String splicingComments(Set<String> value) {
        StringBuilder sb = new StringBuilder();
        for (String s : value) {
            sb.append('[').append(s).append("], ");
        }
        if (sb != null && sb.length() > 0) {
            sb.delete(sb.length() - 2, sb.length());
        }
        return sb.toString();
    }

    private boolean isOnlyOneYunzhijiaAudit(List<HistoricActivityInstanceEntity> hiActInsEntities) {
        HistoricActivityInstanceEntity firstHiActInstEntity = hiActInsEntities.get(0);
        if (firstHiActInstEntity.getActivityType().equalsIgnoreCase("YunzhijiaTask")) {
            Long firstParentTaskId = firstHiActInstEntity.getParentTaskId();
            if (firstParentTaskId == null || firstParentTaskId <= 0L) {
                return false;
            }
            Long parentTaskId = 0L;
            for (int i = 1; i < hiActInsEntities.size(); ++i) {
                parentTaskId = hiActInsEntities.get(i).getParentTaskId();
                if (hiActInsEntities.get(i).getActivityType().equalsIgnoreCase("YunzhijiaTask") && parentTaskId != null && parentTaskId > 0L && firstParentTaskId.equals(parentTaskId)) continue;
                return false;
            }
        } else {
            return false;
        }
        return true;
    }

    private String getAssigneeName(CommentEntity c, List<HistoricActivityInstanceEntity> hiActInsEntities, String lang) {
        String assigneeName = WfMultiLangUtils.getCurrentLang(c.getTaskAssignee(), lang);
        if (c.getTaskId() != null && WfUtils.isNotEmpty(assigneeName) && (assigneeName.contains("(") || assigneeName.contains(")"))) {
            for (HistoricActivityInstanceEntity entity : hiActInsEntities) {
                if (!c.getTaskId().equals(entity.getTaskId())) continue;
                assigneeName = WfMultiLangUtils.getCurrentLang(entity.getAssignee(), lang);
                break;
            }
        }
        return assigneeName;
    }

    private List<Long> getAllTaskIds(List<HistoricActivityInstanceEntity> hiActEntities) {
        ArrayList<Long> taskIds = new ArrayList<Long>(hiActEntities.size());
        for (HistoricActivityInstanceEntity hiActInstance : hiActEntities) {
            taskIds.add(hiActInstance.getTaskId());
        }
        return taskIds;
    }

    protected void getAllLastHiActIns(List<HistoricActivityInstanceEntity> hiActInsEntities, Long processInstanceId, Long currentActInstId, int count) {
        if (++count > 100) {
            logger.warn("\u8ba1\u7b97\u4e0a\u4e00\u6b65\u5ba1\u6279\u4eba\u53ca\u610f\u89c1\u9519\u8bef\uff0cprocessInstanceId \uff1a" + processInstanceId + ",currentActInstId\uff1a" + currentActInstId);
            return;
        }
        ProcessEngineConfigurationImpl processEngineConfiguration = Context.getProcessEngineConfiguration();
        HistoricActivityInstanceEntityManager hisActivityManager = processEngineConfiguration.getHistoricActivityInstanceEntityManager();
        HistoricActivityInstanceEntity currentNode = (HistoricActivityInstanceEntity)hisActivityManager.findById(currentActInstId);
        if (currentNode == null) {
            return;
        }
        Long targetId = "SequenceFlow".equals(currentNode.getActivityType()) ? currentNode.getId() : currentNode.getSourceElementId();
        if (currentNode.getSourceElementId() != null) {
            List<HistoricActivityInstanceEntity> lastNodes = hisActivityManager.findByTargetId(processInstanceId, targetId);
            if (lastNodes.isEmpty() || WfUtils.isNotEmpty(currentNode.getJoinFlag())) {
                HashSet<Long> sourceIds = new HashSet<Long>();
                if (!"SequenceFlow".equals(currentNode.getActivityType())) {
                    if (WfUtils.isEmpty(currentNode.getJoinFlag())) {
                        sourceIds.add(currentNode.getSourceElementId());
                    } else {
                        List<HistoricActivityInstanceEntity> currentActinstFlows = hisActivityManager.findByProInstIdAndJoinFlag(processInstanceId, currentNode.getJoinFlag(), currentNode.getExecutionId());
                        for (HistoricActivityInstanceEntity i : currentActinstFlows) {
                            sourceIds.add(i.getSourceElementId());
                        }
                    }
                    QFilter sourcesIdsfilter = new QFilter("id", "in", sourceIds);
                    lastNodes = hisActivityManager.findByQueryFilters(new QFilter[]{sourcesIdsfilter});
                } else {
                    HistoricActivityInstanceEntity node = (HistoricActivityInstanceEntity)hisActivityManager.findById(currentNode.getSourceElementId());
                    lastNodes.add(node);
                }
            }
            boolean isYzjAudit = false;
            ArrayList<HistoricActivityInstanceEntity> tempHiActInsEntities = new ArrayList<HistoricActivityInstanceEntity>(lastNodes.size());
            for (HistoricActivityInstanceEntity lastNode : lastNodes) {
                Long assigneeId;
                if ("UserTask".equals(lastNode.getActivityType()) || "AuditTask".equals(lastNode.getActivityType())) {
                    boolean isManual;
                    assigneeId = lastNode.getAssigneeId();
                    boolean bl = isManual = BpmnModelUtil.isManualHandled(lastNode.getExecutionType()) && WfUtils.isNotEmpty(lastNode.getJoinFlag());
                    if (assigneeId != null && assigneeId > 0L) {
                        tempHiActInsEntities.add(lastNode);
                        continue;
                    }
                    if (isManual) continue;
                    this.getAllLastHiActIns(hiActInsEntities, processInstanceId, lastNode.getId(), count);
                    continue;
                }
                if ("SSCApprove".equals(lastNode.getActivityType())) {
                    assigneeId = lastNode.getAssigneeId();
                    if (assigneeId != null && (assigneeId > 0L || assigneeId == -2L)) {
                        tempHiActInsEntities.add(lastNode);
                        continue;
                    }
                    this.getAllLastHiActIns(hiActInsEntities, processInstanceId, lastNode.getId(), count);
                    continue;
                }
                if ("YunzhijiaTask".equals(lastNode.getActivityType())) {
                    isYzjAudit = true;
                    assigneeId = lastNode.getAssigneeId();
                    if (assigneeId == null || assigneeId <= 0L) continue;
                    tempHiActInsEntities.add(lastNode);
                    continue;
                }
                this.getAllLastHiActIns(hiActInsEntities, processInstanceId, lastNode.getId(), count);
            }
            hiActInsEntities.addAll(tempHiActInsEntities);
            if (isYzjAudit && tempHiActInsEntities.size() == 0) {
                this.getAllLastHiActIns(hiActInsEntities, processInstanceId, lastNodes.get(0).getId(), count);
            }
        }
    }
}

