/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.workflow.engine.impl.calculator;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.ILocaleString;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.workflow.engine.WfMultiLangUtils;
import kd.bos.workflow.engine.WfUtils;
import kd.bos.workflow.engine.impl.calculator.DefaultMacroParserImpl;
import kd.bos.workflow.engine.impl.calculator.MacroParser;
import kd.bos.workflow.engine.impl.calculator.SenderInfo;
import kd.bos.workflow.engine.impl.cfg.ProcessEngineConfigurationImpl;
import kd.bos.workflow.engine.impl.cmd.precomputation.PercomputatorUtils;
import kd.bos.workflow.engine.impl.context.Context;
import kd.bos.workflow.engine.impl.persistence.entity.history.HistoricActivityInstanceEntity;
import kd.bos.workflow.engine.impl.persistence.entity.history.HistoricActivityInstanceEntityManager;
import kd.bos.workflow.engine.impl.persistence.entity.history.HistoricTaskInstanceEntity;
import kd.bos.workflow.engine.impl.persistence.entity.runtime.ExecutionEntity;
import kd.bos.workflow.engine.impl.util.BpmnModelUtil;
import kd.bos.workflow.engine.impl.util.ParticipantHelper;

public class LastAssigneeMacroParserImpl
extends DefaultMacroParserImpl
implements MacroParser {
    protected static Log logger = LogFactory.getLog(LastAssigneeMacroParserImpl.class);

    public LastAssigneeMacroParserImpl(String macro) {
        super(macro);
    }

    @Override
    public Object parseMacro(ExecutionEntity execution) {
        HistoricTaskInstanceEntity hiTask;
        Map getNextNodeVariable;
        String result;
        if (execution.getTransientVariable("percomputation_ctx") != null && (result = PercomputatorUtils.getLastAssignee((String)execution.getTransientVariable("percomputation_currentnode"), execution)) != null && WfUtils.isNotEmptyString(result)) {
            return result;
        }
        if (execution.getTransientVariable("getnextnode_variable") != null && (getNextNodeVariable = (Map)execution.getTransientVariable("getnextnode_variable")).get(this.macro) != null) {
            return getNextNodeVariable.get(this.macro);
        }
        List<SenderInfo> senders = new ArrayList<SenderInfo>();
        HistoricActivityInstanceEntityManager hisActivityManager = Context.getProcessEngineConfiguration().getHistoricActivityInstanceEntityManager();
        boolean nodeTakeoutgoing = false;
        if (WfUtils.isNotEmpty(execution.getCurrentTaskId()) && (hiTask = (HistoricTaskInstanceEntity)Context.getProcessEngineConfiguration().getHistoricTaskInstanceEntityManager().findById(execution.getCurrentTaskId())) != null && hiTask.getEndTime() != null) {
            nodeTakeoutgoing = true;
            if ("YunzhijiaTask".equals(hiTask.getCategory())) {
                QFilter[] filters = new QFilter[]{new QFilter("processInstanceId", "=", (Object)execution.getProcessInstanceId()), new QFilter("parenttaskid", "=", (Object)hiTask.getId())};
                List cNode = hisActivityManager.findByQueryFilters(filters);
                for (HistoricActivityInstanceEntity i : cNode) {
                    SenderInfo s = new SenderInfo(i.getAssigneeId(), i.getAssignee(), i.getTaskId());
                    senders.add(s);
                }
            } else {
                HistoricActivityInstanceEntity currentNode = (HistoricActivityInstanceEntity)hisActivityManager.findById(execution.getCurrentActInstId());
                SenderInfo s = new SenderInfo(currentNode.getAssigneeId(), currentNode.getAssignee(), currentNode.getTaskId());
                senders.add(s);
            }
        }
        if (!nodeTakeoutgoing) {
            senders = this.getSenders(senders, execution.getProcessInstanceId(), execution.getCurrentActInstId(), 0, new ArrayList<Long>(2));
        }
        HashSet<Long> senderIdSet = new HashSet<Long>();
        StringBuilder senderIds = new StringBuilder();
        int size = senders.size();
        SenderInfo sender = null;
        for (int i = 0; i < size; ++i) {
            sender = senders.get(i);
            if (senderIdSet.contains(sender.getAssigneeId())) continue;
            senderIdSet.add(sender.getAssigneeId());
            if (!WfUtils.isNotEmpty(sender.getAssigneeId()) || sender.getAssigneeId() <= 0L) continue;
            senderIds.append(sender.getAssigneeId()).append(',');
        }
        if (senderIds != null && senderIds.length() > 0) {
            senderIds.deleteCharAt(senderIds.length() - 1);
        }
        if (Context.getCommandContext() != null) {
            Context.getCommandContext().addAttribute("lastAssignee", senders);
        }
        return senderIds.toString();
    }

    public Map<String, ILocaleString> getAssigneeNameFormat(ExecutionEntity execution) {
        List<Object> senders = new ArrayList();
        if (Context.getCommandContext() != null && (senders = (List)Context.getCommandContext().getAttribute("lastAssignee")) == null) {
            senders = this.getSenders(senders, execution.getProcessInstanceId(), execution.getCurrentActInstId(), 0, new ArrayList<Long>(2));
        }
        LocaleString senderNames = new LocaleString();
        LocaleString senderNameFormats = new LocaleString();
        LinkedList<ILocaleString> senderNamesList = new LinkedList<ILocaleString>();
        LinkedList<ILocaleString> senderNameFormatsList = new LinkedList<ILocaleString>();
        HashMap<Long, String> filter = new HashMap<Long, String>();
        if (senders.size() > 0) {
            for (int i = 0; i < senders.size(); ++i) {
                SenderInfo sender = (SenderInfo)senders.get(i);
                if (sender.getAssigneeId() == null || filter.get(sender.getAssigneeId()) != null) continue;
                filter.put(sender.getAssigneeId(), "TRUE");
                ILocaleString assignee = sender.getAssignee();
                senderNamesList.add(assignee);
                QFilter[] secondFilters = new QFilter[]{new QFilter("endtime", "is not null", null)};
                DynamicObject hiparticipant = ParticipantHelper.getUserNameFormatByDynamicObject(sender.getAssigneeId(), sender.getTaskId(), "wf_hiparticipant", "usernameformatter", secondFilters);
                if (hiparticipant == null) continue;
                ILocaleString assigneeFormat = hiparticipant.getLocaleString("usernameformatter");
                senderNameFormatsList.add(assigneeFormat);
            }
            senderNameFormats = WfMultiLangUtils.getFormatMergeValue(senderNameFormatsList);
            senderNames = WfMultiLangUtils.getFormatMergeValue(senderNamesList);
        }
        HashMap<String, ILocaleString> resultMap = new HashMap<String, ILocaleString>(2);
        resultMap.put("senderNames", (ILocaleString)senderNames);
        resultMap.put("senderNameFormats", (ILocaleString)senderNameFormats);
        return resultMap;
    }

    @Override
    public ILocaleString getAssigneeNames(ExecutionEntity execution) {
        List<SenderInfo> senders = new ArrayList<SenderInfo>();
        senders = this.getSenders(senders, execution.getProcessInstanceId(), execution.getCurrentActInstId(), 0, new ArrayList<Long>(2));
        LocaleString senderNames = new LocaleString();
        HashMap<Long, String> filter = new HashMap<Long, String>();
        if (senders.size() > 0) {
            for (int i = 0; i < senders.size(); ++i) {
                SenderInfo sender = senders.get(i);
                if (sender.getAssigneeId() == null || filter.get(sender.getAssigneeId()) != null) continue;
                filter.put(sender.getAssigneeId(), "TRUE");
                ILocaleString assignee = sender.getAssignee();
                for (String lang : assignee.keySet()) {
                    String value = (String)senderNames.get((Object)lang);
                    StringBuilder langValue = new StringBuilder(WfUtils.isNotEmpty(value) ? value : "");
                    if (WfUtils.isNotEmpty((String)assignee.get((Object)lang))) {
                        if (i == senders.size() - 1) {
                            langValue.append((String)assignee.get((Object)lang));
                        } else {
                            langValue.append((String)assignee.get((Object)lang)).append(",");
                        }
                    }
                    senderNames.put((Object)lang, (Object)langValue.toString());
                }
            }
            for (String lang : senderNames.keySet()) {
                String lv = (String)senderNames.get((Object)lang);
                if (WfUtils.isNotEmpty(lv) && lv.lastIndexOf(",") == lv.length() - 1) {
                    lv = lv.substring(0, lv.length() - 1);
                }
                senderNames.put((Object)lang, (Object)lv);
            }
        }
        return senderNames;
    }

    protected List<SenderInfo> getSenders(List<SenderInfo> senders, Long processInstanceId, Long currentActInstId, int count, List<Long> hasCounts) {
        if (++count > 20 || hasCounts.contains(currentActInstId)) {
            logger.warn("\u8ba1\u7b97\u4e0a\u4e00\u4e2a\u5904\u7406\u4eba\u9519\u8befprocessInstanceId \uff1a" + processInstanceId + ",currentActInstI\uff1a" + currentActInstId);
            return senders;
        }
        hasCounts.add(currentActInstId);
        ProcessEngineConfigurationImpl processEngineConfiguration = Context.getProcessEngineConfiguration();
        HistoricActivityInstanceEntityManager hisActivityManager = processEngineConfiguration.getHistoricActivityInstanceEntityManager();
        HistoricActivityInstanceEntity currentNode = (HistoricActivityInstanceEntity)hisActivityManager.findById(currentActInstId);
        if (currentNode == null) {
            return senders;
        }
        Long targetId = "SequenceFlow".equals(currentNode.getActivityType()) ? currentNode.getId() : currentNode.getSourceElementId();
        if (currentNode.getSourceElementId() != null) {
            List<HistoricActivityInstanceEntity> lastNodes = hisActivityManager.findByTargetId(processInstanceId, targetId);
            if (lastNodes.isEmpty() || WfUtils.isNotEmpty(currentNode.getJoinFlag())) {
                HashSet<Long> sourceIds = new HashSet<Long>();
                if (!"SequenceFlow".equals(currentNode.getActivityType())) {
                    if (WfUtils.isEmpty(currentNode.getJoinFlag())) {
                        sourceIds.add(currentNode.getSourceElementId());
                    } else {
                        List<HistoricActivityInstanceEntity> currentActinstFlows = hisActivityManager.findByProInstIdAndJoinFlag(processInstanceId, currentNode.getJoinFlag(), currentNode.getExecutionId());
                        for (HistoricActivityInstanceEntity i : currentActinstFlows) {
                            sourceIds.add(i.getSourceElementId());
                        }
                    }
                    QFilter sourcesIdsfilter = new QFilter("id", "in", sourceIds);
                    lastNodes = hisActivityManager.findByQueryFilters(new QFilter[]{sourcesIdsfilter});
                    if (WfUtils.isEmptyForCollection(lastNodes)) {
                        for (Long sourceId : sourceIds) {
                            HistoricActivityInstanceEntity node = (HistoricActivityInstanceEntity)hisActivityManager.findById(sourceId);
                            lastNodes.add(node);
                        }
                    }
                } else {
                    HistoricActivityInstanceEntity node = (HistoricActivityInstanceEntity)hisActivityManager.findById(currentNode.getSourceElementId());
                    lastNodes.add(node);
                }
            }
            boolean isYzjAudit = false;
            boolean isBillTask = false;
            ArrayList<SenderInfo> tempSenders = new ArrayList<SenderInfo>(lastNodes.size());
            for (HistoricActivityInstanceEntity lastNode : lastNodes) {
                Long assigneeId = lastNode.getAssigneeId();
                ILocaleString assignee = lastNode.getAssignee();
                if ("UserTask".equals(lastNode.getActivityType()) || "AuditTask".equals(lastNode.getActivityType())) {
                    boolean isManual;
                    boolean bl = isManual = BpmnModelUtil.isManualHandled(lastNode.getExecutionType()) && WfUtils.isNotEmpty(lastNode.getJoinFlag());
                    if (assigneeId != null && assigneeId > 0L) {
                        tempSenders.add(new SenderInfo(assigneeId, assignee, lastNode.getTaskId()));
                        continue;
                    }
                    if (isManual) continue;
                    senders = this.getSenders(senders, processInstanceId, lastNode.getId(), count, hasCounts);
                    continue;
                }
                if ("SSCApprove".equals(lastNode.getActivityType())) {
                    if (assigneeId != null && (assigneeId > 0L || assigneeId == -2L)) {
                        tempSenders.add(new SenderInfo(assigneeId, assignee, lastNode.getTaskId()));
                        continue;
                    }
                    senders = this.getSenders(senders, processInstanceId, lastNode.getId(), count, hasCounts);
                    continue;
                }
                if ("YunzhijiaTask".equals(lastNode.getActivityType())) {
                    isYzjAudit = true;
                    if (assigneeId == null || assigneeId <= 0L) continue;
                    tempSenders.add(new SenderInfo(assigneeId, assignee, lastNode.getTaskId()));
                    continue;
                }
                if ("BillTask".equals(lastNode.getActivityType())) {
                    isBillTask = true;
                    if (assigneeId == null || assigneeId <= 0L) continue;
                    tempSenders.add(new SenderInfo(assigneeId, assignee, lastNode.getTaskId()));
                    continue;
                }
                senders = this.getSenders(senders, processInstanceId, lastNode.getId(), count, hasCounts);
            }
            senders.addAll(tempSenders);
            if ((isYzjAudit || isBillTask) && tempSenders.size() == 0) {
                senders = this.getSenders(senders, processInstanceId, lastNodes.get(0).getId(), count, hasCounts);
            }
        }
        return senders;
    }
}

