/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.workflow.engine.impl.calculator;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.ILocaleString;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.orm.query.QFilter;
import kd.bos.workflow.bpmn.model.FlowElement;
import kd.bos.workflow.bpmn.model.YunzhijiaTask;
import kd.bos.workflow.engine.WfUtils;
import kd.bos.workflow.engine.impl.calculator.DefaultMacroParserImpl;
import kd.bos.workflow.engine.impl.calculator.MacroParser;
import kd.bos.workflow.engine.impl.calculator.SenderInfo;
import kd.bos.workflow.engine.impl.cfg.ProcessEngineConfigurationImpl;
import kd.bos.workflow.engine.impl.cmd.precomputation.PercomputatorUtils;
import kd.bos.workflow.engine.impl.context.Context;
import kd.bos.workflow.engine.impl.persistence.entity.history.HistoricActivityInstanceEntity;
import kd.bos.workflow.engine.impl.persistence.entity.history.HistoricActivityInstanceEntityManager;
import kd.bos.workflow.engine.impl.persistence.entity.runtime.ExecutionEntity;

public class NodeAssigneeMacroParserImpl
extends DefaultMacroParserImpl
implements MacroParser {
    public NodeAssigneeMacroParserImpl(String macro) {
        super(macro);
    }

    @Override
    public Object parseMacro(ExecutionEntity execution) {
        Object result;
        Map getNextNodeVariable;
        List<SenderInfo> senders = new ArrayList<SenderInfo>();
        if (execution.getTransientVariable("getnextnode_variable") != null && (getNextNodeVariable = (Map)execution.getTransientVariable("getnextnode_variable")).get(this.macro) != null) {
            return getNextNodeVariable.get(this.macro);
        }
        String nodeId = this.macro.substring(0, this.macro.length() - "Assignee".length());
        if (execution.getTransientVariable("percomputation_ctx") != null && (result = PercomputatorUtils.getNodeAssignee(nodeId, execution)) != null) {
            return result;
        }
        HistoricActivityInstanceEntityManager hiActInstManager = Context.getProcessEngineConfiguration().getHistoricActivityInstanceEntityManager();
        if (nodeId.equals(execution.getActivityId())) {
            Object isPreAssign = execution.getTransientVariable("isPreAssign");
            FlowElement f = execution.getCurrentFlowElement();
            Long actInstId = execution.getCurrentActInstId();
            if (WfUtils.isEmpty(actInstId)) {
                return "";
            }
            HistoricActivityInstanceEntity currentActInst = (HistoricActivityInstanceEntity)hiActInstManager.findById(actInstId);
            if (currentActInst == null) {
                return "";
            }
            if (f instanceof YunzhijiaTask) {
                Long parentTaskId = currentActInst.getParentTaskId();
                QFilter parentTaskIdFilter = new QFilter("parentTaskId", "=", (Object)parentTaskId);
                QFilter proceIdFilter = new QFilter("processInstanceId", "=", (Object)execution.getProcessInstanceId());
                List currentNodeInstanceEntitys = hiActInstManager.findByQueryFilters(new QFilter[]{parentTaskIdFilter, proceIdFilter});
                String assigneeIds = "";
                StringBuilder assigneeIdSB = new StringBuilder();
                for (HistoricActivityInstanceEntity i : currentNodeInstanceEntitys) {
                    if (i.getId().equals(actInstId) || !WfUtils.isNotEmpty(i.getAssigneeId())) continue;
                    assigneeIdSB.append(',').append(i.getAssigneeId());
                }
                if (!WfUtils.isNullObject(isPreAssign) && ((Boolean)isPreAssign).booleanValue()) {
                    assigneeIdSB.append(',').append(RequestContext.get().getUserId());
                } else if (WfUtils.isNotEmpty(currentActInst.getAssigneeId())) {
                    assigneeIdSB.append(',').append(currentActInst.getAssigneeId());
                }
                if (assigneeIdSB.length() > 0) {
                    assigneeIds = assigneeIdSB.substring(1);
                }
                return assigneeIds;
            }
            if (!WfUtils.isNullObject(isPreAssign) && ((Boolean)isPreAssign).booleanValue()) {
                return RequestContext.get().getUserId();
            }
            if (WfUtils.isNotEmpty(currentActInst.getAssigneeId())) {
                return currentActInst.getAssigneeId().toString();
            }
            return "";
        }
        senders = this.getSenders(senders, execution.getProcessInstanceId(), nodeId);
        StringBuilder sbs = new StringBuilder();
        for (SenderInfo sender : senders) {
            Long senderId = sender.getAssigneeId();
            if (senderId == null || senderId <= 0L) continue;
            sbs.append(senderId).append(',');
        }
        String senderIds = "";
        if (sbs.toString().endsWith(",")) {
            senderIds = sbs.substring(0, sbs.length() - 1);
        }
        return senderIds;
    }

    @Override
    public ILocaleString getAssigneeNames(ExecutionEntity execution) {
        List<SenderInfo> senders = new ArrayList<SenderInfo>();
        String nodeId = this.macro.substring(0, this.macro.length() - 8);
        String uid = RequestContext.get().getUserId();
        if (nodeId.equals(execution.getActivityId())) {
            return WfUtils.findUserName(Long.valueOf(uid));
        }
        senders = this.getSenders(senders, execution.getProcessInstanceId(), nodeId);
        LocaleString senderNames = new LocaleString();
        int size = senders.size();
        for (int i = 0; i < size; ++i) {
            SenderInfo sender = senders.get(i);
            ILocaleString assignee = sender.getAssignee();
            for (String key : assignee.keySet()) {
                String value = (String)senderNames.get((Object)key);
                StringBuilder sb = null;
                sb = value == null ? new StringBuilder() : new StringBuilder(value);
                sb.append((String)assignee.get((Object)key));
                if (i < size - 1) {
                    sb.append(',');
                }
                senderNames.put((Object)key, (Object)sb.toString());
            }
        }
        return senderNames;
    }

    protected List<SenderInfo> getSenders(List<SenderInfo> senders, Long processInstanceId, String currentNodeId) {
        ProcessEngineConfigurationImpl processEngineConfiguration = Context.getProcessEngineConfiguration();
        HistoricActivityInstanceEntityManager hisActivityManager = processEngineConfiguration.getHistoricActivityInstanceEntityManager();
        Long parentTaskId = null;
        List<HistoricActivityInstanceEntity> nodes = hisActivityManager.findByActivityId(processInstanceId, currentNodeId);
        for (HistoricActivityInstanceEntity node : nodes) {
            ILocaleString assignee;
            Long assigneeId;
            if (node.getActivityType().equals("YunzhijiaTask")) {
                if (parentTaskId != null && !parentTaskId.equals(node.getParentTaskId())) break;
                parentTaskId = node.getParentTaskId();
                assigneeId = node.getAssigneeId();
                assignee = node.getAssignee();
                if (!WfUtils.isNotEmpty(assigneeId)) continue;
                senders.add(new SenderInfo(assigneeId, assignee));
                continue;
            }
            assigneeId = node.getAssigneeId();
            if (null == assigneeId) {
                assigneeId = 0L;
            }
            assignee = node.getAssignee();
            if (assigneeId > 0L) {
                senders.add(new SenderInfo(assigneeId, assignee));
                break;
            }
            if (assigneeId != -1L) break;
            senders.add(new SenderInfo(-1L, assignee));
            break;
        }
        return senders;
    }
}

