/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.workflow.engine.impl.calculator;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.entity.ValueMapItem;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.workflow.bpmn.model.DecisionOption;
import kd.bos.workflow.bpmn.model.FlowElement;
import kd.bos.workflow.bpmn.model.Process;
import kd.bos.workflow.bpmn.model.UserTask;
import kd.bos.workflow.engine.WfUtils;
import kd.bos.workflow.engine.impl.calculator.DefaultMacroParserImpl;
import kd.bos.workflow.engine.impl.calculator.MacroParser;
import kd.bos.workflow.engine.impl.cmd.precomputation.PercomputatorUtils;
import kd.bos.workflow.engine.impl.context.Context;
import kd.bos.workflow.engine.impl.persistence.entity.history.HistoricActivityInstanceEntity;
import kd.bos.workflow.engine.impl.persistence.entity.history.HistoricActivityInstanceEntityManager;
import kd.bos.workflow.engine.impl.persistence.entity.history.HistoricTaskInstanceEntity;
import kd.bos.workflow.engine.impl.persistence.entity.history.HistoricVariableInstanceEntity;
import kd.bos.workflow.engine.impl.persistence.entity.runtime.ExecutionEntity;
import kd.bos.workflow.engine.impl.util.BpmnModelUtil;
import kd.bos.workflow.engine.impl.util.ProcessDefinitionUtil;

public class NodeAuditNumberMacroParserImpl
extends DefaultMacroParserImpl
implements MacroParser {
    private static Log logger = LogFactory.getLog((String)NodeAuditNumberMacroParserImpl.class.getName());

    public NodeAuditNumberMacroParserImpl(String macro) {
        super(macro);
    }

    @Override
    public Object parseMacro(ExecutionEntity execution) {
        HistoricActivityInstanceEntity actiInstance;
        Object result;
        String activityid = this.macro.substring(0, this.macro.length() - "AuditNumber".length());
        if (execution.getTransientVariable("percomputation_ctx") != null && (result = PercomputatorUtils.getNodeAuditNumber(activityid, execution)) != null) {
            this.buildEnumText(execution, activityid, String.valueOf(result));
            return result;
        }
        if (activityid.equals(execution.getActivityId())) {
            if (execution.getCurrentTaskId() != null) {
                HistoricTaskInstanceEntity hitaskEntity = (HistoricTaskInstanceEntity)Context.getCommandContext().getHistoricTaskInstanceEntityManager().findById(execution.getCurrentTaskId());
                if (hitaskEntity != null && hitaskEntity.getEndTime() != null) {
                    Object val;
                    Map<String, Object> variables = Context.getCommandContext().getHistoricVariableInstanceEntityManager().findVariablesByTaskId(execution.getCurrentTaskId());
                    Object object = val = variables == null ? null : variables.get("auditNumber");
                    if (val == null && "skip".equalsIgnoreCase(hitaskEntity.getExecutionType())) {
                        FlowElement elem = ProcessDefinitionUtil.getFlowElement(hitaskEntity.getProcessDefinitionId(), hitaskEntity.getProcessInstanceId(), hitaskEntity.getTaskDefinitionKey());
                        val = BpmnModelUtil.getDefaultOptionNumber(elem);
                    }
                    this.buildEnumText(execution, activityid, String.valueOf(val));
                    return val;
                }
                if (execution.getCurrentTask() != null) {
                    Object ret = execution.getCurrentTask().getVariable("auditNumber");
                    this.buildEnumText(execution, activityid, String.valueOf(ret));
                    return ret;
                }
                this.buildEnumText(execution, activityid, "");
                return "";
            }
            if (execution.getCurrentTask() != null) {
                Object ret = execution.getCurrentTask().getVariable("auditNumber");
                this.buildEnumText(execution, activityid, String.valueOf(ret));
                return ret;
            }
            this.buildEnumText(execution, activityid, "");
            return "";
        }
        HistoricActivityInstanceEntityManager actMgr = Context.getCommandContext().getHistoricActivityInstanceEntityManager();
        List<HistoricActivityInstanceEntity> entities = actMgr.findByActivityId(execution.getProcessInstanceId(), activityid);
        HistoricActivityInstanceEntity historicActivityInstanceEntity = actiInstance = entities != null && !entities.isEmpty() ? entities.get(0) : null;
        if (actiInstance != null) {
            logger.debug(String.format("the lastest actInst of [%s] is [%s]", activityid, actiInstance.getId()));
            Long taskId = actiInstance.getActivityType().equalsIgnoreCase("YunzhijiaTask") ? actiInstance.getParentTaskId() : actiInstance.getTaskId();
            if (WfUtils.isNotEmpty(taskId)) {
                HistoricVariableInstanceEntity val = Context.getCommandContext().getHistoricVariableInstanceEntityManager().findHistoricVariableInstancesByTaskIdAndVarName(taskId, "auditNumber");
                String ret = val == null ? "" : val.getTextValue();
                this.buildEnumText(execution, activityid, String.valueOf(ret));
                return ret;
            }
        } else {
            logger.debug(String.format("the lastest actInst of [%s] is null", activityid));
        }
        this.buildEnumText(execution, activityid, "");
        return "";
    }

    protected void buildEnumText(ExecutionEntity execution, String activityId, String key) {
        if (execution.getTransientVariable("buildEnumMarcoMark") != null) {
            execution.removeTransientVariable("buildEnumMarcoMark");
            Process process = ProcessDefinitionUtil.getProcessByProcDefId(execution.getProcessDefinitionId());
            if (WfUtils.isNotEmpty(execution.getProcessInstanceId())) {
                process = ProcessDefinitionUtil.getProcessByProcInstId(execution.getProcessInstanceId());
            } else if (WfUtils.isNotEmpty(execution.getSchemeId())) {
                process = ProcessDefinitionUtil.getProcessBySchemeId(execution.getSchemeId());
            }
            UserTask task = (UserTask)process.getFlowElement(activityId);
            List<DecisionOption> options = task.getDecisionOptions();
            ArrayList<ValueMapItem> items = new ArrayList<ValueMapItem>(options.size());
            for (DecisionOption d : options) {
                if (!d.getNumber().equals(key)) continue;
                ValueMapItem item = new ValueMapItem();
                item.setName((LocaleString)WfUtils.getMultiLangValue(d.getName()));
                item.setValue(key);
                items.add(item);
                break;
            }
            if (items.isEmpty()) {
                ValueMapItem item = new ValueMapItem();
                item.setName((LocaleString)WfUtils.getMultiLangValue(key));
                item.setValue(key);
                items.add(item);
            }
            execution.setTransientVariable("enumMarcoCombos", items);
        }
    }
}

