/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.workflow.engine.impl.calculator;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.metadata.dao.MetadataDao;
import kd.bos.servicehelper.botp.BFTrackerServiceHelper;
import kd.bos.workflow.bpmn.model.AutoTask;
import kd.bos.workflow.bpmn.model.CallActivity;
import kd.bos.workflow.bpmn.model.FlowElement;
import kd.bos.workflow.bpmn.model.UserTask;
import kd.bos.workflow.engine.WfConfigurationUtil;
import kd.bos.workflow.engine.WfUtils;
import kd.bos.workflow.engine.impl.calculator.DefaultMacroParserImpl;
import kd.bos.workflow.engine.impl.calculator.MacroParser;
import kd.bos.workflow.engine.impl.context.Context;
import kd.bos.workflow.engine.impl.persistence.entity.history.HistoricActivityInstanceEntity;
import kd.bos.workflow.engine.impl.persistence.entity.runtime.ExecutionEntity;
import kd.bos.workflow.engine.impl.util.ProcessDefinitionUtil;
import kd.bos.workflow.exception.WFEngineException;

public class NodeBillMacroParserImpl
extends DefaultMacroParserImpl
implements MacroParser {
    protected Log logger = LogFactory.getLog((String)this.getClass().getName());

    public NodeBillMacroParserImpl(String macro) {
        super(macro);
    }

    @Override
    public Object parseMacro(ExecutionEntity execution) {
        String activityId = this.macro.substring(0, this.macro.length() - "Bill".length());
        Long procinstId = execution.getProcessInstanceId();
        String vEntityNumberName = String.format("%s.%s", execution.getActivityId(), "expectEntityNumber");
        String targetEntityNumber = (String)execution.getTransientVariable(vEntityNumberName);
        String targetNodeId = (String)execution.getTransientVariable("targetNode");
        List<HistoricActivityInstanceEntity> actInsts = Context.getCommandContext().getHistoricActivityInstanceEntityManager().findByActivityId(execution.getProcessInstanceId(), activityId);
        if (!actInsts.isEmpty()) {
            FlowElement node = ProcessDefinitionUtil.getFlowElement(execution.getProcessDefinitionId(), procinstId, activityId);
            FlowElement target = ProcessDefinitionUtil.getFlowElement(execution.getProcessDefinitionId(), procinstId, targetNodeId);
            String ten = this.getTargetEntityNumber(node);
            boolean onlySrcBill = false;
            if (target != null) {
                Object customPropValue = target.getCustomPropValue("onlySrcBill");
                if (customPropValue == null) {
                    customPropValue = WfConfigurationUtil.getConfigCenterVal("onlySrcBill");
                }
                onlySrcBill = customPropValue == null || "true".equalsIgnoreCase(String.valueOf(customPropValue));
            }
            this.logger.debug(String.format("targetElement:%s/%s/%s,targetNodeId:%s,onlySrcBill:%s", targetEntityNumber, ten, execution.getEntityNumber(), targetNodeId, onlySrcBill));
            Set<Object> srchjjs = onlySrcBill ? this.getSourceBills(execution) : new HashSet();
            ArrayList<String> pks = new ArrayList<String>(actInsts.size());
            for (HistoricActivityInstanceEntity i : actInsts) {
                String bk = i.getBusinessKey();
                if (!ten.equals(i.getEntityNumber()) || !WfUtils.isEmpty(targetEntityNumber) && !targetEntityNumber.equals(ten)) continue;
                if (onlySrcBill) {
                    if (!srchjjs.contains(bk)) continue;
                    pks.add(bk);
                    continue;
                }
                pks.add(bk);
            }
            if (!pks.isEmpty()) {
                this.logger.debug("ret" + WfUtils.listToString(pks, ","));
                return WfUtils.listToString(pks, ",");
            }
        }
        return "";
    }

    private Set<String> getSourceBills(ExecutionEntity execution) {
        String vSrcPksname = String.format("%s.%s", execution.getActivityId(), "srcPks");
        String srcPks = (String)execution.getTransientVariable(vSrcPksname);
        ArrayList<Long> queryPks = new ArrayList<Long>(16);
        queryPks.add(Long.valueOf(execution.getBusinessKey()));
        if (WfUtils.isNotEmpty(srcPks)) {
            List srcPkList = (List)SerializationUtils.fromJsonString((String)srcPks, List.class);
            for (String i : srcPkList) {
                Long li = Long.valueOf(i);
                if (queryPks.contains(li)) continue;
                queryPks.add(li);
            }
        }
        this.logger.debug("queryPks" + WfUtils.listToString(queryPks, ","));
        HashSet<String> srchjjs = new HashSet<String>();
        Map srcs = BFTrackerServiceHelper.findSourceBills((String)execution.getEntityNumber(), (Long[])queryPks.toArray(new Long[0]));
        for (Map.Entry entry : srcs.entrySet()) {
            for (Long pk : (HashSet)entry.getValue()) {
                srchjjs.add(String.valueOf(pk));
            }
        }
        this.logger.debug("srchjjs" + WfUtils.listToString(srchjjs, ","));
        return srchjjs;
    }

    private String getTargetEntityNumber(FlowElement node) {
        String ten = null;
        if (node instanceof UserTask) {
            ten = ((UserTask)node).getEntityNumber();
        } else if (node instanceof AutoTask) {
            String entityId = ((AutoTask)node).getEntityId();
            ten = MetadataDao.getNumberById((String)entityId);
        } else if (node instanceof CallActivity) {
            ten = ((CallActivity)node).getEntityNumber();
        }
        if (ten == null) {
            throw new WFEngineException(String.format(ResManager.loadKDString((String)"\u8282\u70b9%s\u672a\u8bbe\u7f6e\u5b9e\u4f53\u3002", (String)"NodeBillMacroParserImpl_1", (String)"bos-wf-engine", (Object[])new Object[0]), node.getId()));
        }
        return ten;
    }
}

