/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.workflow.engine.impl.calculator;

import java.util.ArrayList;
import java.util.List;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.workflow.engine.WfMultiLangUtils;
import kd.bos.workflow.engine.WfUtils;
import kd.bos.workflow.engine.impl.calculator.DefaultMacroParserImpl;
import kd.bos.workflow.engine.impl.calculator.MacroParser;
import kd.bos.workflow.engine.impl.context.Context;
import kd.bos.workflow.engine.impl.persistence.entity.history.HistoricActivityInstanceEntity;
import kd.bos.workflow.engine.impl.persistence.entity.history.HistoricActivityInstanceEntityManager;
import kd.bos.workflow.engine.impl.persistence.entity.runtime.ExecutionEntity;
import kd.bos.workflow.engine.impl.persistence.entity.task.CommentEntity;

public class NodeCommentMacroParserImpl
extends DefaultMacroParserImpl
implements MacroParser {
    private static Log logger = LogFactory.getLog((String)NodeCommentMacroParserImpl.class.getName());

    public NodeCommentMacroParserImpl(String macro) {
        super(macro);
    }

    @Override
    public Object parseMacro(ExecutionEntity execution) {
        HistoricActivityInstanceEntity actiInstance;
        String activityId = this.macro.substring(0, this.macro.length() - "Comment".length());
        logger.debug("[NodeCommentMacroParserImpl] enter NodeCommentMacroParserImpl activity is " + activityId);
        HistoricActivityInstanceEntityManager actMgr = Context.getCommandContext().getHistoricActivityInstanceEntityManager();
        List<HistoricActivityInstanceEntity> entities = actMgr.findByActivityId(execution.getProcessInstanceId(), activityId);
        HistoricActivityInstanceEntity historicActivityInstanceEntity = actiInstance = entities != null && !entities.isEmpty() ? entities.get(0) : null;
        if (actiInstance != null) {
            logger.debug(String.format("the lastest actInst of [%s] is [%s]", activityId, actiInstance.getId()));
            Long parentTaskId = null;
            QFilter commentfilter = null;
            StringBuilder sb = new StringBuilder();
            String result = "";
            String lang = (String)execution.getTransientVariable("lang");
            if (actiInstance.getActivityType().equalsIgnoreCase("YunzhijiaTask")) {
                Long taskId;
                parentTaskId = taskId = actiInstance.getParentTaskId();
                QFilter filter = new QFilter("parentTaskId", "=", (Object)actiInstance.getParentTaskId());
                List tasks = Context.getCommandContext().getHistoricTaskInstanceEntityManager().findByQueryFilters(new QFilter[]{filter});
                ArrayList<Long> taskIds = new ArrayList<Long>(tasks.size());
                for (Object i : tasks) {
                    taskIds.add(i.getId());
                }
                taskIds.add(taskId);
                commentfilter = new QFilter("taskId", "in", taskIds);
                commentfilter.and(new QFilter("type", "=", (Object)"comment"));
                List comments = Context.getCommandContext().getCommentEntityManager().findByQueryFilters(new QFilter[]{commentfilter});
                for (CommentEntity c : comments) {
                    String commentMessage = WfMultiLangUtils.getCurrentLang(c.getCommentMessage(), lang);
                    if (c.getTaskId().equals(parentTaskId)) {
                        result = String.format(ResManager.loadKDString((String)"\u6700\u7ec8\u7ed3\u679c\uff1a%s", (String)"NodeCommentMacroParserImpl_0", (String)"bos-wf-engine", (Object[])new Object[0]), commentMessage);
                        continue;
                    }
                    sb.append(c.getTaskAssignee().getLocaleValue()).append("\uff1a").append(commentMessage).append("\uff1b");
                }
                StringBuilder sd = new StringBuilder();
                sd.append(result).append((CharSequence)sb);
                return sd.toString();
            }
            Long taskId = actiInstance.getTaskId();
            if (WfUtils.isNotEmpty(taskId)) {
                commentfilter = new QFilter("taskId", "=", (Object)taskId);
                commentfilter.and(new QFilter("type", "=", (Object)"comment"));
                List comments = Context.getCommandContext().getCommentEntityManager().findByQueryFilters(new QFilter[]{commentfilter});
                for (CommentEntity c : comments) {
                    String commentMessage = WfMultiLangUtils.getCurrentLang(c.getCommentMessage(), lang);
                    sb.append(commentMessage);
                }
            }
            StringBuilder sd = new StringBuilder();
            sd.append(result).append((CharSequence)sb);
            return sd.toString();
        }
        logger.debug(String.format("the lastest actInst of [%s] is null", activityId));
        return "";
    }
}

