/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.workflow.engine.impl.calculator;

import com.alibaba.fastjson.JSON;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.node.ObjectNode;
import java.util.Iterator;
import java.util.Map;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.workflow.bpmn.model.BillTask;
import kd.bos.workflow.bpmn.model.BpmnModel;
import kd.bos.workflow.bpmn.model.EventSupportTask;
import kd.bos.workflow.bpmn.model.FlowElement;
import kd.bos.workflow.bpmn.model.WaitTask;
import kd.bos.workflow.engine.WfUtils;
import kd.bos.workflow.engine.impl.calculator.DefaultMacroParserImpl;
import kd.bos.workflow.engine.impl.calculator.MacroParser;
import kd.bos.workflow.engine.impl.persistence.entity.runtime.ExecutionEntity;
import kd.bos.workflow.service.WorkflowService;
import kd.bos.workflow.service.impl.ServiceFactory;

public class NodeEventParamsMacroParserImpl
extends DefaultMacroParserImpl
implements MacroParser {
    private Log log = LogFactory.getLog(this.getClass());

    public NodeEventParamsMacroParserImpl(String macro) {
        super(macro);
    }

    @Override
    public Object parseMacro(ExecutionEntity execution) {
        String activityid = this.macro.replace("EventParams", "");
        WorkflowService service = (WorkflowService)ServiceFactory.getService(WorkflowService.class);
        BpmnModel bpmnModel = service.getRepositoryService().getBpmnModel(execution.getProcessDefinitionId(), execution.getProcessInstanceId());
        FlowElement element = bpmnModel.getFlowElement(activityid);
        if (element instanceof WaitTask) {
            return this.getWaitTaskEventParamsJson(execution, (WaitTask)element);
        }
        if (element instanceof BillTask) {
            return this.getBillTaskEventParamsJson(execution, (BillTask)element);
        }
        if (element instanceof EventSupportTask) {
            return ((EventSupportTask)element).getEventParamsJson(execution);
        }
        return null;
    }

    private ObjectNode getWaitTaskEventParamsJson(ExecutionEntity execution, WaitTask element) {
        ObjectNode evtParams = element.getEventParamsJson(execution);
        return this.getTaskEventParamsJson(execution, evtParams);
    }

    private ObjectNode getBillTaskEventParamsJson(ExecutionEntity execution, BillTask billTask) {
        ObjectNode evtParams = billTask.getEventParamsJson(execution);
        return this.getTaskEventParamsJson(execution, evtParams);
    }

    private ObjectNode getTaskEventParamsJson(ExecutionEntity execution, ObjectNode evtParams) {
        Object varEvtParams;
        ObjectNode params = (ObjectNode)execution.getTransientVariable("eventParams");
        if (params == null && (varEvtParams = execution.getVariable("eventParams")) instanceof Map) {
            try {
                params = (ObjectNode)new ObjectMapper().readTree(JSON.toJSONString((Object)varEvtParams));
            }
            catch (Exception e) {
                this.log.error(String.format("Get EventParams from Execution Variables failed. %s", WfUtils.getExceptionStacktrace(e)));
            }
        }
        if (evtParams.isEmpty() || params == null || params.isEmpty()) {
            return evtParams;
        }
        Iterator iterator = evtParams.fieldNames();
        while (iterator.hasNext()) {
            String key = (String)iterator.next();
            JsonNode value = params.get(key);
            if (value == null) continue;
            evtParams.set(key, value);
        }
        return evtParams;
    }
}

