/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.workflow.engine.impl.calculator;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.TypesContainer;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.MainEntityType;
import kd.bos.exception.KDException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.ORM;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.user.UserServiceHelper;
import kd.bos.workflow.api.AgentExecution;
import kd.bos.workflow.bpmn.converter.util.CollectionUtils;
import kd.bos.workflow.bpmn.model.ActivitiListener;
import kd.bos.workflow.bpmn.model.AuditTask;
import kd.bos.workflow.bpmn.model.BpmnModel;
import kd.bos.workflow.bpmn.model.FlowElement;
import kd.bos.workflow.bpmn.model.FlowNode;
import kd.bos.workflow.bpmn.model.ParticipatantModel;
import kd.bos.workflow.bpmn.model.Process;
import kd.bos.workflow.bpmn.model.UserTask;
import kd.bos.workflow.bpmn.model.YunzhijiaTask;
import kd.bos.workflow.engine.WfUtils;
import kd.bos.workflow.engine.delegate.DelegateExecution;
import kd.bos.workflow.engine.delegate.VariableScope;
import kd.bos.workflow.engine.dynprocess.CustomizedAuditResult;
import kd.bos.workflow.engine.dynprocess.JointAuditInfo;
import kd.bos.workflow.engine.dynprocess.JointResultInfo;
import kd.bos.workflow.engine.extitf.ExtItfCallerType;
import kd.bos.workflow.engine.extitf.ExternalInterfaceUtil;
import kd.bos.workflow.engine.extitf.IWorkflowPlugin;
import kd.bos.workflow.engine.impl.calculator.ParticipantCalculator;
import kd.bos.workflow.engine.impl.calculator.PersonParticipantParser;
import kd.bos.workflow.engine.impl.calculator.PluginParticipantParser;
import kd.bos.workflow.engine.impl.calculator.PositionParticipantParser;
import kd.bos.workflow.engine.impl.calculator.RelationParticipantParser;
import kd.bos.workflow.engine.impl.calculator.RoleParticipantParser;
import kd.bos.workflow.engine.impl.cfg.ProcessEngineConfigurationImpl;
import kd.bos.workflow.engine.impl.cmd.startup.BusinessModelVariableScope;
import kd.bos.workflow.engine.impl.context.Context;
import kd.bos.workflow.engine.impl.interceptor.CommandContext;
import kd.bos.workflow.engine.impl.log.ParticipantParseProcess;
import kd.bos.workflow.engine.impl.log.RunTimeLog;
import kd.bos.workflow.engine.impl.persistence.entity.config.ParticipantModelCfgEntity;
import kd.bos.workflow.engine.impl.persistence.entity.history.HistoricActivityInstanceEntity;
import kd.bos.workflow.engine.impl.persistence.entity.history.HistoricActivityInstanceEntityManager;
import kd.bos.workflow.engine.impl.persistence.entity.history.HistoricProcessInstanceEntity;
import kd.bos.workflow.engine.impl.persistence.entity.history.HistoricProcessInstanceEntityManager;
import kd.bos.workflow.engine.impl.persistence.entity.history.HistoricTaskInstanceEntity;
import kd.bos.workflow.engine.impl.persistence.entity.history.HistoricTaskInstanceEntityManager;
import kd.bos.workflow.engine.impl.persistence.entity.history.HistoricVariableInstanceEntity;
import kd.bos.workflow.engine.impl.persistence.entity.management.ConditionalRuleEntity;
import kd.bos.workflow.engine.impl.persistence.entity.management.ParticipantModelEntity;
import kd.bos.workflow.engine.impl.persistence.entity.management.ParticipantModelEntityImpl;
import kd.bos.workflow.engine.impl.persistence.entity.monitor.worktransfer.WorksTransferLogEntity;
import kd.bos.workflow.engine.impl.persistence.entity.runtime.ExecutionEntity;
import kd.bos.workflow.engine.impl.persistence.entity.runtime.ExecutionEntityImpl;
import kd.bos.workflow.engine.impl.persistence.entity.runtime.PreComputatorExecutionEntityImpl;
import kd.bos.workflow.engine.impl.persistence.entity.task.TaskEntity;
import kd.bos.workflow.engine.impl.util.BpmnModelUtil;
import kd.bos.workflow.engine.impl.util.CollectionUtil;
import kd.bos.workflow.engine.impl.util.DynamicFlowUtil;
import kd.bos.workflow.engine.impl.util.ProcessDefinitionUtil;
import kd.bos.workflow.engine.impl.util.condition.ConditionType;
import kd.bos.workflow.engine.impl.util.condition.ConditionUtil;
import kd.bos.workflow.exception.ExceptionUtil;
import kd.bos.workflow.exception.WFErrorCode;
import kd.bos.workflow.exception.WFJointAuditResultException;
import kd.bos.workflow.exception.WFNullParticipantException;

public class ParticipantCalculatorImpl
implements ParticipantCalculator {
    private Log logger = LogFactory.getLog(this.getClass());
    private static final String ALGOKEY = "kd.bos.workflow.engine.impl.calculator.ParticipantCalculatorImpl";
    private static final String PERSON = "person";
    private static final String ROLE = "role";
    private static final String RELATION = "relation";
    private static final String PLUGIN = "plugin";
    private static final String POSITION = "position";
    protected static final String NUMBER_OF_INSTANCES = "nrOfInstances";
    protected static final String NUMBER_OF_ACTIVE_INSTANCES = "nrOfActiveInstances";
    protected static final String NUMBER_OF_COMPLETED_INSTANCES = "nrOfCompletedInstances";
    protected static Map<String, IWorkflowPlugin> parsers = new HashMap<String, IWorkflowPlugin>();
    protected static RelationParticipantParser relationParser = RelationParticipantParser.getInstance();
    protected static RoleParticipantParser roleParser = RoleParticipantParser.getInstance();
    protected static PluginParticipantParser pluginParser = PluginParticipantParser.getInstance();
    protected static PersonParticipantParser personParser = PersonParticipantParser.getInstance();
    protected static PositionParticipantParser positionParser = PositionParticipantParser.getInstance();
    protected ProcessEngineConfigurationImpl processEngineConfiguration;

    public ParticipantCalculatorImpl() {
    }

    public ParticipantCalculatorImpl(ProcessEngineConfigurationImpl processEngineConfiguration) {
        this.processEngineConfiguration = processEngineConfiguration;
        parsers.put(PERSON, new PersonParticipantParser());
    }

    private List<Long> getUserIds(ParticipantModelEntity participantModelEntity, String businessKey, VariableScope variableScope) {
        String type = participantModelEntity.getType();
        if (PLUGIN.equals(type)) {
            return pluginParser.getUsers(variableScope, participantModelEntity);
        }
        if (RELATION.equals(type)) {
            return relationParser.getUsers(variableScope, participantModelEntity, businessKey);
        }
        if (ROLE.equals(type)) {
            return roleParser.getUsers(participantModelEntity, variableScope, businessKey);
        }
        if (PERSON.equals(type)) {
            return personParser.calcUserIds(variableScope, participantModelEntity.getDynamicObject(), WfUtils.getEntityNumberFromVariableScope(variableScope), businessKey);
        }
        if (POSITION.equals(type)) {
            return positionParser.calcUserIds(variableScope, participantModelEntity.getDynamicObject(), WfUtils.getEntityNumberFromVariableScope(variableScope), businessKey);
        }
        return this.getUsersForOtherParser(participantModelEntity, businessKey, variableScope, WfUtils.getEntityNumberFromVariableScope(variableScope));
    }

    private void putUserPositionToCache(DynamicObject pme) {
        CommandContext commandContext = Context.getCommandContext();
        String userPosition = (String)pme.get("userPosition");
        if (userPosition != null) {
            Map userPositionMap = (Map)SerializationUtils.fromJsonString((String)userPosition, Map.class);
            Set userPositionEntry = userPositionMap.entrySet();
            for (Map.Entry userPositionOne : userPositionEntry) {
                Long userId = Long.valueOf((String)userPositionOne.getKey());
                Long userPositionId = (Long)userPositionOne.getValue();
                QFilter[] qFilter = new QFilter[]{new QFilter("id", "=", (Object)userPositionId)};
                DynamicObject positionDynamicObject = BusinessDataServiceHelper.loadSingle((String)"bos_userposition", (String)POSITION, (QFilter[])qFilter);
                LocaleString positionName = new LocaleString();
                if (positionDynamicObject == null) continue;
                positionName = positionDynamicObject.getLocaleString(POSITION);
            }
        }
    }

    @Override
    public List<String> getOpenIds(Long procInstId, String taskActivityId, String businessKey, VariableScope variableScope) {
        List<Long> userIdList = this.getUserIds(procInstId, taskActivityId, businessKey, variableScope, false);
        return this.getOpenIds(userIdList);
    }

    @Override
    public List<String> getOpenIds(List<Long> userIdList) {
        ArrayList<String> openidList = new ArrayList<String>();
        if (userIdList.isEmpty()) {
            return openidList;
        }
        QFilter[] filters = new QFilter[]{new QFilter("id", "in", userIdList), new QFilter("enable", "=", (Object)Character.valueOf('1'))};
        DynamicObjectCollection dc = QueryServiceHelper.query((String)ALGOKEY, (String)"bos_user", (String)"id, useropenid", (QFilter[])filters, null);
        for (DynamicObject obj : dc) {
            String openid = obj.getString("useropenid");
            if (!WfUtils.isNotEmpty(openid)) continue;
            openidList.add(openid);
        }
        return openidList;
    }

    private boolean match(ConditionalRuleEntity conditionalRule, VariableScope variableScope) {
        ConditionType.logOpDesc(conditionalRule);
        String key = ConditionUtil.getConInstKey(conditionalRule.getElementid(), "participant");
        return ConditionUtil.hasTrueCondition(conditionalRule, variableScope, key);
    }

    private String getParserClass(ParticipantModelEntity pme) {
        String type = pme.getType();
        type = String.valueOf(type.charAt(0)).toUpperCase() + type.substring(1);
        return "kd.bos.workflow.engine.impl.calculator." + type + "ParticipantParser";
    }

    @Override
    public List<Long> getUserIds(Long procInstId, String taskActivityId, String businessKey, VariableScope variableScope, boolean record) {
        List<Long> userIds = new ArrayList<Long>();
        FlowElement elem = null;
        TaskEntity task = null;
        BpmnModel bpmnModel = null;
        if (WfUtils.isEmpty(procInstId) && variableScope instanceof PreComputatorExecutionEntityImpl) {
            bpmnModel = ProcessDefinitionUtil.getBpmnModel(((PreComputatorExecutionEntityImpl)variableScope).getProcessDefinitionId(), ((PreComputatorExecutionEntityImpl)variableScope).getSchemeId(), ((PreComputatorExecutionEntityImpl)variableScope).getProcessInstanceId());
            elem = bpmnModel.getFlowElement(taskActivityId);
            task = ((PreComputatorExecutionEntityImpl)variableScope).getCurrentTask();
        } else if (variableScope instanceof ExecutionEntityImpl) {
            bpmnModel = ProcessDefinitionUtil.getBpmnModel(((ExecutionEntityImpl)variableScope).getProcessDefinitionId(), ((ExecutionEntityImpl)variableScope).getSchemeId(), ((ExecutionEntityImpl)variableScope).getProcessInstanceId());
            elem = bpmnModel.getFlowElement(taskActivityId);
            task = ((ExecutionEntityImpl)variableScope).getCurrentTask();
        } else {
            bpmnModel = ProcessDefinitionUtil.getBpmnModel(((DelegateExecution)variableScope).getProcessDefinitionId(), ((DelegateExecution)variableScope).getProcessInstanceId());
            elem = bpmnModel.getFlowElement(taskActivityId);
        }
        RunTimeLog.get().createBlock(String.format(ParticipantParseProcess.STARTPARSE.getDesc(), elem.getName()));
        List<Long> user = this.getRejectBackToNodeHandlerId(procInstId, taskActivityId, variableScope);
        if (CollectionUtils.isEmpty(user)) {
            List<Long> dynParticipants = this.getDynParticipant(procInstId, taskActivityId, businessKey, elem, variableScope);
            if (dynParticipants == null) {
                RunTimeLog.get().createBlock(ParticipantParseProcess.GETNODEPARTICIPANT.getDesc());
                List<Long> originalUsers = this.getOriginalUsers(procInstId, taskActivityId, businessKey, variableScope, record);
                userIds.addAll(originalUsers);
                RunTimeLog.get().endBlock(String.format(ParticipantParseProcess.GETNODEPARTICIPANTEND.getDesc(), originalUsers.size() == 0 ? ParticipantParseProcess.NULL.getDesc() : RunTimeLog.get().collectAndSubstitution(originalUsers, "user")));
            } else {
                int size = dynParticipants.size();
                RunTimeLog.get().createBlock(String.format(ParticipantParseProcess.DUNGETPARTICIPANTUNENABLE.getDesc(), RunTimeLog.get().collectAndSubstitution(dynParticipants, "user")));
                dynParticipants = WfUtils.filterEnableUsers(dynParticipants);
                if (dynParticipants.size() == 0 && size > 0) {
                    RunTimeLog.get().createBlock(ParticipantParseProcess.GETNODEPARTICIPANTFILTER.getDesc());
                    List<Long> originalUsers = this.getOriginalUsers(procInstId, taskActivityId, businessKey, variableScope, record);
                    userIds.addAll(originalUsers);
                    RunTimeLog.get().endBlock(String.format(ParticipantParseProcess.GETNODEPARTICIPANTEND.getDesc(), originalUsers.size() == 0 ? ParticipantParseProcess.NULL.getDesc() : RunTimeLog.get().collectAndSubstitution(originalUsers, "user")));
                } else {
                    userIds.addAll(dynParticipants);
                }
                RunTimeLog.get().endBlock();
            }
        } else {
            userIds.addAll(user);
        }
        boolean isReject = false;
        if (task != null) {
            isReject = "dismissed".equals(task.getHandleState());
        }
        if (elem != null && !isReject) {
            userIds = this.executeParticipantCalculatePlugin(userIds, variableScope, elem, bpmnModel);
        }
        userIds = this.validateUserIds(variableScope, userIds);
        RunTimeLog.get().endBlock(String.format(ParticipantParseProcess.PARTICIPANRCALCULTOREND.getDesc(), elem.getName(), userIds.size() == 0 ? ParticipantParseProcess.NULL.getDesc() : RunTimeLog.get().collectAndSubstitution(userIds, "user")));
        RunTimeLog.get().addlnFirstLog(" ");
        RunTimeLog.get().addlnFirstLog(String.format(ParticipantParseProcess.RESULT.getDesc(), elem.getName(), userIds.size() == 0 ? ParticipantParseProcess.NULL.getDesc() : RunTimeLog.get().collectAndSubstitution(userIds, "user")));
        return userIds;
    }

    private List<Long> getDynParticipant(Long procInstId, String taskActivityId, String businessKey, FlowElement elem, VariableScope variableScope) {
        boolean isSSCApproval;
        boolean bl = isSSCApproval = elem != null && "SSCApprove".equalsIgnoreCase(elem.getType());
        if (!isSSCApproval && variableScope.hasVariableIgnoreCase("dynParticipant")) {
            ArrayList<Long> userIds = new ArrayList<Long>();
            Object dynParticipant = variableScope.getVariableIgnoreCase("dynParticipant");
            String dynParticipantStr = dynParticipant == null ? "" : dynParticipant.toString();
            this.logger.debug(String.format("calcParticipantWithDynamic[%s-%s-%s-%s]", procInstId, taskActivityId, businessKey, dynParticipantStr));
            List list = SerializationUtils.fromJsonStringToList((String)dynParticipantStr, Map.class);
            List matchedList = list.stream().filter(map -> ((String)map.get("nodeId")).equals(taskActivityId)).collect(Collectors.toList());
            if (CollectionUtil.isNotEmpty(matchedList)) {
                for (Map map2 : matchedList) {
                    String[] sUserIds;
                    String strUserIds = (String)map2.get("userIds");
                    if (strUserIds == null) continue;
                    for (String userId : sUserIds = strUserIds.split(",")) {
                        if (!WfUtils.isNotEmpty(userId)) continue;
                        userIds.add(Long.parseLong(userId));
                    }
                }
                RunTimeLog.get().createBlock();
                RunTimeLog.get().endBlock(String.format(ParticipantParseProcess.DYNPARTICIPANT.getDesc(), userIds.size() == 0 ? ParticipantParseProcess.NULL.getDesc() : RunTimeLog.get().collectAndSubstitution(userIds, "user")));
                return userIds;
            }
        }
        return null;
    }

    private List<Long> getRejectBackToNodeHandlerId(Long procInstId, String taskActivityId, VariableScope variableScope) {
        boolean isNeedAgainCalculator = DynamicFlowUtil.rejectBackNeedAgainCalculatorPartcipant((ExecutionEntity)variableScope, taskActivityId);
        List<Long> userIds = new ArrayList<Long>();
        if (isNeedAgainCalculator) {
            RunTimeLog.get().createBlock(ParticipantParseProcess.REJECTBACKCALCULAYOR_1.getDesc());
            HistoricActivityInstanceEntityManager hisActivityManager = Context.getCommandContext().getHistoricActivityInstanceEntityManager();
            HistoricActivityInstanceEntity historicAct = hisActivityManager.findNodeLastActiveByProcInstIdAndActivityId(procInstId, taskActivityId);
            if (historicAct == null) {
                return null;
            }
            if (((ExecutionEntity)variableScope).getCurrentFlowElement() instanceof YunzhijiaTask) {
                userIds = this.getYunzhijiaTaskHandlerId(historicAct);
            } else if (((ExecutionEntity)variableScope).getCurrentFlowElement() instanceof AuditTask) {
                userIds = this.getAuditTaskHandlerId(historicAct);
            }
            RunTimeLog.get().endBlock(String.format(ParticipantParseProcess.REJECTBACKCALCULAYOR_4.getDesc(), userIds == null || userIds.size() == 0 ? ParticipantParseProcess.NULL.getDesc() : RunTimeLog.get().collectAndSubstitution(userIds, "user")));
        }
        return userIds;
    }

    private List<Long> getAuditTaskHandlerId(HistoricActivityInstanceEntity historicActs) {
        ArrayList<Long> userIds = new ArrayList<Long>();
        HistoricTaskInstanceEntityManager historicTaskManager = Context.getProcessEngineConfiguration().getHistoricTaskInstanceEntityManager();
        HistoricTaskInstanceEntity hiTaskInstanceEntity = (HistoricTaskInstanceEntity)historicTaskManager.findById(historicActs.getTaskId());
        userIds.add(hiTaskInstanceEntity.getAssigneeId());
        RunTimeLog.get().createBlock(String.format(ParticipantParseProcess.REJECTBACKCALCULAYOR_2.getDesc(), RunTimeLog.get().collectAndSubstitution(userIds, "user")));
        RunTimeLog.get().endBlock();
        return userIds;
    }

    private List<Long> getYunzhijiaTaskHandlerId(HistoricActivityInstanceEntity historicActs) {
        Long parentTaskId = historicActs.getParentTaskId();
        Map<String, HistoricVariableInstanceEntity> variableInstanceEntitys = Context.getCommandContext().getHistoricVariableInstanceEntityManager().findHistoricVariableInstancesByTaskIdAndVarNames(parentTaskId, "teamMembers");
        if (variableInstanceEntitys == null || variableInstanceEntitys.size() == 0) {
            return null;
        }
        RunTimeLog.get().createBlock();
        HistoricVariableInstanceEntity variableInstanceEntity = variableInstanceEntitys.get("teamMembers");
        List originalUsers = (List)WfUtils.stringToCollection((String)variableInstanceEntity.getValue(), ",");
        RunTimeLog.get().endBlock(String.format(ParticipantParseProcess.REJECTBACKCALCULAYOR_3.getDesc(), RunTimeLog.get().collectAndSubstitution(originalUsers, "user")));
        return originalUsers;
    }

    @Deprecated
    public List<Long> getRejectToBackUser(FlowElement flowNode, HistoricActivityInstanceEntity historicAct, Long procInstId, String taskActivityId, String businessKey, VariableScope variableScope) {
        return new ArrayList<Long>();
    }

    public List<Long> getRejectToBackUser(FlowElement flowNode, HistoricActivityInstanceEntity historicAct) {
        ArrayList<Long> user = new ArrayList<Long>();
        if (flowNode instanceof YunzhijiaTask) {
            user.addAll(this.getYunzhijiaTaskHandlerId(historicAct));
        } else if (flowNode instanceof AuditTask) {
            user.addAll(this.getAuditTaskHandlerId(historicAct));
        }
        return user;
    }

    public List<Long> executeParticipantCalculatePlugin(List<Long> userIds, VariableScope variableScope, FlowElement elem, BpmnModel bpmnModel) {
        Process process;
        List<ActivitiListener> processExecutionListeners;
        String type = elem.getType();
        if (!BpmnModelUtil.instanceofUserTaskExcludeSSCApprove(type)) {
            return userIds;
        }
        List<ActivitiListener> nodeExecutionListeners = elem.getExecutionListeners();
        if (CollectionUtils.isNotEmpty(nodeExecutionListeners)) {
            for (ActivitiListener activitiListener : nodeExecutionListeners) {
                if (!"calculate_participant".equals(activitiListener.getOperation())) continue;
                return this.executeListeners(activitiListener, userIds, variableScope);
            }
        }
        if (bpmnModel != null && CollectionUtils.isNotEmpty(processExecutionListeners = (process = bpmnModel.getMainProcess()).getExecutionListeners())) {
            for (ActivitiListener activitiListener : processExecutionListeners) {
                if (!"calculate_participant".equals(activitiListener.getEvent())) continue;
                return this.executeListeners(activitiListener, userIds, variableScope);
            }
        }
        return userIds;
    }

    private List<Long> getIdsFromResult(Object result) {
        ArrayList<Long> ids = new ArrayList<Long>();
        if (result instanceof List) {
            return (List)result;
        }
        if (result instanceof Object[]) {
            Object[] idArr;
            for (Object obj : idArr = (Object[])result) {
                if (obj instanceof Number) {
                    ids.add(((Number)obj).longValue());
                    continue;
                }
                if (!(obj instanceof String)) continue;
                ids.add(Long.valueOf(obj.toString()));
            }
        }
        return ids;
    }

    private List<Long> executeListeners(ActivitiListener executionListener, List<Long> userIds, VariableScope variableScope) {
        String implementation = executionListener.getImplementation();
        if (WfUtils.isEmpty(implementation)) {
            return userIds;
        }
        try {
            Map implementationMap = (Map)SerializationUtils.fromJsonString((String)implementation, HashMap.class);
            LinkedHashMap newImplementationMap = new LinkedHashMap();
            RunTimeLog.get().createBlock(String.format(ParticipantParseProcess.PLUGINCALCULATOR_6.getDesc(), implementationMap.get("type")));
            newImplementationMap.put("type", implementationMap.get("type"));
            newImplementationMap.put("microservice", Boolean.TRUE);
            newImplementationMap.put("value", implementationMap.get("value"));
            if (implementationMap.containsKey("params") && implementationMap.get("params") != null) {
                newImplementationMap.put("params", implementationMap.get("params"));
            }
            implementation = SerializationUtils.toJsonString(newImplementationMap);
            RunTimeLog.get().addlnLog(String.format(ParticipantParseProcess.PLUGINCALCULATOR_2.getDesc(), newImplementationMap.get("type"), newImplementationMap.get("value")));
            RunTimeLog.get().addlnLog(String.format(ParticipantParseProcess.PLUGINCALCULATOR_3.getDesc(), newImplementationMap.get("params")));
            Object result = ExternalInterfaceUtil.executeExtItf(ExtItfCallerType.CALCULATEPARTICIPANT, implementation, variableScope, userIds);
            userIds = this.getIdsFromResult(result);
            RunTimeLog.get().endBlock(String.format(ParticipantParseProcess.PLUGINCALCULATOR_5.getDesc(), RunTimeLog.get().collectAndSubstitution(userIds, "user")));
        }
        catch (Exception e) {
            throw new KDException(WFErrorCode.participantParseError(), new Object[]{e.getMessage()});
        }
        return userIds;
    }

    @Override
    public List<Long> validateUserIds(VariableScope variableScope, List<Long> userIds) {
        int size = userIds.size();
        ArrayList<Long> dest = new ArrayList<Long>(userIds);
        this.judgeTransferUser(variableScope, userIds);
        userIds = WfUtils.filterEnableUsers(userIds);
        if (userIds.size() == 0 && size > 0) {
            WFNullParticipantException exp;
            StringBuilder msg = new StringBuilder();
            List ubs = UserServiceHelper.getUserInfoByID(dest);
            if (ubs != null && !ubs.isEmpty()) {
                for (Map user : ubs) {
                    msg.append(user.get("name")).append('(').append(user.get("number")).append(')').append(',');
                }
            }
            if (msg.length() > 0) {
                exp = new WFNullParticipantException(null, WFErrorCode.participantEnabled(), new Object[]{msg.substring(0, msg.length() - 1)});
                throw ExceptionUtil.createWFNullParticipantException(exp, variableScope);
            }
            exp = new WFNullParticipantException(null, WFErrorCode.participantEnabled(), new Object[]{WfUtils.listToString(dest, ",")});
            throw ExceptionUtil.createWFNullParticipantException(exp, variableScope);
        }
        return userIds;
    }

    private List<Long> getOriginalUsers(Long procInstId, String taskActivityId, String businessKey, VariableScope variableScope, boolean record) {
        UserTask element;
        HistoricProcessInstanceEntityManager hisProcessInstanceMgr = Context.getProcessEngineConfiguration().getHistoricProcessInstanceEntityManager();
        HistoricProcessInstanceEntity proinstance = (HistoricProcessInstanceEntity)hisProcessInstanceMgr.findById(procInstId);
        if (proinstance == null && variableScope instanceof PreComputatorExecutionEntityImpl) {
            Long procDstId = ((ExecutionEntity)variableScope).getProcessDefinitionId();
            element = (UserTask)ProcessDefinitionUtil.getBpmnModel(procDstId, ((ExecutionEntity)variableScope).getSchemeId(), null).getFlowElement(taskActivityId);
        } else {
            element = (UserTask)ProcessDefinitionUtil.getBpmnModel(null, procInstId).getFlowElement(taskActivityId);
        }
        if (null != element) {
            List<ParticipantModelEntityImpl> pmes;
            ParticipatantModel participant = element.getParticipant();
            if (null != participant && null != (pmes = participant.getParticipant())) {
                return this.getUserIds(businessKey, variableScope, record, pmes);
            }
        } else {
            RunTimeLog.get().addlnLog(ParticipantParseProcess.GETNODEPARTICIPANTISNULL.getDesc());
        }
        return new ArrayList<Long>();
    }

    private List<Long> getUserIds(String businessKey, VariableScope variableScope, boolean record, List<? extends ParticipantModelEntity> pmes) {
        int pmesSize;
        LinkedHashSet<Long> userSet = new LinkedHashSet<Long>(16);
        ParticipantModelEntity defaultParticipantModelEntity = null;
        LinkedHashSet<Long> userSetWithNoCondition = new LinkedHashSet<Long>(16);
        int conType = -1;
        int n = pmesSize = null == pmes ? 0 : pmes.size();
        if (null != pmes && pmesSize > 0) {
            RunTimeLog.get().createBlock(ParticipantParseProcess.PARTICIPANTCONDITION.getDesc());
            for (ParticipantModelEntity participantModelEntity : pmes) {
                List<Long> rt;
                String[] participant;
                if (participantModelEntity == null) continue;
                if (participantModelEntity.getDefaultCondition() != null && participantModelEntity.getDefaultCondition().booleanValue() && pmesSize > 1) {
                    defaultParticipantModelEntity = participantModelEntity;
                    continue;
                }
                String participantDesc = participantModelEntity.getValue();
                if (participantModelEntity.getType().equals(PERSON)) {
                    participant = participantModelEntity.getValue().split(",");
                    participantDesc = RunTimeLog.get().collectAndSubstitution(Arrays.asList(participant), "user");
                } else if (participantModelEntity.getType().equals(POSITION)) {
                    participant = participantModelEntity.getValue().split(",");
                    participantDesc = RunTimeLog.get().collectAndSubstitution(Arrays.asList(participant), POSITION);
                }
                ConditionalRuleEntity conditionRule = participantModelEntity.getCondrule();
                if (conditionRule == null) {
                    RunTimeLog.get().createBlock(String.format(ParticipantParseProcess.PARTICIPANTCONDIYIONISNULL.getDesc(), participantDesc));
                    rt = this.getUserIds(participantModelEntity, businessKey, variableScope);
                    RunTimeLog.get().endBlock();
                    if (rt == null) continue;
                    userSetWithNoCondition.addAll(rt);
                    continue;
                }
                if (conType == -1) {
                    conType = 0;
                }
                RunTimeLog.get().createBlock(ParticipantParseProcess.PARTICIPANTCONDIYIONISTRUE_1.getDesc());
                if (this.match(conditionRule, variableScope)) {
                    RunTimeLog.get().appendLog(String.format(ParticipantParseProcess.PARTICIPANTCONDIYIONISTRUE.getDesc(), participantDesc));
                    rt = this.getUserIds(participantModelEntity, businessKey, variableScope);
                    RunTimeLog.get().endBlock();
                    if (rt != null) {
                        userSet.addAll(rt);
                    }
                    conType = 1;
                    continue;
                }
                RunTimeLog.get().appendLog(String.format(ParticipantParseProcess.PARTICIPANTCONDIYIONISFALSE.getDesc(), participantDesc));
                RunTimeLog.get().endBlock();
            }
            if (conType == 0 && defaultParticipantModelEntity != null) {
                String defaultparticipantDesc = defaultParticipantModelEntity.getType().equals(PERSON) ? RunTimeLog.get().collectAndSubstitution(Collections.singletonList(defaultParticipantModelEntity.getValue()), "user") : defaultParticipantModelEntity.getValue();
                RunTimeLog.get().createBlock(String.format(ParticipantParseProcess.PARTICIPANTCONDIYIONISDEFAULT.getDesc(), defaultparticipantDesc));
                List<Long> list = this.getUserIds(defaultParticipantModelEntity, businessKey, variableScope);
                RunTimeLog.get().endBlock();
                if (list != null) {
                    userSet.addAll(list);
                }
            }
            RunTimeLog.get().endBlock(ParticipantParseProcess.CONDITIONCIRCULATOREND.getDesc());
        }
        userSet.addAll(userSetWithNoCondition);
        this.logger.debug("ParticipantCalculatorImpl.getUserIds\uff1a" + userSet);
        return new ArrayList<Long>(userSet);
    }

    @Override
    public List<Long> getUserIds(String businessKey, VariableScope variableScope, List<? extends ParticipantModelEntity> pmes) {
        return this.getUserIds(businessKey, variableScope, true, pmes);
    }

    @Override
    public List<Long> getUserIdsWithPlugin(String businessKey, VariableScope variableScope, UserTask userTask, BpmnModel bpmnModel, List<? extends ParticipantModelEntity> pmes) {
        List<Long> userIds = this.getUserIds(businessKey, variableScope, pmes);
        return this.executeParticipantCalculatePlugin(userIds, variableScope, userTask, bpmnModel);
    }

    public int getParticpantCount(VariableScope variableScope) {
        return this.getParticpants(variableScope).size();
    }

    public List<Long> getParticpants(VariableScope variableScope) {
        ArrayList<Long> participants = new ArrayList<Long>();
        DelegateExecution execution = (DelegateExecution)variableScope;
        if (!(execution.getCurrentFlowElement() instanceof UserTask)) {
            String currentFlowElementId = execution.getCurrentFlowElement().getId();
            throw new KDException(WFErrorCode.illegAlargumentException(), new Object[]{ResManager.loadKDString((String)"\u5f53\u524d\u8282\u70b9\uff1a%s\uff0c\u975e\u4eba\u5de5\u8282\u70b9\u7c7b\u578b\uff0c\u65e0\u6cd5\u83b7\u53d6\u53c2\u4e0e\u4eba\u3002", (String)"ParticipantCalculatorImpl_1", (String)"bos-wf-engine", (Object[])new Object[0]), currentFlowElementId});
        }
        Long procInstId = execution.getProcessInstanceId();
        String taskActivityId = ((UserTask)execution.getCurrentFlowElement()).getId();
        String businessKey = ((ExecutionEntity)execution).getBusinessKey();
        participants.addAll(this.getUserIds(procInstId, taskActivityId, businessKey, execution, false));
        return participants;
    }

    public boolean hasCompleted(DelegateExecution execution) {
        DelegateExecution parent = execution.getParent();
        if (parent == null || !(parent.getCurrentFlowElement() instanceof YunzhijiaTask)) {
            return false;
        }
        YunzhijiaTask task = (YunzhijiaTask)parent.getCurrentFlowElement();
        Map<String, Object> variables = ((ExecutionEntity)execution).getCurrentTask().getVariablesLocal();
        String auditType = (String)variables.get("auditType");
        if ("forceReject".equals(auditType)) {
            parent.setTransientVariable("yzjParentApprovl", false);
            return true;
        }
        switch (task.getBusinessModel()) {
            case "oneVoteVeto": {
                int nrOfActiveInstances = this.getLoopVariable(parent, NUMBER_OF_ACTIVE_INSTANCES);
                if ("reject".equals(auditType) || "terminate".equals(auditType)) {
                    parent.setTransientVariable("yzjParentApprovl", false);
                    return true;
                }
                if (nrOfActiveInstances <= 0) {
                    parent.setTransientVariable("yzjParentApprovl", true);
                    return true;
                }
                return false;
            }
            case "passByOne": {
                int nrOfActiveInstances = this.getLoopVariable(parent, NUMBER_OF_ACTIVE_INSTANCES);
                if ("approve".equals(auditType)) {
                    parent.setTransientVariable("yzjParentApprovl", true);
                    return true;
                }
                if (nrOfActiveInstances <= 0) {
                    parent.setTransientVariable("yzjParentApprovl", false);
                    return true;
                }
                return false;
            }
            case "voteOnProportion": {
                int nrOfInstances = this.getLoopVariable(parent, NUMBER_OF_INSTANCES);
                int nrOfCompletedInstances = this.getLoopVariable(parent, NUMBER_OF_COMPLETED_INSTANCES);
                if (nrOfInstances <= 0 || nrOfCompletedInstances <= 0) {
                    return false;
                }
                double vp = (double)(nrOfCompletedInstances * 100) / Double.parseDouble(String.valueOf(nrOfInstances));
                if (vp >= task.getVotePercentage()) {
                    int approveResult = this.getApproveCount(parent);
                    boolean pass = WfUtils.isPassForVote(task.getPasstype(), task.getPassPercentage(), task.getPassfraction(), approveResult, nrOfCompletedInstances);
                    parent.setTransientVariable("yzjParentApprovl", pass);
                    return true;
                }
                return false;
            }
            case "voteByPassProportion": {
                int nrOfInstances = this.getLoopVariable(parent, NUMBER_OF_INSTANCES);
                int nrOfCompletedInstances = this.getLoopVariable(parent, NUMBER_OF_COMPLETED_INSTANCES);
                if (nrOfInstances <= 0 || nrOfCompletedInstances <= 0) {
                    return false;
                }
                int approveResult = this.getApproveCount(parent);
                Map<String, Boolean> result = WfUtils.isPassByPassProportion(task.getPasstype(), task.getPassPercentage(), task.getPassfraction(), approveResult, nrOfCompletedInstances, nrOfInstances);
                boolean pass = result.get("ispass");
                boolean over = result.get("isover");
                if (over) {
                    parent.setTransientVariable("yzjParentApprovl", pass);
                }
                return over;
            }
            case "allVote": {
                int nrOfActiveInstances = this.getLoopVariable(parent, NUMBER_OF_ACTIVE_INSTANCES);
                if (nrOfActiveInstances <= 0) {
                    int nrOfCompletedInstances = this.getLoopVariable(parent, NUMBER_OF_COMPLETED_INSTANCES);
                    int approveResult = this.getApproveCount(parent);
                    boolean pass = WfUtils.isPassForVote(task.getPasstype(), task.getPassPercentage(), task.getPassfraction(), approveResult, nrOfCompletedInstances);
                    parent.setTransientVariable("yzjParentApprovl", pass);
                    return true;
                }
                return false;
            }
            case "custom": {
                boolean result = false;
                int nrOfInstances = this.getLoopVariable(parent, NUMBER_OF_INSTANCES);
                int nrOfCompletedInstances = this.getLoopVariable(parent, NUMBER_OF_COMPLETED_INSTANCES);
                int nrOfActiveInstances = this.getLoopVariable(parent, NUMBER_OF_ACTIVE_INSTANCES);
                List<JointAuditInfo> auditInfo = this.getAuditInfo(parent, execution, variables);
                JointResultInfo jointResultInfo = new JointResultInfo(nrOfInstances, nrOfCompletedInstances, nrOfActiveInstances, auditInfo);
                CustomizedAuditResult customizedAuditResult = (CustomizedAuditResult)ExternalInterfaceUtil.executeExtItf(ExtItfCallerType.CUSTOMBUSINESS, task.getCustomClassName(), execution, jointResultInfo);
                result = customizedAuditResult.isPass();
                if (customizedAuditResult.isOver() || nrOfActiveInstances <= 0) {
                    parent.setTransientVariable("yzjParentApprovl", result);
                    parent.setTransientVariable("yunzhijiaResultNumber", customizedAuditResult.getResultNumber());
                    return true;
                }
                if (nrOfActiveInstances <= 0 && !customizedAuditResult.isOver()) {
                    throw new WFJointAuditResultException(ResManager.loadKDString((String)"\u81ea\u5b9a\u4e49\u4f1a\u5ba1\u4e1a\u52a1\u6a21\u5f0f\u63d2\u4ef6\u5904\u7406\u6709\u8bef\uff0c\u8bf7\u68c0\u67e5\u63d2\u4ef6\u903b\u8f91", (String)"ParticipantCalculatorImpl_34", (String)"bos-wf-engine", (Object[])new Object[0]));
                }
                return false;
            }
        }
        return false;
    }

    private List<JointAuditInfo> getAuditInfo(DelegateExecution parent, DelegateExecution execution, Map<String, Object> variables) {
        ArrayList<JointAuditInfo> jointAuditInfos = new ArrayList<JointAuditInfo>();
        ORM orm = ORM.create();
        Long parentTask = ((ExecutionEntity)parent).getCurrentTask().getId();
        DynamicObjectCollection childTasks = orm.query("wf_hitaskinst", "id", new QFilter[]{new QFilter("parenttaskid", "=", (Object)parentTask)});
        ArrayList<Long> taskIds = new ArrayList<Long>();
        for (DynamicObject task : childTasks) {
            taskIds.add(task.getLong("id"));
        }
        QFilter qf1 = new QFilter("taskid", "in", taskIds);
        DynamicObjectCollection doc = QueryServiceHelper.query((String)"wf_hicomment", (String)"message,resultnumber,decisiontype,userid", (QFilter[])new QFilter[]{qf1});
        if (doc != null && doc.size() > 0) {
            for (DynamicObject dynamicObject : doc) {
                JointAuditInfo jointAuditInfo = new JointAuditInfo(Long.valueOf(dynamicObject.getLong("userid")), dynamicObject.getString("resultnumber"), dynamicObject.getString("decisiontype"), dynamicObject.getString("message"));
                jointAuditInfos.add(jointAuditInfo);
            }
        }
        return jointAuditInfos;
    }

    private Integer getLoopVariable(DelegateExecution execution, String variableName) {
        Object value = execution.getVariableLocal(variableName);
        for (DelegateExecution parent = execution.getParent(); value == null && parent != null; parent = parent.getParent()) {
            value = parent.getVariableLocal(variableName);
        }
        return (Integer)(value != null ? value : Integer.valueOf(0));
    }

    private Integer getApproveCount(DelegateExecution execution) {
        ORM orm = ORM.create();
        Long parentTask = ((ExecutionEntity)execution).getCurrentTask().getId();
        DynamicObjectCollection childTasks = orm.query("wf_hitaskinst", "id", new QFilter[]{new QFilter("parenttaskid", "=", (Object)parentTask)});
        ArrayList<Long> taskIds = new ArrayList<Long>();
        for (DynamicObject task : childTasks) {
            taskIds.add(task.getLong("id"));
        }
        QFilter qf1 = new QFilter("taskid", "in", taskIds);
        QFilter qf2 = new QFilter("decisiontype", "=", (Object)"approve");
        DynamicObjectCollection doc = orm.query("wf_hicomment", "id", new QFilter[]{qf1, qf2});
        return doc == null ? 0 : doc.size();
    }

    @Override
    public List<Long> getNextTaskUsers(Long processDefId, Long procInstId, String taskActivityId, String businessKey, VariableScope variableScope, Map<String, String> nodeIdMapItAuditNumber, Map<String, String> nodeIdMapAgreePersonId, String lastAssign, Map<String, String> nodeIdMapExecutionType) {
        boolean isSSCApproval;
        BpmnModel bpmnModel = ProcessDefinitionUtil.getBpmnModel(processDefId, procInstId);
        UserTask elem = (UserTask)bpmnModel.getFlowElement(taskActivityId);
        ArrayList<Long> enableUserList = new ArrayList<Long>();
        Set<Object> userSet = new LinkedHashSet();
        boolean bl = isSSCApproval = elem != null && BpmnModelUtil.instanceofSSCApprover(elem.getType());
        if (!isSSCApproval && variableScope.hasVariableIgnoreCase("dynParticipant")) {
            Object dynParticipant = variableScope.getVariableIgnoreCase("dynParticipant");
            String dynParticipantStr = dynParticipant == null ? "" : dynParticipant.toString();
            this.logger.debug(String.format("calcPreParticipantWithDynamic[%s-%s-%s-%s]", procInstId, taskActivityId, businessKey, dynParticipantStr));
            List list = SerializationUtils.fromJsonStringToList((String)dynParticipantStr, Map.class);
            List matchedList = list.stream().filter(map -> ((String)map.get("nodeId")).equals(taskActivityId)).collect(Collectors.toList());
            if (matchedList.isEmpty()) {
                this.logger.debug(String.format("\u53d8\u91cf\u4e2d\u672a\u627e\u5230\u8282\u70b9[%s]\u8bbe\u7f6e\u7684\u52a8\u6001\u53c2\u4e0e\u4eba\uff0c\u4ece\u8282\u70b9\u914d\u7f6e\u4e2d\u83b7\u53d6\u53c2\u4e0e\u4eba.", taskActivityId));
                userSet = this.getNormalNextUser(businessKey, variableScope, nodeIdMapItAuditNumber, nodeIdMapAgreePersonId, lastAssign, nodeIdMapExecutionType, elem);
            } else {
                for (Map map2 : matchedList) {
                    String[] sUserIds;
                    String strUserIds = (String)map2.get("userIds");
                    if (strUserIds == null) continue;
                    for (String userId : sUserIds = strUserIds.split(",")) {
                        if (!WfUtils.isNotEmpty(userId)) continue;
                        userSet.add(Long.valueOf(userId));
                    }
                }
                this.logger.debug(String.format("\u83b7\u53d6\u5230\u52a8\u6001\u53c2\u4e0e\u4eba[%s]\uff0c", WfUtils.listToString(userSet, ",")));
                int size = userSet.size();
                List<Long> t = WfUtils.filterEnableUsers(new ArrayList<Long>(userSet));
                userSet = new LinkedHashSet<Long>(t);
                this.logger.debug(String.format("\u8fc7\u6ee4\u65e0\u6548\u53c2\u4e0e\u4eba\u540e\u5269\u4f59[%s]\uff0c", WfUtils.listToString(userSet, ",")));
                if (userSet.isEmpty() && size > 0) {
                    this.logger.debug("\u52a8\u6001\u53c2\u4e0e\u4eba\u4e3a\u7a7a\uff0c\u91cd\u65b0\u4ece\u8282\u70b9\u914d\u7f6e\u4e2d\u83b7\u53d6\u53c2\u4e0e\u4eba.");
                    userSet = this.getNormalNextUser(businessKey, variableScope, nodeIdMapItAuditNumber, nodeIdMapAgreePersonId, lastAssign, nodeIdMapExecutionType, elem);
                }
            }
        } else {
            this.logger.debug(String.format("\u8282\u70b9[%1$s-%2$s]\u65e0\u52a8\u6001\u53c2\u4e0e\u4eba\u8bbe\u7f6e\uff0c\u4ece\u8282\u70b9\u914d\u7f6e\u4e2d\u83b7\u53d6\u53c2\u4e0e\u4eba.", taskActivityId, elem.getName()));
            userSet = this.getNormalNextUser(businessKey, variableScope, nodeIdMapItAuditNumber, nodeIdMapAgreePersonId, lastAssign, nodeIdMapExecutionType, elem);
            this.logger.debug(String.format("calcParticipant[%s-%s-%s-%s]", procInstId, taskActivityId, businessKey, WfUtils.listToString(userSet, ",")));
        }
        List<Long> userList = new ArrayList<Long>(userSet);
        if (elem != null) {
            userList = this.executeParticipantCalculatePlugin(userList, variableScope, elem, bpmnModel);
        }
        Map enableUsers = UserServiceHelper.isUserEnable(userList);
        for (Long uid : userList) {
            if (enableUsers.get(uid) == null || !((Boolean)enableUsers.get(uid)).booleanValue()) continue;
            enableUserList.add(uid);
        }
        return enableUserList;
    }

    private Set<Long> getNormalNextUser(String businessKey, VariableScope variableScope, Map<String, String> nodeIdMapItAuditNumber, Map<String, String> nodeIdMapAgreePersonId, String lastAssign, Map<String, String> nodeIdMapExecutionType, UserTask elem) {
        List<Long> rt;
        List<ParticipantModelEntityImpl> pmes = elem.getParticipant().getParticipant();
        LinkedHashSet<Long> userSet = new LinkedHashSet<Long>();
        if (pmes == null) {
            return userSet;
        }
        int conType = -1;
        ParticipantModelEntity defaultParticipantModelEntity = null;
        LinkedHashSet<Long> userSetWithNoCondition = new LinkedHashSet<Long>();
        int pmesSize = null == pmes ? 0 : pmes.size();
        for (ParticipantModelEntity participantModelEntity : pmes) {
            if (participantModelEntity == null) continue;
            if (participantModelEntity.getDefaultCondition() != null && participantModelEntity.getDefaultCondition().booleanValue() && pmesSize > 1) {
                defaultParticipantModelEntity = participantModelEntity;
                continue;
            }
            String condition = participantModelEntity.getConditionExpression();
            ConditionalRuleEntity conditionRule = participantModelEntity.getCondrule();
            if (conditionRule == null) {
                List<Long> rt2 = this.getUserIdsForCalculatorNextNode(participantModelEntity, businessKey, variableScope, nodeIdMapAgreePersonId, lastAssign);
                if (rt2 == null) continue;
                userSetWithNoCondition.addAll(rt2);
                continue;
            }
            participantModelEntity.getCondrule().setExpression(ConditionUtil.handleMacroForCalculateNextNode(condition, nodeIdMapItAuditNumber, nodeIdMapAgreePersonId, lastAssign, nodeIdMapExecutionType, variableScope));
            if (conType == -1) {
                conType = 0;
            }
            if (!this.match(participantModelEntity.getCondrule(), variableScope)) continue;
            List<Long> rt2 = this.getUserIdsForCalculatorNextNode(participantModelEntity, businessKey, variableScope, nodeIdMapAgreePersonId, lastAssign);
            if (rt2 != null) {
                userSet.addAll(rt2);
            }
            conType = 1;
        }
        if (conType == 0 && defaultParticipantModelEntity != null && (rt = this.getUserIdsForCalculatorNextNode(defaultParticipantModelEntity, businessKey, variableScope, nodeIdMapAgreePersonId, lastAssign)) != null) {
            userSet.addAll(rt);
        }
        userSet.addAll(userSetWithNoCondition);
        return userSet;
    }

    private List<Long> getUserIdsForCalculatorNextNode(ParticipantModelEntity participantModelEntity, String businessKey, VariableScope variableScope, Map<String, String> nodeIdMapAgreePersonId, String lastAssign) {
        String type = participantModelEntity.getType();
        if (PLUGIN.equals(type)) {
            return pluginParser.getUsers(variableScope, participantModelEntity);
        }
        if (RELATION.equals(type)) {
            return relationParser.getUsersForCaculatorNextNode(variableScope, participantModelEntity, businessKey, nodeIdMapAgreePersonId, lastAssign);
        }
        if (ROLE.equals(type)) {
            return roleParser.getUsers(participantModelEntity, variableScope, businessKey);
        }
        if (PERSON.equals(type)) {
            return personParser.calcUserIds(variableScope, participantModelEntity.getDynamicObject(), WfUtils.getEntityNumberFromVariableScope(variableScope), businessKey);
        }
        if (POSITION.equals(type)) {
            return positionParser.calcUserIds(variableScope, participantModelEntity.getDynamicObject(), WfUtils.getEntityNumberFromVariableScope(variableScope), businessKey);
        }
        return this.getUsersForOtherParser(participantModelEntity, businessKey, variableScope, ((ExecutionEntity)variableScope).getEntityNumber());
    }

    @Override
    public boolean isYunzhjiaTaskAgree(DelegateExecution execution) {
        DelegateExecution parent = execution.getParent();
        if (parent == null || !(parent.getCurrentFlowElement() instanceof YunzhijiaTask)) {
            return false;
        }
        if (null == parent.getCurrentTask()) {
            parent = execution;
        }
        YunzhijiaTask yunzhijiaTask = (YunzhijiaTask)parent.getCurrentFlowElement();
        TaskEntity currentTask = ((ExecutionEntity)execution).getCurrentTask();
        Map<String, Object> variables = currentTask.getVariablesLocal();
        String auditType = (String)variables.get("auditType");
        String passType = yunzhijiaTask.getPasstype();
        double passPercentage = yunzhijiaTask.getPassPercentage();
        String passfraction = yunzhijiaTask.getPassfraction();
        switch (yunzhijiaTask.getBusinessModel()) {
            case "oneVoteVeto": {
                return "approve".equals(auditType);
            }
            case "passByOne": {
                return "approve".equals(auditType);
            }
            case "voteOnProportion": {
                int nrOfInstances = this.getLoopVariable(parent, NUMBER_OF_INSTANCES);
                int nrOfCompletedInstances = this.getLoopVariable(parent, NUMBER_OF_COMPLETED_INSTANCES);
                if (nrOfInstances <= 0 || nrOfCompletedInstances <= 0) {
                    return false;
                }
                double vp = (double)(nrOfCompletedInstances * 100) / Double.parseDouble(String.valueOf(nrOfInstances));
                if (vp >= yunzhijiaTask.getVotePercentage()) {
                    int approveResult = this.getApproveCount(parent);
                    return WfUtils.isPassForVote(passType, passPercentage, passfraction, approveResult, nrOfCompletedInstances);
                }
                return false;
            }
            case "voteByPassProportion": {
                int nrOfInsts = this.getLoopVariable(parent, NUMBER_OF_INSTANCES);
                int nrOfCompletedInsts = this.getLoopVariable(parent, NUMBER_OF_COMPLETED_INSTANCES);
                if (nrOfInsts <= 0 || nrOfCompletedInsts <= 0) {
                    return false;
                }
                int approveResult = this.getApproveCount(parent);
                Map<String, Boolean> result = WfUtils.isPassByPassProportion(passType, passPercentage, passfraction, approveResult, nrOfCompletedInsts, nrOfInsts);
                boolean pass = result.get("ispass");
                return pass;
            }
            case "allVote": {
                int nrOfActiveInsts = this.getLoopVariable(parent, NUMBER_OF_ACTIVE_INSTANCES);
                if (nrOfActiveInsts <= 0) {
                    int nrOfCompleteInsts = this.getLoopVariable(parent, NUMBER_OF_COMPLETED_INSTANCES);
                    int apprResult = this.getApproveCount(parent);
                    return WfUtils.isPassForVote(passType, passPercentage, passfraction, apprResult, nrOfCompleteInsts);
                }
                return false;
            }
        }
        return false;
    }

    private List<Long> getUsersForOtherParser(ParticipantModelEntity participantModelEntity, String businessKey, VariableScope variableScope, String entityNumber) {
        RunTimeLog.get().createBlock(ParticipantParseProcess.EXTENDMODLEPARTICIPANT_1.getDesc());
        if (null == participantModelEntity) {
            RunTimeLog.get().endBlock(ParticipantParseProcess.PARTICIPANTMODELISNULL.getDesc());
            return Collections.EMPTY_LIST;
        }
        String type = participantModelEntity.getType();
        if (null == type || WfUtils.isEmpty(type)) {
            RunTimeLog.get().endBlock(ParticipantParseProcess.PARTICIPANTTYPEISNULL.getDesc());
            return Collections.EMPTY_LIST;
        }
        DynamicObject pme = participantModelEntity.getDynamicObject();
        if (null == pme) {
            RunTimeLog.get().endBlock(ParticipantParseProcess.PARTICIPANTMODELDATAISNULL.getDesc());
            return Collections.EMPTY_LIST;
        }
        IWorkflowPlugin parser = parsers.get(type);
        String parserClassMatch = null;
        if (parser == null) {
            List<ParticipantModelCfgEntity> cfgs = Context.getCommandContext().getParticipantModelCfgEntityManager().getExtendParticipantModelCfgs();
            if (null != cfgs && !cfgs.isEmpty()) {
                String parserClassTemp = null;
                for (ParticipantModelCfgEntity cfg : cfgs) {
                    if (null == cfg || null == (parserClassTemp = cfg.getParser()) || WfUtils.isEmpty(parserClassTemp)) continue;
                    if (type.equals(cfg.getNumber())) {
                        parserClassMatch = cfg.getParser();
                    }
                    try {
                        Object obj = TypesContainer.createInstance((String)parserClassTemp);
                        if (obj instanceof IWorkflowPlugin) {
                            parsers.put(cfg.getNumber(), (IWorkflowPlugin)obj);
                            continue;
                        }
                        throw new KDException(WFErrorCode.participantParserNotFoundError(), new Object[0]);
                    }
                    catch (Exception e) {
                        this.logger.warn("kd.bos.workflow.engine.impl.calculator.ParticipantCalculatorImpl.getUserIds(ParticipantModelEntity, String, VariableScope) createInstance error: " + parserClassTemp);
                    }
                }
            }
            if (null == (parser = parsers.get(type)) && null == parserClassMatch) {
                parserClassMatch = this.getParserClass(participantModelEntity);
                try {
                    Object obj = TypesContainer.createInstance((String)parserClassMatch);
                    if (!(obj instanceof IWorkflowPlugin)) {
                        throw new KDException(WFErrorCode.participantParserNotFoundError(), new Object[0]);
                    }
                    parser = (IWorkflowPlugin)obj;
                    parsers.put(type, parser);
                }
                catch (Exception e) {
                    this.logger.warn("kd.bos.workflow.engine.impl.calculator.ParticipantCalculatorImpl.getUserIds(ParticipantModelEntity, String, VariableScope) createInstance error: " + parserClassMatch);
                }
            }
        }
        DynamicObject model = null;
        if (variableScope instanceof BusinessModelVariableScope) {
            model = ((BusinessModelVariableScope)variableScope).getModel();
        } else if (variableScope instanceof PreComputatorExecutionEntityImpl) {
            model = ((PreComputatorExecutionEntityImpl)variableScope).getTransientBill();
        }
        if (null == parser) {
            if (null == variableScope) {
                RunTimeLog.get().endBlock(ParticipantParseProcess.CLASSISNULL.getDesc());
                return Collections.EMPTY_LIST;
            }
            AgentExecution agentExecution = (AgentExecution)variableScope;
            if (null == model && null == (model = WfUtils.findBusinessObject(agentExecution.getBusinessKey(), agentExecution.getEntityNumber()))) {
                MainEntityType mainEntityType = EntityMetadataCache.getDataEntityType((String)entityNumber);
                model = new DynamicObject((DynamicObjectType)mainEntityType);
            }
            RunTimeLog.get().addlnLog(String.format(ParticipantParseProcess.EXTENDMODLEPARTICIPANT_2.getDesc(), parserClassMatch, participantModelEntity.getValue()));
            HashMap<String, Object> map = new HashMap<String, Object>(3);
            map.put("type", "class");
            map.put("value", parserClassMatch);
            map.put("microservice", Boolean.TRUE);
            String str = ExternalInterfaceUtil.castObjectToJSON(map);
            Object[] args = new Object[]{(AgentExecution)variableScope, pme, model};
            List re = (List)ExternalInterfaceUtil.executeExtItf(ExtItfCallerType.PARTICIPANT, str, args);
            RunTimeLog.get().endBlock(String.format(ParticipantParseProcess.EXTENDMODLEPARTICIPANT_3.getDesc(), RunTimeLog.get().collectAndSubstitution(re, "user")));
            return re;
        }
        RunTimeLog.get().addlnLog(String.format(ParticipantParseProcess.EXTENDMODLEPARTICIPANT_4.getDesc(), parser.getClass().getName(), participantModelEntity.getValue()));
        List ret = parser.calcUserIds((AgentExecution)variableScope, pme, model);
        if (null != ret && !ret.isEmpty()) {
            RunTimeLog.get().endBlock(String.format(ParticipantParseProcess.EXTENDMODLEPARTICIPANT_3.getDesc(), RunTimeLog.get().collectAndSubstitution(ret, "user")));
            this.logger.debug(String.format("[%s-%s]\u8ba1\u7b97\u7684\u53c2\u4e0e\u4eba\u662f[%s]", type, businessKey, WfUtils.listToString(ret, ",")));
            return ret;
        }
        ret = null != model ? parser.calcUserIds(pme, entityNumber, model) : parser.calcUserIds(pme, entityNumber, businessKey);
        RunTimeLog.get().endBlock(String.format(ParticipantParseProcess.EXTENDMODLEPARTICIPANT_3.getDesc(), RunTimeLog.get().collectAndSubstitution(ret, "user")));
        this.logger.debug(String.format("[%s-%s]\u8ba1\u7b97\u7684\u53c2\u4e0e\u4eba\u662f[%s]", type, businessKey, WfUtils.listToString(ret, ",")));
        return ret;
    }

    public void judgeTransferUser(VariableScope variableScope, List<Long> userIds) {
        try {
            CommandContext commandContext = Context.getCommandContext();
            this.logger.debug("judgeTransferUser no transfer");
            if (commandContext == null) {
                return;
            }
            if (variableScope instanceof ExecutionEntityImpl) {
                ExecutionEntityImpl execution = (ExecutionEntityImpl)variableScope;
                FlowElement flowElement = execution.getCurrentFlowElement();
                if (flowElement == null) {
                    return;
                }
                if (BpmnModelUtil.isFirstNodeByModel((FlowNode)flowElement) && "UserTask".equalsIgnoreCase(flowElement.getType())) {
                    List<WorksTransferLogEntity> entities = commandContext.getWorksTransferLogEntityManager().getWorksTransferLog(execution.getRootProcessInstanceId());
                    if (WfUtils.isEmptyForCollection(entities)) {
                        this.logger.debug("judgeTransferUser no transfer");
                        return;
                    }
                    Map ret = UserServiceHelper.isUserEnable(userIds);
                    if (WfUtils.isEmptyForMap(ret) || !ret.containsValue(Boolean.TRUE)) {
                        ArrayList<Long> userIdsClone = new ArrayList<Long>(userIds.size());
                        userIdsClone.addAll(userIds);
                        block2: for (Long userId : userIdsClone) {
                            for (WorksTransferLogEntity entity : entities) {
                                if (!userId.equals(entity.getOrigAuditorId())) continue;
                                userIds.remove(userId);
                                userIds.add(Long.parseLong(entities.get(0).getNewAuditorId()));
                                continue block2;
                            }
                        }
                    }
                }
            }
        }
        catch (Exception e) {
            this.logger.error("jump judgeTransferUser is error,errorInfo is :" + WfUtils.getExceptionStacktrace(e));
        }
    }
}

