/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.workflow.engine.impl.calculator;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.TypesContainer;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.ILocaleString;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.lang.Lang;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.org.OrgUnitServiceHelper;
import kd.bos.servicehelper.user.UserServiceHelper;
import kd.bos.workflow.engine.WfConfigurationUtil;
import kd.bos.workflow.engine.WfUtils;
import kd.bos.workflow.engine.delegate.VariableScope;
import kd.bos.workflow.engine.identity.ParticipantPositionEntity;
import kd.bos.workflow.engine.impl.calculator.ExpressionCalculatorUtil;
import kd.bos.workflow.engine.impl.cmd.model.FindBillSubjectByEntityNumberCmd;
import kd.bos.workflow.engine.impl.context.Context;
import kd.bos.workflow.engine.impl.interceptor.CommandContext;
import kd.bos.workflow.engine.impl.persistence.entity.management.BillSubjectModelEntity;

public class ParticipantExpressionParsing {
    private static Log logger = LogFactory.getLog(ParticipantExpressionParsing.class);
    public static final String DEFULTFORMAT = "{name}|{position}";
    public static final String POSTIONINFO = "postionInfo";
    public static final String POSITION = "position";
    public static final String ENTRYENTITY = "entryentity";

    public ParticipantExpressionParsing() {
        logger.debug("construction method");
    }

    public static ParticipantExpressionParsing getParticipantExpressionParsing() {
        return (ParticipantExpressionParsing)TypesContainer.getOrRegisterSingletonInstance((String)"kd.bos.workflow.engine.impl.calculator.ParticipantExpressionParsing");
    }

    public Map<Long, ILocaleString> getParticipantDisplayValue(DynamicObjectCollection users, VariableScope execution, ILocaleString displayInfo, String entityNumber, String businessKey) {
        logger.debug("ParticipantExpressionParsing\u2014\u2014\u2014\u2014\u2014\u2014\u2014\u2014\u2014\u2014start");
        logger.debug(String.format("first,displayInfo is %s;displayInfo string is %s", displayInfo, WfUtils.isEmpty(displayInfo) ? null : displayInfo.toString()));
        Boolean isHandle = Boolean.FALSE;
        if (WfUtils.isEmpty(displayInfo)) {
            logger.debug("second displayInfo is null,The value can be the configuration center or the default value");
            logger.debug(String.format("third, configuration center,isDisplaySetting is %s;  WfConfigurationUtil.getDisplayInfo() is %s", WfConfigurationUtil.isDisplaySetting(), WfConfigurationUtil.getDisplayInfo()));
            if (WfConfigurationUtil.isDisplaySetting() && WfUtils.isNotEmpty(WfConfigurationUtil.getDisplayInfo())) {
                logger.debug("fourth,\u914d\u7f6e\u4e2d\u5fc3\u53ef\u7528\uff0c\u4f7f\u7528\u914d\u7f6e\u4e2d\u5fc3");
                displayInfo = new LocaleString(WfConfigurationUtil.getDisplayInfo());
            } else {
                logger.debug("fourth,The configuration center is unavailable. Use the default value");
                displayInfo = new LocaleString(DEFULTFORMAT);
                isHandle = Boolean.TRUE;
            }
        }
        logger.debug(String.format("fifth,displayInfo Final value is %s", displayInfo.toString()));
        return this.parseParticipantDisplayValue(users, displayInfo, execution, isHandle, entityNumber, businessKey);
    }

    private Map<Long, ILocaleString> parseParticipantDisplayValue(DynamicObjectCollection users, ILocaleString express, VariableScope execution, Boolean isHandle, String entityNumber, String businessKey) {
        HashMap<Long, ILocaleString> resultMap = new HashMap<Long, ILocaleString>();
        List<Long> userIds = this.getUserIds(users);
        if (userIds.isEmpty()) {
            return resultMap;
        }
        List<String> keys = ExpressionCalculatorUtil.getKeywords(express.getLocaleValue());
        HashMap<Long, Map<String, ILocaleString>> usersPositionAndDptMap = new HashMap();
        if (keys.contains(POSITION) || keys.contains("dpt")) {
            usersPositionAndDptMap = this.getPostion(userIds, entityNumber, businessKey);
        }
        for (DynamicObject user : users) {
            Long userId = user.getLong("id");
            ILocaleString expressForUser = this.getExpress(express, execution, isHandle, usersPositionAndDptMap, keys, user, userId);
            expressForUser.put((Object)"GLang", (Object)expressForUser.toString());
            resultMap.put(userId, expressForUser);
        }
        return resultMap;
    }

    private ILocaleString getExpress(ILocaleString express, VariableScope execution, Boolean isHandle, Map<Long, Map<String, ILocaleString>> usersPositionAndDptMap, List<String> keys, DynamicObject user, Long userId) {
        LocaleString expressForUser = new LocaleString();
        for (Lang lang : WfUtils.getSupportLangs()) {
            expressForUser.put((Object)lang.toString(), (Object)(WfUtils.isEmpty((String)express.getItem(lang.toString())) ? express.toString() : (String)express.getItem(lang.toString())));
        }
        for (String key : keys) {
            Lang lang;
            int n;
            int n2;
            Lang[] langArray;
            if (WfUtils.isEmpty(key)) continue;
            Map<String, ILocaleString> positionAndDptMap = usersPositionAndDptMap.get(userId);
            try {
                ILocaleString value = this.getValue(execution, positionAndDptMap, key, user, userId);
                langArray = WfUtils.getSupportLangs();
                n2 = langArray.length;
                for (n = 0; n < n2; ++n) {
                    lang = langArray[n];
                    String langValue = WfUtils.isEmpty((String)value.getItem(lang.toString())) ? value.toString() : (String)value.getItem(lang.toString());
                    String expressLangValue = (String)expressForUser.getItem(lang.toString());
                    if (WfUtils.isEmpty(expressLangValue) || WfUtils.isEmpty(expressLangValue)) continue;
                    expressLangValue = WfUtils.isEmpty(langValue) ? expressLangValue.replace("{" + key + "}", "") : expressLangValue.replace("{" + key + "}", langValue);
                    expressForUser.put((Object)lang.toString(), (Object)expressLangValue);
                }
            }
            catch (Exception e) {
                langArray = WfUtils.getSupportLangs();
                n2 = langArray.length;
                for (n = 0; n < n2; ++n) {
                    lang = langArray[n];
                    if (WfUtils.isEmpty((String)expressForUser.getItem(lang.toString()))) continue;
                    expressForUser.put((Object)lang.toString(), (Object)((String)expressForUser.getItem(lang.toString())).replace("{" + key + "}", ""));
                }
                logger.warn("subjectParser key[" + key + "] error:" + WfUtils.getExceptionStacktrace(e));
            }
            for (Lang lang2 : WfUtils.getSupportLangs()) {
                String expressString = (String)expressForUser.getItem(lang2.toString());
                if (WfUtils.isEmpty(expressString)) continue;
                expressString = this.removeUselessLine(expressString, isHandle);
                expressForUser.put((Object)lang2.toString(), (Object)expressString);
            }
        }
        return expressForUser;
    }

    private List<Long> getUserIds(DynamicObjectCollection users) {
        ArrayList<Long> userIds = new ArrayList<Long>();
        if (users != null && !users.isEmpty()) {
            Iterator userIterator = users.iterator();
            while (userIterator.hasNext()) {
                DynamicObject user = (DynamicObject)userIterator.next();
                if (user == null) {
                    logger.debug(String.format("user is null,it's value:%s", user));
                    userIterator.remove();
                    continue;
                }
                userIds.add(user.getLong("id"));
            }
        }
        return userIds;
    }

    private ILocaleString getValue(VariableScope execution, Map<String, ILocaleString> positionAndDptMap, String key, DynamicObject user, Long userId) {
        LocaleString value = new LocaleString();
        boolean isModelProp = key.contains("mc");
        if (isModelProp) {
            String expressKey = "${model." + key.trim() + "}";
            Object val = ExpressionCalculatorUtil.parseValue(user, execution, expressKey, null, false);
            value = val == null ? new LocaleString() : new LocaleString(val.toString());
        } else {
            switch (key) {
                case "name": {
                    value = WfUtils.findUserName(userId);
                    break;
                }
                case "nameWithoutNumber": {
                    if (user == null || !WfUtils.isNotEmpty(user.getLocaleString("name"))) break;
                    value = user.getLocaleString("name");
                    break;
                }
                case "position": {
                    value = positionAndDptMap.get(POSITION);
                    break;
                }
                case "dpt": {
                    value = positionAndDptMap.get("dpt") == null ? this.getMainDpt(userId) : positionAndDptMap.get("dpt");
                    break;
                }
                default: {
                    value = new LocaleString(user.getString(key));
                }
            }
        }
        return value;
    }

    private ILocaleString getMainDpt(Long userId) {
        LocaleString expressOfBill = new LocaleString();
        long mainOrgId = UserServiceHelper.getUserMainOrgId((long)userId);
        QFilter qFilter = new QFilter("id", "=", (Object)mainOrgId);
        QFilter[] filters = new QFilter[]{qFilter};
        DynamicObject mainOrg = BusinessDataServiceHelper.loadSingle((String)"bos_org", (String)"name", (QFilter[])filters);
        if (mainOrg != null && WfUtils.isNotEmpty(mainOrg.getLocaleString("name"))) {
            expressOfBill = mainOrg.getLocaleString("name");
        }
        return expressOfBill;
    }

    private String removeUselessLine(String express, Boolean isHandle) {
        if (isHandle.booleanValue() && WfUtils.isNotEmpty(express)) {
            String[] expressArray = express.split("\\|");
            if (expressArray == null) {
                return express;
            }
            if (expressArray.length == 1) {
                express = expressArray[0];
            } else if (expressArray.length > 1) {
                express = WfUtils.isEmpty(expressArray[0]) ? expressArray[1] : expressArray[0] + "|" + expressArray[1];
            }
        }
        return express;
    }

    private Map<Long, Map<String, ILocaleString>> getPostion(List<Long> userIds, String entityNumber, String businessKey) {
        CommandContext commandContext = Context.getCommandContext();
        return this.getUserPresentJob(userIds, entityNumber, commandContext, businessKey);
    }

    private Map<Long, Map<String, ILocaleString>> getUserPresentJob(List<Long> userIds, String entityNumber, CommandContext commandContext, String businessKey) {
        Map<Long, Map<String, ILocaleString>> usersPresentJobMap = this.getUserPresentJobFormCache(userIds, commandContext);
        if (!userIds.isEmpty()) {
            logger.debug("\u8fd9\u4ececommandContext\u4e2d\u53d6\u4e0d\u5230\u4e86\uff0c\u8981\u6839\u636e\u5355\u636e\u6d41\u7a0b\u5c5e\u6027\u89e3\u6790");
            List userInfoList = UserServiceHelper.get(userIds, null, (String[])new String[]{POSITION, "dpt", "ispartjob"});
            for (Map userInfo : userInfoList) {
                if (userInfo == null) continue;
                List entryEntitys = userInfo.get(ENTRYENTITY) == null ? new ArrayList() : (List)userInfo.get(ENTRYENTITY);
                for (Object entryEntity : entryEntitys) {
                    HashMap<String, ILocaleString> userPositionAndDptMap = new HashMap<String, ILocaleString>(2);
                    Map entryentityMap = (Map)entryEntity;
                    if (((Boolean)entryentityMap.get("ispartjob")).booleanValue()) continue;
                    ILocaleString position = (ILocaleString)entryentityMap.get(POSITION);
                    DynamicObject orgDynamicObject = (DynamicObject)entryentityMap.get("dpt");
                    ILocaleString dpt = orgDynamicObject.getLocaleString("name");
                    userPositionAndDptMap.put("dpt", dpt);
                    userPositionAndDptMap.put(POSITION, position);
                    logger.debug(String.format("Major job; position is %s;dpt is %s", position.toString(), dpt.toString()));
                    usersPresentJobMap.put((Long)userInfo.get("id"), userPositionAndDptMap);
                }
            }
            usersPresentJobMap.putAll(this.getPositionByBillSubject(entityNumber, businessKey, userInfoList));
        }
        return usersPresentJobMap;
    }

    private Map<Long, Map<String, ILocaleString>> getUserPresentJobFormCache(List<Long> userIds, CommandContext commandContext) {
        HashMap<Long, Map<String, ILocaleString>> usersPresentJobMap = new HashMap<Long, Map<String, ILocaleString>>(userIds.size());
        Iterator<Long> userIdsIterator = userIds.iterator();
        while (userIdsIterator.hasNext()) {
            Long userId = userIdsIterator.next();
            HashMap<String, LocaleString> userPresentJobMap = new HashMap<String, LocaleString>(2);
            LocaleString position = new LocaleString();
            LocaleString dpt = new LocaleString();
            if (commandContext != null && commandContext.getUserPosoitionCache(userId) != null) {
                ParticipantPositionEntity positionEntity = commandContext.getUserPosoitionCache(userId);
                position = WfUtils.isEmpty(positionEntity.getUserPosition()) ? new LocaleString() : positionEntity.getUserPosition();
                Object object = dpt = WfUtils.isEmpty(positionEntity.getDpt()) ? new LocaleString() : positionEntity.getDpt();
            }
            if (!WfUtils.isNotEmpty((ILocaleString)position)) continue;
            userPresentJobMap.put(POSITION, position);
            userPresentJobMap.put("dpt", dpt);
            usersPresentJobMap.put(userId, userPresentJobMap);
            userIdsIterator.remove();
        }
        return usersPresentJobMap;
    }

    private Map<Long, Map<String, ILocaleString>> getPositionByBillSubject(String entityNumber, String businessKey, List<Map<String, Object>> userInfoList) {
        Map<Long, Map<String, ILocaleString>> usersPositionAndDptMap = this.getUserPositionInfo(userInfoList);
        List<Long> referOrgAllSubordinateOrgs = this.getReferOrgAllSubordinateOrgs(entityNumber, businessKey);
        if (referOrgAllSubordinateOrgs == null || referOrgAllSubordinateOrgs.isEmpty()) {
            logger.debug("referOrgAllSubordinateOrgs is null,get main");
            return usersPositionAndDptMap;
        }
        for (Map<String, Object> userInfo : userInfoList) {
            HashMap<String, ILocaleString> userPositionAndDptMap = new HashMap<String, ILocaleString>(2);
            List entryentityRows = (List)userInfo.get(ENTRYENTITY);
            Iterator entryentityRowIterator = entryentityRows.iterator();
            ArrayList<Long> userDptIds = new ArrayList<Long>(entryentityRows.size());
            HashMap<Long, Map<String, Object>> dptIdAndValueMap = new HashMap<Long, Map<String, Object>>(entryentityRows.size());
            while (entryentityRowIterator.hasNext()) {
                Map entryentityRow = (Map)entryentityRowIterator.next();
                DynamicObject dptDynamicObject = (DynamicObject)entryentityRow.get("dpt");
                Long userDptId = dptDynamicObject.getLong("id");
                if (!referOrgAllSubordinateOrgs.contains(userDptId)) continue;
                userDptIds.add(userDptId);
                dptIdAndValueMap.put(userDptId, entryentityRow);
            }
            this.setUserPositionAndMap(usersPositionAndDptMap, userInfo, userPositionAndDptMap, userDptIds, dptIdAndValueMap);
        }
        return usersPositionAndDptMap;
    }

    private void setUserPositionAndMap(Map<Long, Map<String, ILocaleString>> usersPositionAndDptMap, Map<String, Object> userInfo, Map<String, ILocaleString> userPositionAndDptMap, List<Long> userDptIds, Map<Long, Map<String, Object>> dptIdAndValueMap) {
        if (userDptIds.isEmpty()) {
            usersPositionAndDptMap.put((Long)userInfo.get("id"), userPositionAndDptMap);
            return;
        }
        if (userDptIds.size() == 1) {
            ILocaleString position = (ILocaleString)dptIdAndValueMap.get(userDptIds.get(0)).get(POSITION);
            DynamicObject dptDynamicObject = (DynamicObject)dptIdAndValueMap.get(userDptIds.get(0)).get("dpt");
            ILocaleString dptName = dptDynamicObject.getLocaleString("name");
            userPositionAndDptMap.put(POSITION, position);
            userPositionAndDptMap.put("dpt", dptName);
            usersPositionAndDptMap.put((Long)userInfo.get("id"), userPositionAndDptMap);
            logger.debug(String.format("userDptIds only one,position is %s;dptName is %s", position.toString(), dptName.toString()));
            return;
        }
        List<Long> orgIdList = this.getOrgIdList(userDptIds);
        if (orgIdList.size() == 1) {
            ILocaleString position = (ILocaleString)dptIdAndValueMap.get(orgIdList.get(0)).get(POSITION);
            DynamicObject dptDynamicObject = (DynamicObject)dptIdAndValueMap.get(orgIdList.get(0)).get("dpt");
            ILocaleString dptName = dptDynamicObject.getLocaleString("name");
            userPositionAndDptMap.put(POSITION, position);
            userPositionAndDptMap.put("dpt", dptName);
            usersPositionAndDptMap.put((Long)userInfo.get("id"), userPositionAndDptMap);
            logger.debug(String.format("There's only one left after we cut out the tissue,position is %s;dptName is %s", position.toString(), dptName.toString()));
        }
    }

    private Map<Long, Map<String, ILocaleString>> getUserPositionInfo(List<Map<String, Object>> userInfoList) {
        HashMap<Long, Map<String, ILocaleString>> usersPositionAndDptMap = new HashMap<Long, Map<String, ILocaleString>>();
        Iterator<Map<String, Object>> userInfoIterator = userInfoList.iterator();
        while (userInfoIterator.hasNext()) {
            Map<String, Object> userInfo = userInfoIterator.next();
            if (userInfo == null) continue;
            ILocaleString position = null;
            HashMap<String, ILocaleString> userPositionAndDptMap = new HashMap<String, ILocaleString>(2);
            List entryentity = (List)userInfo.get(ENTRYENTITY);
            if (entryentity == null || entryentity.isEmpty()) {
                logger.debug("\u6536\u96c6user\u804c\u4f4d\u4fe1\u606f\u65f6\uff0c\u53d1\u73b0\u804c\u4f4d\u548c\u90e8\u95e8\u6ca1\u6709\uff0c\u8fd4\u56de\u4e2anull");
                usersPositionAndDptMap.put((Long)userInfo.get("id"), userPositionAndDptMap);
                userInfoIterator.remove();
                continue;
            }
            if (entryentity.size() != 1) continue;
            Map entryentityMap = (Map)entryentity.get(0);
            position = (ILocaleString)entryentityMap.get(POSITION);
            DynamicObject orgDynamicObject = (DynamicObject)entryentityMap.get("dpt");
            ILocaleString dpt = orgDynamicObject.getLocaleString("name");
            userPositionAndDptMap.put("dpt", dpt);
            userPositionAndDptMap.put(POSITION, position);
            usersPositionAndDptMap.put((Long)userInfo.get("id"), userPositionAndDptMap);
            userInfoIterator.remove();
        }
        return usersPositionAndDptMap;
    }

    public List<Long> getOrgIdList(List<Long> userDptIds) {
        ArrayList<Long> orgIdList = new ArrayList<Long>();
        logger.debug("\u5254\u9664\u6389\u548c\u53c2\u7167\u7ec4\u7ec7\u65e0\u5173\u7684\u4eba\u5458\u4efb\u804c\u90e8\u95e8\u540e\u5269\u4e0b\u591a\u4e2a\uff0c\u9700\u8981\u8ba1\u7b97\uff0c\u90e8\u95e8\u503c\u4e3a\uff1a" + userDptIds);
        QFilter filter1 = new QFilter("org", "in", userDptIds);
        QFilter filter2 = new QFilter("view", "=", (Object)1L);
        QFilter[] filters = new QFilter[]{filter1, filter2};
        DynamicObject[] structureArray = BusinessDataServiceHelper.load((String)"bos_adminorg_structure", (String)"org,level,longnumber", (QFilter[])filters, (String)"level ASC");
        if (structureArray == null || structureArray.length < 1) {
            logger.debug("\u6839\u636e\u5254\u9664\u540e\u7684\u591a\u4e2a\u90e8\u95e8iD\uff0c\u6309\u7167level\u5012\u53d9\u67e5\uff0c\u67e5\u51fa\u6765\u4e3a\u7a7a,\u8fd4\u56deposition\u503c\u4e3a\uff1a\u7a7a");
            return orgIdList;
        }
        int level = 0;
        for (DynamicObject structureDynamicObject : structureArray) {
            int tmp = structureDynamicObject.getInt("level");
            Long orgId = structureDynamicObject.getLong("org.id");
            if (level == 0) {
                logger.debug("\u7b2c\u4e00\u6b21\u8fdb\u5165\u67e5\u627e\uff0c\u7ec4\u7ec7id\u4e3a" + orgId);
                level = tmp;
                orgIdList.add(orgId);
                continue;
            }
            if (level == tmp) {
                logger.debug("\u6709\u76f8\u7b49\u7684\u60c5\u51b5");
                orgIdList.add(orgId);
                continue;
            }
            if (level >= tmp) continue;
            logger.debug("\u627e\u5230\u4e0b\u4e00\u7ea7\u4e86\uff0c\u53ef\u4ee5\u8df3\u51fa\u4e86");
            break;
        }
        return orgIdList;
    }

    private List<Long> getReferOrgAllSubordinateOrgs(String entityNumber, String businessKey) {
        CommandContext commandContext = Context.getCommandContext();
        BillSubjectModelEntity billSubjectByEntity = new FindBillSubjectByEntityNumberCmd(entityNumber).execute(commandContext);
        Object referOrganizationValue = null;
        if (billSubjectByEntity != null) {
            String referOrganization = billSubjectByEntity.getReferOrganization();
            try {
                referOrganizationValue = ExpressionCalculatorUtil.getFieldValue(entityNumber, businessKey, referOrganization);
            }
            catch (Exception e) {
                logger.debug(String.format("ParticipantExpressionParsing.getReferOrgAllSubordinateOrgs:analysis referOrganization error:%s", WfUtils.getExceptionStacktrace(e)));
            }
            logger.debug(String.format("\u5355\u636e\u6d41\u7a0b\u5c5e\u6027\u4e2d\u7684\u53c2\u7167\u7ec4\u7ec7\u4e0d\u662f\u7a7a\uff0c\u62ff\u5230\u90a3\u4e2a\u503c,\u53c2\u7167\u7ec4\u7ec7\u5b57\u6bb5\u503c\u4e3a\uff1a%s\uff1b\u771f\u5b9e\u503c\u4e3a:%s", billSubjectByEntity, referOrganizationValue));
        }
        ArrayList<Long> orgIds = new ArrayList<Long>();
        if (null != referOrganizationValue) {
            logger.debug("\u8ba1\u7b97\u51fa\u6765\u7684\u5355\u636e\u6d41\u7a0b\u5c5e\u6027\u4e2d\u7684\u53c2\u7167\u7ec4\u7ec7\u4e0d\u662f\u7a7a,\u53c2\u7167\u7ec4\u7ec7\u503c\u4e3a\uff1a" + referOrganizationValue);
            if (referOrganizationValue instanceof Long) {
                Long person = (Long)referOrganizationValue;
                if (WfUtils.isNotEmpty(person)) {
                    orgIds.add(person);
                }
                logger.debug(String.format("\u7ec4\u7ec7\u5c5e\u4e8elong,\u8ba1\u7b97\u51fa\u6765\u7684\u53c2\u7167\u7ec4\u7ec7\u4e3a%s", orgIds));
            } else if (referOrganizationValue instanceof List) {
                orgIds.addAll((List)referOrganizationValue);
                logger.debug(String.format("\u7ec4\u7ec7\u5c5e\u4e8elist,\u8ba1\u7b97\u51fa\u6765\u7684\u53c2\u7167\u7ec4\u7ec7\u4e3a%s", orgIds));
            }
        }
        return OrgUnitServiceHelper.getAllSubordinateOrgs((String)"01", orgIds, (boolean)true);
    }
}

