/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.workflow.engine.impl.calculator;

import java.util.ArrayList;
import java.util.List;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.exception.KDException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.workflow.engine.WfUtils;
import kd.bos.workflow.engine.delegate.VariableScope;
import kd.bos.workflow.engine.extitf.IWorkflowPlugin;
import kd.bos.workflow.engine.impl.calculator.ExpressionCalculatorUtil;
import kd.bos.workflow.engine.impl.log.ParticipantParseProcess;
import kd.bos.workflow.engine.impl.log.RunTimeLog;
import kd.bos.workflow.exception.WFErrorCode;

public class PersonParticipantParser
implements IWorkflowPlugin {
    private Log log = LogFactory.getLog(this.getClass());
    private static PersonParticipantParser uniqueInstance = new PersonParticipantParser();

    protected static PersonParticipantParser getInstance() {
        return uniqueInstance;
    }

    public List<Long> calcUserIds(DynamicObject pme, String entityNumber, String businessKey) {
        return this.getUserIdsForPersonParticipant(pme);
    }

    public List<Long> calcUserIds(DynamicObject pme, String entityNumber, DynamicObject businessModel) {
        return this.getUserIdsForPersonParticipant(pme);
    }

    public List<Long> calcUserIds(VariableScope variableScope, DynamicObject pme, String entityNumber, String businessKey) {
        return this.getUserIdsForPersonParticipant(variableScope, pme, WfUtils.findBusinessObject(businessKey, entityNumber));
    }

    private List<Long> getUserIdsForPersonParticipant(DynamicObject pme) {
        return this.getUserIdsForPersonParticipant(null, pme, null);
    }

    private List<Long> getUserIdsForPersonParticipant(VariableScope variableScope, DynamicObject pme, DynamicObject bill) {
        ArrayList<Long> list = new ArrayList<Long>();
        try {
            String[] ids = pme.getString("value").split(",");
            for (int j = 0; j < ids.length; ++j) {
                String id = ids[j].trim();
                if (variableScope != null && id.matches("\\$?\\{\\s*proc\\..+?\\}")) {
                    String personId = ExpressionCalculatorUtil.contentParser(id.replace("$", ""), bill, variableScope, false);
                    if (personId != null && personId.matches("\\d+")) {
                        list.add(Long.valueOf(personId));
                        continue;
                    }
                    this.log.debug(String.format("person expression value (%s) not a valid ID format.", personId));
                    continue;
                }
                if (id.isEmpty() || list.contains(Long.valueOf(id))) continue;
                list.add(Long.valueOf(id));
            }
            RunTimeLog.get().createBlock(String.format(ParticipantParseProcess.PERSONRE.getDesc(), list.size() == 0 ? ParticipantParseProcess.NULL.getDesc() : RunTimeLog.get().collectAndSubstitution(list, "user")));
            RunTimeLog.get().endBlock();
        }
        catch (Exception e) {
            throw new KDException(WFErrorCode.participantParseError(), new Object[]{e.getMessage()});
        }
        return list;
    }
}

