/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.workflow.engine.impl.calculator;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import kd.bos.exception.KDException;
import kd.bos.workflow.engine.WfUtils;
import kd.bos.workflow.engine.delegate.VariableScope;
import kd.bos.workflow.engine.extitf.ExtItfCallerType;
import kd.bos.workflow.engine.extitf.ExternalInterfaceUtil;
import kd.bos.workflow.engine.impl.log.ParticipantParseProcess;
import kd.bos.workflow.engine.impl.log.RunTimeLog;
import kd.bos.workflow.engine.impl.persistence.entity.management.ParticipantModelEntity;
import kd.bos.workflow.engine.impl.persistence.entity.runtime.ExecutionEntity;
import kd.bos.workflow.engine.impl.persistence.entity.runtime.PreComputatorExecutionEntityImpl;
import kd.bos.workflow.exception.WFEngineException;
import kd.bos.workflow.exception.WFErrorCode;

public class PluginParticipantParser {
    private static PluginParticipantParser uniqueInstance = new PluginParticipantParser();

    private PluginParticipantParser() {
    }

    protected static PluginParticipantParser getInstance() {
        return uniqueInstance;
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected List<Long> getUsers(VariableScope variableScope, ParticipantModelEntity pme) {
        ExecutionEntity entity = null;
        String eventName = null;
        try {
            if (variableScope instanceof ExecutionEntity) {
                entity = (ExecutionEntity)variableScope;
                eventName = entity.getEventName();
                entity.setEventName(this.getEventName(entity));
            }
            RunTimeLog.get().createBlock(String.format(ParticipantParseProcess.PLUGINCALCULATOR_1.getDesc(), pme.getValue()));
            if (!WfUtils.isEmpty(pme.getValue())) {
                HashMap<String, Object> map = ExternalInterfaceUtil.castJSONToMap(pme.getValue());
                RunTimeLog.get().addlnLog(String.format(ParticipantParseProcess.PLUGINCALCULATOR_2.getDesc(), map.get("type"), map.get("value")));
                RunTimeLog.get().addlnLog(String.format(ParticipantParseProcess.PLUGINCALCULATOR_3.getDesc(), map.get("params")));
            }
            Object result = ExternalInterfaceUtil.executeExtItf(ExtItfCallerType.PARTICIPANT, pme.getValue(), variableScope);
            List<Long> list = this.getIdsFromResult(result);
            if (entity != null) {
                entity.setEventName(eventName);
            }
            return list;
        }
        catch (WFEngineException e) {
            try {
                throw e;
                catch (KDException e2) {
                    throw e2;
                }
                catch (Exception e3) {
                    throw new KDException(WFErrorCode.participantParseError(), new Object[]{e3.getMessage()});
                }
            }
            catch (Throwable throwable) {
                if (entity != null) {
                    entity.setEventName(eventName);
                }
                throw throwable;
            }
        }
    }

    private String getEventName(ExecutionEntity entity) {
        if (entity instanceof PreComputatorExecutionEntityImpl) {
            return String.format("%s_%s", "precomputation", "calculateParticipants");
        }
        return "calculateParticipants";
    }

    private List<Long> getIdsFromResult(Object result) {
        ArrayList<Long> ids = new ArrayList<Long>();
        if (result instanceof List) {
            RunTimeLog.get().endBlock(String.format(ParticipantParseProcess.PLUGINCALCULATOR_5.getDesc(), RunTimeLog.get().collectAndSubstitution((List)result, "user")));
            return (List)result;
        }
        if (result instanceof Object[]) {
            Object[] idArr;
            for (Object obj : idArr = (Object[])result) {
                if (obj instanceof Number) {
                    ids.add(((Number)obj).longValue());
                    continue;
                }
                if (!(obj instanceof String)) continue;
                ids.add(Long.valueOf(obj.toString()));
            }
        }
        RunTimeLog.get().endBlock(String.format(ParticipantParseProcess.PLUGINCALCULATOR_5.getDesc(), RunTimeLog.get().collectAndSubstitution(ids, "user")));
        return ids;
    }
}

