/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.workflow.engine.impl.calculator;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.exception.KDException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.user.UserServiceHelper;
import kd.bos.workflow.engine.WfUtils;
import kd.bos.workflow.engine.delegate.VariableScope;
import kd.bos.workflow.engine.extitf.IWorkflowPlugin;
import kd.bos.workflow.engine.impl.log.ParticipantParseProcess;
import kd.bos.workflow.engine.impl.log.RunTimeLog;
import kd.bos.workflow.exception.WFErrorCode;

public class PositionParticipantParser
implements IWorkflowPlugin {
    private Log log = LogFactory.getLog(this.getClass());
    private static PositionParticipantParser uniqueInstance = new PositionParticipantParser();

    protected static PositionParticipantParser getInstance() {
        return uniqueInstance;
    }

    public List<Long> calcUserIds(VariableScope variableScope, DynamicObject pme, String entityNumber, String businessKey) {
        return this.getUserIdsForPersonParticipant(variableScope, pme, WfUtils.findBusinessObject(businessKey, entityNumber));
    }

    private List<Long> getUserIdsForPersonParticipant(VariableScope variableScope, DynamicObject pme, DynamicObject bill) {
        this.log.debug("PositionParticipantParser_start:");
        ArrayList<Long> list = new ArrayList<Long>();
        try {
            String[] ids = pme.getString("value").split(",");
            if (WfUtils.isNotEmptyForArrays(ids)) {
                HashSet<Long> positionIds = new HashSet<Long>(ids.length);
                for (String id : ids) {
                    positionIds.add(Long.valueOf(id.trim()));
                }
                Set<Long> enablePositionIds = this.getEnablePosition(positionIds);
                Map peopleUnderPosition = UserServiceHelper.getPeopleUnderPosition(enablePositionIds);
                if (WfUtils.isNotEmptyForMap(peopleUnderPosition)) {
                    peopleUnderPosition.values().forEach(objs -> objs.forEach(obj -> list.add(obj.getLong("id"))));
                }
            }
            RunTimeLog.get().createBlock(String.format(ParticipantParseProcess.POSITIONCALCULATOR_1.getDesc(), list.size() == 0 ? ParticipantParseProcess.NULL.getDesc() : RunTimeLog.get().collectAndSubstitution(list, "user")));
            RunTimeLog.get().endBlock();
        }
        catch (Exception e) {
            this.log.debug("PositionParticipantParser_end:" + WfUtils.getExceptionStacktrace(e));
            throw new KDException(WFErrorCode.participantParseError(), new Object[]{e.getMessage()});
        }
        return list;
    }

    private Set<Long> getEnablePosition(Set<Long> positionIds) {
        HashSet<Long> ids = new HashSet<Long>(1);
        QFilter f1 = new QFilter("id", "in", positionIds);
        QFilter f2 = new QFilter("enable", "=", (Object)Character.valueOf('1'));
        DynamicObjectCollection positionObjects = QueryServiceHelper.query((String)"bos_position", (String)"id", (QFilter[])new QFilter[]{f1, f2});
        positionObjects.forEach(obj -> ids.add(obj.getLong("id")));
        return ids;
    }
}

