/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.workflow.engine.impl.calculator;

import java.lang.reflect.Constructor;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.ValueMapItem;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.user.UserServiceHelper;
import kd.bos.workflow.engine.WfUtils;
import kd.bos.workflow.engine.impl.agenda.ForkJoinUtils;
import kd.bos.workflow.engine.impl.calculator.DefaultMacroParserImpl;
import kd.bos.workflow.engine.impl.calculator.MacroParser;
import kd.bos.workflow.engine.impl.context.Context;
import kd.bos.workflow.engine.impl.persistence.entity.history.HistoricVariableInstanceEntityManager;
import kd.bos.workflow.engine.impl.persistence.entity.runtime.ExecutionEntity;
import kd.bos.workflow.engine.impl.util.ReflectUtil;
import org.apache.commons.beanutils.MethodUtils;

public class ProcessMacroParserImpl
extends DefaultMacroParserImpl
implements MacroParser {
    private Log logger = LogFactory.getLog(this.getClass());
    public static final String INITIATORNAME = "initiatorName";
    private Map<String, String> types = new LinkedHashMap<String, String>();

    public ProcessMacroParserImpl(String macro) {
        super(macro);
        this.types.put("emptyVal", ResManager.loadKDString((String)"\u7a7a", (String)"ExpressionPropUtils_12", (String)"bos-wf-engine", (Object[])new Object[0]));
        this.types.put("approve", ResManager.loadKDString((String)"\u540c\u610f", (String)"ExpressionPropUtils_13", (String)"bos-wf-engine", (Object[])new Object[0]));
        this.types.put("reject", ResManager.loadKDString((String)"\u9a73\u56de", (String)"ExpressionPropUtils_14", (String)"bos-wf-engine", (Object[])new Object[0]));
    }

    @Override
    public Object parseMacro(ExecutionEntity execution) {
        String prop = this.macro;
        if (INITIATORNAME.equalsIgnoreCase(prop)) {
            long startUserId = execution.getProcessInstance().getStartUserId();
            if (startUserId > 0L) {
                try {
                    Map user = UserServiceHelper.getUserInfoByID((long)startUserId);
                    return user != null && user.get("name") != null ? user.get("name") : "";
                }
                catch (Exception e) {
                    this.logger.warn(String.format("cannot feture user name for id[%s]", startUserId));
                    return "";
                }
            }
            return "";
        }
        if (prop.endsWith("ForkResult")) {
            String[] exps = prop.substring(0, prop.length() - "ForkResult".length()).split("\\$");
            if (exps != null && exps.length == 3) {
                String forkNode = exps[1];
                String forkNumber = ForkJoinUtils.getNumber(exps[1], execution.getProcessInstance());
                String forkFirstNode = exps[2];
                String[] variables = new String[]{forkNumber + "_" + "forkNodeEnterCycle"};
                HistoricVariableInstanceEntityManager hivarMgr = Context.getCommandContext().getHistoricVariableInstanceEntityManager();
                Map<String, Object> vals = hivarMgr.findHistoricVariableInstancesByExecutionId(execution.getProcessInstanceId(), variables);
                if (vals != null && !vals.isEmpty()) {
                    String cycle = String.valueOf(vals.get(variables[0]));
                    int cycleInt = Integer.parseInt(cycle);
                    String result = ForkJoinUtils.getItemForkResult(forkNode, forkFirstNode, cycleInt, execution.getProcessInstance());
                    if (WfUtils.isEmpty(result) && cycleInt > 1) {
                        result = ForkJoinUtils.getItemForkResult(forkNode, forkFirstNode, --cycleInt, execution.getProcessInstance());
                    }
                    this.buildEnumText(execution, result);
                    return result;
                }
                if (execution.getTransientVariable("percomputation_ctx") != null) {
                    String result = "approve";
                    this.buildEnumText(execution, result);
                    return result;
                }
            }
        } else {
            try {
                QFilter[] qs = new QFilter[]{new QFilter("number", "=", (Object)prop)};
                DynamicObject dyn = BusinessDataServiceHelper.loadSingle((String)"wf_expressionext", (String)"parseclass", (QFilter[])qs);
                if (dyn != null && dyn.getString("parseclass") != null) {
                    Class<?> cls = ReflectUtil.loadClass(dyn.getString("parseclass"));
                    Constructor<?> cst = cls.getDeclaredConstructor(String.class);
                    return MethodUtils.invokeMethod(cst.newInstance(prop), (String)"parseMacro", (Object[])new Object[]{execution});
                }
            }
            catch (Exception e) {
                this.logger.warn(WfUtils.getExceptionStacktrace(e));
            }
        }
        return "";
    }

    protected void buildEnumText(ExecutionEntity execution, String key) {
        if (execution.getTransientVariable("buildEnumMarcoMark") != null) {
            execution.removeTransientVariable("buildEnumMarcoMark");
            ArrayList<ValueMapItem> items = new ArrayList<ValueMapItem>(1);
            ValueMapItem item = new ValueMapItem();
            item.setValue(key);
            String n = this.types.get(key);
            if (n == null) {
                n = "";
            }
            item.setName((LocaleString)WfUtils.getMultiLangValue(n));
            items.add(item);
            execution.setTransientVariable("enumMarcoCombos", items);
        }
    }
}

