/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.workflow.engine.impl.calculator;

import com.alibaba.fastjson.JSONObject;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.exception.KDException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.permission.model.PersonQueryParam;
import kd.bos.permission.model.PersonQueryType;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.DispatchServiceHelper;
import kd.bos.servicehelper.user.UserServiceHelper;
import kd.bos.workflow.engine.WfConfigurationUtil;
import kd.bos.workflow.engine.WfUtils;
import kd.bos.workflow.engine.delegate.VariableScope;
import kd.bos.workflow.engine.impl.calculator.ExpressionCalculatorUtil;
import kd.bos.workflow.engine.impl.calculator.participant.IRelationParser;
import kd.bos.workflow.engine.impl.calculator.participant.ParticipantServiceFactory;
import kd.bos.workflow.engine.impl.cmd.startup.BusinessModelVariableScope;
import kd.bos.workflow.engine.impl.context.Context;
import kd.bos.workflow.engine.impl.el.ExtExpressionELResolver;
import kd.bos.workflow.engine.impl.log.ParticipantParseProcess;
import kd.bos.workflow.engine.impl.log.RunTimeLog;
import kd.bos.workflow.engine.impl.persistence.entity.management.CollaborationParam;
import kd.bos.workflow.engine.impl.persistence.entity.management.ParticipantModelEntity;
import kd.bos.workflow.engine.impl.persistence.entity.runtime.ExecutionEntity;
import kd.bos.workflow.engine.impl.persistence.entity.task.TaskEntity;
import kd.bos.workflow.engine.impl.util.CollectionUtil;
import kd.bos.workflow.engine.impl.util.FilterDimemsionsUtils;
import kd.bos.workflow.exception.WFEngineException;
import kd.bos.workflow.exception.WFErrorCode;
import kd.bos.workflow.exception.WFException;
import org.apache.commons.beanutils.MethodUtils;

public class RelationParticipantParser {
    private static final String SELF = "self";
    private static final String WF_COOPERATION_DEF = "wf_cooperation_def";
    private static final String RELTYPENUM = "reltypenum";
    private static final String SERVICENAME = "\uff1bserviceName\uff1a";
    private static final String METHODNAME = "\uff1bmethodName\uff1a";
    private static final String APPKEY = "\uff1bappKey\uff1a";
    private static final String ORGIDS = "orgIds\uff1a";
    private static final String MANAGER = "manager";
    private static final String DIRECT = "direct";
    private static final String ALL = "all";
    protected static Log logger = LogFactory.getLog(RelationParticipantParser.class);
    private static RelationParticipantParser uniqueInstance = new RelationParticipantParser();

    private RelationParticipantParser() {
    }

    protected static RelationParticipantParser getInstance() {
        return uniqueInstance;
    }

    protected List<Long> getUsers(VariableScope variableScope, ParticipantModelEntity pme, String businessKey) {
        List<Long> userIds = new ArrayList<Long>();
        try {
            String relationType;
            String entityNumber = WfUtils.getEntityNumberFromVariableScope(variableScope);
            if (WfUtils.isNotEmpty(pme.getReferencePerson())) {
                RunTimeLog.get().createBlock(String.format(ParticipantParseProcess.PARTICIPANTRELEATION_1.getDesc(), pme.getValue()));
                String relation = pme.getPersonRelation();
                String reportType = pme.getReportType();
                QFilter reportTypeFilter = new QFilter("number", "=", (Object)reportType);
                String selectProperties = "id,number,name,status,creator,enable,masterid,servicename,appkey,cloudkey,relationtypeentry.reltypenum,relationtypeentry.reltypename,relationtypeentry.apimethod";
                DynamicObject doj = BusinessDataServiceHelper.loadSingleFromCache((String)WF_COOPERATION_DEF, (String)selectProperties, (QFilter[])new QFilter[]{reportTypeFilter});
                if (doj == null) {
                    doj = BusinessDataServiceHelper.loadSingle((String)WF_COOPERATION_DEF, (String)selectProperties, (QFilter[])new QFilter[]{reportTypeFilter});
                }
                if (doj == null) {
                    throw new KDException(WFErrorCode.participantParseError(), new Object[]{String.format(ResManager.loadKDString((String)"\u627e\u4e0d\u5230\u534f\u4f5c\u7c7b\u578b\uff1a%s\u7684\u6570\u636e\u3002", (String)"RelationParticipantParser_2", (String)"bos-wf-engine", (Object[])new Object[0]), reportType)});
                }
                String serviceName = doj.getString("servicename");
                String appkey = doj.getString("appkey");
                String cloudkey = doj.getString("cloudkey");
                String methodName = "";
                DynamicObjectCollection doc = (DynamicObjectCollection)doj.get("relationtypeentry");
                for (DynamicObject o : doc) {
                    if (!WfUtils.isNotEmptyString(o.get(RELTYPENUM)) || !o.get(RELTYPENUM).equals(relation)) continue;
                    methodName = o.getString("apimethod");
                    break;
                }
                HashMap<String, Object> params = new HashMap<String, Object>();
                ArrayList<Long> orgIds = new ArrayList<Long>();
                List<Long> referencePersons = this.buildRefrencePresonAndOrg(variableScope, pme, businessKey, entityNumber, params, orgIds, null, null);
                IRelationParser parser = ParticipantServiceFactory.getInstance().getRelationParser(serviceName);
                if (!SELF.equals(relation)) {
                    RunTimeLog.get().appendLog(String.format(ParticipantParseProcess.PARTICIPANTRELEATION_24.getDesc(), RunTimeLog.get().collectAndSubstitution(orgIds, "org")));
                }
                RunTimeLog.get().appendLog(String.format(ParticipantParseProcess.PARTICIPANTRELEATION_25.getDesc(), RunTimeLog.get().collectAndSubstitution(referencePersons, "user")));
                if (parser != null) {
                    Object result;
                    params.put("orgIds", orgIds);
                    params.put("reportTypeId", pme.getReportTo());
                    logger.debug("\u83b7\u53d6\u53c2\u4e0e\u4eba\u8c03\u7528\u63a5\u53e3\uff0ccloudkey\uff1a" + cloudkey + APPKEY + appkey + SERVICENAME + serviceName + METHODNAME + methodName + "\uff1b\u989d\u5916\u53c2\u6570\uff1a" + WfUtils.mapToString(params));
                    if (businessKey == null) {
                        businessKey = " ";
                    }
                    if ((result = MethodUtils.invokeMethod((Object)parser, (String)methodName, (Object[])new Object[]{referencePersons, businessKey, entityNumber, params})) instanceof List) {
                        userIds = (List)result;
                    }
                } else {
                    List<CollaborationParam> collaborationParams = pme.getCollaborationParams();
                    DynamicObject billObj = null;
                    if (WfUtils.isEmpty(businessKey) && variableScope instanceof BusinessModelVariableScope) {
                        billObj = ((BusinessModelVariableScope)variableScope).getModel();
                    } else {
                        billObj = WfUtils.findBusinessObject(businessKey, entityNumber);
                        if (billObj == null) {
                            billObj = Context.getCommandContext().getParsedBusinessObject();
                        }
                    }
                    if (billObj == null) {
                        return userIds;
                    }
                    HashMap<String, Object> extraParams = new HashMap<String, Object>();
                    for (CollaborationParam i : collaborationParams) {
                        String number = i.getNumber();
                        if (WfUtils.isEmpty(number)) continue;
                        String expression = i.getValueExpression();
                        logger.debug("\u89e3\u6790\u989d\u5916\u53c2\u6570\uff0c\u53c2\u6570\u540d\u79f0\uff1a" + number + ",\u503c\uff1a" + expression);
                        if (WfUtils.isNotEmpty(expression)) {
                            Object val = expression;
                            if (!"1".equals(i.getValueFormat()) && expression.startsWith("${")) {
                                val = ExpressionCalculatorUtil.parseValue(billObj, variableScope, expression, null);
                                extraParams.put(number, val);
                                continue;
                            }
                            switch (i.getParamType()) {
                                case "datetime": {
                                    if (val instanceof String) {
                                        val = new Date((String)val);
                                        break;
                                    }
                                    if (val instanceof Date) break;
                                    throw new Exception(String.format(ResManager.loadKDString((String)"val\u7c7b\u578b\u5e94\u8be5\u4e3a\u65e5\u671f\u7c7b\u578b\uff0c\u4f46\u662f\u4e0d\u80fd\u8f6c\u6362\u6210\u65e5\u671f\uff1bval=%s", (String)"RelationParticipantParser_3", (String)"bos-wf-engine", (Object[])new Object[0]), val));
                                }
                                case "boolean": {
                                    if (val instanceof String) {
                                        val = Boolean.valueOf((String)val);
                                        break;
                                    }
                                    if (val instanceof Boolean) break;
                                    throw new Exception(String.format(ResManager.loadKDString((String)"val\u7c7b\u578b\u5e94\u8be5\u4e3aBoolean\u7c7b\u578b\uff0c\u4f46\u662f\u4e0d\u80fd\u8f6c\u6362\u6210Boolean\uff1bval=%s", (String)"RelationParticipantParser_4", (String)"bos-wf-engine", (Object[])new Object[0]), val));
                                }
                                case "text": {
                                    if (val instanceof String) break;
                                    val = val.toString();
                                    break;
                                }
                                case "decimal": {
                                    if (val instanceof String) {
                                        val = new BigDecimal((String)val);
                                        break;
                                    }
                                    if (val instanceof Number) break;
                                    throw new Exception(String.format(ResManager.loadKDString((String)"val\u7c7b\u578b\u5e94\u8be5\u4e3a\u6570\u5b57\u7c7b\u578b\uff0c\u4f46\u662f\u4e0d\u80fd\u8f6c\u6362\u6210\u6570\u5b57\uff1bval=%s", (String)"RelationParticipantParser_5", (String)"bos-wf-engine", (Object[])new Object[0]), val));
                                }
                                case "entityobject": {
                                    val = WfUtils.findBusinessObject(JSONObject.parseObject((String)val.toString()).get((Object)"id").toString(), i.getEntityObjectType());
                                    if (val != null) break;
                                    throw new Exception(String.format(ResManager.loadKDString((String)"val\u7c7b\u578b\u5e94\u8be5\u4e3a\u5bf9\u8c61\u7c7b\u578b\uff0c\u51fa\u73b0\u5f02\u5e38\uff1bval=%s", (String)"RelationParticipantParser_6", (String)"bos-wf-engine", (Object[])new Object[0]), val));
                                }
                            }
                            extraParams.put(number, val);
                            continue;
                        }
                        extraParams.put(number, expression);
                    }
                    params.put("parameters", extraParams);
                    params.put("referencePersons", referencePersons);
                    params.put("businesskey", businessKey);
                    params.put("entityNumber", entityNumber);
                    logger.debug("\u83b7\u53d6\u53c2\u4e0e\u4eba\u8c03\u7528\u63a5\u53e3\uff0ccloudkey\uff1a" + cloudkey + APPKEY + appkey + SERVICENAME + serviceName + METHODNAME + methodName + "\uff1b\u53c2\u6570\uff1a" + WfUtils.mapToString(params));
                    Object result = DispatchServiceHelper.invokeBizService((String)cloudkey, (String)appkey, (String)serviceName, (String)methodName, (Object[])new Object[]{referencePersons, businessKey, entityNumber, extraParams});
                    if (result instanceof List) {
                        userIds = (List)result;
                    }
                }
            } else if (WfUtils.isNotEmpty(pme.getReferenceOrg())) {
                List<Long> orgIds = this.getReferenceOrgs(pme.getReferenceOrg(), entityNumber, businessKey, variableScope);
                RunTimeLog.get().createBlock(String.format(ParticipantParseProcess.PARTICIPANTRELEATION_2.getDesc(), pme.getValue(), RunTimeLog.get().collectAndSubstitution(orgIds, "org")));
                if (0 != orgIds.size()) {
                    for (Long orgId : orgIds) {
                        userIds.addAll(this.getUserIdsByOrg(orgId, pme.getOrgRelation()));
                    }
                }
            } else if (WfUtils.isNotEmpty(pme.getValue()) && "org".equals(relationType = pme.getRelationType()) && pme.getValue().matches("\\d+")) {
                Long orgId = Long.valueOf(pme.getValue());
                userIds.addAll(this.getUserIdsByOrg(orgId, pme.getOrgRelation()));
            }
        }
        catch (Exception e) {
            if (e instanceof WFEngineException) {
                throw (WFEngineException)((Object)e);
            }
            throw new KDException(WFErrorCode.participantParseError(), new Object[]{e.getMessage()});
        }
        RunTimeLog.get().endBlock(String.format(ParticipantParseProcess.PARTICIPANTRELEATION_3.getDesc(), pme.getValue(), userIds.size() == 0 ? ParticipantParseProcess.NULL.getDesc() : RunTimeLog.get().collectAndSubstitution(userIds, "user")));
        logger.debug(String.format("userIds [%s]", userIds));
        return userIds;
    }

    private List<Long> buildRefrencePresonAndOrg(VariableScope variableScope, ParticipantModelEntity pme, String businessKey, String entityNumber, Map<String, Object> extraParams, List<Long> orgIds, Map<String, String> nodeIdMapAgreePersonId, String lastAssign) {
        List<Long> referencePersons = new ArrayList<Long>();
        String referencePerson = pme.getReferencePerson();
        int underlineIndex = referencePerson.indexOf(95);
        String prefix = referencePerson.substring(0, underlineIndex + 1);
        String referencePersonWithoutPrefix = referencePerson.substring(underlineIndex + 1);
        if (!SELF.equals(pme.getPersonRelation())) {
            orgIds.addAll(this.getReferenceOrgs(pme.getReferenceOrg(), entityNumber, businessKey, variableScope));
        }
        if (CollectionUtil.isEmpty(orgIds)) {
            orgIds.add(0L);
        }
        if ("ENTI_".equals(prefix)) {
            Object personObj = ExpressionCalculatorUtil.getFieldValue(entityNumber, businessKey, referencePersonWithoutPrefix);
            if (null != personObj) {
                if (personObj instanceof Long) {
                    Long person = (Long)personObj;
                    if (WfUtils.isNotEmpty(person)) {
                        referencePersons.add(person);
                    }
                } else if (personObj instanceof List) {
                    referencePersons.addAll((List)personObj);
                } else if (personObj instanceof String) {
                    try {
                        referencePersons.add(Long.valueOf((String)personObj));
                    }
                    catch (Exception e) {
                        logger.error(WfUtils.getExceptionStacktrace(e));
                    }
                }
            }
            logger.debug(String.format("\u83b7\u53d6\u53c2\u4e0e\u4eba\u8c03\u7528\u63a5\u53e3\uff0c\u83b7\u53d6\u53c2\u7167\u4eba\uff1abusinessKey\uff1a%1$s\uff0c\u5b57\u6bb5\u540d\uff1a%2$s:%3$s%4$s\u53c2\u7167\u4eba\uff1a%5$s", businessKey, "ENTI_", ORGIDS, WfUtils.listToString(orgIds, ","), WfUtils.listToString(referencePersons, ",")));
        } else if ("ENTRY_".equals(prefix)) {
            String fieldWithEntryKey = referencePersonWithoutPrefix + " id ";
            DynamicObjectCollection collection = ExpressionCalculatorUtil.getEntryFieldValue(entityNumber, fieldWithEntryKey, businessKey);
            if (null != collection && !collection.isEmpty()) {
                String fieldWithoutPrefix = ExpressionCalculatorUtil.removeFieldPrefix(fieldWithEntryKey);
                String[] props = ExpressionCalculatorUtil.getPropsFromField(fieldWithoutPrefix);
                boolean isMulBasedataPropForEntry = ExpressionCalculatorUtil.isMulBasedataPropForEntry(entityNumber, props);
                if (isMulBasedataPropForEntry) {
                    referencePersons.addAll(ExpressionCalculatorUtil.getObjIdsForMulbaseDataProp(collection));
                } else {
                    Long person = null;
                    if (1 == orgIds.size()) {
                        for (DynamicObject obj : collection) {
                            person = (Long)obj.get("id");
                            if (!WfUtils.isNotEmpty(person)) continue;
                            referencePersons.add(person);
                        }
                    } else {
                        for (int i = 0; i < collection.size(); ++i) {
                            person = (Long)((DynamicObject)collection.get(i)).get("id");
                            if (!WfUtils.isNotEmpty(person)) continue;
                            referencePersons.add(person);
                        }
                    }
                }
            }
            logger.debug(String.format("\u83b7\u53d6\u53c2\u4e0e\u4eba\u8c03\u7528\u63a5\u53e3\uff0c\u83b7\u53d6\u53c2\u7167\u4eba\uff1abusinessKey\uff1a%1$s\uff0c\u5b57\u6bb5\u540d\uff1a%2$s:%3$s%4$s\u53c2\u7167\u4eba\uff1a%5$s", businessKey, "ENTRY_", ORGIDS, WfUtils.listToString(orgIds, ","), WfUtils.listToString(referencePersons, ",")));
        } else if ("PROC_".equals(prefix)) {
            logger.debug(String.format("referencePersonWithoutPrefix [%s]", referencePersonWithoutPrefix));
            if ("currentParticipant".equals(referencePersonWithoutPrefix) && variableScope instanceof ExecutionEntity) {
                TaskEntity task = ((ExecutionEntity)variableScope).getCurrentTask();
                logger.debug(String.format("execution[%s], task[%s]", ((ExecutionEntity)variableScope).getId(), task));
                String person = null;
                if (task != null && WfUtils.isNotEmptyString(person = (String)task.getVariable("currentParticipant"))) {
                    logger.debug(String.format("persion [%s] ", person));
                    for (String p : person.split("\\,")) {
                        if (!WfUtils.isNotEmpty(p)) continue;
                        referencePersons.add(Long.valueOf(p.trim()));
                    }
                }
            }
            Object value = null;
            if ("lastAssignee".equals(referencePersonWithoutPrefix) && WfUtils.isNotEmpty(lastAssign)) {
                value = lastAssign;
            } else {
                value = ExpressionCalculatorUtil.getVariableValue(variableScope, referencePersonWithoutPrefix);
                if (WfUtils.isEmptyString(value) && referencePersonWithoutPrefix.endsWith("Assignee") && nodeIdMapAgreePersonId != null) {
                    String uid = nodeIdMapAgreePersonId.get(referencePersonWithoutPrefix.substring(0, referencePersonWithoutPrefix.length() - 8));
                    Object object = value = WfUtils.isEmpty(uid) ? "" : uid;
                }
            }
            if (WfUtils.isNotEmptyString(value)) {
                referencePersons.addAll(this.splitValueToList(value));
            }
            logger.debug(String.format("\u83b7\u53d6\u53c2\u4e0e\u4eba\u8c03\u7528\u63a5\u53e3\uff0c\u83b7\u53d6\u53c2\u7167\u4eba\uff1abusinessKey\uff1a%1$s\uff0c\u5b57\u6bb5\u540d\uff1a%2$s:%3$s%4$s%5$s\u53c2\u7167\u4eba\uff1a%6$s", businessKey, "PROC_", prefix, ORGIDS, WfUtils.listToString(orgIds, ","), WfUtils.listToString(referencePersons, ",")));
        } else {
            if ("proc.currentParticipant".equals(referencePerson) && variableScope instanceof ExecutionEntity) {
                String person;
                TaskEntity task = ((ExecutionEntity)variableScope).getCurrentTask();
                if (task != null && WfUtils.isNotEmptyString(person = (String)task.getVariable("currentParticipant"))) {
                    for (String p : person.split("\\,")) {
                        if (!WfUtils.isNotEmpty(p)) continue;
                        referencePersons.add(Long.valueOf(p.trim()));
                    }
                }
                return referencePersons;
            }
            if ("proc.lastAssignee".equals(referencePerson) && WfUtils.isNotEmpty(lastAssign)) {
                referencePersons.addAll(this.splitValueToList(lastAssign));
                return referencePersons;
            }
            referencePersons = FilterDimemsionsUtils.extractExpressField(referencePerson, businessKey, entityNumber, variableScope);
            if (WfUtils.isEmptyForCollection(referencePersons) && referencePerson.startsWith("proc.") && referencePerson.endsWith("Assignee") && nodeIdMapAgreePersonId != null) {
                String nodeId = referencePerson.substring(5, referencePerson.length() - 8);
                String uid = nodeIdMapAgreePersonId.get(nodeId);
                referencePersons.addAll(this.splitValueToList(uid));
                return referencePersons;
            }
            logger.debug("\u8868\u8fbe\u5f0f\u83b7\u53d6\u5230\u7684\u53c2\u7167\u4ebaid:" + WfUtils.listToString(referencePersons, ","));
        }
        return referencePersons;
    }

    private Collection<Long> splitValueToList(Object value) {
        ArrayList<Long> referencePersons = new ArrayList<Long>();
        if (WfUtils.isEmptyString(value)) {
            return referencePersons;
        }
        String person = String.valueOf(value);
        for (String p : person.split(",")) {
            Long personId = Long.valueOf(p.trim());
            if (!WfUtils.isNotEmpty(personId)) continue;
            referencePersons.add(personId);
        }
        return referencePersons;
    }

    private List<Long> getReferenceOrgs(String referenceOrg, String entityNumber, String businessKey, VariableScope variableScope) {
        List<Long> orgIds = new ArrayList<Long>();
        if (WfUtils.isNotEmpty(referenceOrg)) {
            int underlineIndexForOrg;
            if (referenceOrg.startsWith("{")) {
                JSONObject parseObject = JSONObject.parseObject((String)referenceOrg);
                String selectType = (String)parseObject.get((Object)"selectType");
                String parseInfo = (String)parseObject.get((Object)"parseInfo");
                if (!"2".equals(selectType)) {
                    orgIds = FilterDimemsionsUtils.parseOptionData(selectType, parseInfo, businessKey, entityNumber, variableScope);
                    logger.debug("\u901a\u8fc7json\u89e3\u6790\u5f97\u5230\u7684\u7ec4\u7ec7id\u96c6\u5408:" + WfUtils.listToString(orgIds, ","));
                    return orgIds;
                }
                referenceOrg = parseInfo;
            }
            if ((underlineIndexForOrg = referenceOrg.indexOf(95)) > -1) {
                String prefixForOrg = referenceOrg.substring(0, underlineIndexForOrg + 1);
                String referenceOrgWithoutPrefixForOrg = referenceOrg.substring(underlineIndexForOrg + 1);
                String extProp = "";
                if (referenceOrgWithoutPrefixForOrg.indexOf(".mc_") > -1) {
                    String[] parts = referenceOrgWithoutPrefixForOrg.split(".mc_");
                    referenceOrgWithoutPrefixForOrg = referenceOrgWithoutPrefixForOrg.substring(0, referenceOrgWithoutPrefixForOrg.indexOf(".mc_"));
                    extProp = "mc_" + parts[parts.length - 1];
                }
                if ("ENTI_".equals(prefixForOrg)) {
                    Object org = ExpressionCalculatorUtil.getFieldValue(entityNumber, businessKey, referenceOrgWithoutPrefixForOrg);
                    if (null != org) {
                        if (org instanceof Long) {
                            Long orgId = (Long)org;
                            if (WfUtils.isNotEmpty(orgId)) {
                                if (WfUtils.isNotEmpty(extProp)) {
                                    orgIds.addAll(this.getExtOrg(extProp, org, variableScope));
                                } else {
                                    orgIds.add(orgId);
                                }
                            }
                        } else if (org instanceof List) {
                            if (WfUtils.isNotEmpty(extProp)) {
                                orgIds.addAll(this.getExtOrg(extProp, org, variableScope));
                            } else {
                                orgIds.addAll((List)org);
                            }
                        }
                    }
                    logger.debug(String.format("\u83b7\u53d6\u53c2\u4e0e\u4eba\u8c03\u7528\u63a5\u53e3\uff0c\u83b7\u53d6\u53c2\u7167\u7ec4\u7ec7\uff1abusinessKey\uff1a%1$s\uff0c\u5b57\u6bb5\u540d\uff1a%2$s:%3$s%4$s%5$s", businessKey, "ENTI_", prefixForOrg, ORGIDS, WfUtils.listToString(orgIds, ",")));
                } else if ("ENTRY_".equals(prefixForOrg)) {
                    DynamicObjectCollection collection = ExpressionCalculatorUtil.getEntryFieldValue(entityNumber, referenceOrgWithoutPrefixForOrg + " id ", businessKey);
                    if (null != collection && !collection.isEmpty()) {
                        if (WfUtils.isNotEmpty(extProp)) {
                            orgIds.addAll(this.getExtOrg(extProp, collection, variableScope));
                        } else {
                            for (DynamicObject obj : collection) {
                                Long org = (Long)obj.get("id");
                                if (org == null) continue;
                                orgIds.add(org);
                            }
                        }
                    }
                    logger.debug(String.format("\u83b7\u53d6\u53c2\u4e0e\u4eba\u8c03\u7528\u63a5\u53e3\uff0c\u83b7\u53d6\u53c2\u7167\u7ec4\u7ec7\uff1abusinessKey\uff1a%1$s\uff0c\u5b57\u6bb5\u540d\uff1a%2$s:%3$s%4$s%5$s", businessKey, "ENTRY_", prefixForOrg, ORGIDS, WfUtils.listToString(orgIds, ",")));
                }
            }
        }
        return orgIds;
    }

    private List<Long> getExtOrg(String extProp, Object param, VariableScope variableScope) {
        ArrayList<Long> extOrgList = new ArrayList<Long>();
        Object extOrg = ExtExpressionELResolver.invokeExtPropParseMethod(extProp, variableScope, param);
        if (WfUtils.isNotEmptyString(extOrg)) {
            String extOrgStr = extOrg.toString();
            if (extOrgStr.contains(",")) {
                String[] extOrgArr;
                for (String s : extOrgArr = extOrgStr.split(",")) {
                    Long tmp = Long.parseLong(s);
                    if (tmp == null || tmp.equals(0L)) continue;
                    extOrgList.add(tmp);
                }
            } else {
                Long tmp = Long.parseLong(extOrgStr);
                if (tmp != null && !tmp.equals(0L)) {
                    extOrgList.add(tmp);
                }
            }
        }
        return extOrgList;
    }

    private List<Long> getUserIdsByOrg(Long referenceOrgId, String orgRelation) {
        try {
            List<Long> userIds = new ArrayList<Long>();
            if (referenceOrgId == null || referenceOrgId == 0L || WfUtils.isEmpty(orgRelation)) {
                return userIds;
            }
            String resultForHelper = null;
            PersonQueryType queryType = null;
            StringBuilder log = new StringBuilder();
            log.append(String.format("RelationParticipantParser getUserIdsByOrg:orgId:[%s]", referenceOrgId));
            RunTimeLog.get().createBlock(String.format(ParticipantParseProcess.RELATIONPARTICIPANTPARSER_1.getDesc(), RunTimeLog.get().collectAndSubstitution(Collections.singletonList(referenceOrgId), "org")));
            switch (orgRelation) {
                case "manager": {
                    queryType = PersonQueryType.MANAGER_OF_ORG;
                    RunTimeLog.get().appendLog(ParticipantParseProcess.RELATIONPARTICIPANTPARSER_2.getDesc());
                    break;
                }
                case "direct": {
                    queryType = PersonQueryType.ALL_OF_ORG;
                    RunTimeLog.get().appendLog(ParticipantParseProcess.RELATIONPARTICIPANTPARSER_3.getDesc());
                    break;
                }
                case "all": {
                    queryType = PersonQueryType.ALL_OF_ORG_INCLUDE_SUB;
                    RunTimeLog.get().appendLog(ParticipantParseProcess.RELATIONPARTICIPANTPARSER_4.getDesc());
                    break;
                }
            }
            log.append(String.format("orgRelation[%s]", queryType));
            if (null != queryType) {
                PersonQueryParam param = new PersonQueryParam();
                param.setOrgId(referenceOrgId.longValue());
                param.setUserId(0L);
                param.setQueryType(queryType);
                param.setQuerySuperior(WfConfigurationUtil.getQuerySuperWhenOrgManager());
                log.append(String.format("QuerySuperior[%s]", param.isQuerySuperior()));
                RunTimeLog.get().appendLog(String.format(ParticipantParseProcess.RELATIONPARTICIPANTPARSER_6.getDesc(), param.isQuerySuperior() ? ParticipantParseProcess.OPEN.getDesc() : ParticipantParseProcess.CLOSE.getDesc()));
                userIds = UserServiceHelper.getPerson((PersonQueryParam)param);
                resultForHelper = param.getErrorMsg();
            }
            log.append(String.format("resultForHelper[%s],userIds[%s]", resultForHelper, WfUtils.listToString(userIds, ",")));
            logger.debug(log.toString());
            RunTimeLog.get().appendLog(String.format(ParticipantParseProcess.RELATIONPARTICIPANTPARSER_5.getDesc(), RunTimeLog.get().collectAndSubstitution(userIds, "user")));
            RunTimeLog.get().endBlock();
            return userIds;
        }
        catch (Exception e) {
            throw new WFException(e, WFErrorCode.engineError(), e.getMessage());
        }
    }

    protected List<Long> getUsersForCaculatorNextNode(VariableScope variableScope, ParticipantModelEntity pme, String businessKey, Map<String, String> nodeIdMapAgreePersonId1, String lastAssign) {
        List<Long> userIds = new ArrayList<Long>();
        try {
            List<Long> orgIds;
            String entityNumber = ((ExecutionEntity)variableScope).getEntityNumber();
            if (WfUtils.isNotEmpty(pme.getReferencePerson())) {
                String relation = pme.getPersonRelation();
                String selectProperties = "id,number,name,status,creator,enable,masterid,servicename,appkey,cloudkey,relationtypeentry.reltypenum,relationtypeentry.reltypename,relationtypeentry.apimethod";
                String reportType = pme.getReportType();
                QFilter reportTypeFilter = new QFilter("number", "=", (Object)reportType);
                DynamicObject doj = BusinessDataServiceHelper.loadSingleFromCache((String)WF_COOPERATION_DEF, (String)selectProperties, (QFilter[])new QFilter[]{reportTypeFilter});
                if (doj == null) {
                    doj = BusinessDataServiceHelper.loadSingle((String)WF_COOPERATION_DEF, (String)selectProperties, (QFilter[])new QFilter[]{reportTypeFilter});
                }
                if (doj == null) {
                    throw new KDException(WFErrorCode.participantParseError(), new Object[]{String.format(ResManager.loadKDString((String)"\u627e\u4e0d\u5230\u534f\u4f5c\u7c7b\u578b\uff1a%s\u7684\u6570\u636e\u3002", (String)"RelationParticipantParser_2", (String)"bos-wf-engine", (Object[])new Object[0]), reportType)});
                }
                String serviceName = doj.getString("servicename");
                String appkey = doj.getString("appkey");
                String cloudkey = doj.getString("cloudkey");
                String methodName = "";
                DynamicObjectCollection doc = (DynamicObjectCollection)doj.get("relationtypeentry");
                for (DynamicObject o : doc) {
                    if (!WfUtils.isNotEmptyString(o.get(RELTYPENUM)) || !o.get(RELTYPENUM).equals(relation)) continue;
                    methodName = o.getString("apimethod");
                    break;
                }
                HashMap<String, Object> params = new HashMap<String, Object>();
                ArrayList<Long> orgIds2 = new ArrayList<Long>();
                List<Long> referencePersons = this.buildRefrencePresonAndOrg(variableScope, pme, businessKey, entityNumber, params, orgIds2, nodeIdMapAgreePersonId1, lastAssign);
                IRelationParser parser = ParticipantServiceFactory.getInstance().getRelationParser(serviceName);
                if (parser != null) {
                    params.put("orgIds", orgIds2);
                    params.put("reportTypeId", pme.getReportTo());
                    logger.debug("\u83b7\u53d6\u53c2\u4e0e\u4eba\u8c03\u7528\u63a5\u53e3\uff0ccloudkey\uff1a" + cloudkey + APPKEY + appkey + SERVICENAME + serviceName + METHODNAME + methodName + "\uff1b\u989d\u5916\u53c2\u6570\uff1a" + WfUtils.mapToString(params));
                    Object result = MethodUtils.invokeMethod((Object)parser, (String)methodName, (Object[])new Object[]{referencePersons, businessKey, entityNumber, params});
                    if (result instanceof List) {
                        userIds = (List)result;
                    }
                } else {
                    List<CollaborationParam> collaborationParams = pme.getCollaborationParams();
                    DynamicObject billObj = BusinessDataServiceHelper.loadSingle((Object)businessKey, (String)entityNumber);
                    HashMap<String, Object> extraParams = new HashMap<String, Object>();
                    for (CollaborationParam i : collaborationParams) {
                        String number = i.getNumber();
                        if (WfUtils.isEmpty(number)) continue;
                        String expression = i.getValueExpression();
                        Object val = expression;
                        if (WfUtils.isEmpty(expression)) {
                            extraParams.put(number, val);
                            continue;
                        }
                        if (!"1".equals(i.getValueFormat()) && expression.startsWith("${")) {
                            val = ExpressionCalculatorUtil.parseValue(billObj, variableScope, expression, null);
                            extraParams.put(number, val);
                            continue;
                        }
                        switch (i.getParamType()) {
                            case "datetime": {
                                if (val instanceof String) {
                                    val = new Date((String)val);
                                    break;
                                }
                                if (val instanceof Date) break;
                                throw new Exception(String.format(ResManager.loadKDString((String)"val\u7c7b\u578b\u5e94\u8be5\u4e3a\u65e5\u671f\u7c7b\u578b\uff0c\u4f46\u662f\u4e0d\u80fd\u8f6c\u6362\u6210\u65e5\u671f\uff1bval=%s", (String)"RelationParticipantParser_3", (String)"bos-wf-engine", (Object[])new Object[0]), val));
                            }
                            case "boolean": {
                                if (val instanceof String) {
                                    val = Boolean.valueOf((String)val);
                                    break;
                                }
                                if (val instanceof Boolean) break;
                                throw new Exception(String.format(ResManager.loadKDString((String)"val\u7c7b\u578b\u5e94\u8be5\u4e3aBoolean\u7c7b\u578b\uff0c\u4f46\u662f\u4e0d\u80fd\u8f6c\u6362\u6210Boolean\uff1bval=%s", (String)"RelationParticipantParser_4", (String)"bos-wf-engine", (Object[])new Object[0]), val));
                            }
                            case "text": {
                                if (val instanceof String) break;
                                val = val.toString();
                                break;
                            }
                            case "decimal": {
                                if (val instanceof String) {
                                    val = new BigDecimal((String)val);
                                    break;
                                }
                                if (val instanceof Number) break;
                                throw new Exception(String.format(ResManager.loadKDString((String)"val\u7c7b\u578b\u5e94\u8be5\u4e3a\u6570\u5b57\u7c7b\u578b\uff0c\u4f46\u662f\u4e0d\u80fd\u8f6c\u6362\u6210\u6570\u5b57\uff1bval=%s", (String)"RelationParticipantParser_5", (String)"bos-wf-engine", (Object[])new Object[0]), val));
                            }
                            case "entityobject": {
                                val = WfUtils.findBusinessObject(JSONObject.parseObject((String)val.toString()).get((Object)"id").toString(), i.getEntityObjectType());
                                if (val != null) break;
                                throw new Exception(String.format(ResManager.loadKDString((String)"val\u7c7b\u578b\u5e94\u8be5\u4e3a\u5bf9\u8c61\u7c7b\u578b\uff0c\u51fa\u73b0\u5f02\u5e38\uff1bval=%s", (String)"RelationParticipantParser_6", (String)"bos-wf-engine", (Object[])new Object[0]), val));
                            }
                        }
                        extraParams.put(number, val);
                    }
                    params.put("parameters", extraParams);
                    params.put("referencePersons", referencePersons);
                    params.put("businesskey", businessKey);
                    params.put("entityNumber", entityNumber);
                    logger.debug("\u83b7\u53d6\u53c2\u4e0e\u4eba\u8c03\u7528\u63a5\u53e3\uff0ccloudkey\uff1a" + cloudkey + APPKEY + appkey + SERVICENAME + serviceName + METHODNAME + methodName + "\uff1b\u53c2\u6570\uff1a" + WfUtils.mapToString(params));
                    Object result = DispatchServiceHelper.invokeBizService((String)cloudkey, (String)appkey, (String)serviceName, (String)methodName, (Object[])new Object[]{referencePersons, businessKey, entityNumber, extraParams});
                    if (result instanceof List) {
                        userIds = (List)result;
                    }
                }
            } else if (WfUtils.isNotEmpty(pme.getReferenceOrg()) && CollectionUtil.isNotEmpty(orgIds = this.getReferenceOrgs(pme.getReferenceOrg(), entityNumber, businessKey, variableScope))) {
                for (Long orgId : orgIds) {
                    userIds.addAll(this.getUserIdsByOrg(orgId, pme.getOrgRelation()));
                }
            }
        }
        catch (Exception e) {
            throw new KDException(WFErrorCode.participantParseError(), new Object[]{e.getMessage()});
        }
        return userIds;
    }
}

