/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.workflow.engine.impl.calculator;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.ILocaleString;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.entity.BasedataEntityType;
import kd.bos.exception.KDException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.permission.model.PersonQueryType;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.org.OrgServiceHelper;
import kd.bos.servicehelper.user.UserServiceHelper;
import kd.bos.workflow.engine.WfConfigurationUtil;
import kd.bos.workflow.engine.WfRoleDimensionUtil;
import kd.bos.workflow.engine.WfUtils;
import kd.bos.workflow.engine.delegate.VariableScope;
import kd.bos.workflow.engine.identity.ParticipantPositionEntity;
import kd.bos.workflow.engine.impl.calculator.ExpressionCalculatorUtil;
import kd.bos.workflow.engine.impl.calculator.RoleDimension;
import kd.bos.workflow.engine.impl.context.Context;
import kd.bos.workflow.engine.impl.log.ParticipantParseProcess;
import kd.bos.workflow.engine.impl.log.RunTimeLog;
import kd.bos.workflow.engine.impl.persistence.entity.management.ParticipantModelEntity;
import kd.bos.workflow.engine.impl.util.FilterDimemsionsUtils;
import kd.bos.workflow.exception.WFEngineException;
import kd.bos.workflow.exception.WFErrorCode;

public class RoleParticipantParser {
    private final String WF_ROLE = "wf_role";
    private final String WF_ROLE_ORGUNIT = "orgunit";
    private final String WF_ROLE_ROLEENTRY = "roleentry";
    private final String ROLEENTRY_USER = "user";
    private final String ROLEENTRY_ALTERNATETYPE = "alternatetype";
    private final String ALTERNATETYPE_ITEM_SUPERIOR = "superior";
    private final String ALTERNATETYPE_ITEM_DESIGNATEDPERSON = "designatedPerson";
    private final String ROLEENTRY_ALTERNATEUSER = "alternateuser";
    private final String ROLEENTRY_ORG = "org";
    private final String WF_ROLE_APPROVALPOSITION = "approvalposition";
    private final String INCLUDADMINSUB = "includadminsub";
    private final String SCENE_2 = "scene2";
    private final String SCENE_9 = "scene9";
    private final String SCENE_8 = "scene8";
    private final String SCENE_3 = "scene3";
    private final String SCENE_16 = "scene16";
    private final String ROLETYPE = "roletype";
    protected static Log logger = LogFactory.getLog(RoleParticipantParser.class);
    private static RoleParticipantParser uniqueInstance = new RoleParticipantParser();
    public static final String SUPERIOR = "superior";

    private RoleParticipantParser() {
    }

    protected static RoleParticipantParser getInstance() {
        return uniqueInstance;
    }

    protected List<Long> getUsers(ParticipantModelEntity pme, VariableScope variableScope, String businessKey) {
        String entityNumber = WfUtils.getEntityNumberFromVariableScope(variableScope);
        ArrayList<Long> userIds = new ArrayList<Long>(3);
        if (null == pme) {
            return userIds;
        }
        logger.debug(String.format("RoleParticipantParser.getUsers [%s-%s-%s]", pme.getId(), entityNumber, businessKey));
        try {
            String businessOrg = pme.getBusinessOrgField();
            Long roleId = pme.getRoleId();
            String dimensionField = pme.getDimensionField();
            logger.debug(String.format("RoleParticipantParser.getUsers dimensionField[%s]", dimensionField));
            if (WfUtils.isEmpty(roleId)) {
                throw new KDException(WFErrorCode.illegAlargumentException(), new Object[]{ResManager.loadKDString((String)"\u8be5\u89d2\u8272\u53c2\u4e0e\u4eba\u3010\u89d2\u8272\u3011\u672a\u8bbe\u7f6e\u3002", (String)"RoleParticipantParser_2", (String)"bos-wf-engine", (Object[])new Object[0])});
            }
            HashMap<String, List<String>> dimensionMap = new HashMap<String, List<String>>(3);
            if (WfUtils.isNotEmpty(dimensionField)) {
                Map map = (Map)SerializationUtils.fromJsonString((String)dimensionField, Map.class);
                StringBuilder dimensionDesc = new StringBuilder();
                for (Object value : map.values()) {
                    JSONObject obj = JSONObject.parseObject((String)value.toString());
                    dimensionDesc.append(obj.get((Object)"showName")).append(",");
                    dimensionMap.put((String)obj.get((Object)"entityNumber"), this.toStringList(FilterDimemsionsUtils.parseOptionObjectData(value.toString(), businessKey, entityNumber, variableScope)));
                }
                if (dimensionDesc.length() > 0) {
                    RunTimeLog.get().setTransientVariable("dimenDesc", dimensionDesc.deleteCharAt(dimensionDesc.length() - 1).toString());
                }
            }
            DynamicObject role = null;
            try {
                role = BusinessDataServiceHelper.loadSingle((Object)roleId, (String)"wf_role");
            }
            catch (Exception e) {
                String msg = String.format(ResManager.loadKDString((String)"\u5de5\u4f5c\u6d41\u89d2\u8272\u201c%1$s\u201d\u4e0d\u5b58\u5728\uff0c\u5f02\u5e38\u4fe1\u606f\uff1a%2$s\u3002", (String)"RoleParticipantParser_6", (String)"bos-wf-engine", (Object[])new Object[0]), roleId, e.getMessage());
                logger.debug(msg);
            }
            if (role == null) {
                return userIds;
            }
            DynamicObject rootOrg = (DynamicObject)role.get("orgunit");
            if (rootOrg == null) {
                return userIds;
            }
            Long roleOrgId = rootOrg.getLong("id");
            String roleDimension = (String)role.get("roledimension");
            Boolean isOrgFieldEnable = Boolean.TRUE;
            ArrayList<RoleDimension> rdList = new ArrayList(4);
            if (WfUtils.isNotEmpty(roleDimension)) {
                Map<String, Object> dimensionInfos = WfRoleDimensionUtil.getDimensionInfos(roleDimension);
                isOrgFieldEnable = (Boolean)Optional.ofNullable(dimensionInfos.get("isOrgFieldEnable")).orElseGet(() -> Boolean.TRUE);
                rdList = (List)dimensionInfos.get("dimensions");
            }
            logger.debug(String.format("RoleParticipantParser.getUsers businessOrg[%s]", businessOrg));
            if (!isOrgFieldEnable.booleanValue() || WfUtils.isEmpty(businessOrg)) {
                if (WfUtils.isNotEmptyForMap(dimensionMap)) {
                    userIds.addAll(this.parseUserId(role, rdList, dimensionMap));
                }
            } else if (WfUtils.isJSONObject(businessOrg)) {
                Map businessOrgMap = (Map)JSON.parse((String)businessOrg);
                RunTimeLog.get().createBlock(String.format(ParticipantParseProcess.DIMEMSIONSCALCULATOR_1.getDesc(), pme.getValue(), businessOrgMap.get("showName")));
                List<Long> collection = FilterDimemsionsUtils.parseOptionData(businessOrg, businessKey, entityNumber, variableScope);
                for (Long l : collection) {
                    userIds.addAll(this.parseUserId(role, roleOrgId, l, rdList, dimensionMap));
                }
            } else if (businessOrg.startsWith("ENTRY_")) {
                RunTimeLog.get().createBlock(String.format(ParticipantParseProcess.DIMEMSIONSCALCULATOR_1.getDesc(), pme.getValue(), ParticipantParseProcess.NULL.getDesc()));
                String newBusinessOrg = ExpressionCalculatorUtil.removeFieldPrefix(businessOrg);
                DynamicObjectCollection collection = ExpressionCalculatorUtil.getEntryFieldValue(entityNumber, newBusinessOrg + " id ", businessKey);
                if (null != collection && collection.size() > 0) {
                    for (DynamicObject dynamicObject : collection) {
                        Long orgId = (Long)dynamicObject.get("id");
                        userIds.addAll(this.parseUserId(role, roleOrgId, orgId, new ArrayList<RoleDimension>(), new HashMap<String, List<String>>()));
                    }
                }
            } else {
                ArrayList<Long> orgIds = new ArrayList<Long>();
                RunTimeLog.get().createBlock(String.format(ParticipantParseProcess.DIMEMSIONSCALCULATOR_1.getDesc(), pme.getValue(), ParticipantParseProcess.NULL.getDesc()));
                Object orgIdObj = ExpressionCalculatorUtil.getFieldValue(entityNumber, businessKey, businessOrg);
                if (null != orgIdObj) {
                    if (orgIdObj instanceof Long) {
                        Long person = (Long)orgIdObj;
                        if (WfUtils.isNotEmpty(person)) {
                            orgIds.add(person);
                        }
                    } else if (orgIdObj instanceof List) {
                        orgIds.addAll((List)orgIdObj);
                    }
                }
                logger.debug(String.format("RoleParticipantParser.getUsers  orgIds[%s]", WfUtils.listToString(orgIds, ",")));
                if (WfUtils.isNotEmptyForCollection(orgIds)) {
                    for (Object e : orgIds) {
                        Long orgId;
                        if (!(e instanceof Long) || (orgId = (Long)e) == null) continue;
                        userIds.addAll(this.parseUserId(role, roleOrgId, orgId, new ArrayList<RoleDimension>(), new HashMap<String, List<String>>()));
                    }
                }
            }
        }
        catch (Exception e) {
            throw new KDException(WFErrorCode.participantParseError(), new Object[]{e.getMessage()});
        }
        RunTimeLog.get().endBlock(String.format(ParticipantParseProcess.DIMEMSIONSCALCULATOR_14.getDesc(), userIds.size() > 0 ? RunTimeLog.get().collectAndSubstitution(userIds, "user") : ParticipantParseProcess.NULL.getDesc()));
        logger.debug(String.format("RoleParticipantParser.getUsers  userIds[%s]", WfUtils.listToString(userIds, ",")));
        return userIds;
    }

    private List<Long> parseUserId(DynamicObject role, Long roleRogId, Long matchRoleId, List<RoleDimension> rdList, Map<String, List<String>> dimensionMap) {
        ArrayList<Long> userIds = new ArrayList<Long>();
        String roleType = role.getString("roletype");
        List<DynamicObject> roleEntrys = this.getMatchedEntryRoles((DynamicObjectCollection)role.get("roleentry"), roleRogId, matchRoleId, rdList, dimensionMap, roleType);
        if (WfUtils.isNotEmptyForCollection(roleEntrys)) {
            for (DynamicObject roleEntry : roleEntrys) {
                userIds.addAll(this.doExtract(roleEntry, roleType));
            }
        }
        return userIds;
    }

    private List<Long> parseUserId(DynamicObject role, List<RoleDimension> rdList, Map<String, List<String>> dimensionMap) {
        ArrayList<Long> userIds = new ArrayList<Long>();
        String roleType = role.getString("roletype");
        DynamicObjectCollection roleEntrys = (DynamicObjectCollection)role.get("roleentry");
        if (WfUtils.isEmptyForCollection((Collection)roleEntrys)) {
            return userIds;
        }
        roleEntrys.forEach(r -> {
            if (this.isDimensionMatched((DynamicObject)r, rdList, dimensionMap, roleType, Boolean.FALSE).booleanValue()) {
                userIds.addAll(this.doExtract((DynamicObject)r, roleType));
            }
        });
        return userIds;
    }

    private List<String> toStringList(List<Object> dimensionLongList) {
        ArrayList<String> dimensionStringList = new ArrayList<String>(dimensionLongList.size());
        for (Object dimension : dimensionLongList) {
            dimensionStringList.add(String.valueOf(dimension));
        }
        return dimensionStringList;
    }

    private List<Long> doExtract(DynamicObject roleentry, String roleType) {
        ArrayList<Long> userIds = new ArrayList<Long>(3);
        List<DynamicObject> userObjs = WfRoleDimensionUtil.getUserFromRoleEntryCoreFieldByRoleType(roleentry, roleType);
        RunTimeLog.get().createBlock();
        String roleEntryName = this.getRoleEntryNameByRoleType(roleentry, roleType);
        if (WfUtils.isNotEmptyForCollection(userObjs)) {
            DynamicObject userPosition = (DynamicObject)roleentry.get("userposition");
            LocaleString position = userPosition != null ? userPosition.getLocaleString("position") : new LocaleString();
            LocaleString orgName = userPosition != null ? userPosition.getLocaleString("org.name") : new LocaleString();
            userObjs.forEach(arg_0 -> this.lambda$doExtract$2(userPosition, roleType, (ILocaleString)position, (ILocaleString)orgName, userIds, arg_0));
            RunTimeLog.get().endBlock(String.format(this.getParaseDescByScene(roleType, "scene16"), roleEntryName, RunTimeLog.get().collectAndSubstitution(userIds, "user")));
        }
        if (WfUtils.isNotEmptyForCollection(userIds)) {
            return userIds;
        }
        RunTimeLog.get().addlnLog(String.format(ParticipantParseProcess.DIMEMSIONSCALCULATOR_15.getDesc(), roleEntryName));
        String alternateType = roleentry.getString("alternatetype");
        if ("designatedPerson".equals(alternateType)) {
            RunTimeLog.get().addlnLog(ParticipantParseProcess.DIMEMSIONSCALCULATOR_17.getDesc());
            DynamicObject alternateuser = (DynamicObject)roleentry.get("alternateuser");
            if (alternateuser != null) {
                userIds.addAll(this.calculateAlternateUser(alternateType, null, alternateuser.getLong("id")));
            }
            RunTimeLog.get().endBlock(String.format(ParticipantParseProcess.DIMEMSIONSCALCULATOR_18.getDesc(), RunTimeLog.get().collectAndSubstitution(userIds, "user")));
        }
        if (SUPERIOR.equals(alternateType) && WfUtils.isNotEmptyForCollection(userObjs)) {
            RunTimeLog.get().addlnLog(ParticipantParseProcess.DIMEMSIONSCALCULATOR_19.getDesc());
            UserServiceHelper.getPerson((long)0L, (long)userObjs.get(0).getLong("id"), (PersonQueryType)PersonQueryType.MANAGER_OF_SUPERIOR, userIds);
        }
        return userIds;
    }

    private String getRoleEntryNameByRoleType(DynamicObject roleentry, String roleType) {
        DynamicObject coreObj = "approvalposition".equals(roleType) ? roleentry.getDynamicObject("approvalposition") : roleentry.getDynamicObject("user");
        if (coreObj == null) {
            return ParticipantParseProcess.NULL.getDesc();
        }
        ILocaleString name = coreObj.getLocaleString("name");
        return WfUtils.isNotEmpty(name) ? name.toString() : ParticipantParseProcess.NULL.getDesc();
    }

    private List<DynamicObject> getMatchedEntryRoles(DynamicObjectCollection entryRoles, Long rootOrg, Long org, List<RoleDimension> rdList, Map<String, List<String>> dimensionMap, String roleType) {
        Long newOrg;
        if (entryRoles == null || rootOrg == null || org == null) {
            return new ArrayList<DynamicObject>();
        }
        logger.debug(String.format("RoleParticipantParser.getMatchedEntryRoles params [%s]", org));
        List<DynamicObject> target = this.match(entryRoles, org, rdList, dimensionMap, roleType);
        if (!target.isEmpty()) {
            return target;
        }
        DynamicObjectCollection afterFiterRoles = this.getAfterFilterRoles(entryRoles);
        if (afterFiterRoles.isEmpty()) {
            return target;
        }
        List superiorOrgs = OrgServiceHelper.getSuperiorOrgs((long)org);
        if (superiorOrgs.size() > 0 && (Long)superiorOrgs.get(0) != 0L) {
            RunTimeLog.get().createBlock(String.format(ParticipantParseProcess.DIMEMSIONSCALCULATOR_11.getDesc(), RunTimeLog.get().collectAndSubstitution(Collections.singletonList(org), "org"), RunTimeLog.get().collectAndSubstitution(superiorOrgs, "org")));
            RunTimeLog.get().endBlock();
        }
        Iterator iterator = superiorOrgs.iterator();
        while (iterator.hasNext() && ((newOrg = (Long)iterator.next()) == 0L || (target = this.getMatchedEntryRoles(afterFiterRoles, rootOrg, newOrg, rdList, dimensionMap, roleType)).isEmpty())) {
        }
        return target;
    }

    private DynamicObjectCollection getAfterFilterRoles(DynamicObjectCollection entryRoles) {
        if (!WfConfigurationUtil.isRepairWorkflowRoleIncludeAdminSubComplete()) {
            return entryRoles;
        }
        DynamicObjectCollection afterFiterRoles = new DynamicObjectCollection();
        entryRoles.forEach(entryRole -> {
            if (entryRole.getBoolean("includadminsub")) {
                afterFiterRoles.add(entryRole);
            }
        });
        return afterFiterRoles;
    }

    private List<DynamicObject> match(DynamicObjectCollection roleentrys, Long orgId, List<RoleDimension> rdList, Map<String, List<String>> dimensionMap, String roleType) {
        ArrayList<DynamicObject> resultRoles = new ArrayList<DynamicObject>();
        if (roleentrys == null || orgId == null) {
            return resultRoles;
        }
        StringBuilder userName = new StringBuilder();
        RunTimeLog.get().createBlock(String.format(this.getParaseDescByScene(roleType, "scene2"), RunTimeLog.get().collectAndSubstitution(Collections.singletonList(orgId), "org")));
        for (DynamicObject role : roleentrys) {
            DynamicObject org = role.getDynamicObject("org");
            if (org == null) continue;
            DynamicObject obj = WfRoleDimensionUtil.getRoleEntryRoleEntryCoreObjByRoleType(role, roleType);
            if (orgId.equals(org.getLong("id"))) {
                if (!this.isDimensionMatched(role, rdList, dimensionMap, roleType, Boolean.TRUE).booleanValue()) continue;
                userName.append(obj == null ? ParticipantParseProcess.NULL.getDesc() : obj.get("name").toString()).append(",");
                resultRoles.add(role);
                continue;
            }
            RunTimeLog.get().createBlock(String.format(this.getParaseDescByScene(roleType, "scene8"), obj == null ? ParticipantParseProcess.NULL.getDesc() : obj.get("name"), RunTimeLog.get().collectAndSubstitution(Collections.singletonList(orgId), "org")));
            RunTimeLog.get().endBlock();
        }
        RunTimeLog.get().endBlock(String.format(this.getParaseDescByScene(roleType, "scene9"), userName.length() > 0 ? userName.deleteCharAt(userName.length() - 1) : ParticipantParseProcess.NULL.getDesc()));
        return resultRoles;
    }

    private Boolean isDimensionMatched(DynamicObject tmpRole, List<RoleDimension> rdList, Map<String, List<String>> dimensionMap, String roleType, Boolean hasOrgFilter) {
        String name = this.getRoleEntryNameByRoleType(tmpRole, roleType);
        if (rdList == null || rdList.size() == 0) {
            RunTimeLog.get().createBlock(String.format(this.getParaseDescByScene(roleType, "scene3"), name));
            RunTimeLog.get().endBlock();
            return Boolean.TRUE;
        }
        if (hasOrgFilter.booleanValue()) {
            RunTimeLog.get().createBlock(String.format(ParticipantParseProcess.DIMEMSIONSCALCULATOR_4.getDesc(), name, RunTimeLog.get().getTransientVariable("dimenDesc") == null ? ParticipantParseProcess.NULL.getDesc() : RunTimeLog.get().getTransientVariable("dimenDesc")));
        } else {
            RunTimeLog.get().createBlock(String.format(ParticipantParseProcess.DIMEMSIONSCALCULATOR_27.getDesc(), name, RunTimeLog.get().getTransientVariable("dimenDesc") == null ? ParticipantParseProcess.NULL.getDesc() : RunTimeLog.get().getTransientVariable("dimenDesc")));
        }
        for (RoleDimension rd : rdList) {
            DynamicObject objectType;
            RunTimeLog.get().createBlock();
            String index = rd.getIndex();
            char dimensionIndex = index.charAt(index.length() - 1);
            String entityNumber = rd.getEntityNumber();
            DynamicObject dynObject = WfRoleDimensionUtil.getObjectType(entityNumber);
            if (WfUtils.isNullObject(dynObject)) {
                throw new WFEngineException(String.format(ResManager.loadKDString((String)"number\u4e3a\u201c%s\u201d\u7684\u5143\u6570\u636e\u4e0d\u5b58\u5728\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458\u8c03\u6574\u7ef4\u5ea6\u8bbe\u7f6e\u3002", (String)"RoleParticipantParser_7", (String)"bos-wf-engine", (Object[])new Object[0]), rd.getEntityNumber()));
            }
            BasedataEntityType basedataEntityTaype = (BasedataEntityType)dynObject.getDataEntityType();
            String numberProperty = basedataEntityTaype.getNumberProperty();
            String obj = tmpRole.getString(index);
            String dimensionNumber = tmpRole.getString("numberdimension" + dimensionIndex);
            if (WfUtils.isEmptyString(obj) && WfUtils.isEmptyString(dimensionNumber)) {
                RunTimeLog.get().endBlock(String.format(ParticipantParseProcess.DIMEMSIONSCALCULATOR_5.getDesc(), name));
                continue;
            }
            if (WfUtils.isEmpty(obj) && WfUtils.isNotEmpty(dimensionNumber) && !WfUtils.isNullObject(objectType = BusinessDataServiceHelper.loadSingle((String)entityNumber, (String)"id", (QFilter[])new QFilter[]{new QFilter(numberProperty, "=", (Object)dimensionNumber)}))) {
                obj = objectType.get("id").toString();
            }
            if (dimensionMap.containsKey(entityNumber) && !dimensionMap.get(entityNumber).contains(obj)) {
                RunTimeLog.get().endBlock(String.format(ParticipantParseProcess.DIMEMSIONSCALCULATOR_7.getDesc(), name, tmpRole.get("mulilangdimension" + dimensionIndex).toString()));
                RunTimeLog.get().endBlock();
                return Boolean.FALSE;
            }
            RunTimeLog.get().endBlock(String.format(ParticipantParseProcess.DIMEMSIONSCALCULATOR_6.getDesc(), name, tmpRole.get("mulilangdimension" + dimensionIndex).toString()));
        }
        RunTimeLog.get().endBlock();
        return Boolean.TRUE;
    }

    private List<Long> calculateAlternateUser(String alternatetype, Long originalUserId, Long designatedPerson) {
        RunTimeLog.get().createBlock();
        ArrayList<Long> userIds = new ArrayList<Long>();
        if (WfUtils.isEmpty(alternatetype)) {
            RunTimeLog.get().endBlock(ParticipantParseProcess.DIMEMSIONSCALCULATOR_19.getDesc());
            return userIds;
        }
        if (SUPERIOR.equals(alternatetype) && originalUserId != null) {
            RunTimeLog.get().addlnLog(ParticipantParseProcess.DIMEMSIONSCALCULATOR_19.getDesc());
            List superiors = UserServiceHelper.getUsersBySuperior((long)originalUserId);
            RunTimeLog.get().addlnLog(String.format(String.format(ParticipantParseProcess.DIMEMSIONSCALCULATOR_20.getDesc(), RunTimeLog.get().collectAndSubstitution(superiors, "user")), new Object[0]));
            if (superiors != null) {
                userIds.addAll(superiors);
            }
        } else if ("designatedPerson".equals(alternatetype) && designatedPerson != null) {
            RunTimeLog.get().addlnLog(ParticipantParseProcess.DIMEMSIONSCALCULATOR_17.getDesc());
            userIds.add(designatedPerson);
            RunTimeLog.get().addlnLog(String.format(String.format(ParticipantParseProcess.DIMEMSIONSCALCULATOR_21.getDesc(), RunTimeLog.get().collectAndSubstitution(Collections.singletonList(designatedPerson), "user")), new Object[0]));
        }
        RunTimeLog.get().endBlock();
        return userIds;
    }

    private String getParaseDescByScene(String roleType, String scene) {
        switch (scene) {
            case "scene2": {
                return "approvalposition".equals(roleType) ? ParticipantParseProcess.DIMEMSIONSCALCULATOR_22.getDesc() : ParticipantParseProcess.DIMEMSIONSCALCULATOR_2.getDesc();
            }
            case "scene9": {
                return "approvalposition".equals(roleType) ? ParticipantParseProcess.DIMEMSIONSCALCULATOR_23.getDesc() : ParticipantParseProcess.DIMEMSIONSCALCULATOR_9.getDesc();
            }
            case "scene8": {
                return "approvalposition".equals(roleType) ? ParticipantParseProcess.DIMEMSIONSCALCULATOR_24.getDesc() : ParticipantParseProcess.DIMEMSIONSCALCULATOR_8.getDesc();
            }
            case "scene3": {
                return "approvalposition".equals(roleType) ? ParticipantParseProcess.DIMEMSIONSCALCULATOR_25.getDesc() : ParticipantParseProcess.DIMEMSIONSCALCULATOR_3.getDesc();
            }
            case "scene16": {
                return "approvalposition".equals(roleType) ? ParticipantParseProcess.DIMEMSIONSCALCULATOR_26.getDesc() : ParticipantParseProcess.DIMEMSIONSCALCULATOR_16.getDesc();
            }
        }
        return "";
    }

    private /* synthetic */ void lambda$doExtract$2(DynamicObject userPosition, String roleType, ILocaleString position, ILocaleString orgName, List userIds, DynamicObject user) {
        if (user.getBoolean("enable")) {
            Long userId = user.getLong("id");
            if (userPosition != null && !"approvalposition".equals(roleType)) {
                ParticipantPositionEntity participantPositionEntity = new ParticipantPositionEntity(userId, position, "role", orgName);
                Context.getCommandContext().putUserPosoitionCache(participantPositionEntity);
            }
            userIds.add(userId);
        }
    }
}

