/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.workflow.engine.impl.calculator.participant;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.permission.model.PersonQueryParam;
import kd.bos.permission.model.PersonQueryType;
import kd.bos.servicehelper.user.UserServiceHelper;
import kd.bos.workflow.engine.WfConfigurationUtil;
import kd.bos.workflow.engine.WfUtils;
import kd.bos.workflow.engine.impl.calculator.participant.IRelationParser;
import kd.bos.workflow.engine.impl.log.ParticipantParseProcess;
import kd.bos.workflow.engine.impl.log.RunTimeLog;
import kd.bos.workflow.service.WorkflowUserService;
import kd.bos.workflow.service.impl.ServiceFactory;

public class AdminOrgRelationParser
implements IRelationParser {
    public static final String SELF = "self";
    public static final String INDIRECT_SUPERIOR = "indirectSuperior";
    public static final String SUPERIOR = "superior";
    public static final String EQUAL = "equal";
    public static final String SUBORDINATE = "subordinate";
    public static final String INDIRECT_SUBORDINATE = "indirectSubordinate";
    protected static Log logger = LogFactory.getLog(AdminOrgRelationParser.class);

    public List<Long> parseSelf(List<Long> referencePersons, String businessKey, String entityNumber, Map<String, Object> params) {
        return this.parse(referencePersons, businessKey, entityNumber, params, SELF);
    }

    public List<Long> parseIndirectSuperior(List<Long> referencePersons, String businessKey, String entityNumber, Map<String, Object> params) {
        return this.parseNew(referencePersons, params, INDIRECT_SUPERIOR);
    }

    public List<Long> parseSuperior(List<Long> referencePersons, String businessKey, String entityNumber, Map<String, Object> params) {
        return this.parseNew(referencePersons, params, SUPERIOR);
    }

    public List<Long> parseEqual(List<Long> referencePersons, String businessKey, String entityNumber, Map<String, Object> params) {
        return this.parse(referencePersons, businessKey, entityNumber, params, EQUAL);
    }

    public List<Long> parseSubordinate(List<Long> referencePersons, String businessKey, String entityNumber, Map<String, Object> params) {
        return this.parse(referencePersons, businessKey, entityNumber, params, SUBORDINATE);
    }

    public List<Long> parseIndirectSubordinate(List<Long> referencePersons, String businessKey, String entityNumber, Map<String, Object> params) {
        return this.parse(referencePersons, businessKey, entityNumber, params, INDIRECT_SUBORDINATE);
    }

    public List<Long> parse(List<Long> referencePersons, String businessKey, String entityNumber, Map<String, Object> params, String personRelation) {
        List orgIds = new ArrayList();
        if (params.get("orgIds") != null) {
            orgIds = (List)params.get("orgIds");
        }
        ArrayList<Long> userIds = new ArrayList<Long>();
        if (referencePersons == null || WfUtils.isEmpty(personRelation) || referencePersons.isEmpty() || orgIds.isEmpty()) {
            return userIds;
        }
        PersonQueryType queryType = null;
        logger.debug("RelationParticipantParser getUserIdsByPerson \u53c2\u6570 -- orgIds \uff1a" + WfUtils.listToString(orgIds, ",") + "; referencePersons : " + WfUtils.listToString(referencePersons, ",") + "");
        if (SELF.equals(personRelation)) {
            logger.debug("personRelation is self");
            userIds.addAll(referencePersons);
        } else {
            switch (personRelation) {
                case "indirectSuperior": {
                    queryType = PersonQueryType.MANAGER_OF_INDIRECT_SUPERIOR;
                    logger.debug("personRelation is indirectSuperior and queryType :" + queryType);
                    break;
                }
                case "superior": {
                    queryType = PersonQueryType.MANAGER_OF_SUPERIOR;
                    logger.debug("personRelation is superior and queryType :" + queryType);
                    break;
                }
                case "equal": {
                    queryType = PersonQueryType.ALL_OF_EQUATIVE;
                    logger.debug("personRelation is equal and queryType :" + queryType);
                    break;
                }
                case "subordinate": {
                    queryType = PersonQueryType.ALL_OF_SUBORDINATE;
                    logger.debug("personRelation is subordinate and queryType :" + queryType);
                    break;
                }
                case "indirectSubordinate": {
                    queryType = PersonQueryType.ALL_OF_INDIRECT_SUBORDINATE;
                    logger.debug("personRelation is indirectSubordinate and queryType :" + queryType);
                    break;
                }
            }
            if (null != queryType) {
                HashSet orgIdSet = new HashSet(orgIds);
                HashSet<Long> referencePersonSet = new HashSet<Long>(referencePersons);
                for (Long orgId : orgIdSet) {
                    for (Long referencePerson : referencePersonSet) {
                        Object mainOrgDefault;
                        String resultForHelper = null;
                        if (orgId == 0L && ((mainOrgDefault = WfConfigurationUtil.getConfigCenterVal("workflow.relation.mainorgdefault")) == null || Boolean.parseBoolean(mainOrgDefault.toString()))) {
                            orgId = UserServiceHelper.getUserMainOrgId((long)referencePerson);
                        }
                        resultForHelper = UserServiceHelper.getPerson((long)orgId, (long)referencePerson, (PersonQueryType)queryType, userIds);
                        logger.debug("RelationParticipantParser getUserIdsByPerson result -- resultForHelper :" + resultForHelper + "; userIds :" + WfUtils.listToString(userIds, ","));
                    }
                }
            }
        }
        RunTimeLog.get().createBlock(String.format(ParticipantParseProcess.PARTICIPANTRELEATION_4.getDesc(), RunTimeLog.get().collectAndSubstitution(referencePersons, "user"), RunTimeLog.get().collectAndSubstitution(userIds, "user")));
        RunTimeLog.get().endBlock();
        return userIds;
    }

    public List<Long> parseNew(List<Long> referencePersons, Map<String, Object> params, String personRelation) {
        ArrayList<Long> userIds = new ArrayList<Long>();
        if (!WfUtils.isNotEmptyForCollection(referencePersons) || null == params || WfUtils.isEmpty(personRelation)) {
            return userIds;
        }
        List orgIds = new ArrayList();
        if (params.get("orgIds") != null) {
            orgIds = (List)params.get("orgIds");
        }
        PersonQueryType queryType = null;
        switch (personRelation) {
            case "superior": {
                queryType = PersonQueryType.MANAGER_OF_SUPERIOR;
                break;
            }
            case "indirectSuperior": {
                queryType = PersonQueryType.MANAGER_OF_INDIRECT_SUPERIOR;
                break;
            }
        }
        WorkflowUserService wfUserService = (WorkflowUserService)ServiceFactory.getService(WorkflowUserService.class);
        HashSet<Long> referencePersonSet = new HashSet<Long>(referencePersons);
        HashSet orgIdSet = new HashSet(orgIds);
        for (Long userId : referencePersonSet) {
            for (Long orgId : orgIdSet) {
                PersonQueryParam personQueryParam = new PersonQueryParam();
                personQueryParam.setUserId(userId.longValue());
                personQueryParam.setOrgId(orgId.longValue());
                personQueryParam.setQueryType(queryType);
                userIds.addAll(wfUserService.getPerson(personQueryParam));
            }
        }
        return userIds;
    }
}

