/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.workflow.engine.impl.calculator.participant;

import java.util.HashMap;
import java.util.Map;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.exception.KDException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.workflow.engine.WfUtils;
import kd.bos.workflow.engine.impl.calculator.participant.AdminOrgRelationParser;
import kd.bos.workflow.engine.impl.calculator.participant.IRelationParser;
import kd.bos.workflow.engine.impl.calculator.participant.PositionRelationParser;
import kd.bos.workflow.exception.WFErrorCode;

public class ParticipantServiceFactory {
    private static Log logger = LogFactory.getLog(ParticipantServiceFactory.class);
    private static volatile ParticipantServiceFactory instance = null;
    private final Map<String, Class<? extends IRelationParser>> participantServices = new HashMap<String, Class<? extends IRelationParser>>();

    private ParticipantServiceFactory() {
        this.register();
    }

    private void register() {
        this.participantServices.put("adminOrgService", AdminOrgRelationParser.class);
        this.participantServices.put("positionService", PositionRelationParser.class);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static ParticipantServiceFactory getInstance() {
        if (instance != null) return instance;
        Class<ParticipantServiceFactory> clazz = ParticipantServiceFactory.class;
        synchronized (ParticipantServiceFactory.class) {
            if (instance != null) return instance;
            instance = new ParticipantServiceFactory();
            // ** MonitorExit[var0] (shouldn't be in output)
            return instance;
        }
    }

    public IRelationParser getRelationParser(String key) {
        logger.debug("[participantParse]:\u89e3\u6790\u7c7b\u6807\u8bc6\u5f00\u59cb\uff1a" + key);
        if (WfUtils.isEmpty(key)) {
            throw new KDException(WFErrorCode.participantParseError(), new Object[]{ResManager.loadKDString((String)"\u53c2\u4e0e\u4eba\u534f\u4f5c\u7c7b\u578b\u8ba1\u7b97\u5b9e\u4f8b\u5316\u89e3\u6790\u7c7b\u5f02\u5e38\uff0c\u5b9e\u4f8b\u5316\u7c7b\u6807\u8bc6\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"ParticipantServiceFactory_1", (String)"bos-wf-engine", (Object[])new Object[0])});
        }
        Class<? extends IRelationParser> clazz = this.participantServices.get(key);
        if (clazz != null) {
            try {
                IRelationParser parser = clazz.newInstance();
                logger.debug("[participantParse]:\u89e3\u6790\u7c7b\u6807\u8bc6\u5b8c\u6210\uff1a" + key);
                return parser;
            }
            catch (Exception e) {
                throw new KDException(WFErrorCode.participantParseError(), new Object[]{String.format(ResManager.loadKDString((String)"\u53c2\u4e0e\u4eba\u534f\u4f5c\u7c7b\u578b\u8ba1\u7b97\u5b9e\u4f8b\u5316\u89e3\u6790\u7c7b\u5f02\u5e38\uff0c\u5b9e\u4f8b\u5316\u7c7b\u6807\u8bc6\uff1a%s", (String)"ParticipantServiceFactory_2", (String)"bos-wf-engine", (Object[])new Object[0]), key)});
            }
        }
        logger.debug("[participantParse]:\u672a\u627e\u5230\u5bf9\u5e94\u7684\u89e3\u6790\u7c7b\uff1a" + key);
        return null;
    }
}

