/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.workflow.engine.impl.calculator.participant;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.servicehelper.user.UserServiceHelper;
import kd.bos.workflow.engine.WfUtils;
import kd.bos.workflow.engine.impl.calculator.participant.IRelationParser;
import kd.bos.workflow.engine.impl.log.ParticipantParseProcess;
import kd.bos.workflow.engine.impl.log.RunTimeLog;
import kd.bos.workflow.relservice.WorkflowUserRelQueryHelper;

public class PositionRelationParser
implements IRelationParser {
    public static final String INDIRECT_SUPERIOR = "indirectSuperior";
    public static final String SUPERIOR = "superior";
    private static Log logger = LogFactory.getLog(PositionRelationParser.class);

    public List<Long> getSuperiorPositionUsers(List<Long> referencePersons, String businessKey, String entityNumber, Map<String, Object> params) {
        return this.parse(referencePersons, SUPERIOR, params);
    }

    public List<Long> getIndirectSuperiorPositionUsers(List<Long> referencePersons, String businessKey, String entityNumber, Map<String, Object> params) {
        return this.parse(referencePersons, INDIRECT_SUPERIOR, params);
    }

    private List<Long> parse(List<Long> referencePersons, String type, Map<String, Object> params) {
        Map peopleUnderPositions;
        ArrayList<Long> orgIds = new ArrayList();
        if (params.get("orgIds") != null) {
            orgIds = (List)params.get("orgIds");
        }
        ArrayList<Long> userIds = new ArrayList<Long>();
        Object reportTypeObj = params.get("reportTypeId");
        if (WfUtils.isEmptyForCollection(referencePersons) || WfUtils.isEmpty(type) || WfUtils.isEmptyString(reportTypeObj)) {
            return userIds;
        }
        ArrayList<Long> reportTypeIds = new ArrayList<Long>(1);
        reportTypeIds.add(Long.valueOf((String)reportTypeObj));
        RunTimeLog.get().appendLog(String.format(ParticipantParseProcess.POSITIONRELATIONPARSER_1.getDesc(), RunTimeLog.get().collectAndSubstitution(reportTypeIds, "reporttype")));
        List<Long> currentPositions = WorkflowUserRelQueryHelper.getPositionQueryProvider().getPosiontsByUserIdsAndOrgIds(referencePersons, orgIds, params);
        if (currentPositions.isEmpty()) {
            RunTimeLog.get().createBlock(ParticipantParseProcess.POSITIONRELATIONPARSER_4.getDesc());
            RunTimeLog.get().endBlock();
            return userIds;
        }
        RunTimeLog.get().createBlock(String.format(ParticipantParseProcess.POSITIONRELATIONPARSER_5.getDesc(), RunTimeLog.get().collectAndSubstitution(currentPositions, "position")));
        Set<Long> positions = this.getPositionsByType(currentPositions, type, Long.valueOf((String)reportTypeObj));
        if (WfUtils.isNotEmptyForCollection(positions) && WfUtils.isNotEmptyForMap(peopleUnderPositions = UserServiceHelper.getPeopleUnderPosition(positions))) {
            peopleUnderPositions.values().stream().filter(Objects::nonNull).forEach(dynamicObjects -> dynamicObjects.forEach(dynamicObject -> userIds.add(dynamicObject.getLong("id"))));
        }
        return userIds;
    }

    private Set<Long> getPositionsByType(List<Long> currentPositions, String type, Long reportTypeId) {
        ArrayList<Long> positions = new ArrayList<Long>();
        if (INDIRECT_SUPERIOR.equals(type)) {
            RunTimeLog.get().appendLog(ParticipantParseProcess.POSITIONRELATIONPARSER_6.getDesc());
            positions.addAll(WorkflowUserRelQueryHelper.getPositionQueryProvider().getIndirectSuperiorPositions(currentPositions, reportTypeId, new HashMap<String, Object>()));
        } else if (SUPERIOR.equals(type)) {
            RunTimeLog.get().appendLog(ParticipantParseProcess.POSITIONRELATIONPARSER_7.getDesc());
            positions.addAll(WorkflowUserRelQueryHelper.getPositionQueryProvider().getSuperiorPositions(currentPositions, reportTypeId, new HashMap<String, Object>()));
        }
        RunTimeLog.get().appendLog(String.format(ParticipantParseProcess.POSITIONRELATIONPARSER_8.getDesc(), RunTimeLog.get().collectAndSubstitution(positions, "position")));
        RunTimeLog.get().endBlock();
        return new HashSet<Long>(positions);
    }
}

