/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.workflow.engine.impl.calendar;

import java.util.Date;
import java.util.TimeZone;
import kd.bos.workflow.engine.impl.calendar.BusinessCalendar;
import kd.bos.workflow.engine.runtime.ClockReader;
import org.joda.time.DateTimeZone;
import org.joda.time.format.ISODateTimeFormat;

public abstract class BusinessCalendarImpl
implements BusinessCalendar {
    protected ClockReader clockReader;

    public BusinessCalendarImpl(ClockReader clockReader) {
        this.clockReader = clockReader;
    }

    @Override
    public Date resolveDuedate(String duedateDescription, String startDate) {
        return this.resolveDuedate(duedateDescription, -1, startDate);
    }

    @Override
    public Date resolveDuedate(String duedateDescription, int maxIterations) {
        return this.resolveDuedate(duedateDescription, maxIterations, null);
    }

    @Override
    public Boolean validateDuedate(String duedateDescription, int maxIterations, Date endDate, Date newTimer) {
        return endDate == null || endDate.compareTo(newTimer) >= 0;
    }

    @Override
    public Date resolveEndDate(String endDateString) {
        return ISODateTimeFormat.dateTimeParser().withZone(DateTimeZone.forTimeZone((TimeZone)this.clockReader.getCurrentTimeZone())).parseDateTime(endDateString).toCalendar(null).getTime();
    }
}

