/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.workflow.engine.impl.calendar;

import java.util.Date;
import kd.bos.workflow.engine.impl.calendar.BusinessCalendarImpl;
import kd.bos.workflow.engine.impl.calendar.CronExpression;
import kd.bos.workflow.engine.impl.calendar.DurationHelper;
import kd.bos.workflow.engine.runtime.ClockReader;
import kd.bos.workflow.exception.WFEngineException;
import org.apache.commons.lang.StringUtils;
import org.joda.time.DateTime;

public class CycleBusinessCalendar
extends BusinessCalendarImpl {
    public static String NAME = "cycle";

    public CycleBusinessCalendar(ClockReader clockReader) {
        super(clockReader);
    }

    @Override
    public Date resolveDuedate(String duedateDescription, int maxIterations, String startDate) {
        try {
            if (duedateDescription != null && duedateDescription.startsWith("R")) {
                return new DurationHelper(duedateDescription, maxIterations, this.clockReader).getDateAfter();
            }
            CronExpression ce = new CronExpression(duedateDescription, this.clockReader);
            if (StringUtils.isNotEmpty((String)startDate)) {
                return ce.getTimeAfter(DateTime.parse((String)startDate).toDate());
            }
            return ce.getTimeAfter(this.clockReader.getCurrentTime());
        }
        catch (Exception e) {
            throw new WFEngineException("Failed to parse cron expression: " + duedateDescription, e);
        }
    }

    @Override
    public Boolean validateDuedate(String duedateDescription, int maxIterations, Date endDate, Date newTimer) {
        if (endDate != null) {
            return super.validateDuedate(duedateDescription, maxIterations, endDate, newTimer);
        }
        try {
            if (duedateDescription != null && duedateDescription.startsWith("R")) {
                return new DurationHelper(duedateDescription, maxIterations, this.clockReader).isValidDate(newTimer);
            }
            return true;
        }
        catch (Exception e) {
            throw new WFEngineException("Failed to parse cron expression: " + duedateDescription, e);
        }
    }
}

