/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.workflow.engine.impl.calendar;

import java.util.Date;
import kd.bos.workflow.engine.impl.calendar.BusinessCalendarImpl;
import kd.bos.workflow.engine.runtime.ClockReader;
import kd.bos.workflow.exception.WFEngineException;
import org.joda.time.DateTime;
import org.joda.time.Period;
import org.joda.time.ReadablePeriod;

public class DueDateBusinessCalendar
extends BusinessCalendarImpl {
    public static final String NAME = "dueDate";

    public DueDateBusinessCalendar(ClockReader clockReader) {
        super(clockReader);
    }

    @Override
    public Date resolveDuedate(String duedate, int maxIterations, String startDate) {
        try {
            if (duedate.startsWith("P")) {
                return new DateTime((Object)this.clockReader.getCurrentTime()).plus((ReadablePeriod)Period.parse((String)duedate)).toDate();
            }
            return DateTime.parse((String)duedate).toDate();
        }
        catch (Exception e) {
            throw new WFEngineException("couldn't resolve duedate: " + e.getMessage(), e);
        }
    }
}

