/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.workflow.engine.impl.calendar;

import java.util.HashMap;
import java.util.Map;
import kd.bos.workflow.engine.impl.calendar.BusinessCalendar;
import kd.bos.workflow.engine.impl.calendar.BusinessCalendarManager;
import kd.bos.workflow.exception.WFEngineException;

public class MapBusinessCalendarManager
implements BusinessCalendarManager {
    private final Map<String, BusinessCalendar> businessCalendars;

    public MapBusinessCalendarManager() {
        this.businessCalendars = new HashMap<String, BusinessCalendar>();
    }

    public MapBusinessCalendarManager(Map<String, BusinessCalendar> businessCalendars) {
        if (businessCalendars == null) {
            throw new IllegalArgumentException("businessCalendars can not be null");
        }
        this.businessCalendars = new HashMap<String, BusinessCalendar>(businessCalendars);
    }

    @Override
    public BusinessCalendar getBusinessCalendar(String businessCalendarRef) {
        BusinessCalendar businessCalendar = this.businessCalendars.get(businessCalendarRef);
        if (businessCalendar == null) {
            throw new WFEngineException("Requested business calendar " + businessCalendarRef + " does not exist. Allowed calendars are " + this.businessCalendars.keySet() + ".");
        }
        return businessCalendar;
    }

    public BusinessCalendarManager addBusinessCalendar(String businessCalendarRef, BusinessCalendar businessCalendar) {
        this.businessCalendars.put(businessCalendarRef, businessCalendar);
        return this;
    }
}

