/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.workflow.engine.impl.clean.calculator;

import java.util.List;
import kd.bos.dataentity.TypesContainer;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.workflow.engine.WfUtils;
import kd.bos.workflow.engine.impl.clean.calculator.CleanDataCalculator;
import kd.bos.workflow.engine.impl.clean.cleaner.DefaultProcessCleaner;
import kd.bos.workflow.engine.impl.clean.cleaner.LogProcessCleaner;
import kd.bos.workflow.engine.impl.clean.model.CleanConfigFactory;
import kd.bos.workflow.engine.impl.clean.model.CleanTaskConfigParam;
import kd.bos.workflow.engine.impl.interceptor.CommandContext;
import kd.bos.workflow.engine.impl.util.ReflectUtil;

public class CleanProcDataCalculator
implements CleanDataCalculator {
    private static Log log = LogFactory.getLog(CleanProcDataCalculator.class);

    @Override
    public void executeProcessCleaners(CommandContext commandContext, String cleanMoment, List<String> businessKeys, List<Long> procInstIds) {
        List<CleanTaskConfigParam> cleanTaskParamList = CleanConfigFactory.getCleanTaskConfigParams("wfs", cleanMoment);
        if (WfUtils.isEmptyForCollection(cleanTaskParamList)) {
            log.debug("\u672a\u627e\u5230\u9700\u8981\u6e05\u7406\u7684\u5b9e\u4f53\uff0c\u6e05\u7406\u6846\u67b6\u6309\u6d41\u7a0b\u6e05\u7406\u6267\u884c\u5931\u8d25\u3002");
            return;
        }
        LogProcessCleaner logCleaner = new LogProcessCleaner();
        DefaultProcessCleaner defaultCleaner = new DefaultProcessCleaner();
        for (CleanTaskConfigParam configParam : cleanTaskParamList) {
            try {
                if (WfUtils.isEmpty(configParam.getExecutePlugin())) {
                    if (configParam.isLogForm()) {
                        logCleaner.execute(commandContext, configParam, businessKeys, procInstIds);
                    } else {
                        defaultCleaner.execute(commandContext, configParam, businessKeys, procInstIds);
                    }
                } else {
                    ReflectUtil.invoke(TypesContainer.createInstance((String)configParam.getExecutePlugin()), "execute", new Object[]{commandContext, configParam, businessKeys, procInstIds});
                }
                log.debug(String.format("\u6e05\u7406\u6846\u67b6-\u4e3b\u5b9e\u4f53\uff1a[%s]\uff0c\u6309\u6d41\u7a0b\u6e05\u7406-\u6e05\u7406\u65f6\u673a[%s]-\u6267\u884c\u6210\u529f\u3002", configParam.getMainEntityNumber(), configParam.getCleanMoment()));
            }
            catch (Exception ex) {
                log.debug(String.format("\u6e05\u7406\u6846\u67b6-\u4e3b\u5b9e\u4f53\uff1a[%s]\uff0c\u6309\u6d41\u7a0b\u6e05\u7406-\u6e05\u7406\u65f6\u673a[%s]-\u6267\u884c\u51fa\u9519\u3002 %s", configParam.getMainEntityNumber(), configParam.getCleanMoment(), WfUtils.getExceptionStacktrace(ex)));
            }
        }
    }
}

