/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.workflow.engine.impl.clean.calculator;

import java.util.List;
import java.util.Map;
import kd.bos.dataentity.TypesContainer;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.bos.workflow.engine.WfUtils;
import kd.bos.workflow.engine.impl.clean.calculator.CleanDataCalculator;
import kd.bos.workflow.engine.impl.clean.cleaner.CompactProcessCleaner;
import kd.bos.workflow.engine.impl.clean.cleaner.DefaultRegularTimeCleaner;
import kd.bos.workflow.engine.impl.clean.cleaner.LogRegularTimeCleaner;
import kd.bos.workflow.engine.impl.clean.model.CleanConfigFactory;
import kd.bos.workflow.engine.impl.clean.model.CleanTaskConfigParam;
import kd.bos.workflow.engine.impl.clean.model.RelaCleanConfigParam;
import kd.bos.workflow.engine.impl.util.ReflectUtil;

public class CleanRegularTimeDataCalculator
implements CleanDataCalculator {
    private static Log log = LogFactory.getLog(CleanRegularTimeDataCalculator.class);

    @Override
    public void executeTimingCleaners(String appName) {
        List<CleanTaskConfigParam> cleanTaskParamList = CleanConfigFactory.getCleanTaskConfigParams(appName, null);
        if (WfUtils.isEmptyForCollection(cleanTaskParamList)) {
            log.debug(String.format("\u672a\u627e\u5230\u9700\u8981\u6e05\u7406\u7684\u5b9e\u4f53\uff0c\u6e05\u7406\u6846\u67b6\u6309\u65f6\u95f4\u6e05\u7406\u6267\u884c\u5931\u8d25-\u6240\u5c5e\u5e94\u7528\uff1a[%s]\u3002", appName));
            return;
        }
        LogRegularTimeCleaner logCleaner = new LogRegularTimeCleaner();
        DefaultRegularTimeCleaner defaultCleaner = new DefaultRegularTimeCleaner();
        CompactProcessCleaner compactCleaner = new CompactProcessCleaner();
        for (CleanTaskConfigParam configParam : cleanTaskParamList) {
            try {
                Map<String, Object> ret = null;
                ret = WfUtils.isEmpty(configParam.getExecutePlugin()) ? ("wfs_compact".equals(appName) ? compactCleaner.execute(configParam) : (configParam.isLogForm() ? logCleaner.execute(configParam) : defaultCleaner.execute(configParam))) : (Map<String, Object>)ReflectUtil.invoke(TypesContainer.createInstance((String)configParam.getExecutePlugin()), "execute", new Object[]{configParam});
                if (WfUtils.isNotEmptyForMap(ret)) {
                    this.saveResult(configParam, ret);
                }
                log.debug(String.format("\u6e05\u7406\u6846\u67b6-\u4e3b\u5b9e\u4f53\uff1a[%s]\uff0c\u6309\u65f6\u95f4\u6e05\u7406\u6267\u884c\u6210\u529f\u3002", configParam.getMainEntityNumber()));
            }
            catch (Exception ex) {
                log.error(String.format("\u6e05\u7406\u6846\u67b6-\u4e3b\u5b9e\u4f53\uff1a[%s]\uff0c\u6309\u65f6\u95f4\u6e05\u7406\u6267\u884c\u51fa\u9519\u3002 %s", configParam.getMainEntityNumber(), WfUtils.getExceptionStacktrace(ex)));
            }
        }
    }

    private void saveResult(CleanTaskConfigParam configParam, Map<String, Object> ret) {
        if (WfUtils.isEmptyForMap(ret)) {
            return;
        }
        String paramsStr = SerializationUtils.toJsonString(ret);
        String entityNumber = configParam.getMainEntityNumber();
        QFilter[] filters = new QFilter[]{new QFilter("entitynumber", "=", (Object)entityNumber), new QFilter("cleanmode", "=", (Object)"timing"), new QFilter("order", "=", (Object)configParam.getOrder())};
        DynamicObject dynConfig = QueryServiceHelper.queryOne((String)"wf_cleandynamicconfig", (String)"id,params", (QFilter[])filters);
        if (dynConfig == null) {
            dynConfig = BusinessDataServiceHelper.newDynamicObject((String)"wf_cleandynamicconfig");
            dynConfig.set("entitynumber", (Object)entityNumber);
            dynConfig.set("cleanmode", (Object)"timing");
            dynConfig.set("params", (Object)paramsStr);
            dynConfig.set("order", (Object)configParam.getOrder());
            dynConfig.set("status", (Object)"1");
            StringBuilder relaStr = new StringBuilder();
            List<RelaCleanConfigParam> relaList = configParam.getRelaCleanConfigParams();
            if (WfUtils.isNotEmptyForCollection(relaList)) {
                for (RelaCleanConfigParam rela : relaList) {
                    relaStr.append(rela.getRelaEntityNumber()).append(",");
                }
                dynConfig.set("relaentity", (Object)relaStr.substring(0, relaStr.length() - 1));
            }
            SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{dynConfig});
        } else {
            Object[] sqlParam = new Object[]{paramsStr, dynConfig.get("id")};
            String sql = "update t_wf_cleandynamicconfig set fparams = ? where fid = ?;";
            DB.execute((DBRoute)DBRoute.workflow, (String)sql, (Object[])sqlParam);
        }
    }
}

