/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.workflow.engine.impl.clean.cleaner;

import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import java.util.StringJoiner;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.metadata.clr.DataEntityPropertyCollection;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.MainEntityType;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.logorm.LogORM;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.operation.DeleteServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.bos.workflow.engine.WfDBUtils;
import kd.bos.workflow.engine.WfUtils;
import kd.bos.workflow.engine.impl.clean.model.CleanTaskConfigParam;
import kd.bos.workflow.engine.impl.clean.model.RelaCleanConfigParam;
import kd.bos.workflow.engine.impl.clean.transfer.EntityTransfer;
import kd.bos.workflow.engine.impl.clean.transfer.EntityTransferFactory;

public class BaseCleaner {
    private static Log log = LogFactory.getLog(BaseCleaner.class);
    private static final String DISPOSAL_DELETE = "delete";
    private static final String DISPOSAL_TRANSFER = "transfer";

    protected void disposeMainEntityData(String accordFeild, List<Object> params, CleanTaskConfigParam configParam) {
        log.debug(String.format("\u5904\u7406\uff08\u5220\u9664\u3001\u8f6c\u79fb\uff09\u4e3b\u5b9e\u4f53[%s]\u6570\u636e\u5f00\u59cb\uff0c\u6e05\u7406\u65b9\u5f0f[%s]", configParam.getMainEntityNumber(), configParam.getDisposalType()));
        if (DISPOSAL_DELETE.equals(configParam.getDisposalType())) {
            this.deleteData(configParam.getMainEntityNumber(), accordFeild, params, configParam.hasMultiLang(), configParam.getTableName());
        } else if (DISPOSAL_TRANSFER.equals(configParam.getDisposalType())) {
            String transferEntityNumber = configParam.getTransferEntity();
            this.transferToTargetEntity(configParam.getMainEntityNumber(), transferEntityNumber, new QFilter[]{new QFilter(accordFeild, "in", params)}, configParam.hasMultiLang(), configParam.getTableName());
        }
    }

    protected void disposeRelaEntityData(List<Object> pks, RelaCleanConfigParam relaParam, String disposalType) {
        log.debug(String.format("\u5904\u7406\uff08\u5220\u9664\u3001\u8f6c\u79fb\uff09\u5173\u8054\u5b9e\u4f53[%s]\u6570\u636e\u5f00\u59cb\uff0c\u5173\u8054\u5b57\u6bb5[%s]\uff0c\u6e05\u7406\u65b9\u5f0f[%s]", relaParam.getRelaEntityNumber(), relaParam.getRelaField(), disposalType));
        String relaEntityNumber = relaParam.getRelaEntityNumber();
        if (DISPOSAL_DELETE.equals(disposalType)) {
            if (relaParam.isLogForm()) {
                this.deleteLogData(relaEntityNumber, relaParam.getRelaField(), pks);
            } else if (relaParam.hasMultiLang()) {
                String relaPkFeild = EntityMetadataCache.getDataEntityType((String)relaEntityNumber).getPrimaryKey().getName();
                List<Object> relaPks = this.getRelaPks(pks, relaParam, relaPkFeild);
                this.deleteData(relaEntityNumber, relaPkFeild, relaPks, relaParam.hasMultiLang(), relaParam.getTableName());
            } else {
                this.deleteData(relaEntityNumber, relaParam.getRelaField(), pks, relaParam.hasMultiLang(), relaParam.getTableName());
            }
        } else if (DISPOSAL_TRANSFER.equals(disposalType)) {
            String transferEntityNumber = relaParam.getRelaTransferEntity();
            this.transferToTargetEntity(relaEntityNumber, transferEntityNumber, new QFilter[]{new QFilter(relaParam.getRelaField(), "in", pks)}, relaParam.hasMultiLang(), relaParam.getTableName());
        }
    }

    private List<Object> getRelaPks(List<Object> pks, RelaCleanConfigParam relaParam, String relaPkFeild) {
        String relaEntityNumber = relaParam.getRelaEntityNumber();
        ArrayList<Object> relaPks = new ArrayList<Object>(10);
        try (DataSet dataSet = QueryServiceHelper.queryDataSet((String)"BaseCleaner.getRelaPks", (String)relaEntityNumber, (String)relaPkFeild, (QFilter[])new QFilter[]{new QFilter(relaParam.getRelaField(), "in", pks)}, (String)String.format("%s asc", relaPkFeild));){
            Row row = null;
            while (dataSet != null && dataSet.hasNext()) {
                row = dataSet.next();
                relaPks.add(row.get(relaPkFeild));
            }
        }
        return relaPks;
    }

    protected void transferToTargetEntity(String sourceEntityNumber, String targetEntityNumber, QFilter[] filters, boolean hasMultiLang, String tableName) {
        EntityTransfer entityTransfer = EntityTransferFactory.createEntityTransfer(sourceEntityNumber, targetEntityNumber);
        StringJoiner queryFeilds = new StringJoiner(",");
        List<String> sourcePropertys = this.getPropertys(sourceEntityNumber);
        for (String property : sourcePropertys) {
            queryFeilds.add(property);
        }
        if (queryFeilds.length() == 0) {
            return;
        }
        List<String> targetPropertys = this.getPropertys(targetEntityNumber);
        try (DataSet dataSet = QueryServiceHelper.queryDataSet((String)String.format("bos.wf.AbstractTimeCleaner.transferToTargetEntity.%s", sourceEntityNumber), (String)sourceEntityNumber, (String)queryFeilds.toString(), (QFilter[])filters, null);){
            if (!dataSet.isEmpty()) {
                String sourcePkFeild = EntityMetadataCache.getDataEntityType((String)sourceEntityNumber).getPrimaryKey().getName();
                ArrayList<Object> pkValues = new ArrayList<Object>(10);
                Iterator iter = dataSet.iterator();
                int count = 0;
                ArrayList<DynamicObject> objList = new ArrayList<DynamicObject>(10);
                while (iter.hasNext()) {
                    Row row = (Row)iter.next();
                    Object val = null;
                    DynamicObject hiEntityObj = BusinessDataServiceHelper.newDynamicObject((String)targetEntityNumber);
                    for (String targetProperty : targetPropertys) {
                        val = entityTransfer.getTargetValue(targetProperty, row);
                        hiEntityObj.set(targetProperty, val);
                    }
                    objList.add(hiEntityObj);
                    pkValues.add(row.get(sourcePkFeild));
                    if (++count != 1000) continue;
                    this.transferData(objList, sourceEntityNumber, sourcePkFeild, pkValues, hasMultiLang, tableName);
                    objList.clear();
                    pkValues.clear();
                    count = 0;
                }
                if (count > 0) {
                    this.transferData(objList, sourceEntityNumber, sourcePkFeild, pkValues, hasMultiLang, tableName);
                }
            }
        }
    }

    private void transferData(List<DynamicObject> targetObj, String sourceEntityNumber, String sourcePkFeild, List<Object> sourcePkValues, boolean sourceHasMultiLang, String sourceTableName) {
        try (TXHandle tx = TX.required((String)"AbstractTimeCleaner_transferData");){
            SaveServiceHelper.save((DynamicObject[])targetObj.toArray(new DynamicObject[0]));
            this.deleteData(sourceEntityNumber, sourcePkFeild, sourcePkValues, sourceHasMultiLang, sourceTableName);
        }
    }

    private List<String> getPropertys(String entityNumber) {
        MainEntityType entityType = EntityMetadataCache.getDataEntityType((String)entityNumber);
        DataEntityPropertyCollection sourcePropertyCollection = entityType.getProperties();
        ArrayList<String> propertys = new ArrayList<String>(sourcePropertyCollection.size());
        for (IDataEntityProperty sourceProperty : sourcePropertyCollection) {
            if (!WfUtils.isNotEmpty(sourceProperty.getName()) || !WfUtils.isNotEmpty(sourceProperty.getAlias())) continue;
            propertys.add(sourceProperty.getName());
        }
        return propertys;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected void deleteData(String entityNumber, String accordFeild, List<Object> params, boolean hasMultiLang, String tableName) {
        if (WfUtils.isEmptyForCollection(params)) {
            return;
        }
        MainEntityType entityType = EntityMetadataCache.getDataEntityType((String)entityNumber);
        String accordColumn = entityType.getProperty(accordFeild).getAlias();
        if (entityType.getAllEntities().size() == 1) {
            try (TXHandle tx = TX.required((String)"AbstractTimeCleaner_deleteData");){
                String sql = String.format("DELETE FROM %s WHERE %s in ( ? ) ;", tableName, accordColumn);
                WfDBUtils.executeBatchDeleteByIn(sql, params, 500, true);
                if (!hasMultiLang) return;
                sql = String.format("DELETE FROM %s_L WHERE %s in ( ? ) ;", tableName, accordColumn);
                WfDBUtils.executeBatchDeleteByIn(sql, params, 500, true);
                return;
            }
        } else {
            DeleteServiceHelper.delete((String)entityNumber, (QFilter[])new QFilter[]{new QFilter(accordFeild, "in", params)});
        }
    }

    private void deleteLogData(String relaEntityNumber, String relaField, List<Object> pks) {
        try {
            LogORM.create().delete(relaEntityNumber, new QFilter[]{new QFilter(relaField, "in", pks)});
        }
        catch (Throwable ex) {
            log.error("deleteData is error, errorinfo is :" + WfUtils.getExceptionStacktrace(ex));
        }
    }

    protected Date getTargetTime(Date dateTime, int scope) {
        Calendar c = Calendar.getInstance();
        c.setTime(dateTime);
        c.add(5, scope);
        return c.getTime();
    }
}

