/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.workflow.engine.impl.clean.cleaner;

import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.operation.DeleteServiceHelper;
import kd.bos.workflow.engine.WfUtils;
import kd.bos.workflow.engine.impl.clean.cleaner.DefaultRegularTimeCleaner;
import kd.bos.workflow.engine.impl.clean.model.CleanTaskConfigParam;
import kd.bos.workflow.engine.impl.clean.model.EntityCompactConfigFactory;
import kd.bos.workflow.engine.impl.clean.model.EntityCompactConfigParam;
import kd.bos.workflow.engine.impl.clean.transfer.EntityTransferFactory;
import kd.bos.workflow.service.WorkflowService;
import kd.bos.workflow.service.impl.ServiceFactory;

public class CompactProcessCleaner
extends DefaultRegularTimeCleaner {
    protected WorkflowService wfService = (WorkflowService)ServiceFactory.getService(WorkflowService.class);
    private static Log log = LogFactory.getLog(CompactProcessCleaner.class);
    private static final int DEFAULT_STEPLIMITQUANTITY = 5000;
    private static final int DEFAULT_LIMITQUANTITY = 50000;

    @Override
    protected void updateStartingDate(CleanTaskConfigParam configParam) {
        Date startingDate = (Date)configParam.getParams().remove("startingDate");
        if (startingDate != null) {
            configParam.getParams().put("startingTime", startingDate.getTime());
        }
    }

    @Override
    protected int executeEverySegment(CleanTaskConfigParam configParam, int everytimeCount, Date startingDate, Date maxCleanDate) {
        int stepLength = configParam.getStepLength() == 0 ? 7 : configParam.getStepLength();
        Date endingDate = this.getTargetTime(startingDate, stepLength);
        if (endingDate.after(maxCleanDate)) {
            endingDate = maxCleanDate;
        }
        String orderBys = String.format("%s asc", "endTime");
        ArrayList<QFilter> filters = new ArrayList<QFilter>(10);
        filters.add(new QFilter("endTime", "<=", (Object)endingDate));
        filters.add(new QFilter("endTime", ">=", (Object)startingDate));
        if (configParam.getConditionFilters() != null) {
            filters.add(configParam.getConditionFilters());
        }
        String selectFieldStr = String.format("%s,%s", "id", "endTime");
        int partCount = "compact".equals(configParam.getDisposalType()) ? 50 : 200;
        ArrayList<Long> procInstIds = new ArrayList<Long>(partCount);
        int i = 0;
        try (DataSet dataSet = QueryServiceHelper.queryDataSet((String)"CompactProcessCleaner.executeEverySegment", (String)"wf_hiprocinst", (String)selectFieldStr, (QFilter[])filters.toArray(new QFilter[0]), (String)orderBys, (int)everytimeCount);){
            Row row = null;
            while (dataSet != null && dataSet.hasNext()) {
                row = dataSet.next();
                procInstIds.add(row.getLong("id"));
                startingDate = row.getDate("endTime");
                if (++i % partCount != 0) continue;
                this.disposePartData(procInstIds, configParam);
                procInstIds.clear();
            }
            if (i < everytimeCount) {
                startingDate = endingDate;
            }
            if (!procInstIds.isEmpty()) {
                this.disposePartData(procInstIds, configParam);
            }
        }
        configParam.getParams().put("startingDate", startingDate);
        log.debug(String.format("\u6309\u4fdd\u7559\u65f6\u95f4\u6e05\u7406\u4e3b\u5b9e\u4f53[%s]\u5206\u6279\u6b21\u6e05\u7406\uff0c\u672c\u6279\u6b21\u5171\u6e05\u7406[%s]\u6761\u6570\u636e", configParam.getMainEntityNumber(), i));
        return i;
    }

    private void disposePartData(List<Long> procInstIds, CleanTaskConfigParam configParam) {
        if ("compact".equals(configParam.getDisposalType())) {
            this.compactProcData(procInstIds, configParam.getMainEntityNumber());
        } else {
            this.deleteProcData(procInstIds, configParam.getMainEntityNumber());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void deleteProcData(List<Long> procInstIds, String entityNumber) {
        if (WfUtils.isEmpty(entityNumber) || WfUtils.isEmptyForCollection(procInstIds)) {
            return;
        }
        try (TXHandle handle = TX.requiresNew();){
            DeleteServiceHelper.delete((String)entityNumber, (QFilter[])new QFilter[]{new QFilter(EntityTransferFactory.createEntityTransfer("wf_historicalprocesses", entityNumber).getTargetProperty("processinstanceid"), "in", procInstIds)});
        }
        log.debug(String.format("CompactProcessCleaner.compactProcData [%s]\u5206\u6279\u5220\u9664\u5b8c\u6210", entityNumber));
    }

    private void compactProcData(List<Long> procInstIds, String entityNumber) {
        if (WfUtils.isEmpty(entityNumber) || WfUtils.isEmptyForCollection(procInstIds)) {
            return;
        }
        EntityCompactConfigParam compactParam = EntityCompactConfigFactory.getCompactConfig(entityNumber);
        log.debug(String.format("CompactProcessCleaner.compactProcData [%s]\u5206\u6279\u5f00\u59cb\u538b\u7f29", entityNumber));
        try {
            this.wfService.getHistoryService().compactFinishedProcessDatas(procInstIds, compactParam);
        }
        catch (Exception ex) {
            log.error(String.format("\u6e05\u7406\u6846\u67b6-\u4e3b\u5b9e\u4f53\uff1a[%s]\uff0c\u6267\u884c\u538b\u7f29-\u6267\u884c\u51fa\u9519\u3002 %s", entityNumber, WfUtils.getExceptionStacktrace(ex)));
        }
        log.debug(String.format("CompactProcessCleaner.compactProcData [%s]\u5206\u6279\u538b\u7f29\u5b8c\u6210", entityNumber));
    }

    @Override
    protected Date getRealStartingDate(CleanTaskConfigParam configParam, Date maxCleanDate) {
        String orderBys = String.format("%s asc", "endTime");
        ArrayList<QFilter> filters = new ArrayList<QFilter>(10);
        filters.add(new QFilter("endTime", "<=", (Object)maxCleanDate));
        if (configParam.getConditionFilters() != null) {
            filters.add(configParam.getConditionFilters());
        }
        try (DataSet dataSet = QueryServiceHelper.queryDataSet((String)"CompactProcessCleaner.getRealStartingDate", (String)"wf_hiprocinst", (String)"endTime", (QFilter[])filters.toArray(new QFilter[0]), (String)orderBys, (int)1);){
            if (dataSet != null && dataSet.hasNext()) {
                Row row = dataSet.next();
                Date date = row.getDate("endTime");
                return date;
            }
        }
        return null;
    }

    @Override
    protected int getDefaultStepLimitQuantity() {
        return 5000;
    }

    @Override
    protected int getDefaultLimitQuantity() {
        return 50000;
    }

    @Override
    protected Date getNextSeekDate(CleanTaskConfigParam configParam) {
        return (Date)configParam.getParams().get("startingDate");
    }

    @Override
    protected boolean validateParam(CleanTaskConfigParam configParam) {
        boolean result = true;
        if (WfUtils.isEmpty(configParam.getMainEntityNumber())) {
            log.debug(String.format("\u6309\u4fdd\u7559\u65f6\u95f4\u6e05\u7406\u4e3b\u5b9e\u4f53[%s]\u6267\u884c\u6e05\u7406\u5931\u8d25\uff0cmainEntityNumber \u4e3a\u7a7a\uff01", configParam.getMainEntityNumber()));
            result = false;
        }
        if (WfUtils.isEmpty(configParam.getDisposalType())) {
            log.debug(String.format("\u6309\u4fdd\u7559\u65f6\u95f4\u6e05\u7406\u4e3b\u5b9e\u4f53[%s]\u6267\u884c\u6e05\u7406\u5931\u8d25\uff0cdisposalType \u4e3a\u7a7a\uff01", configParam.getMainEntityNumber()));
            result = false;
        }
        return result;
    }
}

