/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.workflow.engine.impl.clean.cleaner;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.context.RequestContext;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.workflow.engine.WfDBUtils;
import kd.bos.workflow.engine.WfUtils;
import kd.bos.workflow.engine.impl.clean.cleaner.ProcessCleaner;
import kd.bos.workflow.engine.impl.clean.model.CleanTaskConfigParam;
import kd.bos.workflow.engine.impl.cmd.job.DeleteMovedDeadLetterJobListener;
import kd.bos.workflow.engine.impl.interceptor.CommandContext;
import kd.bos.workflow.engine.impl.persistence.entity.job.FailedJobEntityManager;
import kd.bos.workflow.engine.impl.util.RuntimeUtil;

public class DeadLetterJobCleaner
implements ProcessCleaner {
    private Log log = LogFactory.getLog(DeadLetterJobCleaner.class);

    @Override
    public void execute(CommandContext commandContext, CleanTaskConfigParam configParam, List<String> businessKeys, List<Long> procInstIds) {
        if (WfUtils.isNotEmptyForCollection(businessKeys)) {
            return;
        }
        FailedJobEntityManager failedJobManager = commandContext.getFailedJobEntityManager();
        ArrayList<String> businessKeyList = new ArrayList<String>(businessKeys.size());
        for (String businessKey : businessKeys) {
            businessKeyList.add(String.format("'%s'", businessKey));
        }
        ArrayList<Object> params = new ArrayList<Object>(1000);
        for (int i = 0; i < businessKeyList.size(); ++i) {
            params.add(businessKeyList.get(i));
            if ((i + 1) % 1000 != 0) continue;
            this.deletePartDeadLetterJobs(commandContext, failedJobManager, params);
            params.clear();
        }
        if (WfUtils.isNotEmptyForCollection(params)) {
            this.deletePartDeadLetterJobs(commandContext, failedJobManager, params);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void deletePartDeadLetterJobs(CommandContext commandContext, FailedJobEntityManager failedJobManager, List<Object> params) {
        try (TXHandle handle = TX.requiresNew();){
            String lang = String.valueOf(RequestContext.get().getLang());
            String fields = "D.FID, D.FBUSINESSKEY, D.FEXECUTIONID, D.FPROCESSINSTANCEID, D.FPROCDEFID, D.FELEMENTID, D.FOPERATION, D.FENTITYNUMBER, D.FTYPE, D.FHANDLERTYPE, D.FHANDLERCFG, D.FSOLUTION, D.FERRORCODE, D.FERRORTYPE, D.FROOTTRACENO, D.FEXCEPTIONMSG, D.FEXCEPTIONSTACKMSG, D.FCREATEDATE, D.FBIZTRACENO, DL.FNAME, DL.FENTRABILLNAME, DL.FSUBJECT, DL.FELEMENTNAME";
            StringBuilder sb = new StringBuilder();
            sb.append("SELECT ").append(fields).append(" FROM T_WF_DEADLETTERJOB D ");
            sb.append("INNER JOIN T_WF_DEADLETTERJOB_L DL ON D.FID = DL.FID AND DL.FLOCALEID = ? ");
            sb.append("WHERE D.FBUSINESSKEY IN ");
            List<String> paramsAfterIn = WfUtils.formatInQueryParam(params, 200, false);
            ArrayList<Long> deadLetterJobIds = new ArrayList<Long>();
            try (DataSet ds = WfDBUtils.batchQueryByInWithParams(sb.toString(), paramsAfterIn, "wf.engine.deleteFinishedProcessDeadLetterJobs", new Object[]{lang}, true);){
                if (ds != null) {
                    Iterator iter = ds.iterator();
                    Long jobId = null;
                    while (iter.hasNext()) {
                        Row row = (Row)iter.next();
                        jobId = row.getLong("FID");
                        if (RuntimeUtil.isNeedToRemoveFailedJob(row.getString("FHANDLERTYPE"), row.getString("FHANDLERCFG"))) {
                            failedJobManager.createFailedJobByDeadLetterJob(row);
                        }
                        deadLetterJobIds.add(jobId);
                    }
                }
            }
            if (!deadLetterJobIds.isEmpty()) {
                commandContext.addCloseListener(new DeleteMovedDeadLetterJobListener(deadLetterJobIds.toArray()));
            }
            this.log.debug(String.format("deleteClosedJob_deleteDeadLetterJobs\uff0c\u6267\u884c\u6210\u529f\uff01\u6570\u636e\u91cf[%s]", paramsAfterIn.size()));
        }
    }
}

